var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from "@angular/core";
import { GlobalFunctions } from "../../shared/global-functions";
let BaseViewerComponent = class BaseViewerComponent {
    constructor(phoneManager, dialogManager, translateService) {
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.onShowLocationMap = new EventEmitter();
    }
    openImage(imageUrl) {
        if (!GlobalFunctions.isEmpty(imageUrl))
            window.open(imageUrl, "_blank", "toolbar=0,location=0,menubar=0,status=1,scrollbars=1,resizable=1,width=1000,height=500");
    }
    emitShowLocationMap() {
        this.onShowLocationMap.emit();
    }
    placeCall(phoneNumber, name, picture, id = null) {
        GlobalFunctions.placeCall(this.phoneManager, phoneNumber, name, picture, id);
    }
    loadSendEmailDialog(emailId) {
        GlobalFunctions.loadSendEmailDialog(emailId, this.dialogManager);
    }
    handleMissingImage(event) {
        GlobalFunctions.handleMissingImage(event);
    }
    openEmployeeDetailPopUp(employeeId) {
        this.dialogManager.openEmployeeDetailPopUp(employeeId);
    }
};
__decorate([
    Input()
], BaseViewerComponent.prototype, "relatedFor", void 0);
__decorate([
    Input()
], BaseViewerComponent.prototype, "selectedViewerEntity", void 0);
__decorate([
    Output()
], BaseViewerComponent.prototype, "onShowLocationMap", void 0);
BaseViewerComponent = __decorate([
    Component({
        selector: 'base-viewer',
        template: '<span></span>'
    })
], BaseViewerComponent);
export { BaseViewerComponent };
//# sourceMappingURL=base-viewer.component.js.map