var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, HostListener, Input, Output } from "@angular/core";
import { OperationType, RecordSelection } from "src/app/core/enums/common-enums";
import { SearchResultSource } from "src/app/core/enums/search-result-source.enum";
import { ContentType } from "src/app/core/models/jkc-object/jkc-object";
import { BroadCastEventKeys, EntityName, RoutePath } from "src/app/shared/constants";
import { GlobalFunctions } from "src/app/shared/global-functions";
import { CommonHelper } from "src/app/shared/helper/common-helper";
import { SubSink } from "subsink";
import { EntityFqdn } from "../../core/enums/core-enums";
import moment from "moment";
let BaseSearchResultComponent = class BaseSearchResultComponent {
    constructor(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService) {
        this.translateService = translateService;
        this.changeDetectorRef = changeDetectorRef;
        this.sessionManager = sessionManager;
        this.router = router;
        this.activatedRoute = activatedRoute;
        this.eventProvider = eventProvider;
        this.sortManager = sortManager;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.searchService = searchService;
        this.sendResultCount = new EventEmitter();
        this.onGridItemClick = new EventEmitter();
        this.onSelectAll = new EventEmitter();
        this.onSelect = new EventEmitter();
        this.updateMenu = new EventEmitter();
        this.resultList = [];
        this.recordSelection = RecordSelection.Single;
        this.showSearchStatus = true;
        this.type = '';
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        this.unfilteredList = [];
        this.listSearchCompleted = false;
        this.isSearchingInOlderData = false;
        this.isSearchedOnPrivateField = false;
        this.selectDeSelectAllText = this.translateService.instant('LBL_SELECT_ALL');
        this.activeHandlersObj = { ActiveHandlers: null };
        this.lazyLoadingChunk = 40;
        this.lazyLoadingLimitTo = this.lazyLoadingChunk;
        this.DateJS = Date;
        this.RecordSelection = RecordSelection;
        this.subs = new SubSink();
        this.previousResultCount = 0;
        this.sourceHandlers = [];
        this.concatenatedHandlers = "";
        this.filteredSearchResult = [];
        this.timeoutIds = [];
        this.emailOptions = ['ALL', 'MY', 'INBOX', 'ARCHIVE'];
        this.searchCompletedStatus = function (message) {
            console.log('email-search-result->updateSearchStatus:', message);
            this.sourceCount = 0;
            if (!GlobalFunctions.isEmpty(this.selectedOption) && (this.emailOptions.includes(this.selectedOption.toUpperCase())))
                this.updateSearchStatus({ ActiveHandlers: [] });
            if (this.sourceCount == 0 && !this.sessionManager.isEWSEnabled && !GlobalFunctions.isEmpty(this.sessionManager.pendingCount.EmailCount)) {
                let emailCount = this.resultList.length;
                switch (this.emailSourceSelected) {
                    case 0:
                        if (!this.retrieveMyEmails || message.IsAllSourceRequest)
                            this.sessionManager.pendingCount.AllEmailsCount = emailCount;
                        this.sessionManager.pendingCount.EmailCount[0].MyCount = jlinq.from(this.resultList).starts("Header.HandlerId", GlobalFunctions.getLoggedInUserId()).select().length;
                        break;
                    case 2:
                        this.sessionManager.pendingCount.EmailCount[0].ArchiveCount = emailCount;
                        break;
                }
            }
        };
        this.dateClass = (cellDate, view) => {
            const day = cellDate.getDate();
            this.timeoutIds.push(setTimeout(() => { GlobalFunctions.formatDaysWithLeadingZeros(); }));
            // handle UI representation of day
            if (!GlobalFunctions.isEmpty(view) && view.toLowerCase() == 'month')
                return (day >= 1 && day <= 9) ? 'custom-cell' : '';
        };
        this.sessionManager.localSearchQuery = "";
        this.searchResultFound = this.searchResultFound.bind(this);
        this.updateSearchStatus = this.updateSearchStatus.bind(this);
        this.searchStartedStatus = this.searchStartedStatus.bind(this);
        this.searchCompletedStatus = this.searchCompletedStatus.bind(this);
        this.alternateSearchResponseReceived = this.alternateSearchResponseReceived.bind(this);
        this.searchPrivateFieldValidationResponseFound = this.searchPrivateFieldValidationResponseFound.bind(this);
        this.alternateSearchSuggestionsResponseReceived = this.alternateSearchSuggestionsResponseReceived.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_LOCAL_SEARCH_RESULT_LIST).subscribe(localSearchResultList => {
            if (this.searchResultSource == SearchResultSource.Dashboard && GlobalFunctions.isEmpty(this.searchStatusQuery))
                this.searchStatusQuery = (this.type.toUpperCase() !== 'DOCUMENT')
                    ? this.type.charAt(0).toUpperCase() + this.type.slice(1).toLowerCase()
                    : this.sessionManager.pendingCount.DocumentTitle;
            this.filteredSearchResult = localSearchResultList.filteredResults;
            this.updateSearchStatus(localSearchResultList.searchMessage);
        });
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.resultList = [];
        this.sessionManager.localSearchFieldList = [];
        this.filteredSearchResult = [];
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    openHelpUrl(key) {
        CommonHelper.openHelpUrl(key);
    }
    updateSearchStatus(message) {
        this.sourceCount = message.ActiveHandlers == null ? null : message.ActiveHandlers.length;
        let resultCount = this.filteredSearchResult.length;
        if (typeof this.sourceCount == 'undefined')
            return;
        this.showProgressBar = true;
        if (this.sourceCount == null)
            this.searchStatusMessage = this.translateService.instant('LBL_SEARCHING_STARTED');
        else if (this.sourceCount == 0) {
            this.sourceHandlers = [];
            if (resultCount == 0) {
                let query = this.sessionManager.localSearchQuery !== "" ? this.sessionManager.localSearchQuery ?? '' : this.searchStatusQuery ?? '';
                this.searchStatusMessage = this.type.toLowerCase() === 'person' || this.type.toLowerCase() === 'organization' ? this.translateService.instant('LBL_NO_OR_TOO_MANY_RECORDS_FOUND_FOR').replace('{0}', query) : this.translateService.instant('LBL_NO_RECORDS_FOUND_FOR').replace('{0}', query);
            }
            else if (resultCount == 1) {
                this.searchStatusMessage = this.sessionManager.localSearchQuery !== ""
                    ? this.translateService.instant('LBL_LOCAL_SEARCH_RECORD_FOUND').replace('{0}', resultCount).replace('{1}', this.sessionManager.localSearchQuery).replace('{2}', this.searchStatusQuery !== undefined ? this.searchStatusQuery : '')
                    : this.translateService.instant('LBL_RECORD_FOUND').replace('{0}', resultCount).replace('{1}', this.searchStatusQuery !== undefined ? this.searchStatusQuery : '');
                if (this.alternateSearchSources.length > 0)
                    this.searchStatusMessage += " " + this.translateService.instant("LBL_FROM").toLowerCase() + " " + this.concatenatedHandlers;
            }
            else {
                this.timeoutIds.push(setTimeout(() => {
                    if (resultCount != 0) {
                        if (resultCount === this.previousResultCount || this.searchService.isLocalSearch) {
                            this.searchStatusMessage = this.sessionManager.localSearchQuery !== ""
                                ? this.translateService.instant('LBL_LOCAL_SEARCH_RECORDS_FOUND').replace('{0}', resultCount).replace('{1}', this.sessionManager.localSearchQuery).replace('{2}', this.searchStatusQuery !== undefined ? this.searchStatusQuery : '')
                                : this.translateService.instant('LBL_RECORDS_FOUND').replace('{0}', resultCount).replace('{1}', this.searchStatusQuery !== undefined ? this.searchStatusQuery : '');
                            if (this.alternateSearchSources.length > 0)
                                this.searchStatusMessage += " " + this.translateService.instant("LBL_FROM").toLowerCase() + " " + this.concatenatedHandlers;
                        }
                    }
                }));
            }
            this.listSearchCompleted = true;
            this.showProgressBar = false;
        }
        else {
            this.searchStatusMessage = resultCount == 0
                ? (this.sourceCount > 1
                    ? this.translateService.instant('LBL_SEARCHING_IN_SOURCES').replace('{0}', this.sourceCount)
                    : this.translateService.instant('LBL_SEARCHING_IN_SOURCE').replace('{0}', this.sourceCount))
                : (resultCount > 1
                    ? this.translateService.instant('LBL_SEARCH_STATUS_WITH_RESULTS_MESSAGE').replace('{0}', this.sourceCount).replace('{1}', resultCount)
                    : this.translateService.instant('LBL_SEARCH_STATUS_WITH_RESULT_MESSAGE').replace('{0}', this.sourceCount).replace('{1}', resultCount));
        }
        this.previousResultCount = resultCount;
    }
    searchStartedStatus(message) {
        this.sourceCount = this.sourceCount + 1;
        this.filteredSearchResult = [];
        let searchMessage = new Object();
        searchMessage.ActiveHandlers = [];
        searchMessage.ActiveHandlers.push(message.ContentType);
        this.updateSearchStatus(searchMessage);
    }
    alternateSearchResponseReceived(result) {
        this.alternateSearchSources.push(result);
    }
    alternateSearchSuggestionsResponseReceived(result) {
        if (result.Suggestions != null && result.Suggestions.length > 0) {
            for (let i = 0; i < result.Suggestions.length; i++) {
                let suggestion = result.Suggestions[i];
                if (this.alternateSearchSuggestions.indexOf(suggestion) == -1)
                    this.alternateSearchSuggestions.push(suggestion);
            }
        }
    }
    searchPrivateFieldValidationResponseFound(result) {
        if (!GlobalFunctions.isEmpty(result) && !GlobalFunctions.isEmpty(result.SearchedPrivateFields) && result.SearchedPrivateFields.length > 0)
            this.isSearchedOnPrivateField = true;
    }
    selectAll(isCheck) {
        if (isCheck)
            this.selectDeSelectAllText = this.translateService.instant('LBL_UNSELECT_ALL');
        else
            this.selectDeSelectAllText = this.translateService.instant('LBL_SELECT_ALL');
        this.onSelectAll.emit({ filteredEntities: this.resultList, isCheck });
    }
    select(entityObj, event) {
        event.stopPropagation();
        event.cancelBubble = false;
        this.onSelect.emit({ domainObj: entityObj, isCheck: event.target.checked });
    }
    resize() {
        let windowHeight = window.innerHeight;
        $("#searchresultoverflow").height(windowHeight - 100 + 'px');
        GlobalFunctions.resizejkcBootstrapTable();
    }
    onItemClick(itemObj) {
        if (this.isSearchPopup) {
            if (this.recordSelection == RecordSelection.Single)
                this.onGridItemClick.emit(itemObj);
            else
                return;
        }
        else if (this.type.toLowerCase() === "news" && !itemObj.HasDetailView && this.recordSelection == RecordSelection.Single)
            window.open(itemObj.Link, '_blank');
        else {
            this.sessionManager.loadedFromRelatedView = false;
            if (this.type.toLowerCase() === "task")
                this.sessionManager.selectedEntity = itemObj.ObjectSourceDto;
            else
                this.sessionManager.selectedEntity = itemObj;
            if (this.type.toLowerCase() === "contacthistory") {
                let splitDate;
                if (itemObj.StringRepresentation.includes(','))
                    splitDate = itemObj.StringRepresentation.split(',')[1].trim();
                else
                    splitDate = itemObj.StringRepresentation.trim();
                const isDutch = navigator.language.includes('nl');
                let parsedDate;
                if (isDutch) {
                    parsedDate = moment(splitDate, 'DD MMM YYYY HH:mm', 'nl').toDate();
                }
                else {
                    parsedDate = moment(splitDate, 'DD MMM YYYY HH:mm').toDate();
                }
                if (!isNaN(parsedDate.getTime())) {
                    itemObj.contactDate = this.datePipe.transform(parsedDate, `${this.sessionManager.defaultOptions.date} ${this.sessionManager.defaultOptions.month} ${this.sessionManager.defaultOptions.year} ${this.sessionManager.defaultOptions.timeFormat}`);
                    const replacedDate = itemObj.StringRepresentation.split(',');
                    replacedDate[1] = ' ' + itemObj.contactDate;
                    itemObj.StringRepresentation = replacedDate.join(',');
                }
                else {
                    console.error('Error parsing date:', splitDate);
                }
            }
            this.resultList.forEach(resultObject => {
                switch (this.type.toLowerCase()) {
                    case 'task': {
                        resultObject.locationUrl = `${RoutePath.DETAIL_PATH}/${itemObj.ScheduledWorkType.toLowerCase()}/${itemObj.Id}`;
                        break;
                    }
                    case 'ticket': {
                        resultObject.locationUrl = `${RoutePath.DETAIL_PATH}/ticket/${itemObj.Id}`;
                        break;
                    }
                    case 'socialmedia':
                        if (resultObject.Type.toLowerCase() == "twitter")
                            resultObject.locationUrl = `${RoutePath.DETAIL_PATH}/twitter`;
                        else if (resultObject.Type.toLowerCase() == "facebook")
                            resultObject.locationUrl = `${RoutePath.DETAIL_PATH}/facebook`;
                        else if (resultObject.Type.toLowerCase() == "whatsapp")
                            resultObject.locationUrl = `${RoutePath.DETAIL_PATH}/whatsapp`;
                        break;
                    default: {
                        resultObject.locationUrl = `${RoutePath.DETAIL_PATH}/${this.type}`;
                        break;
                    }
                }
                resultObject.searchStatusQuery = this.searchStatusQuery;
            });
            this.sessionManager.addBreadcrumbItems(this.resultList, itemObj, this.router.url);
            this.onGridItemClick.emit(itemObj);
        }
        // To ckeck if person is exists or not by email or dob from Add Person Panel,then On item select record loads in deatil view(if that person already exists).
        let jsPanelName = this.sessionManager.jkcParentPanel;
        if (jsPanelName?.parameters?.HeaderId == "addPersonHeader" || jsPanelName?.parameters?.FooterId == "addPersonFooter") {
            if (this.type.toLowerCase() == "person") {
                this.sessionManager.selectedEntity = itemObj;
                itemObj.locationUrl = `${RoutePath.DETAIL_PATH}/${this.type.toLowerCase()}`;
                this.sessionManager.addBreadcrumbItems([itemObj], null, this.router.url);
                this.router.navigate([itemObj.locationUrl]);
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.REMOVE_COMPONENT);
                this.sessionManager.closeJkcParentPanel();
            }
        }
    }
    searchResultFound(result) {
        console.log('Base list->' + this.type + '->searchResultFound:', result);
        if (result != null && result.length > 0) {
            this.updateSourceHandler(result[0].ObjectSource);
            //GlobalFunctions.filterDate(result, this.type, sessionManager, $filter);
            this.sessionManager.setBgColorBasedOnObjectSource(result);
            if (this.type.toLowerCase() == "person" || this.type.toLowerCase() == "organization")
                result = this.mergeDuplicateResults(result);
            if (this.type.toLowerCase() == "person") {
                let grammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_Breadcrumb");
                for (let i = 0; i < result.length; i++)
                    GlobalFunctions.setStringPresentation(result[i], grammerValue);
            }
            else if (this.type.toLowerCase() === "employee") {
                // To set the availability , pass the result in array of 20 items if resultList is greater than 20 items.
                let batchSize = 20;
                for (let i = 0; i < result.length; i += batchSize) {
                    const batch = result.slice(i, i + batchSize);
                    this.employeeService.setEmployeeAvailability(batch);
                }
            }
            else if (this.type.toLowerCase() === "document") {
                if (this.searchResultSource == SearchResultSource.Dashboard)
                    this.setLookingOn(result);
            }
            else if (this.type.toLowerCase() === "news") {
                if (this.isSearchPopup)
                    this.setIDForNewsEntity(result);
                else {
                    result.forEach((result, i) => {
                        if (result.PublishDate)
                            result.PublishDateText = this.datePipe.transform(result.PublishDate, this.sessionManager.defaultOptions.defaultDateFormat);
                    });
                }
            }
            else if (this.type.toLowerCase() === "noteentity" || this.type.toLowerCase() == "fileentity" || this.type.toLowerCase() == "link")
                this.formatManager.setCreatedBy(result);
            else if (this.type.toLowerCase() === "contacthistory") {
                this.updateContactHistoryListWithHandlerName(result);
                GlobalFunctions.updateResultListWitTags(this.applicationSettingManager.tagSetting.tagList.length > 0, result, this.applicationSettingManager);
            }
            else if (this.type.toLowerCase() === "ticket") {
                if (result != null && result.length > 0) {
                    for (let index = 0; index < result.length; index++) {
                        result[index].CreatedDateText = this.datePipe.transform(result[index].CreatedDate, this.sessionManager.defaultOptions.defaultDateFormat);
                        result[index].DueDateText = this.datePipe.transform(result[index].DueDate, this.sessionManager.defaultOptions.defaultDateFormat);
                        result[index].LastChangeDateText = this.datePipe.transform(result[index].LastChangedDate, this.sessionManager.defaultOptions.defaultDateFormat);
                        if (!GlobalFunctions.isEmpty(result[index].FieldDataList) && result[index].FieldDataList.length > 0) {
                            let ticketConfig = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
                            let ticketType = jlinq.from(ticketConfig.TicketTypes).equals("Id", result[index].TicketTypeId).first();
                            if (!GlobalFunctions.isEmpty(ticketType) && !GlobalFunctions.isEmpty(ticketType.Fields) && ticketType.Fields.length > 0)
                                result[index].FieldDataList.forEach(fieldData => {
                                    let field = jlinq.from(ticketType.Fields).equals("Id", fieldData.FieldId).first();
                                    if (!GlobalFunctions.isEmpty(field) && !GlobalFunctions.isEmpty(field.FieldListId))
                                        fieldData.FieldListId = field.FieldListId;
                                });
                        }
                    }
                    this.sessionManager.setBgColorBasedOnObjectSource(result);
                }
            }
            else if (this.type.toLowerCase() === "email") {
                if (result != null && result.length > 0) {
                    let hasCanHandleAnyRights = GlobalFunctions.hasRight(ContentType.Document, OperationType.CanHandleAnyEmail);
                    ;
                    result.forEach((emailItem) => {
                        if (emailItem.Header.Date) {
                            //emailItem.ReceivedDateText = $filter('date')(emailItem.Header.Date, this.sessionManager.defaultOptions.datetime24HoursFormat);
                            emailItem.ReceivedDateText = emailItem.Header.Date;
                        }
                        emailItem.Header.ToAddresses = emailItem.Header.To.join();
                        //Show checkbox checked if user has CanHandleAny rights and email assigned to other
                        if (hasCanHandleAnyRights && emailItem.Header.HandlerId != null && emailItem.Header.HandlerId != '' && !emailItem.Header.HandlerBySelf)
                            emailItem.Header.HandlerBySelf = true;
                    });
                    this.updateEmailListWithHandlerName(result);
                    if (this.sourceCount == undefined)
                        this.sourceCount = 0;
                    this.sessionManager.setBgColorBasedOnObjectSource(result);
                }
            }
            else if (this.type.toLowerCase() === "socialmedia")
                this.formatManager.setUserDetail(result, this.cacheManager);
            this.resultList = this.resultList.concat(result);
            this.unfilteredList = this.resultList;
            this.resultList = this.sortManager.sortEntityBasedOnApplicationSetting(this.type.toUpperCase(), this.resultList);
            console.log("result count ", this.resultList.length);
            this.resultCount = this.resultList.length;
            this.changeDetectorRef.markForCheck();
            this.sendResultCount.emit(this.resultCount);
            this.resize();
        }
    }
    updateContactHistoryListWithHandlerName(result) {
        if (result != null && result.length > 0) {
            for (let index = 0; index < result.length; index++) {
                if (result[index].StartDate)
                    result[index].StartDateText = this.datePipe.transform(result[index].StartDate, this.sessionManager.defaultOptions.defaultDateFormat);
                let handler = result[index].HandlerDto;
                if (handler != null) {
                    let userId = handler.UserId;
                    if (userId != null && userId != '') {
                        result[index].HandlerDto.HandlerObject = this.cacheManager.getEmployeeById(userId);
                    }
                }
            }
        }
    }
    updateEmailListWithHandlerName(result) {
        if (result != null && result.length > 0) {
            for (let index = 0; index < result.length; index++) {
                //handler
                let handlerId = result[index].Header.HandlerId;
                if (!GlobalFunctions.isEmpty(handlerId)) {
                    let handlerObject = this.cacheManager.getEmployeeById(handlerId);
                    if (handlerObject != null)
                        result[index].Header.HandlerName = handlerObject.StringRepresentation;
                }
                //user
                result[index].Header.LookingOnTitle = this.translateService.instant("LBL_ASSIGN_ITEM");
                let userId = result[index].Header.LookingOn;
                if (!GlobalFunctions.isEmpty(userId)) {
                    let userObject = this.cacheManager.getEmployeeById(userId);
                    if (userObject != null)
                        result[index].Header.LookingOnUserName = userObject.StringRepresentation;
                    let LookingOnByOtherUser = userId != GlobalFunctions.getLoggedInUserId();
                    result[index].Header.LookingOnTitle = LookingOnByOtherUser ? GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ASSIGNED_ITEM_TO_OTHER_USER"), [userObject.StringRepresentation]) : this.translateService.instant("LBL_UNASSIGN_ITEM");
                    result[index].Header.LookingOnByOtherUserTitle = LookingOnByOtherUser ? userObject.StringRepresentation + this.translateService.instant("LBL_ASSIGNED_ITEM") : '';
                }
            }
        }
    }
    mergeDuplicateResults(result) {
        let isExists = false;
        let resultListArray = new Array();
        let existingSourceName = "";
        let sourceName = "";
        result.forEach((resultItem, i) => {
            isExists = false;
            this.resultList.forEach((existingResultItem, j) => {
                if (this.type.toLowerCase() == 'person') {
                    if (resultItem != null && resultItem.AdministeredPersonDto != null && existingResultItem != null && existingResultItem.AdministeredPersonDto != null && resultItem.AdministeredPersonDto.ServiceNumber != 0 && resultItem.AdministeredPersonDto.ServiceNumber == existingResultItem.AdministeredPersonDto.ServiceNumber) {
                        isExists = true;
                        existingResultItem.BackgroundColor = '#808080';
                        existingSourceName = !GlobalFunctions.isEmpty(existingResultItem.Tooltiptext) && existingResultItem.Tooltiptext.length > 1 ? existingResultItem.Tooltiptext : existingResultItem.ObjectSource.split('.')[existingResultItem.ObjectSource.split('.').length - 1];
                        sourceName = !GlobalFunctions.isEmpty(resultItem.Tooltiptext) && resultItem.Tooltiptext.length > 1 ? resultItem.Tooltiptext : resultItem.ObjectSource.split('.')[resultItem.ObjectSource.split('.').length - 1];
                        if (!GlobalFunctions.isEmpty(existingResultItem.additionalObjectSource))
                            existingResultItem.additionalObjectSource = existingResultItem.additionalObjectSource + '\n' + sourceName;
                        else
                            existingResultItem.additionalObjectSource = existingSourceName + '\n' + sourceName;
                    }
                }
                else if (this.type.toLowerCase() == 'organization') {
                    if (resultItem != null && resultItem.AdministeredOrganizationDto != null && existingResultItem != null && existingResultItem.AdministeredOrganizationDto != null && resultItem.AdministeredOrganizationDto.Identification != 0 && resultItem.AdministeredOrganizationDto.Identification == existingResultItem.AdministeredOrganizationDto.Identification) {
                        isExists = true;
                        existingResultItem.BackgroundColor = '#808080';
                        existingSourceName = !GlobalFunctions.isEmpty(existingResultItem.Tooltiptext) && existingResultItem.Tooltiptext.length > 1 ? existingResultItem.Tooltiptext : existingResultItem.ObjectSource.split('.')[existingResultItem.ObjectSource.split('.').length - 1];
                        sourceName = !GlobalFunctions.isEmpty(resultItem.Tooltiptext) && resultItem.Tooltiptext.length > 1 ? resultItem.Tooltiptext : resultItem.ObjectSource.split('.')[resultItem.ObjectSource.split('.').length - 1];
                        if (!GlobalFunctions.isEmpty(existingResultItem.additionalObjectSource))
                            existingResultItem.additionalObjectSource = existingResultItem.additionalObjectSource + '\n' + sourceName;
                        else
                            existingResultItem.additionalObjectSource = existingSourceName + '\n' + sourceName;
                    }
                }
            });
            if (!isExists)
                resultListArray.push(result[i]);
        });
        return resultListArray;
    }
    isSingleRecordSelection() {
        return this.recordSelection == RecordSelection.Single;
    }
    fetchSourceCaption(obj) {
        return (this.sessionManager.fetchSourceCaption(obj.additionalObjectSource, null));
    }
    setLookingOn(resultList) {
        for (let i = 0; i < resultList.length; i++) {
            let LookingOn = {};
            LookingOn.ByOtherUser = false;
            LookingOn.Title = this.translateService.instant("LBL_ASSIGN_ITEM");
            if (!GlobalFunctions.isEmpty(resultList[i].LookingOn)) {
                LookingOn.UserId = resultList[i].LookingOn.UserId;
                let userObject = this.cacheManager.getEmployeeById(LookingOn.UserId);
                LookingOn.UserName = (!GlobalFunctions.isEmpty(userObject)) ? userObject.StringRepresentation : "";
                LookingOn.ByOtherUser = LookingOn.UserId != GlobalFunctions.getLoggedInUserId();
                LookingOn.Title = LookingOn.ByOtherUser ? GlobalFunctions.formatStringValue(this.translateService.instant("LBL_ASSIGNED_ITEM_TO_OTHER_USER"), [LookingOn.UserName]) : this.translateService.instant("LBL_UNASSIGN_ITEM");
                LookingOn.ByOtherUserTitle = LookingOn.ByOtherUser ? LookingOn.UserName + this.translateService.instant("LBL_ASSIGNED_ITEM") : '';
            }
            resultList[i].LookingOn = LookingOn;
            let handlerId = resultList[i].HandlerId;
            if (!GlobalFunctions.isEmpty(handlerId)) {
                let handlerObject = this.cacheManager.getEmployeeById(handlerId);
                if (handlerObject != null)
                    resultList[i].HandlerName = handlerObject.StringRepresentation;
            }
            if (resultList[i].HandlerId != null && resultList[i].HandlerId != '' && !resultList[i].HandlerBySelf && !GlobalFunctions.hasRight(ContentType.Document, OperationType.CanHandleAnyDocument))
                resultList[i].IsDisabled = true;
            else
                resultList[i].IsDisabled = false;
        }
    }
    setIDForNewsEntity(result) {
        if (this.type.toUpperCase().indexOf(EntityName.NEWS.toLocaleUpperCase()) >= 0) {
            if (result != null && result.length > 0) {
                for (let index = 0; index < result.length; index++) {
                    if (result[index].Link != null)
                        result[index].Id = result[index].Link;
                }
            }
        }
    }
    loadMore() {
        if (this.lazyLoadingLimitTo < this.resultList.length) {
            let nextList = this.lazyLoadingLimitTo + this.lazyLoadingChunk;
            if (nextList > this.resultList.length)
                this.lazyLoadingLimitTo = this.resultList.length;
            else
                this.lazyLoadingLimitTo = nextList;
        }
        else
            this.lazyLoadingLimitTo = this.resultList.length;
    }
    isValid(searchQuery, validFormat) {
        return searchQuery.match(validFormat) != null;
    }
    ;
    handleMissingImage(event) {
        GlobalFunctions.handleMissingImage(event);
    }
    trackById(index, item) {
        return item.Id || String(index);
    }
    // METHOD : to append source name in search status/alternate source search status message as concatenatedHandlers
    updateSourceHandler(handler) {
        try {
            if (!GlobalFunctions.isEmpty(handler) && this.alternateSearchSources.length > 0) {
                if (!this.sourceHandlers.includes(this.translateService.instant(handler.toUpperCase()))) {
                    this.sourceHandlers.push(this.translateService.instant(handler.toUpperCase())); // sourceHandlers contains source names(en/nl) that will append at last to search status message.
                    this.concatenatedHandlers = this.sourceHandlers.join(' , ');
                }
            }
        }
        catch (e) {
            console.error(e);
        }
    }
};
__decorate([
    Output()
], BaseSearchResultComponent.prototype, "sendResultCount", void 0);
__decorate([
    Output()
], BaseSearchResultComponent.prototype, "onGridItemClick", void 0);
__decorate([
    Output()
], BaseSearchResultComponent.prototype, "onSelectAll", void 0);
__decorate([
    Output()
], BaseSearchResultComponent.prototype, "onSelect", void 0);
__decorate([
    Output()
], BaseSearchResultComponent.prototype, "updateMenu", void 0);
__decorate([
    Input()
], BaseSearchResultComponent.prototype, "resultList", void 0);
__decorate([
    Input()
], BaseSearchResultComponent.prototype, "searchStatusQuery", void 0);
__decorate([
    Input()
], BaseSearchResultComponent.prototype, "localSearchFilterText", void 0);
__decorate([
    Input()
], BaseSearchResultComponent.prototype, "isSearchPopup", void 0);
__decorate([
    Input()
], BaseSearchResultComponent.prototype, "searchResultCount", void 0);
__decorate([
    Input()
], BaseSearchResultComponent.prototype, "recordSelection", void 0);
__decorate([
    Input()
], BaseSearchResultComponent.prototype, "searchResultSource", void 0);
__decorate([
    Input()
], BaseSearchResultComponent.prototype, "showSearchStatus", void 0);
__decorate([
    Input()
], BaseSearchResultComponent.prototype, "selectedOption", void 0);
__decorate([
    HostListener('window:scroll', ['$event'])
], BaseSearchResultComponent.prototype, "loadMore", null);
BaseSearchResultComponent = __decorate([
    Component({
        selector: 'base-search-result',
        template: '<span></span>'
    })
], BaseSearchResultComponent);
export { BaseSearchResultComponent };
//# sourceMappingURL=base-search-result.component.js.map