var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from '@angular/core';
import { AlternateSearchType } from '../../../core/enums/common-enums';
import { SearchDto } from '../../../core/models/common/searchDto';
import { StringCriteriaDto } from '../../../core/models/common/string-criteria';
import { OrganizationSearchField, PersonSearchField, TicketSearchField } from '../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../shared/global-functions';
let AssociatedComponent = class AssociatedComponent {
    constructor(ticketService, personService, organizationService) {
        this.ticketService = ticketService;
        this.personService = personService;
        this.organizationService = organizationService;
        this.associatedViews = [];
        this.associatedStatusList = [];
        this.associatedResultList = [];
        this.showAssociatedWaitIndicator = false;
        this.showNoAssociatedFoundMessage = true;
        this.searchAssociatedStatus = this.searchAssociatedStatus.bind(this);
        this.searchAssociatedResult = this.searchAssociatedResult.bind(this);
    }
    ngOnChanges(changes) {
        if (changes.data.currentValue)
            this.searchAssociated(changes.data.currentValue.item, changes.data.currentValue.itemType);
    }
    searchAssociatedResult(result, contentType) {
        if (result.length > 0) {
            contentType = contentType.toUpperCase();
            if (!this.associatedViews.includes(contentType))
                this.associatedViews.push(contentType);
            if (this.associatedResultList[contentType] == null)
                this.associatedResultList[contentType] = [];
            for (let i = 0; i < result.length; i++) {
                let found = $.grep(this.associatedResultList[contentType], existingItem => existingItem.Id == result[i].Id && existingItem.ObjectSource == result[i].ObjectSource);
                if (found.length == 0)
                    this.associatedResultList[contentType].push(result[i]);
            }
        }
    }
    searchAssociatedStatus(status, contentType) {
        contentType = contentType.toUpperCase();
        if (this.associatedStatusList[contentType] == null)
            this.associatedStatusList[contentType] = 1;
        this.associatedStatusList[contentType] = status.ActiveHandlers.length;
        this.showAssociatedWaitIndicator = !((this.associatedStatusList["PERSON"] == null || this.associatedStatusList["PERSON"] == 0) && (this.associatedStatusList["ORGANIZATION"] == null || this.associatedStatusList["ORGANIZATION"] == 0) && (this.associatedStatusList["TICKET"] == null || this.associatedStatusList["TICKET"] == 0));
        this.showNoAssociatedFoundMessage = (this.showAssociatedWaitIndicator == false && (this.associatedResultList["PERSON"] == null && this.associatedResultList["ORGANIZATION"] == null && this.associatedResultList["TICKET"] == null));
    }
    prepareSearchDto(searchValue, searchField) {
        let searchDto = new SearchDto();
        searchDto.StringCriteriaList = [];
        searchDto.NumericCriteriaList = [];
        searchDto.DateCriteriaList = [];
        searchDto.EnumCriteriaList = [];
        let statusSearchCriteria = new StringCriteriaDto();
        statusSearchCriteria.IsInUse = true;
        statusSearchCriteria.Name = searchField;
        statusSearchCriteria.CompareType = 1;
        statusSearchCriteria.Value = searchValue;
        searchDto.StringCriteriaList.push(statusSearchCriteria);
        return searchDto;
    }
    ;
    searchAssociated(item, itemType = 0) {
        this.associatedViews = [];
        this.associatedResultList = [];
        this.associatedStatusList = [];
        this.showAssociatedWaitIndicator = true;
        let ticketSearchDto = null, personSearchDto = null, organizationSearchDto = null;
        if (itemType === 0) {
            organizationSearchDto = this.prepareSearchDto(item, OrganizationSearchField.Email);
            personSearchDto = this.prepareSearchDto(item, PersonSearchField.Email);
            ticketSearchDto = this.prepareSearchDto(item, TicketSearchField.ContactEmail);
        }
        else {
            organizationSearchDto = this.prepareSearchDto(item, GlobalFunctions.isMobileNumber(item) ? OrganizationSearchField.MobileNumber : OrganizationSearchField.PhoneNumber);
            personSearchDto = this.prepareSearchDto(item, GlobalFunctions.isMobileNumber(item) ? PersonSearchField.MobileNumber : PersonSearchField.PhoneNumber);
            ticketSearchDto = this.prepareSearchDto(item, GlobalFunctions.isMobileNumber(item) ? TicketSearchField.ContactMobileNumber : TicketSearchField.ContactPhoneNumber);
        }
        this.organizationService.advancedSearch(organizationSearchDto, AlternateSearchType.None, "", "", this.searchAssociatedResult, this.searchAssociatedStatus, null, null, null);
        this.personService.advancedSearch(personSearchDto, AlternateSearchType.None, "", "", this.searchAssociatedResult, this.searchAssociatedStatus, null, null, null);
        this.ticketService.advancedSearch(ticketSearchDto, AlternateSearchType.None, "", "", this.searchAssociatedResult, this.searchAssociatedStatus, null);
    }
};
__decorate([
    Input()
], AssociatedComponent.prototype, "data", void 0);
AssociatedComponent = __decorate([
    Component({
        selector: 'associated',
        templateUrl: './associated.component.html',
        styleUrls: ['./associated.component.scss'],
    })
], AssociatedComponent);
export { AssociatedComponent };
//# sourceMappingURL=associated.component.js.map