var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { environment } from 'src/environments/environment';
import { SubSink } from 'subsink';
import { BaseDialogComponent } from '../base-dialog.component';
let AboutComponent = class AboutComponent extends BaseDialogComponent {
    constructor(translateService, sessionManager, dialogRef, downloadService, applicationSettingManager) {
        super();
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.dialogRef = dialogRef;
        this.downloadService = downloadService;
        this.applicationSettingManager = applicationSettingManager;
        this.date = new Date();
        this.versionNumber = '';
        this.isContainerEnvironment = false;
        this.subs = new SubSink();
    }
    ngOnInit() {
        this.checkEnvironment();
        this.versionNumber = this.sessionManager.applicationInfo.ApplicationVersion;
        this.sessionManager.showUIOnTop = false;
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    close() {
        this.dialogRef.close();
    }
    checkEnvironment() {
        this.subs.sink = this.applicationSettingManager.getVersion(environment.api_url + '/AppData?param=IsContainerEnvironment').subscribe(result => {
            if (!GlobalFunctions.isEmpty(result))
                this.isContainerEnvironment = result.toLocaleLowerCase() == 'true';
        });
    }
};
AboutComponent = __decorate([
    Component({
        selector: 'about',
        templateUrl: './about.component.html',
        styleUrls: ['./about.component.scss']
    })
], AboutComponent);
export { AboutComponent };
//# sourceMappingURL=about.component.js.map