var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { LocationStrategy, registerLocaleData } from '@angular/common';
import { HttpClient, HttpClientModule } from '@angular/common/http';
import localeNl from '@angular/common/locales/nl';
import { LOCALE_ID, NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { RouterModule, UrlSerializer } from '@angular/router';
import { TranslateLoader, TranslateModule } from '@ngx-translate/core';
import { TranslateHttpLoader } from '@ngx-translate/http-loader';
import { AppComponent } from './app.component';
import { AuthGuard } from './core/auth.guard';
import { QueryHashLocationStrategy } from './core/query-hash-location-strategy';
import { MaterialModule } from './modules/material.module';
import { RoutePath } from './shared/constants';
import { PipesModule } from './shared/pipes/pipes.module';
import { CaseInsensitiveUrlSerializer } from './shared/util/url-serializer';
registerLocaleData(localeNl);
let AppModule = class AppModule {
};
AppModule = __decorate([
    NgModule({
        imports: [
            PipesModule,
            RouterModule.forRoot([
                { path: '', loadChildren: () => import('./modules/home/home.module').then(mod => mod.HomeModule), canActivate: [AuthGuard] },
                { path: RoutePath.LOADING, loadChildren: () => import('./modules/app-loader/app-loader.module').then(mod => mod.AppLoaderModule), canActivate: [AuthGuard] },
                { path: RoutePath.LOGIN, loadChildren: () => import('./modules/login/login.module').then(mod => mod.LoginModule) },
                { path: RoutePath.SUMMARIZE_DOCUMENT, loadChildren: () => import('./modules/summarize-document/summarize-document.module').then(m => m.SummarizeDocumentModule) }
            ], { useHash: true }),
            BrowserModule.withServerTransition({ appId: 'ng-cli-universal' }),
            MaterialModule,
            TranslateModule.forRoot({ loader: { deps: [HttpClient], provide: TranslateLoader, useFactory: http => new TranslateHttpLoader(http, './assets/i18n/', '.json') }, defaultLanguage: 'en' }),
            HttpClientModule,
            BrowserAnimationsModule
        ],
        providers: [
            { provide: LOCALE_ID, useValue: navigator.language },
            { provide: UrlSerializer, useClass: CaseInsensitiveUrlSerializer },
            { provide: LocationStrategy, useClass: QueryHashLocationStrategy }
        ],
        bootstrap: [AppComponent],
        declarations: [AppComponent]
    })
], AppModule);
export { AppModule };
//# sourceMappingURL=app.module.js.map