﻿using Decos.Kcs.Core.Messages;
using Decos.Kcs.Sessions.Dtos;
using Decos.Kcs.Sessions.Messages;
using Decos.Kcs.Tasks.Dtos;
using Decos.Kcs.Tasks.Messages;
using log4net;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.IO;
using System.Web;
using System.Web.Http;
using Decos.Kcs.Core.Web;

namespace Decos.Kcs.Tasks.Web.App_Code
{
    [AuthorizeSessionToken]
    public class PostController : ApiController
    {
        private ILog _logger;
        public PostController()
        {
            _logger = LogManager.GetLogger(typeof(PostController));
        }
        [HttpPost]
        [Throttle(Name = "PostTaskXDoc", Seconds = 1)]
        public void PostTaskXDoc()
        {
            _logger.Debug("CreateTaskRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var taskCreationMsg = HubHelper.DeserializeJsonFromStream<CreateTaskRequest>(reader))
                {
                    if (taskCreationMsg == null) return;
                    taskCreationMsg.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    taskCreationMsg.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], taskCreationMsg);
                }
            }
        }

        [HttpPost]
        public void PostHandleTaskXDoc()
        {
            _logger.Debug("HandleTaskRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                var request = HubHelper.DeserializeJsonFromStream<HandleTaskRequest>(reader);
                if (request != null && request.TaskDto != null)
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
            }
        }

        [HttpPost]
        public void PostReplyIRXDoc()
        {
            _logger.Debug("ReplyIRRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = new ReplyIRRequest { SessionId = HttpContext.Current.Request.QueryString["SessionId"], UICulture = HttpContext.Current.Request.QueryString["UICulture"] })
                {
                    request.TaskDto = HubHelper.DeserializeJsonFromStream<TaskDto>(reader);
                    if (request.TaskDto != null)
                        RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }

        [HttpPost]
        public void PostForwardTaskXDoc()
        {
            _logger.Debug("ForwardTaskRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                var inputObject = HubHelper.DeserializeJsonFromStream<dynamic>(reader);
                if (inputObject == null) return;
                var jObject = inputObject as JObject;
                if (jObject == null) return;
                if ((jObject.ToObject<JToken>().First) == null || jObject.ToObject<JToken>().Last == null) return;
                var taskString = ((JProperty)jObject.ToObject<JToken>().First).Value.ToString().Replace("\r\n ", "");
                var taskType = ((JProperty)jObject.ToObject<JToken>().Last).Value.ToString();
                var taskDto = JsonConvert.DeserializeObject<TaskDto>(taskString, new JsonSerializerSettings { TypeNameHandling = TypeNameHandling.Auto, MissingMemberHandling = MissingMemberHandling.Ignore });
                var forwardTaskType = JsonConvert.DeserializeObject<ForwardTaskType>(taskType, new JsonSerializerSettings { TypeNameHandling = TypeNameHandling.Auto, MissingMemberHandling = MissingMemberHandling.Ignore });
                if (taskDto == null) return;
                using (var request = new ForwardTaskRequest { TaskDto = taskDto, SessionId = HttpContext.Current.Request.QueryString["SessionId"], UICulture = HttpContext.Current.Request.QueryString["UICulture"], ForwardTaskType = forwardTaskType })
                {
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }
        [HttpPost]
        public void PostBulkHandleTaskXDoc()
        {
            _logger.Debug("BulkHandleTaskRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<BulkHandleTaskRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }
        [HttpPost]
        [Throttle(Name = "PostCallbackAttemptXDoc", Seconds = 1)]
        public void PostCallbackAttemptXDoc()
        {
            _logger.Debug("CallbackAttemptTaskRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<CallbackAttemptTaskRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }
        [HttpPost]
        [Throttle(Name = "PostCreateReportXDoc", Seconds = 1)]
        public void PostCreateReportXDoc()
        {
            _logger.Debug("CreateReportRequest called");
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = HubHelper.DeserializeJsonFromStream<CreateReportRequest>(reader))
                {
                    if (request == null) return;
                    request.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    request.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }

        [HttpPost]
        [Throttle(Name = "PostSessionXDoc", Seconds = 1)]
        public void PostSessionXDoc()
        {
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var request = new CreateOrUpdateSessionRequest { SessionId = HttpContext.Current.Request.QueryString["SessionId"], UICulture = HttpContext.Current.Request.QueryString["UICulture"] })
                {
                    request.SessionDto = HubHelper.DeserializeJsonFromStream<SessionEntityDto>(reader);
                    if (request.SessionDto != null)
                        RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], request);
                }
            }
        }
    }
}