﻿using Decos.Kcs.Core.Web;
using Decos.Kcs.Files.Messages;
using Newtonsoft.Json;
using System.IO;
using System.Web;
using System.Web.Http;

namespace Decos.Kcs.Files.Web.App_Code
{
    [AuthorizeSessionToken]
    public class PostController : ApiController
    {
        [HttpPost]
        [Throttle(Name = "PostFileXDoc", Seconds = 1)]
        public void PostFileXDoc()
        {
            using (var reader = new StreamReader(HttpContext.Current.Request.InputStream))
            {
                using (var fileCreationOrUpdationMsg = HubHelper.DeserializeJsonFromStream<CreateOrUpdateFileRequest>(reader))
                {
                    if (fileCreationOrUpdationMsg == null) return;
                    fileCreationOrUpdationMsg.SessionId = HttpContext.Current.Request.QueryString["SessionId"];
                    fileCreationOrUpdationMsg.UICulture = HttpContext.Current.Request.QueryString["UICulture"];
                    RebusWeb.SendMessageFromHub<KcsHub>(HttpContext.Current.Request.QueryString["connectionid"], fileCreationOrUpdationMsg);
                }
            }
        }
    }
}
