import { DateHelper } from "../helper/date-helper";
export class Sort {
    constructor() {
        this.sortOrder = 1;
        this.collator = new Intl.Collator(undefined, { numeric: true, sensitivity: "base" });
    }
    startSort(property, order, type = '') {
        if (order === "desc")
            this.sortOrder = -1;
        else if (order === "asc")
            this.sortOrder = 1;
        let nestedProperty;
        try {
            nestedProperty = property.split('.');
            if (nestedProperty.length === 2) {
                return (a, b) => {
                    if (type === 'date')
                        return this.sortData(new Date(a[nestedProperty[0]][nestedProperty[1]]), new Date(b[nestedProperty[0]][nestedProperty[1]]));
                    else
                        return this.collator.compare((a[nestedProperty[0]][nestedProperty[1]]), b[nestedProperty[0]][nestedProperty[1]]) * this.sortOrder;
                };
            }
            else if (nestedProperty.length === 3) {
                return (a, b) => {
                    if (type === 'date')
                        return this.sortData(new Date(a[nestedProperty[0]][nestedProperty[1]][nestedProperty[2]]), new Date(b[nestedProperty[0]][nestedProperty[1]][nestedProperty[2]]));
                    else
                        return this.collator.compare((a[nestedProperty[0]][nestedProperty[1]][nestedProperty[2]]), b[nestedProperty[0]][nestedProperty[1]][nestedProperty[2]]) * this.sortOrder;
                };
            }
            else {
                return (a, b) => {
                    if (type === 'date')
                        return this.sortData(new Date(a[property]), new Date(b[property]));
                    else
                        return this.collator.compare((a[property]), b[property]) * this.sortOrder;
                };
            }
        }
        catch (ex) {
            return (a, b) => {
                if (type === 'date')
                    return this.sortData(new Date(a[property]), new Date(b[property]));
                else
                    return this.collator.compare((a[property]), b[property]) * this.sortOrder;
            };
        }
    }
    sortData(a, b) {
        if (a < b)
            return -1 * this.sortOrder;
        else if (a > b)
            return 1 * this.sortOrder;
        else if (!DateHelper.validDate(a))
            return -1 * this.sortOrder;
        else if (!DateHelper.validDate(b))
            return 1 * this.sortOrder;
        else
            return 0 * this.sortOrder;
    }
}
//# sourceMappingURL=sort.js.map