var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe, SecurityContext } from '@angular/core';
let SafeHtmlPipe = class SafeHtmlPipe {
    constructor(domSanitizer) {
        this.domSanitizer = domSanitizer;
    }
    transform(value) {
        if (!value)
            return '';
        let urlRegex = /((https?:\/\/)|(www\.))[^\s/$.?#].[^\s]*/gi;
        let linkClass = 'link-content standard-blueLink';
        // Convert URLs into anchor tags with class
        let htmlLinks = value.replace(urlRegex, (safeURL) => {
            let url = safeURL.startsWith("www.") ? `http://${safeURL}` : safeURL;
            let sanitizedUrl = this.domSanitizer.sanitize(SecurityContext.URL, url);
            return `<a href="${sanitizedUrl}" target="_blank" rel="noopener noreferrer" class="${linkClass}" style="text-decoration: underline;">${safeURL}</a>`;
        });
        if (!htmlLinks)
            return '';
        const sanitizedHtml = this.domSanitizer.sanitize(SecurityContext.HTML, htmlLinks); // make HTML content safe before applying bypassSecurityTrustHtml.
        return this.domSanitizer.bypassSecurityTrustHtml(sanitizedHtml || '');
    }
};
SafeHtmlPipe = __decorate([
    Pipe({ name: 'safeHtml' })
], SafeHtmlPipe);
export { SafeHtmlPipe };
//# sourceMappingURL=safe-html.pipe.js.map