var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe } from "@angular/core";
import { PipeHelper } from "../helper/pipe-helper";
let OrganizationFormattedAddressPipe = class OrganizationFormattedAddressPipe {
    constructor(translateService) {
        this.translateService = translateService;
    }
    transform(organizationDto, returnHtml = false) {
        let addressInfo = "";
        if (organizationDto != null) {
            let addressDto = null;
            if (organizationDto.RegistrationAddress != null && organizationDto.RegistrationAddress.Address != null)
                addressDto = organizationDto.RegistrationAddress.Address;
            else if (organizationDto.CorrespondenceAddress != null && organizationDto.CorrespondenceAddress.Address != null)
                addressDto = organizationDto.CorrespondenceAddress.Address;
            addressInfo = PipeHelper.getFormattedAddress(addressDto, returnHtml, organizationDto.PrivateFields);
        }
        let defaultResult = returnHtml ? "<em style='color: gray;'>" + this.translateService.instant("LBL_NO_ADDRESS_FOUND") + "</em>" : this.translateService.instant("LBL_NO_ADDRESS_FOUND");
        return addressInfo == "" ? defaultResult : addressInfo;
    }
};
OrganizationFormattedAddressPipe = __decorate([
    Pipe({ name: 'organizationFormattedAddress' })
], OrganizationFormattedAddressPipe);
export { OrganizationFormattedAddressPipe };
//# sourceMappingURL=organization-formated-address.pipe.js.map