var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe } from "@angular/core";
import { GlobalFunctions } from "../global-functions";
import { PipeHelper } from "../helper/pipe-helper";
let OrganizationFormattedAddressWithLabelPipe = class OrganizationFormattedAddressWithLabelPipe {
    constructor(translateService) {
        this.translateService = translateService;
    }
    transform(organizationDto, returnHtml = false) {
        let addressInfo = "";
        let label = "";
        if (organizationDto != null) {
            let registrationAddress, correspondenceAddress;
            if (organizationDto.RegistrationAddress != null && organizationDto.RegistrationAddress.Address != null)
                registrationAddress = PipeHelper.getFormattedAddress(organizationDto.RegistrationAddress.Address, returnHtml, organizationDto.PrivateFields);
            if (organizationDto.CorrespondenceAddress != null && organizationDto.CorrespondenceAddress.Address != null)
                correspondenceAddress = PipeHelper.getFormattedAddress(organizationDto.CorrespondenceAddress.Address, returnHtml, organizationDto.PrivateFields);
            if (correspondenceAddress == registrationAddress)
                correspondenceAddress = null;
            if (!GlobalFunctions.isEmpty(registrationAddress) && GlobalFunctions.isEmpty(correspondenceAddress))
                addressInfo = registrationAddress;
            else {
                if (!GlobalFunctions.isEmpty(registrationAddress)) {
                    label = returnHtml ? "<b>" + this.translateService.instant("LBL_REGISTRATION") + ": </b>" : this.translateService.instant("LBL_REGISTRATION") + ":";
                    addressInfo = label + registrationAddress;
                }
                if (!GlobalFunctions.isEmpty(correspondenceAddress)) {
                    label = returnHtml ? "<b>" + this.translateService.instant("LBL_CORRESPONDENCE") + ": </b>" : this.translateService.instant("LBL_CORRESPONDENCE") + ":";
                    correspondenceAddress = label + correspondenceAddress;
                    if (!GlobalFunctions.isEmpty(addressInfo))
                        addressInfo = addressInfo + (returnHtml ? "<br/>" : "\n") + correspondenceAddress;
                    else
                        addressInfo = correspondenceAddress;
                }
            }
        }
        let defaultResult = "";
        if (organizationDto != null && (organizationDto.RegistrationAddress != undefined || organizationDto.CorrespondenceAddress != undefined))
            defaultResult = returnHtml ? "<em style='color: gray;'>" + this.translateService.instant("LBL_NO_ADDRESS_FOUND") + "</em>" : this.translateService.instant("LBL_NO_ADDRESS_FOUND");
        return addressInfo == "" ? defaultResult : addressInfo;
    }
};
OrganizationFormattedAddressWithLabelPipe = __decorate([
    Pipe({ name: 'organizationFormattedAddressWithLabel' })
], OrganizationFormattedAddressWithLabelPipe);
export { OrganizationFormattedAddressWithLabelPipe };
//# sourceMappingURL=organization-formated-address-with-label.pipe.js.map