var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe } from '@angular/core';
import { GlobalFunctions } from '../global-functions';
let EmployeeFilterPipe = class EmployeeFilterPipe {
    transform(employees, query) {
        let filteredEmployees = [];
        if (query != null && query.length > 0) {
            query = query.toLowerCase();
            if (GlobalFunctions.isNumber(query)) {
                employees.forEach(employee => {
                    if ((employee.ExtensionNumber && employee.ExtensionNumber.indexOf(query) >= 0) ||
                        (employee.PhoneNumber && employee.PhoneNumber.indexOf(query) >= 0) ||
                        (employee.MobileNumber && employee.MobileNumber.indexOf(query) >= 0))
                        filteredEmployees.push(employee);
                });
            }
            else {
                employees.forEach(employee => {
                    if (GlobalFunctions.isValidDiacriticSearch(employee.Surname, query) ||
                        GlobalFunctions.isValidDiacriticSearch(employee.FirstName, query) ||
                        GlobalFunctions.isValidDiacriticSearch(employee.Function, query) ||
                        GlobalFunctions.isValidDiacriticSearch(employee.Note, query) ||
                        (employee.Skills != null && employee.Skills.length > 0 && jlinq.from(employee.Skills).contains("Name", query).any()) ||
                        (employee.Department != null && GlobalFunctions.isValidDiacriticSearch(employee.Department.Name, query)) ||
                        (employee.IsPopular && employee.FunctionWithDepartment != null && GlobalFunctions.isValidDiacriticSearch(employee.FunctionWithDepartment, query)) ||
                        GlobalFunctions.isValidDiacriticSearch(employee.ExtraInfo, query))
                        filteredEmployees.push(employee);
                });
            }
        }
        else
            filteredEmployees = employees;
        return filteredEmployees;
    }
};
EmployeeFilterPipe = __decorate([
    Pipe({ name: 'employeeFilter' })
], EmployeeFilterPipe);
export { EmployeeFilterPipe };
//# sourceMappingURL=employee-filter.pipe.js.map