import { ContactSessionNotesUIState } from '../../core/enums/common-enums';
export class DialogHelper {
    static openDialog(dialog, component, width, height, top, left, data, id = dialog.openDialogs.length.toString()) {
        // Use already opened dialog to prevent a duplicate component type from opening (only works for dialogs with an unique id)
        const alreadyOpenedDialog = dialog.getDialogById(id);
        alreadyOpenedDialog ? this.dialogRef = alreadyOpenedDialog : this.dialogRef = dialog.open(component, {
            id,
            data,
            role: 'dialog',
            width,
            height,
            position: { top, left },
            autoFocus: true,
            panelClass: 'make-it-middle',
            disableClose: true,
            closeOnNavigation: true
        });
        return this.dialogRef;
    }
    static getMessage(messageHeader, textMsg, isConfirmativeBox, isAutoClose = false, yesButton = null, noButton = null, okButton = null, translateService) {
        const messagedata = {
            messageHeader: messageHeader,
            textMsg: textMsg,
            isConfirmation: isConfirmativeBox,
            isAutoClose: isAutoClose,
            yesButton: yesButton ? yesButton : translateService.instant('LBL_YES'),
            noButton: noButton ? noButton : translateService.instant('LBL_NO'),
            okButton: okButton ? okButton : translateService.instant('LBL_OK')
        };
        return messagedata;
    }
    static closeDialog() {
        if (this.dialogRef != null)
            this.dialogRef.close();
    }
    static checkUIState(state) {
        return state != ContactSessionNotesUIState.Pinned ? '50vw' : '45vw';
    }
}
//# sourceMappingURL=dialog-helper.js.map