var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Directive } from '@angular/core';
import { fromEvent, Subject } from 'rxjs';
import { map, switchMap, takeUntil } from 'rxjs/operators';
let DragDirective = class DragDirective {
    constructor(_elementRef, _zone, _cd) {
        this._elementRef = _elementRef;
        this._zone = _zone;
        this._cd = _cd;
        this._delta = { x: 0, y: 0 };
        this._offset = { x: 0, y: 0 };
        this._destroy$ = new Subject();
        this._isResized = false;
    }
    ngOnInit() {
        this._elementRef.nativeElement.style.cursor = 'default';
        this._handle = this._elementRef.nativeElement;
        // Due to different parent element length, directly accessing root element.
        this._container = document.getElementById("jkcParentPanelContainer");
        this._target = document.getElementById("jkcParentPanel");
        this._container.style.resize = 'both';
        this._container.style.overflow = 'hidden';
        this._setupEvents();
    }
    ngOnDestroy() {
        if (!!this._destroy$ && !this._destroy$.closed) {
            this._destroy$.next();
            this._destroy$.complete();
        }
    }
    _setupEvents() {
        this._zone.runOutsideAngular(() => {
            const mousedown$ = fromEvent(this._handle, 'mousedown');
            const mousemove$ = fromEvent(document, 'mousemove');
            const mouseup$ = fromEvent(document, 'mouseup');
            const mousedrag$ = mousedown$.pipe(switchMap((event) => {
                const startX = event.clientX;
                const startY = event.clientY;
                const rectX = this._container.getBoundingClientRect();
                if (
                // if the user is clicking on the bottom-right corner, he will resize the dialog
                startY > rectX.bottom - 15 &&
                    startY <= rectX.bottom &&
                    startX > rectX.right - 15 &&
                    startX <= rectX.right) {
                    this._isResized = true;
                    // return observableOf(null);
                }
                return mousemove$.pipe(map((innerEvent) => {
                    innerEvent.preventDefault();
                    this._delta = {
                        x: innerEvent.clientX - startX,
                        y: innerEvent.clientY - startY,
                    };
                }), takeUntil(mouseup$));
            }), takeUntil(this._destroy$));
            mousedrag$.subscribe(() => {
                if (this._delta.x === 0 && this._delta.y === 0) {
                    return;
                }
                this._translate();
            });
            mouseup$.pipe(takeUntil(this._destroy$)).subscribe(() => {
                if (this._isResized) {
                    this._handle.style.width = 'auto';
                }
                this._offset.x += this._delta.x;
                this._offset.y += this._delta.y;
                this._delta = { x: 0, y: 0 };
                this._cd.markForCheck();
            });
        });
    }
    _translate() {
        requestAnimationFrame(() => {
            this._target.style.transform = `
        translate(${this._offset.x + this._delta.x}px,
                  ${this._offset.y + this._delta.y}px)
      `;
        });
    }
};
DragDirective = __decorate([
    Directive({
        selector: '[drag]'
    })
], DragDirective);
export { DragDirective };
//# sourceMappingURL=drag.directive.js.map