var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Directive, EventEmitter, HostListener, Input, Output } from '@angular/core';
import { Subject } from 'rxjs';
import { debounceTime, distinctUntilChanged, takeUntil, tap } from 'rxjs/operators';
let DebounceDirective = class DebounceDirective {
    constructor() {
        this.time = 500;
        this.onDebounce = new EventEmitter();
        this.subs = new Subject();
        this.event = new Subject();
    }
    ngOnInit() {
        this.event.pipe(takeUntil(this.subs), distinctUntilChanged(), debounceTime(this.time), tap(value => this.emit(value))).subscribe();
    }
    ngOnDestroy() {
        this.subs.complete();
    }
    emit(value) {
        this.onDebounce.emit(value);
    }
    onKeyUp(event) {
        event.preventDefault();
        this.event.next(event);
    }
};
__decorate([
    Input()
], DebounceDirective.prototype, "time", void 0);
__decorate([
    Output()
], DebounceDirective.prototype, "onDebounce", void 0);
__decorate([
    HostListener('keyup', ['$event'])
], DebounceDirective.prototype, "onKeyUp", null);
DebounceDirective = __decorate([
    Directive({
        selector: '*[debounce]'
    })
], DebounceDirective);
export { DebounceDirective };
//# sourceMappingURL=debounce.directive.js.map