export class AppConstants {
}
AppConstants.KCS_HUB = 'kcsHub';
AppConstants.KCS_HUB_ISSUE = 'issueHub';
AppConstants.KCS_HUB_TICKET = 'ticketsHub';
AppConstants.EMAIL_VALIDATOR = '/^[a-zA-Z0-9_\+-]+(\.[a-zA-Z0-9_\+-]+)*@[a-zA-Z0-9_\+-]+(\.[a-zA-Z0-9-]+)*\.([a-zA-Z]{2,4})$/';
export class LanaguageCode {
}
LanaguageCode.NL_CODE = 'nl';
LanaguageCode.EN_CODE = 'en';
export class Locale {
}
Locale.NL_NL = 'nl-NL';
Locale.EN_EN = 'en-US';
export class DateTimeFormat {
}
DateTimeFormat.FORMAT_1 = 'M/d/yyyy HH:mm:ss';
export class LocalStorageKey {
}
LocalStorageKey.REDIRECT_URL = 'redirect_url';
LocalStorageKey.SESSION_TOKEN = 'sessionToken';
LocalStorageKey.USER_AUTHENTICATED = 'user_authenticated';
LocalStorageKey.KCS_USERNAME = 'kcs_username';
LocalStorageKey.KCS_PASSWORD = 'kcs_password';
LocalStorageKey.KCS_REMEMBER_ME = 'kcs_rememberMe';
LocalStorageKey.KCS_USERLOGON_TYPE = 'kcs_userlogontype';
LocalStorageKey.KCS_USERAUTH_TYPE = 'kcs_userAuthType';
LocalStorageKey.KCS_USER2FA = 'kcs_user2fa';
LocalStorageKey.REGISTERED_EXTENSION = 'registeredExtension';
LocalStorageKey.PRIVILEGE_DATA = 'privilege_data';
LocalStorageKey.APP_REFRESHED = 'app_refreshed';
LocalStorageKey.APP_INIT_VIEW = 'app_init_view';
LocalStorageKey.SOURCE = 'source';
LocalStorageKey.DEEPLINK = 'deeplink';
LocalStorageKey.SSO_LOGOUT = 'ssologout';
export class SignalREvents {
}
SignalREvents.SEARCH_RESULT_FOUND = 'searchResultFound';
SignalREvents.UPDATED_SEARCH_STATUS = 'updateSearchStatus';
SignalREvents.USER_BUSINESS_EXCEPTION_RECIEVED = 'userBusinessExceptionReceived';
SignalREvents.PROFILE_RESPONSE = 'profileResponse';
SignalREvents.SERVICE_NOT_RUNNING_RESULT = 'serviceNotRunningResult';
SignalREvents.TOKEN_FAILED_RESPONSE = 'tokenFailedResponse';
SignalREvents.SEARCH = 'search';
SignalREvents.SEARCH_ROLE_RESPONSE = 'searchRoleResponse';
SignalREvents.RELATED_EMPLOYEE_RESULT_SOUND = 'relatedEmployeeResultFound';
export class RoutePath {
}
RoutePath.LOGIN = 'login';
RoutePath.LOADING = 'loading';
RoutePath.DASHBOARD = 'dashboard';
RoutePath.SEARCH_PATH = 'search';
RoutePath.SEARCH = 'search/:domain';
RoutePath.LIST_PATH = 'list';
RoutePath.LIST = 'list/:domain';
RoutePath.LIST_WITH_SUB_TYPE = 'list/:domain/:subType';
RoutePath.DETAIL_PATH = 'detail';
RoutePath.DETAIL = 'detail/:domain';
RoutePath.DETAIL_WITH_ID = 'detail/:domain/:id';
RoutePath.ACTIVITY_PATH = 'activity';
RoutePath.ACTIVITY = 'activity/:number';
RoutePath.SUMMARIZE_DOCUMENT = 'summarize-document';
export class WebTilesEntity {
}
WebTilesEntity.TASK = 'Task';
WebTilesEntity.EMAIL = 'Email';
WebTilesEntity.SOCIAL_MEDIA = 'SocialMedia';
WebTilesEntity.CONTACT = 'Contact';
WebTilesEntity.POST = 'Post';
WebTilesEntity.TICKET = 'Ticket';
WebTilesEntity.ALL_EMAIL = 'AllEmai';
WebTilesEntity.ALL_SOCIAL_MEDIA = 'AllSocialMedia';
export class WebPartType {
    ;
}
WebPartType.BIRTHDAY_WEEK = 'BirthdayWeek';
WebPartType.MY_FAVOURITE = 'MyFavourite';
WebPartType.MOST_SELECTED_BY_ME = 'MostSelectedByMe';
WebPartType.MOST_SELECTED_BY_EVERYONE = 'MostSelectedByEveryone';
WebPartType.MOST_SELECTED_BY_ROLE = 'MostSelectedByRole';
WebPartType.NOTIFICATIONS = 'Notifications';
WebPartType.IMPORTANT = 'Important';
WebPartType.LINKS = 'Link';
WebPartType.FILE_ENTITY = 'Fileentity';
WebPartType.NOTE_ENTITY = 'Noteentity';
WebPartType.THEME_PAGE = 'Themepage';
WebPartType.QUESTION_ANSWER = 'Questionanswer';
WebPartType.PRODUCT = 'Product';
WebPartType.NEWS = 'News';
WebPartType.RSS_FEED = 'RSSFeed';
export class Parameters {
}
Parameters.THEME = 'theme';
Parameters.DOMAIN = 'domain';
export class SideMenuItem {
}
SideMenuItem.THEME = 'theme';
SideMenuItem.DASHBOARD = 'dashboard';
SideMenuItem.DOCUMENT = 'document';
SideMenuItem.CONTACT_HISTORY = 'contacthistory';
SideMenuItem.NEWS = 'news';
SideMenuItem.NOTE = 'note';
SideMenuItem.TASK = 'task';
SideMenuItem.TICKET = 'ticket';
SideMenuItem.EMAIL = 'email';
SideMenuItem.SOCIAL_MEDIA = 'socialmedia';
export class BroadCastEventKeys {
}
BroadCastEventKeys.LOCAL_SEARCH_TEXT_CHANGE = 'localSearchTextChange';
BroadCastEventKeys.UPDATE_SEARCH_VIEW = 'updateSearchView';
BroadCastEventKeys.UPDATE_SEARCH_RESULTS = 'updateSearchResults';
BroadCastEventKeys.UPDATE_DETAIL_VIEW = 'update_detail_view';
BroadCastEventKeys.UPDATE_VIEWER_VIEW = 'update_viewer_view';
BroadCastEventKeys.TAGS_SELECTED = 'tagsSelected';
BroadCastEventKeys.TAG_SELECTED = 'tagSelected';
BroadCastEventKeys.CLEAR_SESSION = 'clearSession';
BroadCastEventKeys.SINGLE_RECORD_SELECTION = 'singleRecordSelection';
BroadCastEventKeys.SET_CONTACT_SESSION_QUESTION_ANSWERS = 'setContactSessionQuestionAnswers';
BroadCastEventKeys.STOP_SPINNER = 'stop_spinner';
BroadCastEventKeys.RELOAD_ENTITY_DETAIL = 'reloadEntityDetail';
BroadCastEventKeys.CONTACT_HISTORY_SERVICE_CONNECTED = 'contactHistoryServiceConnected';
BroadCastEventKeys.ADDED_ENTITY_TO_CURRENT_SESSION = 'addedEntityToCurrentSession';
BroadCastEventKeys.AUTO_END_SESSION = 'autoEndSession';
BroadCastEventKeys.SELECT_ROLE = 'selectRole';
BroadCastEventKeys.JKC_PANEL_RESET = 'jkcPanelReset';
BroadCastEventKeys.CLEAR_POPULAR_LIST = 'clearPopularList';
BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL = 'loadSelectedEntityInDetail';
BroadCastEventKeys.JSPANEL_RESIZE = 'jspanelResize';
BroadCastEventKeys.LOGOUT = 'logout';
BroadCastEventKeys.RESIZE_CSN = 'resizeCSN';
BroadCastEventKeys.OPEN_VIEWER_PANEL = 'openViewerPanel';
BroadCastEventKeys.TOGGLE_VIEWER_PANEL = 'toggleViewerPanel';
BroadCastEventKeys.TOGGLE_SUGGESTION_PANEL = 'toggleSuggestionPanel';
BroadCastEventKeys.REFRESH_DASHBOARD = 'refreshDashboard';
BroadCastEventKeys.UPDATE_LOCAL_SEARCH_RESULT_LIST = 'updateLocalSearchResultList';
BroadCastEventKeys.REMOVE_COMPONENT = 'removeComponent';
BroadCastEventKeys.UPDATE_LOCATIONS = 'updateLocations';
BroadCastEventKeys.UPDATE_LOCATIONS_SEARCH_RESULTS = 'updateLocationsSearchResult';
BroadCastEventKeys.FETCH_TASK_STATISTIC = 'fetchTaskStatistic';
BroadCastEventKeys.FETCH_TICKET_STATISTIC = 'fetchTicketStatistic';
BroadCastEventKeys.FETCH_CONTACT_STATISTIC = 'fetchContactStatistic';
BroadCastEventKeys.FETCH_SOCIAL_MEDIA_STATISTIC = 'fetchSocialMediaStatistic';
BroadCastEventKeys.FETCH_SPECIFIC_STATISTIC = 'fetchSpecificStatistic';
BroadCastEventKeys.UPDATE_EMAIL_TABS = 'updateEmailTabs';
BroadCastEventKeys.CLOSE_AUTOCOMPLETE_SEARCH = 'closeAutocompleteSearch';
BroadCastEventKeys.CLOSE_ALL_POPUPS = 'closeAllOpenedPopups';
export class Domain {
}
Domain.PERSON = 'PERSON';
Domain.SOCIAL_MEDIA = 'SOCIALMEDIA';
Domain.TASK = {
    ALL: 'TASK',
    APPOINTMENT: 'APPOINTMENT',
    ASSIGNMENT: 'ASSIGNMENT',
    CALLBACK_NOTE: 'CALLBACKNOTE',
    INFORMATION_REQUEST: 'INFORMATIONREQUEST',
    REPORT_IMPROVEMENT: 'REPORTIMPROVEMENT'
};
Domain.THEME = 'THEME';
export class Viewer {
}
Viewer.DOMAIN_VIEWVER = 'DomainViewer';
Viewer.PERSON_VIEWVER = 'PersonViewer';
Viewer.THEME_VIEWVER = 'ThemeViewer';
Viewer.ORGANIZATION_VIEWER = 'OrganizationViewer';
Viewer.DOCUMENT_VIEWVER = 'DocumentViewer';
Viewer.FILE_VIEWVER = 'FileViewer';
Viewer.LINK_VIEWVER = 'LinkViewer';
Viewer.CASE_ENTITY_VIEWER = 'CaseEntityViewer';
Viewer.QUESTION_ANSWER_VIEWER = 'QuestionAnswerViewer';
Viewer.NOTE_ENTITY = 'NoteViewer';
Viewer.EMPLOYEE = 'EmployeeViewer';
Viewer.PRODUCT_VIEWER = 'ProductViewer';
Viewer.EMPLOYEE_VIEWER = 'EmployeeViewer';
Viewer.ISSUE_VIEWER = 'IssueViewer';
Viewer.NEWS_VIEWER = 'NewsViewer';
Viewer.CONTACT_HISTORY_VIEWER = 'ContactHistoryViewer';
Viewer.EMAIL_VIEWER = 'EmailViewer';
Viewer.ASSIGNMENT_VIEWER = 'AssignmentViewer';
Viewer.APPOINTMENT_VIEWER = 'AppointmentViewer';
Viewer.CALLBACK_NOTE_VIEWER = 'CallbackNoteViewer';
Viewer.INFORMATION_REQUEST_VIEWER = 'InformationRequestViewer';
Viewer.REPORT_IMPROVEMENT_VIEWER = 'ReportImprovementViewer';
Viewer.TICKET_VIEWER = 'TicketViewer';
Viewer.FACEBOOK_VIEWER = 'FacebookViewer';
Viewer.TWITTER_VIEWER = 'TwitterViewer';
Viewer.WHATSAPP_VIEWER = 'WhatsAppViewer';
export class EntityName {
}
EntityName.CASEENTITY = 'caseentity';
EntityName.DOCUMENT = 'document';
EntityName.EMPLOYEE = 'employee';
EntityName.FILEENTITY = 'fileentity';
EntityName.ORGANIZATION = 'organization';
EntityName.PERSON = 'person';
EntityName.PRODUCT = 'product';
EntityName.THEME = 'theme';
EntityName.TICKET = 'ticket';
EntityName.NEWS = 'news';
EntityName.SOCIAL_MEDIA = 'socialmedia';
EntityName.LOCATION = 'location';
EntityName.TASK = 'task';
EntityName.EMAIL = 'email';
EntityName.CONTACT_HISTORY = 'contacthistory';
EntityName.NOTE_ENTITY = 'noteentity';
EntityName.LINK = 'link';
EntityName.QUESTIONANSWER = 'questionanswer';
export class TinyMCE {
}
TinyMCE.PLUGINS = 'link image table autolink lists';
TinyMCE.TASK_TOOLBAR = 'undo redo | fontfamily blocks fontsize | bold italic underline | alignleft aligncenter alignright | bullist numlist | outdent indent | table | forecolor backcolor | link | standardFormat | image';
TinyMCE.FONT_SIZE_FORMATS = '8pt 8.5pt 9pt 9.5pt 10pt 10.5pt 11pt 11.5pt 12pt 13pt 14pt 15pt 16pt 17pt 18pt 19pt 20pt 22pt 24pt 28pt 32pt 36pt';
TinyMCE.FONT_FAMILY_FORMATS = 'Andale Mono=andale mono,times;Arial=arial,sans-serif;Arial Black=arial black,sans-serif;Book Antiqua=book antiqua,serif;Comic Sans MS=comic sans ms;Courier New=courier new;Georgia=georgia,serif;Helvetica=helvetica;Impact=impact,sans-serif;Symbol=symbol;Tahoma=tahoma,sans-serif;Terminal=terminal,monaco;Times New Roman=times new roman,serif;Trebuchet MS=trebuchet ms,sans-serif;Verdana=verdana,sans-serif;Webdings=webdings;Wingdings=wingdings,zapf dingbats';
//# sourceMappingURL=constants.js.map