var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { MessageboxComponent } from '../../components/common/messagebox/messagebox.component';
import { DialogHelper } from '../../shared/helper/dialog-helper';
import { marked } from 'marked';
import { BaseComponent } from '../../components/base-component';
import { SubSink } from 'subsink';
let SummarizeDocumentComponent = class SummarizeDocumentComponent extends BaseComponent {
    constructor(sessionManager, applicationSettingManager, translateService, systemComponentService, dialog, route, router, zone, changeDetectorRef, viewContainerRef) {
        super(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef);
        this.sessionManager = sessionManager;
        this.applicationSettingManager = applicationSettingManager;
        this.translateService = translateService;
        this.systemComponentService = systemComponentService;
        this.dialog = dialog;
        this.route = route;
        this.router = router;
        this.zone = zone;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
        this.summarizedContentToShow = "";
        this.entityDescription = "";
        this.entityTitle = "";
        this.showProgressBar = true;
        this.subs = new SubSink();
        this.getSummarizedDocumentResponse = this.getSummarizedDocumentResponse.bind(this);
        this.summarizedDocumentErrorCallback = this.summarizedDocumentErrorCallback.bind(this);
    }
    ngOnInit() {
        window.addEventListener('message', (event) => {
            const { title, content } = event.data;
            if (title && content) {
                this.entityTitle = title;
                this.entityDescription = content;
                this.executeSummarization();
            }
        });
    }
    executeSummarization() {
        this.systemComponentService.connect().then(() => {
            this.systemComponentService.generateSummary({ Document: this.entityDescription }, this.getSummarizedDocumentResponse, this.summarizedDocumentErrorCallback);
        });
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    getSummarizedDocumentResponse(response) {
        if (response && response.Success) {
            this.summarizedContentToShow = String(marked.parse(response.SummarizedContent));
            this.showProgressBar = false;
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_SUMMARIZE'), textMsg: response.ErrorMessage }).afterClosed().subscribe(() => {
                this.showProgressBar = false;
                setTimeout(() => { window.close(); }, 100);
            });
    }
    summarizedDocumentErrorCallback() {
    }
    ngAfterViewInit() {
        const links = document.querySelectorAll('.summary-content a');
        links.forEach(link => {
            link.setAttribute('target', '_blank');
            link.setAttribute('rel', 'noopener noreferrer');
        });
    }
};
SummarizeDocumentComponent = __decorate([
    Component({
        selector: 'app-summarize-document',
        templateUrl: './summarize-document.component.html',
        styleUrls: ['./summarize-document.component.scss']
    })
], SummarizeDocumentComponent);
export { SummarizeDocumentComponent };
//# sourceMappingURL=summarize-document.component.js.map