var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, HostListener } from '@angular/core';
import { BaseComponent } from '../../components/base-component';
import { LocalStorageKey, RoutePath } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { BooleanHelper } from '../../shared/helper/boolean-helper';
let HomeComponent = class HomeComponent extends BaseComponent {
    constructor(phoneManager, sessionManager, translateService, router, zone, dialog, changeDetectorRef, viewContainerRef, contactHistoryService) {
        super(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef);
        this.phoneManager = phoneManager;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.router = router;
        this.zone = zone;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
        this.contactHistoryService = contactHistoryService;
        this.rights = { contactHistory: false };
    }
    unloadHandler(event) {
        const initAppView = localStorage.getItem(LocalStorageKey.APP_INIT_VIEW);
        if (!GlobalFunctions.isEmpty(initAppView))
            localStorage.removeItem(LocalStorageKey.APP_INIT_VIEW);
        else if (!this.sessionManager.isLoggedOut)
            localStorage.setItem(LocalStorageKey.APP_REFRESHED, 'true');
    }
    ngOnInit() {
        const isApplicationRefreshed = localStorage.getItem(LocalStorageKey.APP_REFRESHED);
        if (!GlobalFunctions.isEmpty(isApplicationRefreshed) && BooleanHelper.stringToBoolean(isApplicationRefreshed)) {
            localStorage.removeItem(LocalStorageKey.APP_REFRESHED);
            super.navigate(RoutePath.LOGIN, true);
        }
        else
            this.rights.contactHistory = GlobalFunctions.checkRights('ContactHistory', 3);
    }
    contactSessionNotesBarClicked() {
        this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen = !this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen;
        const contactSessionNotesPanelElement = $("#contactSessionNotesPanel");
        if (this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen) {
            const windowHeight = $(window).height();
            const newHeight = windowHeight - $("#contactSessionNotesHeader").height() - $("#contactSessionNotesFooter").height() - contactSessionNotesPanelElement?.position()?.top - 2;
            $("#contactSessionNotesBody").height(newHeight + 'px');
            this.contactHistoryService.resizeContactSessionNotes();
            contactSessionNotesPanelElement.css({ 'display': 'flex' });
        }
        else
            contactSessionNotesPanelElement.css({ 'display': 'none' });
    }
    ;
    hidePhoneWindow() {
        if (!GlobalFunctions.isEmpty(this.phoneManager.phoneState) && !GlobalFunctions.isEmpty(this.phoneManager.phoneState.CurrentState) && (this.phoneManager.phoneState.CurrentState == 2 || this.phoneManager.phoneState.CurrentState == 5 || this.phoneManager.phoneState.CurrentState == 6 || this.phoneManager.phoneState.CurrentState == 9))
            return;
        const element = $('#mainPhoneContainer');
        if (element)
            element.hide();
    }
    ;
    hideNoChannelSelectionWindow() {
        const element = $('#noChannelSelectionMsgPopup');
        if (element)
            element.hide();
    }
    ;
};
__decorate([
    HostListener('window:beforeunload', ['$event'])
], HomeComponent.prototype, "unloadHandler", null);
HomeComponent = __decorate([
    Component({
        selector: 'home',
        templateUrl: './home.component.html',
        styleUrls: ['./home.component.scss']
    })
], HomeComponent);
export { HomeComponent };
//# sourceMappingURL=home.component.js.map