var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { OperationType } from 'src/app/core/enums/common-enums';
import { DashboardWebpartLink } from 'src/app/core/models/dashboard/dashboard-webpart-link';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
let PopularComponent = class PopularComponent {
    constructor(cacheManager, sessionManager, productService, systemComponentService) {
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.productService = productService;
        this.systemComponentService = systemComponentService;
        this.showProgressBar = false;
        this.onItemSelect = new EventEmitter();
        this.searchMostSelectedResponse = this.searchMostSelectedResponse.bind(this);
    }
    ;
    ngOnInit() {
        try {
            let dashbordPopularItems_cache = this.dashboardWebPart.Type.toUpperCase() === "MOSTSELECTEDBYROLE" ? this.cacheManager.getFromDashboardCache(this.dashboardWebPart.Type + this.productService.roleId) : this.cacheManager.getFromDashboardCache(this.dashboardWebPart.Type);
            if (dashbordPopularItems_cache != undefined)
                this.dashboardWebPart.Links = dashbordPopularItems_cache;
            else {
                this.showProgressBar = true;
                switch (this.dashboardWebPart.Type.toUpperCase()) {
                    case "MOSTSELECTEDBYME":
                        {
                            this.systemComponentService.searchMostSelectedByMe(GlobalFunctions.getLoggedInUserId(), this.searchMostSelectedResponse);
                            break;
                        }
                    case "MOSTSELECTEDBYROLE":
                        {
                            this.systemComponentService.searchMostSelectedByRole(this.productService.roleId, this.searchMostSelectedResponse);
                            break;
                        }
                    case "MOSTSELECTEDBYEVERYONE":
                        {
                            this.systemComponentService.searchMostSelectedByEveryone(this.searchMostSelectedResponse);
                            break;
                        }
                }
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    searchMostSelectedResponse(message) {
        try {
            if (message !== null && message.MostSelectedDtoList != null && message.MostSelectedDtoList.length > 0) {
                let result = message.MostSelectedDtoList;
                result.sort((x, y) => y.Hits - x.Hits);
                this.dashboardWebPart.Links = this.convertToWebpartLink(result);
                this.sessionManager.setBgColorBasedOnObjectSource(this.dashboardWebPart.Links);
            }
            if (this.dashboardWebPart.Type.toUpperCase() === "MOSTSELECTEDBYROLE")
                this.cacheManager.addToDashboardCache(this.dashboardWebPart.Type + this.productService.roleId, this.dashboardWebPart.Links);
            else
                this.cacheManager.addToDashboardCache(this.dashboardWebPart.Type, this.dashboardWebPart.Links);
            this.showProgressBar = false;
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    convertToWebpartLink(mostSelectedDtoList) {
        let webpartLinks = [];
        for (let index = 0; index < mostSelectedDtoList.length; index++) {
            let entityType = GlobalFunctions.getObjectTypeName(mostSelectedDtoList[index].RelatedEntityFqdn);
            if (GlobalFunctions.checkRights(entityType, OperationType.View)) {
                let link = new DashboardWebpartLink();
                link.Id = mostSelectedDtoList[index].Id;
                link.StringRepresentation = mostSelectedDtoList[index].StringRepresentation;
                link.Entity = entityType;
                if (entityType.toUpperCase() === "PRODUCT" && !GlobalFunctions.isEmpty(mostSelectedDtoList[index].Link))
                    link.Link = mostSelectedDtoList[index].Link;
                link.RelatedEntityFqdn = GlobalFunctions.toContentType(entityType);
                link.Icon = GlobalFunctions.getIconClass(link.RelatedEntityFqdn);
                link.RelatedEntityFqdn = link.RelatedEntityFqdn.replace(/\./g, '_');
                link.ObjectSource = mostSelectedDtoList[index].ObjectSource;
                link.Order = webpartLinks.length + 1;
                webpartLinks.push(link);
            }
        }
        return webpartLinks;
    }
    ;
    showEform(link, event) {
        GlobalFunctions.stopEventPropagation(event);
        if (!GlobalFunctions.isEmpty(link))
            this.productService.showEform(link);
    }
    ;
    select(popularItem) {
        this.onItemSelect.emit(popularItem);
    }
};
__decorate([
    Input()
], PopularComponent.prototype, "dashboardWebPart", void 0);
__decorate([
    Output()
], PopularComponent.prototype, "onItemSelect", void 0);
PopularComponent = __decorate([
    Component({
        selector: 'popular-webpart',
        templateUrl: './popular.component.html',
        styleUrls: ['./popular.component.scss']
    })
], PopularComponent);
export { PopularComponent };
//# sourceMappingURL=popular.component.js.map