var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { OperationType } from 'src/app/core/enums/common-enums';
import { DashboardWebpartLink } from 'src/app/core/models/dashboard/dashboard-webpart-link';
import { GlobalFunctions } from 'src/app/shared/global-functions';
let FavouriteComponent = class FavouriteComponent {
    constructor(cacheManager, sessionManager, systemComponentService) {
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.systemComponentService = systemComponentService;
        this.showProgressBar = false;
        this.onItemSelect = new EventEmitter();
        this.searchFavouriteResponse = this.searchFavouriteResponse.bind(this);
    }
    ngOnInit() {
        try {
            let dashbordFavouriteItems_cache = this.cacheManager.getFromDashboardCache(this.dashboardWebPart.Type);
            if (dashbordFavouriteItems_cache != undefined) {
                dashbordFavouriteItems_cache.sort((a, b) => new Date(b.Date).getTime() - new Date(a.Date).getTime());
                this.dashboardWebPart.Links = dashbordFavouriteItems_cache;
                this.sessionManager.setBgColorBasedOnObjectSource(this.dashboardWebPart.Links);
            }
            else {
                this.showProgressBar = true;
                this.systemComponentService.searchFavourite(this.searchFavouriteResponse);
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    searchFavouriteResponse(message) {
        try {
            if (message !== null && message.FavouriteDtoList != null && message.FavouriteDtoList.length > 0) {
                this.dashboardWebPart.Links = this.convertToWebpartLink(message.FavouriteDtoList);
                this.sessionManager.setBgColorBasedOnObjectSource(this.dashboardWebPart.Links);
            }
            this.cacheManager.addToDashboardCache(this.dashboardWebPart.Type, this.dashboardWebPart.Links);
            this.showProgressBar = false;
        }
        catch (e) {
            console.error(e);
        }
    }
    convertToWebpartLink(favouriteDtoList) {
        let webpartLinks = [];
        for (let index = 0; index < favouriteDtoList.length; index++) {
            let entityType = GlobalFunctions.getObjectTypeName(favouriteDtoList[index].EntityType);
            if (this.hasRights(entityType, favouriteDtoList[index].EntitySource)) {
                let link = new DashboardWebpartLink().FromFavourite(favouriteDtoList[index]);
                link.Order = webpartLinks.length + 1;
                webpartLinks.push(link);
            }
        }
        return webpartLinks;
    }
    ;
    hasRights(entity, source) {
        let rights = false;
        if (entity.toUpperCase() === "PERSON" || entity.toUpperCase() === "ORGANIZATION") {
            rights = GlobalFunctions.hasRight(entity, OperationType.View, source);
            if (rights === null)
                rights = GlobalFunctions.checkRights(entity, OperationType.View);
        }
        else
            rights = GlobalFunctions.checkRights(entity, OperationType.View);
        return rights;
    }
    select(favItem) {
        this.onItemSelect.emit(favItem);
    }
};
__decorate([
    Input()
], FavouriteComponent.prototype, "dashboardWebPart", void 0);
__decorate([
    Output()
], FavouriteComponent.prototype, "onItemSelect", void 0);
FavouriteComponent = __decorate([
    Component({
        selector: 'favourite-webpart',
        templateUrl: './favourite.component.html',
        styleUrls: ['./favourite.component.scss']
    })
], FavouriteComponent);
export { FavouriteComponent };
//# sourceMappingURL=favourite.component.js.map