var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { DateHelper } from '../../../../shared/helper/date-helper';
let BirthdayComponent = class BirthdayComponent {
    constructor(cacheManager, sessionManager, employeeService) {
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.showProgressBar = false;
        this.dashbordEmployeeItems = [];
        this.onItemSelect = new EventEmitter();
    }
    ngOnInit() {
        try {
            let dashbordEmployeeItems_cache = this.cacheManager.getFromDashboardCache("birthday");
            if (dashbordEmployeeItems_cache != undefined) {
                if (dashbordEmployeeItems_cache != null && dashbordEmployeeItems_cache.length > 0)
                    this.dashbordEmployeeItems = dashbordEmployeeItems_cache;
                else {
                    this.showProgressBar = true;
                    this.employeeService.globalEventEmployeeFetchCompleted = this.getEmployeesBirthdayItems();
                }
            }
            else {
                this.showProgressBar = true;
                this.employeeService.globalEventEmployeeFetchCompleted = this.getEmployeesBirthdayItems();
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    getEmployeesBirthdayItems() {
        try {
            let result = this.cacheManager.getEmployeeList(true);
            if (result != null && result.length > 0) {
                let firstWeekDay = DateHelper.getFirstDayOfWeek();
                for (let index = 0; index < result.length; index++) {
                    if (result[index].DateOfBirth != undefined && result[index].DateOfBirth != null) {
                        let dateOfBirth = new Date(result[index].DateOfBirth);
                        if (DateHelper.isDateInCurrentWeek(firstWeekDay, dateOfBirth)) {
                            result[index].IsTodayBirthday = new Date().getMonth() == dateOfBirth.getMonth() && new Date().getDay() == dateOfBirth.getDay();
                            this.dashbordEmployeeItems.push(result[index]);
                        }
                    }
                }
                if (this.dashbordEmployeeItems.length > 0) {
                    this.dashbordEmployeeItems.sort((x, y) => Date.parse(x.DateOfBirth) - Date.parse(y.DateOfBirth));
                    for (let index = 0; index < this.dashbordEmployeeItems.length; index++) {
                        //this.addBirthdayItemsToCache(this.dashbordEmployeeItems); // TODO - This function is not required, will delete it somewhere later. It's also not found in to older application.
                    }
                }
            }
            this.cacheManager.addToDashboardCache("birthday", this.dashbordEmployeeItems);
            this.showProgressBar = false;
        }
        catch (e) {
            console.error(e);
        }
    }
    select(employeeItem) {
        this.onItemSelect.emit(employeeItem);
    }
};
__decorate([
    Input()
], BirthdayComponent.prototype, "dashboardWebPart", void 0);
__decorate([
    Output()
], BirthdayComponent.prototype, "onItemSelect", void 0);
BirthdayComponent = __decorate([
    Component({
        selector: 'birthday-webpart',
        templateUrl: './birthday.component.html',
        styleUrls: ['./birthday.component.scss']
    })
], BirthdayComponent);
export { BirthdayComponent };
//# sourceMappingURL=birthday.component.js.map