var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { cloneDeep } from "lodash";
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { AlternateSearchType, DateCompareType, FieldDataType, OperationType } from '../enums/common-enums';
import { EntityFqdn } from '../enums/core-enums';
import { TaskHandlerType } from '../enums/task-enum';
import { DateCriteriaDto } from '../models/common/date-criteria';
import { StringCriteriaDto } from '../models/common/string-criteria';
import { ContentType, TicketSearchField } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let TicketService = class TicketService extends BaseService {
    constructor(zone, router, dialog, httpClient, cacheManager, eventProvider, sessionManager, translateService, integrationSettingManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.dialog = dialog;
        this.httpClient = httpClient;
        this.cacheManager = cacheManager;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.integrationSettingManager = integrationSettingManager;
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.initializing = false;
        this.filterOptions = [];
        this.lastAppliedFilters = [];
        this.pendingCountMessageId = "";
        this.clearCallbacks = () => {
            this.getTicketFilterConfigurationCallback = null;
            this.getConfigurationCallbackHandler = null;
            this.setSearchResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setRelatedTicketResultFound = null;
            this.setViewerRelatedTicketResultFound = null;
            this.setCreateReportResponse = null;
        };
        this.setRelatedResultCallback = (setRelatedTicketResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedTicketResultFound = setRelatedTicketResultFoundCallback;
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedTicketResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedTicketResultFound = setViewerRelatedTicketResultFoundCallback;
        };
        this.getTicketFilterConfiguration = (getTicketFilterCallback) => {
            this.getTicketFilterConfigurationCallback = getTicketFilterCallback;
            console.log('Tickets -> fetching ticket filter configuration:', this.messageId);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getFilterConfiguration');
            });
        };
        this.createOrUpdateTicket = (ticket, ticketType, createOrUpdateTicketResponseHandlerCallback) => {
            this.createOrUpdateTicketResponseHandler = createOrUpdateTicketResponseHandlerCallback;
            let createOrUpdateTicketRequest = new Object();
            createOrUpdateTicketRequest.Ticket = ticket;
            createOrUpdateTicketRequest.TicketType = ticketType;
            let cookie = this.isValidToken();
            let url = environment.ticket_config.replace("/signalr", "/post/PostTicketXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, createOrUpdateTicketRequest).subscribe(result => {
                        console.log(result);
                    }, error => {
                        console.error(error);
                    });
                }
            });
        };
        this.createReport = (exportReportRequest, createReportCallback) => {
            this.setCreateReportResponse = createReportCallback;
            let cookie = this.isValidToken();
            let url = environment.ticket_config.replace("/signalr", "/post/PostCreateReportXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, exportReportRequest).subscribe(result => {
                        console.log(result);
                    }, error => {
                        console.error(error);
                    });
                }
            });
        };
        this.linkRelatedEntity = (ticketObj, entityObjList, linkRelatedEntityCallback) => {
            this.linkEntityToTicketCallback = linkRelatedEntityCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('LinkEntityToTicket', ticketObj, entityObjList);
            });
        };
        this.search = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            isAllSourceRequest = GlobalFunctions.isEmpty(isAllSourceRequest) ? false : isAllSourceRequest;
            this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
            this.searchQuery = query;
            alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
            handler = handler != undefined ? handler : "";
            this.messageId = GlobalFunctions.getGuid();
            console.log("ticketService->search:", this.searchQuery);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke("search", this.searchQuery, this.messageId, isAllSourceRequest, sourceLocation);
            });
        };
        this.sendReminder = (ticketIdList) => {
            console.log('ticketService -> sendReminder');
            let userId = GlobalFunctions.getLoggedInUserId();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('SendReminder', ticketIdList, userId);
            });
        };
        this.deleteTicket = (ticketId, deleteTicketResponseCallback) => {
            this.setTicketDeleteResponse = deleteTicketResponseCallback;
            console.log('ticketService -> deleteTicket');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('DeleteTicket', ticketId);
            });
        };
        this.getPendingTicketCount = (messageId, pendingTicketCountCallback) => {
            this.setPendingTicketCountResponse = pendingTicketCountCallback;
            console.log('ticketService->getPendingTicketCount:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke("getPendingItemsCount", messageId);
            });
        };
        this.unlinkRelatedEntity = (ticketObj, entityObjList, unlinkRelatedEntityCallback) => {
            this.unlinkEntityToTicketCallback = unlinkRelatedEntityCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('unlinkRelatedEntity', ticketObj, entityObjList);
            });
        };
        this.fetchStatistic = (fetchStatisticResponseCallback) => {
            console.log('ticketService->fetchStatistic');
            this.setFetchStatisticResponse = fetchStatisticResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('fetchStatistic', this.roleId);
            });
        };
        this.handleTicket = (ticketHistory, handleTicketResponseCallback) => {
            console.log('ticketService -> handleTicket');
            this.setHandleTicketResponse = handleTicketResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('handleTicket', ticketHistory);
            });
        };
        this.attemptTicket = (ticketHistory, attemptTicketResponseCallback) => {
            console.log('ticketService -> attemptTicket');
            this.setAttemptTicketResponse = attemptTicketResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('attemptTicket', ticketHistory);
            });
        };
        this.assignTicket = (ticketHistory, handlerList, assignTicketResponseCallback) => {
            console.log('ticketService -> assignTicket');
            this.setAssignTicketResponse = assignTicketResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('assignTicket', ticketHistory, handlerList);
            });
        };
        this.addFilterCriteriaToSearchDto = (ticketFilter, searchDto) => {
            if (ticketFilter && ticketFilter.Criteria && ticketFilter.Criteria.length > 0) {
                ticketFilter.Criteria.forEach(criteria => {
                    if (criteria.Field && !GlobalFunctions.isEmpty(criteria.Field.Title)) {
                        switch (criteria.Field.Title.toLowerCase()) {
                            case "status":
                                {
                                    let statusSearchCriteria = new StringCriteriaDto();
                                    statusSearchCriteria.Name = TicketSearchField.Status;
                                    statusSearchCriteria.CompareType = 1;
                                    statusSearchCriteria.Value = criteria.Value;
                                    searchDto.StringCriteriaList.push(statusSearchCriteria);
                                    break;
                                }
                            case "priority":
                            case "prioriteit":
                                {
                                    let prioritySearchCriteria = new StringCriteriaDto();
                                    prioritySearchCriteria.IsInUse = true;
                                    prioritySearchCriteria.Name = TicketSearchField.Priority;
                                    prioritySearchCriteria.CompareType = 1;
                                    prioritySearchCriteria.Value = criteria.Value;
                                    searchDto.StringCriteriaList.push(prioritySearchCriteria);
                                    break;
                                }
                            case "behandelaar":
                            case "handler":
                                {
                                    let handlerSearchCriteria = new StringCriteriaDto();
                                    handlerSearchCriteria.Name = TicketSearchField.Handler;
                                    handlerSearchCriteria.CompareType = 1;
                                    handlerSearchCriteria.Value = criteria.Value;
                                    searchDto.StringCriteriaList.push(handlerSearchCriteria);
                                    break;
                                }
                            default:
                                {
                                    let filterSearchCriteria = new StringCriteriaDto();
                                    filterSearchCriteria.DisplayName = criteria.FieldId;
                                    filterSearchCriteria.Name = TicketSearchField.Filter;
                                    filterSearchCriteria.CompareType = 1;
                                    filterSearchCriteria.Value = criteria.Value;
                                    searchDto.StringCriteriaList.push(filterSearchCriteria);
                                    break;
                                }
                        }
                    }
                });
            }
            var prioritySearchCriteria = new StringCriteriaDto();
            prioritySearchCriteria.IsInUse = true;
            prioritySearchCriteria.Name = TicketSearchField.Type;
            prioritySearchCriteria.CompareType = 0;
            prioritySearchCriteria.Value = ticketFilter.TicketTypeId;
            searchDto.StringCriteriaList.push(prioritySearchCriteria);
            if (!GlobalFunctions.isEmpty(ticketFilter.Period) && ticketFilter.Period > 0) {
                let dateRange = this.getDateRange(ticketFilter.Period);
                var dateSearchCriteria = new DateCriteriaDto();
                dateSearchCriteria.CompareType = DateCompareType.Between;
                dateSearchCriteria.DisplayName = "REGISTRATION_DATE";
                dateSearchCriteria.Name = TicketSearchField.CreatedDate;
                ;
                dateSearchCriteria.Value = dateRange.FromDate.toString('M/d/yyyy HH:mm:ss');
                dateSearchCriteria.ToDate = dateRange.ToDate.toString('M/d/yyyy HH:mm:ss');
                searchDto.DateCriteriaList.push(dateSearchCriteria);
            }
        };
        this.getDateRange = (period) => {
            let dateRange = { 'FromDate': new Date(), 'ToDate': new Date() };
            switch (period) {
                case 2:
                    {
                        var fromDate = new Date();
                        fromDate.setDate(fromDate.getDate() - 1);
                        dateRange.FromDate = fromDate;
                        dateRange.ToDate = fromDate;
                        break;
                    }
                case 3:
                    {
                        var fromDate = new Date();
                        fromDate.setDate(fromDate.getDate() - 7);
                        dateRange.FromDate = fromDate;
                        break;
                    }
                case 4:
                    {
                        var fromDate = new Date();
                        fromDate.setDate(fromDate.getDate() - 30);
                        dateRange.FromDate = fromDate;
                        break;
                    }
                case 5:
                    {
                        var fromDate = new Date();
                        fromDate.setDate(fromDate.getDate() - 90);
                        dateRange.FromDate = fromDate;
                        break;
                    }
            }
            return dateRange;
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.ticket_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB_TICKET);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_TICKET'), this.translateService, this.dialog);
                        return reject('Failed to connect to ticket service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Ticket service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Ticket service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for ticket service');
        });
    }
    registerServerEvents() {
        this.proxy.on('ticketDetailResponse', (response) => {
            console.log("ticketService -> ticketDetailResponse", response);
            let ticketSetting = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
            if (!GlobalFunctions.isEmpty(ticketSetting)) {
                console.log("ticketService -> ticketSetting is not null", ticketSetting);
                let result = [];
                if (response !== null) {
                    result.push(response);
                    this.updateTicketInformation(response);
                    this.updateTicketHandler(result);
                    if (this.getDetailHandlerCallback != null)
                        this.getDetailHandlerCallback(response);
                }
            }
        });
        this.proxy.on('linkEntityToTicketResponse', (response) => {
            console.log("ticketService -> linkEntityToTicketResponse", response);
            if (this.linkEntityToTicketCallback != null)
                this.linkEntityToTicketCallback(response);
        });
        this.proxy.on('createOrUpdateTicketResponse', (response) => {
            console.log("ticketService -> createOrUpdateTicketResponse", response);
            this.updateTicketInformation(response.Ticket);
            if (this.createOrUpdateTicketResponseHandler != null)
                this.createOrUpdateTicketResponseHandler(response);
        });
        this.proxy.on("searchStartedNotification", (message) => {
            console.log("ticketService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on("searchCompletedNotification", (message) => {
            console.log("ticketService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on("updateSearchStatus", (result, messageId) => {
            console.log("ticketService -> updateSearchStatus:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setUpdateSearchStatus != null)
                    this.setUpdateSearchStatus(result, "Ticket");
            }
        });
        this.proxy.on("searchResultFound", (result, messageId) => {
            console.log("ticketService -> searchResultFound:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setSearchResultFound != null) {
                    this.updateTicketHandler(result);
                    this.setSearchResultFound(result, "Ticket");
                }
            }
        });
        this.proxy.on('relatedTicketResultFound', (result, messageId) => {
            console.log("ticketService -> relatedTicketResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedTicketResultFound != null) {
                    this.updateTicketHandler(result);
                    this.setRelatedTicketResultFound(result, "Ticket", this.translateService.instant("LBL_TICKETS"));
                }
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setRelatedTicketResultFound != null) {
                    this.updateTicketHandler(result);
                    this.setViewerRelatedTicketResultFound(result, "Ticket", this.translateService.instant("LBL_TICKETS"));
                }
            }
        });
        this.proxy.on('pendingItemCountResponse', result => {
            console.log("ticketService -> pendingItemCountResponse:", result);
            if (this.setPendingTicketCountResponse != null)
                this.setPendingTicketCountResponse(result);
        });
        this.proxy.on('deleteTicketResponse', response => {
            console.log('ticketService -> deleteTicketResponse');
            if (this.setTicketDeleteResponse != null)
                this.setTicketDeleteResponse(response);
        });
        this.proxy.on('unlinkRelatedEntityResponse', (response) => {
            console.log("ticketService -> unlinkRelatedEntityResponse", response);
            if (this.unlinkEntityToTicketCallback != null)
                this.unlinkEntityToTicketCallback(response);
        });
        this.proxy.on('fetchStatisticResponse', response => {
            console.log("ticketService -> fetchStatisticResponse");
            if (this.setFetchStatisticResponse != null)
                this.setFetchStatisticResponse(response);
        });
        this.proxy.on('handleTicketResponse', response => {
            console.log("ticketService -> handleTicketResponse");
            if (this.setHandleTicketResponse != null)
                this.setHandleTicketResponse(response);
        });
        this.proxy.on('attemptTicketResponse', response => {
            console.log("ticketService -> attemptTicketResponse");
            if (this.setAttemptTicketResponse != null)
                this.setAttemptTicketResponse(response);
        });
        this.proxy.on('assignTicketResponse', response => {
            console.log("ticketService -> assignTicketResponse");
            if (this.setAssignTicketResponse != null)
                this.setAssignTicketResponse(response);
        });
        this.proxy.on('getTicketFilterResponse', response => {
            console.log("ticketService -> getTicketFilterResponse");
            if (this.getTicketFilterConfigurationCallback != null)
                this.getTicketFilterConfigurationCallback(response);
        });
        this.proxy.on('createReportResponse', result => {
            console.log("ticketService -> createReportResponse");
            if (this.setCreateReportResponse != null)
                this.setCreateReportResponse(result);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_TICKET'), this.translateService, this.dialog));
        this.proxy.on('tokenFailedResponse', () => this.sessionExpired(this.translateService, this.dialog));
    }
    updateTicketHandler(result) {
        for (let index = 0; index < result.length; index++) {
            let employeeDto = this.cacheManager.getEmployeeById(result[index].CreatedBy);
            if (employeeDto != null)
                result[index].CreatedByText = employeeDto.StringRepresentation;
            else
                result[index].CreatedByText = '';
            result[index].HandlerText = '';
            if (result[index].HandlerList != null && result[index].HandlerList.length > 0) {
                for (let hIndex = 0; hIndex < result[index].HandlerList.length; hIndex++) {
                    let handler = result[index].HandlerList[hIndex];
                    let handleData = null;
                    if (handler.HandlerType == TaskHandlerType.Department || handler.HandlerType == "Department")
                        handleData = this.cacheManager.getDepartmentById(handler.HandlerId);
                    else if (handler.HandlerType == TaskHandlerType.Employee || handler.HandlerType == "Employee")
                        handleData = this.cacheManager.getEmployeeById(handler.HandlerId);
                    else if (handler.HandlerType == TaskHandlerType.Mailbox || handler.HandlerType == "Mailbox")
                        handleData = this.cacheManager.getTaskMailboxById(handler.HandlerId);
                    if (handleData != null) {
                        result[index].HandlerText = handleData.StringRepresentation;
                        result[index].HandlerDepartmentText = handleData.Department != undefined ? handleData.Department.Name : null;
                    }
                }
            }
        }
    }
    updateTicketInformation(ticketDto) {
        let ticketConfig = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
        ticketDto.TicketType = cloneDeep(jlinq.from(ticketConfig.TicketTypes).equals("Id", ticketDto.TicketTypeId).first());
        ticketDto.TicketState = jlinq.from(ticketDto.TicketType.States.Entries).equals("Key", ticketDto.State).first();
        ticketDto.TicketPriority = jlinq.from(ticketDto.TicketType.Priorities.Entries).equals("Key", ticketDto.Priority).first();
        if (ticketDto.FieldDataList && ticketDto.TicketType && !GlobalFunctions.isEmpty(ticketDto.TicketType.FieldGroups)) {
            ticketDto.TicketType.FieldGroups = jlinq.from(ticketDto.TicketType.FieldGroups).sort("Order").select();
            for (let i = 0; i < ticketDto.TicketType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(ticketDto.TicketType.FieldGroups[i].Fields)) {
                    ticketDto.TicketType.FieldGroups[i].Fields = jlinq.from(ticketDto.TicketType.FieldGroups[i].Fields).sort("Order").select();
                    for (let j = 0; j < ticketDto.TicketType.FieldGroups[i].Fields.length; j++) {
                        let ticketFieldDataItem = jlinq.from(ticketDto.FieldDataList).equals("FieldId", ticketDto.TicketType.FieldGroups[i].Fields[j].Id).first();
                        if (!GlobalFunctions.isEmpty(ticketFieldDataItem)) {
                            let fieldData = ticketFieldDataItem.Data;
                            if (ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.List) {
                                if (!GlobalFunctions.isEmpty(fieldData)) {
                                    let fieldListEntry = jlinq.from(ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries).equals("Key", fieldData).first();
                                    if (!GlobalFunctions.isEmpty(fieldListEntry))
                                        ticketDto.TicketType.FieldGroups[i].Fields[j].Data = fieldListEntry.Key;
                                }
                            }
                            else if (ticketDto.TicketType.FieldGroups[i].Fields[j].DataType == FieldDataType.ListMultiSelect) {
                                ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData = [];
                                let existingValues = !GlobalFunctions.isEmpty(fieldData) ? fieldData.split(';') : '';
                                if (ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList && !GlobalFunctions.isEmpty(ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries)) {
                                    let entryList = ticketDto.TicketType.FieldGroups[i].Fields[j].FieldList.Entries;
                                    for (let e = 0; e < entryList.length; e++) {
                                        if (GlobalFunctions.isStringInList(existingValues, entryList[e].Key))
                                            ticketDto.TicketType.FieldGroups[i].Fields[j].DisplayData.push(entryList[e]);
                                    }
                                }
                            }
                            else
                                ticketDto.TicketType.FieldGroups[i].Fields[j].Data = fieldData;
                        }
                    }
                }
            }
        }
    }
    fetchDetail(ticketId, detailHandlerCallback) {
        this.getDetailHandlerCallback = detailHandlerCallback;
        console.log('ticketService -> fetchDetail:', ticketId);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('FetchDetail', ticketId);
        });
    }
    ;
    advancedSearch(searchDto, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) {
        this.setSearchResultFound = searchResultFoundCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
        alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
        handler = handler != undefined ? handler : "";
        sourceLocation = sourceLocation != undefined ? sourceLocation : "";
        this.messageId = GlobalFunctions.getGuid();
        console.log('ticketService->advancedSearch:', searchDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('advancedSearch', searchDto, this.messageId, sourceLocation);
        });
    }
    ;
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Ticket, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            let userId = GlobalFunctions.getLoggedInUserId();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', userId, JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Ticket, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            let userId = GlobalFunctions.getLoggedInUserId();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', userId, JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
    updatePendingTicketCount(result) {
        try {
            if (result && result.length > 0) {
                console.log('getPendingTicketCount', result);
                this.sessionManager.pendingCount.MyTicketCount = result[0].Count;
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
};
TicketService = __decorate([
    Injectable({ providedIn: 'root' })
], TicketService);
export { TicketService };
//# sourceMappingURL=ticket-service.js.map