var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants, BroadCastEventKeys } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { OperationType, SocialMediaStatus, SocialMediaType } from '../enums/common-enums';
import { EntityFqdn } from '../enums/core-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
import { ReplyMessageRequest } from '../models/social-media/reply-message-request';
import { SocialMediaContactHistoryDto } from '../models/social-media/social-media-contact-historyDto';
import { SocialMediaContactDto } from '../models/social-media/social-media-contactDto';
import { StopHandlingMessageRequest } from '../models/social-media/stop-handling-message-request';
import { FieldListEntryDto } from '../models/ticket/field-list-entryDto';
import { FieldListDto } from '../models/ticket/field-listDto';
import { BaseService } from './base-service';
let X2JS = require('x2js');
let SocialMediaService = class SocialMediaService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, integrationSettingManager, dialog, downloadService, sessionManager, cacheManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.integrationSettingManager = integrationSettingManager;
        this.dialog = dialog;
        this.downloadService = downloadService;
        this.sessionManager = sessionManager;
        this.cacheManager = cacheManager;
        this.DateJS = Date;
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.lastSelectedOption = "socialmedia";
        this.filterOptions = [];
        this.resultCompleteList = [];
        this.lastAppliedFilters = [];
        this.x2Js = new X2JS();
        this.pendingCountMessageId = "";
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setFetchDetailResponse = null;
            this.setViewerRelatedSocialMediaResultFound = null;
        };
        this.getDirectMessageImageUrl = mediaAttachmentId => {
            let baseUrl = null;
            if (!GlobalFunctions.isEmpty(mediaAttachmentId))
                baseUrl = this.downloadService.DOWNLOAD_API_URL.replace('{0}', mediaAttachmentId);
            return baseUrl;
        };
        this.getFilterList = () => {
            let fieldListDtoArray = [];
            let facebookPagesStr = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_SocialMedia_Entities_Facebook, "CONFIGUREFACEBOOKPAGES");
            if (!GlobalFunctions.isEmpty(facebookPagesStr)) {
                let facebookPages = this.x2Js.xml2js(facebookPagesStr);
                if (!GlobalFunctions.isEmpty(facebookPages) && !GlobalFunctions.isEmpty(facebookPages.FacebookPages.FacebookPage)) {
                    let fieldListfbDto = new FieldListDto();
                    fieldListfbDto.Description = this.translateService.instant("LBL_FACEBOOK");
                    fieldListfbDto.Title = this.translateService.instant("LBL_FACEBOOK");
                    fieldListfbDto.Entries = [];
                    let pageList = GlobalFunctions.ConvertToArrayIfOnlySingleObject(facebookPages.FacebookPages.FacebookPage);
                    for (let iteration = 0; iteration < pageList.length; iteration++) {
                        let fieldListEntryFbPagesDto = new FieldListEntryDto();
                        fieldListEntryFbPagesDto.Key = pageList[iteration]._PageId;
                        fieldListEntryFbPagesDto.Title = pageList[iteration]._SourceName;
                        fieldListfbDto.Entries.push(fieldListEntryFbPagesDto);
                    }
                    fieldListDtoArray.push(fieldListfbDto);
                }
            }
            let twitterPagesStr = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_SocialMedia_Entities_Twitter, "CONFIGURETWITTERACCOUNTS");
            if (!GlobalFunctions.isEmpty(twitterPagesStr)) {
                let twitterPages = this.x2Js.xml2js(twitterPagesStr);
                if (!GlobalFunctions.isEmpty(twitterPages) && !GlobalFunctions.isEmpty(twitterPages.TwitterAccounts.TwitterAccount)) {
                    let fieldListTwDto = new FieldListDto();
                    fieldListTwDto.Description = this.translateService.instant("LBL_TWITTER");
                    fieldListTwDto.Title = this.translateService.instant("LBL_TWITTER");
                    fieldListTwDto.Entries = [];
                    let pageLists = GlobalFunctions.ConvertToArrayIfOnlySingleObject(twitterPages.TwitterAccounts.TwitterAccount);
                    for (let iterations = 0; iterations < pageLists.length; iterations++) {
                        let fieldListEntryTwPagesDto = new FieldListEntryDto();
                        fieldListEntryTwPagesDto.Key = pageLists[iterations]._Id;
                        fieldListEntryTwPagesDto.Title = pageLists[iterations]._SourceName;
                        fieldListTwDto.Entries.push(fieldListEntryTwPagesDto);
                    }
                    fieldListDtoArray.push(fieldListTwDto);
                }
            }
            let whatsAppStr = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_SocialMedia_Entities_WhatsApp, "CONFIGUREWHATSAPPACCOUNTS");
            if (!GlobalFunctions.isEmpty(whatsAppStr)) {
                let whatsAppAccounts = this.x2Js.xml2js(whatsAppStr);
                if (!GlobalFunctions.isEmpty(whatsAppAccounts) && !GlobalFunctions.isEmpty(whatsAppAccounts.WhatsAppAccounts.WhatsAppAccount)) {
                    let fieldListWtAppDto = new FieldListDto();
                    fieldListWtAppDto.Description = this.translateService.instant("LBL_WHATSAPP");
                    fieldListWtAppDto.Title = this.translateService.instant("LBL_WHATSAPP");
                    fieldListWtAppDto.Entries = [];
                    let pageLists = GlobalFunctions.ConvertToArrayIfOnlySingleObject(whatsAppAccounts.WhatsAppAccounts.WhatsAppAccount);
                    for (let i = 0; i < pageLists.length; i++) {
                        let fieldListEntryWtAppPagesDto = new FieldListEntryDto();
                        fieldListEntryWtAppPagesDto.Key = pageLists[i]._Id;
                        fieldListEntryWtAppPagesDto.Title = pageLists[i]._SourceName;
                        fieldListWtAppDto.Entries.push(fieldListEntryWtAppPagesDto);
                    }
                    fieldListDtoArray.push(fieldListWtAppDto);
                }
            }
            let fieldListMessageTypeDto = new FieldListDto();
            fieldListMessageTypeDto.Id = "MessageType";
            fieldListMessageTypeDto.Description = this.translateService.instant("LBL_PUBLIC_PRIVATE_MESSAGE");
            fieldListMessageTypeDto.Title = this.translateService.instant("LBL_PUBLIC_PRIVATE_MESSAGE");
            fieldListMessageTypeDto.Entries = [];
            let fieldListEntryPublicDto = new FieldListEntryDto();
            fieldListEntryPublicDto.Key = "false";
            fieldListEntryPublicDto.Title = this.translateService.instant("LBL_PUBLIC_MESSAGE");
            fieldListMessageTypeDto.Entries.push(fieldListEntryPublicDto);
            let fieldListEntryPrivateDto = new FieldListEntryDto();
            fieldListEntryPrivateDto.Key = "true";
            fieldListEntryPrivateDto.Title = this.translateService.instant("LBL_PRIVATE_MESSAGE");
            fieldListMessageTypeDto.Entries.push(fieldListEntryPrivateDto);
            fieldListDtoArray.push(fieldListMessageTypeDto);
            return fieldListDtoArray;
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.social_media_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_SOCIAL_MEDIA'), this.translateService, this.dialog);
                        return reject('Failed to connect to social media service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Social media service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Social media service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for social media service');
        });
    }
    registerServerEvents() {
        this.proxy.on('createSocialMediaResponse', (result, response) => {
            console.log("socialMediaService->createsocialMediaComplete", result);
            if (this.setCreateSocialMediaComplete != null)
                this.setCreateSocialMediaComplete(response);
        });
        this.proxy.on('bulkReplySocialMediaResponse', (result, response) => {
            console.log("socialMediaService->bulkReplySocialMediaResponse", result);
            if (this.setBulkReplySocialMediaComplete != null)
                this.setBulkReplySocialMediaComplete(response);
        });
        this.proxy.on('archiveSocialMediaResponse', (response) => {
            console.log("socialMediaService->archiveSocialMediaResponse", response);
            if (this.setArchiveMessageResponse != null)
                this.setArchiveMessageResponse(response);
        });
        this.proxy.on('deleteSocialMediaMessageResponse', (result, response) => {
            console.log("socialMediaService->DeleteSocialMediaMessageResponse", result);
            if (this.setDeleteSocialMediaMessageComplete != null)
                this.setDeleteSocialMediaMessageComplete(response);
        });
        this.proxy.on('socialMediaSearchResultFound', (message) => {
            console.log("socialMediaService->socialMediaSearchResultFound:", message);
            if (this.messageId == "" || this.messageId == message.MessageId) {
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(message.SocialMediaList);
            }
        });
        this.proxy.on('socialMeidaDetailResponse', (result) => {
            console.log("socialMediaService->socialMeidaDetailResponse:", result);
            if (this.setFetchDetailResponse != null)
                this.setFetchDetailResponse(result);
        });
        this.proxy.on('messageHandlingResponse', (result) => {
            console.log("socialMediaService->messageHandlingResponse:", result);
            if (this.setMessageHandlingResponse != null)
                this.setMessageHandlingResponse(result);
        });
        this.proxy.on('replyMessageResponse', (message) => {
            console.log("socialMediaService->replyMessageResponse:", message.Result);
            if (this.setReplyMessageResponse != null)
                this.setReplyMessageResponse(message.ReplyMessage, message.Result);
        });
        this.proxy.on('updateSearchStatus', result => {
            console.log("socialMediaService->updateSearchStatus:", result);
            if (this.setUpdateSearchStatus != null)
                this.setUpdateSearchStatus(result);
        });
        this.proxy.on('relatedSocialMediaResultFound', (message) => {
            console.log("socialMediaService->relatedTaskResultFound:", message);
            if (this.relatedMessageId == "" || this.relatedMessageId == message.MessageId) {
                if (this.setRelatedSocialMediaResultFound != null) {
                    let contentType = GlobalFunctions.getObjectTypeName(message.ResponseEntityType);
                    this.setRelatedSocialMediaResultFound(message.DtoList, contentType, contentType.toUpperCase() === "SOCIALMEDIA" ? this.translateService.instant("LBL_SOCIAL_MEDIA") : this.translateService.instant('LBL_SOCIAL_MEDIA_HISTORY'));
                }
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == message.MessageId) {
                if (this.setViewerRelatedSocialMediaResultFound != null) {
                    let contentType = GlobalFunctions.getObjectTypeName(message.ResponseEntityType);
                    this.setViewerRelatedSocialMediaResultFound(message.DtoList, contentType, contentType.toUpperCase() === "SOCIALMEDIA" ? this.translateService.instant("LBL_SOCIAL_MEDIA") : this.translateService.instant('LBL_SOCIAL_MEDIA_HISTORY'));
                }
            }
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("socialMediaService->searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("socialMediaService->searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('socialMediaMessageCountResponse', (message) => {
            console.log("socialMediaService->socialMediaMessageCountResponse:", message);
            if (this.setFetchSociaMediaMessageCountResponse != null)
                this.setFetchSociaMediaMessageCountResponse(message);
        });
        this.proxy.on('socialMediaBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_SOCIAL_MEDIA'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('reassignMessageResponse', message => {
            console.log("socialMediaService->reassignMessageResponse:", message);
            if (this.setReassignMessageResponse != null)
                this.setReassignMessageResponse(message);
        });
        this.proxy.on('updateMemoResponse', (message) => {
            console.log("socialMediaService->updateMemoResponse:", message.Result);
            if (this.setUpdateSocialMedialMemoResponse != null)
                this.setUpdateSocialMedialMemoResponse(message);
        });
        this.proxy.on('linkSocialMediaResponse', response => {
            console.log('link social media response --> ' + response);
            if (this.linkUnlinkEntityItemsResponse != null)
                this.linkUnlinkEntityItemsResponse(response);
        });
        this.proxy.on('linkToSocialMediaResponse', (response) => {
            console.log("socialMediaService -> linkToSocialMediaResponse", response);
            if (this.linkUnlinkEntityItemsResponse != null)
                this.linkUnlinkEntityItemsResponse(response);
        });
        this.proxy.on('fetchStatisticResponse', response => {
            console.log("socialMediaService -> fetchStatisticResponse");
            if (this.setFetchStatisticResponse != null)
                this.setFetchStatisticResponse(response);
        });
        this.proxy.on('tokenFailedResponse', () => this.sessionExpired(this.translateService, this.dialog));
    }
    setRelatedResultCallback(setRelatedSocialMediaResultFoundCallback, messageId) {
        this.relatedMessageId = messageId;
        this.setRelatedSocialMediaResultFound = setRelatedSocialMediaResultFoundCallback;
    }
    ;
    setSearchNotificationCallbacks(setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) {
        this.setSearchStartedNotification = setSearchStartedNotificationCallback;
        this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
    }
    ;
    setViewerRelatedResultCallback(setViewerRelatedSocialMediaResultFoundCallback, messageId) {
        this.viewerRelatedMessageId = messageId;
        this.setViewerRelatedSocialMediaResultFound = setViewerRelatedSocialMediaResultFoundCallback;
    }
    ;
    getMessageHandlingDto(selectedEntity) {
        let messageHandlingDto = new SocialMediaContactDto();
        messageHandlingDto.MessageParentId = selectedEntity.Id;
        messageHandlingDto.MessageId = selectedEntity.Message.Id;
        messageHandlingDto.Type = selectedEntity.Type;
        messageHandlingDto.UserMobileNumber = typeof selectedEntity.User.MobileNumber === "undefined" ? "" : selectedEntity.User.MobileNumber;
        messageHandlingDto.UserEmailAddress = typeof selectedEntity.User.EmailAddress === "undefined" ? "" : selectedEntity.User.EmailAddress;
        messageHandlingDto.UserName = selectedEntity.User.Name;
        messageHandlingDto.UserId = selectedEntity.User.Id;
        messageHandlingDto.IsPrivate = selectedEntity.Message.IsPrivate;
        messageHandlingDto.CurrentStatus = SocialMediaStatus.Unhandled;
        messageHandlingDto.StartDate = new this.DateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        messageHandlingDto.HandlerId = GlobalFunctions.getLoggedInUserId();
        messageHandlingDto.Memo = typeof messageHandlingDto.Memo != null ? "" : messageHandlingDto.Memo;
        return messageHandlingDto;
    }
    ;
    getReceiveMessageList(selectedEntity) {
        let receiveMessageList = [];
        if (selectedEntity.MessageHistoryList != null && selectedEntity.MessageHistoryList.length > 0) {
            for (let index = selectedEntity.MessageHistoryList.length - 1; index >= 0; index--) {
                let lastMessage = selectedEntity.MessageHistoryList[index];
                if (lastMessage.ReplyBy == "Handler")
                    break;
                let receiveMessage = new SocialMediaContactHistoryDto();
                receiveMessage.SocialMediaContactId = selectedEntity.MessageHandling.Id;
                receiveMessage.MessageId = lastMessage.Id;
                receiveMessage.Message = lastMessage.Message;
                receiveMessage.MediaType = lastMessage.MediaType;
                receiveMessage.MediaList = lastMessage.MediaList;
                receiveMessage.UserId = lastMessage.User.Id;
                receiveMessage.UserName = lastMessage.User.Name;
                receiveMessage.MessageDateTime = lastMessage.DateTime;
                receiveMessage.ReplyBy = lastMessage.ReplyBy;
                receiveMessageList.push(receiveMessage);
            }
        }
        return receiveMessageList;
    }
    ;
    search(query, socialMediaType, searchResultFoundCallback, updateSearchStatusCallback) {
        this.setSearchResultFound = searchResultFoundCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        this.messageId = GlobalFunctions.getGuid();
        console.log('socialMediaService->search:', query);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('search', query, socialMediaType, this.messageId);
        });
    }
    advancedSearch(searchDto, socialMediaType, searchType, searchResultFoundCallback, updateSearchStatusCallback) {
        this.setSearchResultFound = searchResultFoundCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        this.messageId = GlobalFunctions.getGuid();
        console.log('socialMediaService->advancedSearch:', searchDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('advancedSearch', searchDto, socialMediaType, searchType, this.messageId);
        });
    }
    fetchDetail(partialDto, socialMediaType, fetchDetailCallback) {
        this.setFetchDetailResponse = fetchDetailCallback;
        console.log('socialMediaService->advancedSearch:', partialDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                switch (socialMediaType) {
                    case SocialMediaType.WhatsApp:
                        {
                            this.proxy.invoke('FetchWhatsAppDetail', partialDto);
                            break;
                        }
                    case SocialMediaType.Twitter:
                        {
                            this.proxy.invoke('FetchTwitterDetail', partialDto);
                            break;
                        }
                    case SocialMediaType.Facebook:
                        {
                            this.proxy.invoke('FetchFacebookDetail', partialDto);
                            break;
                        }
                }
            }
        });
    }
    getPendingSocialMediaMessageCount(messageId, fetchSocialMediaMessageCountCallback) {
        this.setFetchSociaMediaMessageCountResponse = fetchSocialMediaMessageCountCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('FetchSocialMediaMessageCount', messageId);
        });
    }
    startHandlingMessage(socialMediaHandlingDto, messageHandlingCallback) {
        this.setMessageHandlingResponse = messageHandlingCallback;
        console.log('socialMediaService->startHandlingMessage:', socialMediaHandlingDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('startHandlingMessage', socialMediaHandlingDto);
        });
    }
    stopHandlingMessage(socialMediaHandlingDto, messageHandlingCallback, errorCallback) {
        this.setMessageHandlingResponse = messageHandlingCallback;
        console.log('socialMediaService->stopHandlingMessage:', socialMediaHandlingDto);
        let reqObj = new StopHandlingMessageRequest();
        reqObj.SocialMediaMessageDto = socialMediaHandlingDto;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                let cookie = this.isValidToken();
                let url = environment.social_media_config.replace("/signalr", "/post/StopHandlingMessageXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
                this.httpClient.post(url, reqObj).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (errorCallback)
                        errorCallback();
                });
            }
        });
    }
    replyMessage(replyMessageDto, receiveMessageList, type, replyMessageCallback, errorCallback = null) {
        this.setReplyMessageResponse = replyMessageCallback;
        console.log('socialMediaService->replyMessage:');
        let reqObj = new ReplyMessageRequest();
        reqObj.ReplyMessage = replyMessageDto;
        reqObj.ReceiveMessageList = receiveMessageList;
        reqObj.Type = type;
        let cookie = this.isValidToken();
        let url = environment.social_media_config.replace("/signalr", "/post/PostReplyXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, reqObj).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (errorCallback)
                        errorCallback();
                });
            }
        });
    }
    ;
    updateSocialMediaMemo(memo, socialMeidaId, updateSocialMediaMemoResponseCallBack) {
        this.setUpdateSocialMedialMemoResponse = updateSocialMediaMemoResponseCallBack;
        console.log('socialMediaService->updateSocialMediaMemo:');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('updateSocialMediaMemo', memo, socialMeidaId);
        });
    }
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.SocialMedia, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            if ((relatedObject.nativeObjectList != null && relatedObject.nativeObjectList.length > 0) || (relatedObject.mainObject != null && (relatedObject.mainObject.ObjectSource.indexOf("Person") > 0 || relatedObject.mainObject.ObjectSource.indexOf("Organization") > 0))) {
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
                });
            }
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.SocialMedia, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            if ((relatedObject.nativeObjectList != null && relatedObject.nativeObjectList.length > 0) || (relatedObject.mainObject != null && (relatedObject.mainObject.ObjectSource.indexOf("Person") > 0 || relatedObject.mainObject.ObjectSource.indexOf("Organization") > 0))) {
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
                });
            }
        }
    }
    ;
    createSocialMedia(socialMedia, createSocialMediaCompleteCallback, errorCallbackFunction) {
        this.setCreateSocialMediaComplete = createSocialMediaCompleteCallback;
        let cookie = this.isValidToken();
        let url = environment.social_media_config.replace("/signalr", "/post/PostSocialMediaXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, socialMedia).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (errorCallbackFunction)
                        errorCallbackFunction();
                });
            }
        });
    }
    bulkReplyHandleSocialMedia(bulkReplyHandleSocialMediaRequest, bulkReplyResponseCallback, errorCallback) {
        this.setBulkReplySocialMediaComplete = bulkReplyResponseCallback;
        console.log('social media service -> bulk reply :', Date.now());
        let cookie = this.isValidToken();
        let url = environment.social_media_config.replace("/signalr", "/post/PostBulkReplyXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, bulkReplyHandleSocialMediaRequest).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (errorCallback)
                        errorCallback();
                });
            }
        });
    }
    ;
    deleteSocialMediaMessage(deleteSocialMediaMessageRequest, deleteSocialMediaMessageResponseCallback, errorCallback) {
        this.setDeleteSocialMediaMessageComplete = deleteSocialMediaMessageResponseCallback;
        console.log('social media service -> delete message:', Date.now());
        let cookie = this.isValidToken();
        let url = environment.social_media_config.replace("/signalr", "/post/PostDeleteXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, deleteSocialMediaMessageRequest).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (errorCallback)
                        errorCallback();
                });
            }
        });
    }
    ;
    linkUnlinkEntityItems(linkUnlinkEntityItemsRequest, linkUnlinkResponseCallback, linkUnlinkErrorCallback) {
        console.log('Send link/unlink entity items request', Date.now());
        this.linkUnlinkEntityItemsResponse = linkUnlinkResponseCallback;
        let cookie = this.isValidToken();
        let url = environment.social_media_config.replace("/signalr", "/post/PostLinkUnlinkEntityItemsXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, linkUnlinkEntityItemsRequest).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (linkUnlinkErrorCallback)
                        linkUnlinkErrorCallback();
                });
            }
        });
    }
    ;
    archiveSocialMediaMessage(archiveSocialMediaMessageRequest, archiveSocialMediaMessageResponse) {
        this.setArchiveMessageResponse = archiveSocialMediaMessageResponse;
        console.log('social media service -> archive message :', Date.now());
        let cookie = this.isValidToken();
        let url = environment.social_media_config.replace("/signalr", "/post/PostArchiveMessageXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, archiveSocialMediaMessageRequest).subscribe(result => {
                    console.log(result);
                }, error => {
                    console.error(error);
                });
            }
        });
    }
    ;
    reassignMessage(newHandlerId, socialMediaType, messageHandlignId, reassignMessageCallback) {
        this.setReassignMessageResponse = reassignMessageCallback;
        console.log('Social Media ->Reassign message:', Date.now());
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('reassignMessage', newHandlerId, socialMediaType, messageHandlignId);
        });
    }
    updateContactSessionNotesWithSocialMediaDetails(sessionManager) {
        let socialMedia = GlobalFunctions.getLastSocialMediaHistoryRecord(sessionManager.detailViewCachedEntityList);
        if (!GlobalFunctions.isEmpty(socialMedia)) {
            let detailEntityType = GlobalFunctions.getObjectTypeName(socialMedia.RelatedEntityFqdn);
            let contentType = GlobalFunctions.toContentType(detailEntityType).toUpperCase();
            if (contentType.indexOf("SOCIALMEDIA") != -1) {
                if (contentType === GlobalFunctions.toContentType("SOCIALMEDIA").toUpperCase()) {
                    sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = socialMedia.Type;
                    sessionManager.contactSessionNotesState.ContactHistoryDto.IsPrivateSocialMessage = socialMedia.Message.IsPrivate;
                    sessionManager.contactSessionNotesState.ContactHistoryDto.SubjectFreeText = socialMedia.Message.Message;
                    if (GlobalFunctions.isEmpty(sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson))
                        sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson = socialMedia.User.Name;
                    if (!GlobalFunctions.isEmpty(socialMedia.MessageHistoryList))
                        sessionManager.contactSessionNotesState.ContactHistoryDto.MemoFreeText = socialMedia.MessageHistoryList[socialMedia.MessageHistoryList.length - 1].Message;
                    sessionManager.sessionStartDateTime = new Date(socialMedia.MessageHandling.StartDate);
                }
                else {
                    if (contentType === GlobalFunctions.toContentType("FACEBOOK").toUpperCase())
                        sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "Facebook";
                    else if (contentType === GlobalFunctions.toContentType("TWITTER").toUpperCase())
                        sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "Twitter";
                    else if (contentType === GlobalFunctions.toContentType("WHATSAPP").toUpperCase())
                        sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "WhatsApp";
                    if (GlobalFunctions.isEmpty(sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson))
                        sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson = socialMedia.User.Name;
                    sessionManager.contactSessionNotesState.ContactHistoryDto.IsPrivateSocialMessage = socialMedia.Message.IsPrivate;
                    if (socialMedia.IsPublishedMessage == false) {
                        sessionManager.contactSessionNotesState.ContactHistoryDto.SubjectFreeText = socialMedia.Message.Message;
                        if (!GlobalFunctions.isEmpty(socialMedia.MessageHistoryList))
                            sessionManager.contactSessionNotesState.ContactHistoryDto.MemoFreeText = socialMedia.MessageHistoryList[socialMedia.MessageHistoryList.length - 1].Message;
                    }
                }
            }
        }
    }
    ;
    fetchStatistic(fetchStatisticResponseCallback) {
        console.log('socialMediaService->fetchStatistic');
        this.setFetchStatisticResponse = fetchStatisticResponseCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('fetchStatistic', this.roleId);
        });
    }
    ;
    addSocialMediaAndRelatedPersonOrOrganizationIntoSession() {
        this.sessionManager.addItemsToDetailViewCacheList(this.sessionManager.selectedEntity, this.sessionManager.selectedEntity.ObjectSource, true);
        this.sessionManager.addRelatedPersonOrOrganizationIntoSession(this.cacheManager);
    }
    ;
    updatePendingSocialMediaCount(message) {
        this.sessionManager.pendingCount.SocialMediaMessageCount.NewMessageCount = this.sessionManager.pendingCount.SocialMediaMessageCount.NewMessageCount + message.MessageCount.NewMessageCount;
        if (message.MessageCount.NewMessageCount > 0) {
            this.sessionManager.pendingCount.SocialMediaMessageCount.NewMessageInfo = this.sessionManager.pendingCount.SocialMediaMessageCount.NewMessageInfo + this.translateService.instant("LBL_" + message.MessageCount.Type.toUpperCase()) + ": " + message.MessageCount.NewMessageCount + "\n";
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_SPECIFIC_STATISTIC, { Type: 'TOTALOPENSOCIALMEDIA', TotalCount: this.sessionManager.pendingCount.SocialMediaMessageCount.NewMessageCount, TooltipText: this.sessionManager.pendingCount.SocialMediaMessageCount.NewMessageInfo });
        }
        this.sessionManager.pendingCount.SocialMediaMessageCount.MyMessageCount = this.sessionManager.pendingCount.SocialMediaMessageCount.MyMessageCount + message.MessageCount.MyMessageCount;
        this.sessionManager.pendingCount.SocialMediaMessageCount.MyUnreadMessageCount = this.sessionManager.pendingCount.SocialMediaMessageCount.MyUnreadMessageCount + message.MessageCount.MyUnreadMessageCount;
        this.sessionManager.pendingCount.SocialMediaMessageCount.AllMessageCount = this.sessionManager.pendingCount.SocialMediaMessageCount.AllMessageCount + message.MessageCount.AllMessageCount;
        this.sessionManager.pendingCount.SocialMediaMessageCount.AllUnreadMessageCount = this.sessionManager.pendingCount.SocialMediaMessageCount.AllUnreadMessageCount + message.MessageCount.AllUnreadMessageCount;
        this.sessionManager.pendingCount.SocialMediaMessageCount.PublishedMessageCount = this.sessionManager.pendingCount.SocialMediaMessageCount.PublishedMessageCount + message.MessageCount.PublishedMessageCount;
        this.sessionManager.pendingCount.SocialMediaMessageCount.PublishedUnreadMessageCount = this.sessionManager.pendingCount.SocialMediaMessageCount.PublishedUnreadMessageCount + message.MessageCount.PublishedUnreadMessageCount;
        this.sessionManager.pendingCount.SocialMediaMessageCount.TotalMessageCount = this.sessionManager.pendingCount.SocialMediaMessageCount.NewMessageCount + this.sessionManager.pendingCount.SocialMediaMessageCount.AllMessageCount + this.sessionManager.pendingCount.SocialMediaMessageCount.PublishedMessageCount;
        this.sessionManager.pendingCount.SocialMediaMessageCount.PublishArchiveMessageCount = this.sessionManager.pendingCount.SocialMediaMessageCount.PublishArchiveMessageCount + message.MessageCount.PublishArchiveMessageCount;
    }
    ;
};
SocialMediaService = __decorate([
    Injectable({ providedIn: 'root' })
], SocialMediaService);
export { SocialMediaService };
//# sourceMappingURL=social-media-service.js.map