var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { AlternateSearchType, OperationType } from '../enums/common-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let QuestionAnswerService = class QuestionAnswerService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, dialog, translateService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.dialog = dialog;
        this.translateService = translateService;
        this.setMultipleFetchDetailResponse = [];
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setFetchDetailResponse = null;
            this.setMultipleFetchDetailResponse = [];
            this.setRelatedQuestionAnswerResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setAlternateSearchResponseFound = null;
            this.setAlternateSearchSuggestionsResponseFound = null;
            this.setViewerRelatedQuestionAnswerResultFound = null;
        };
        this.setRelatedResultCallback = (setRelatedQuestionAnswerResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedQuestionAnswerResultFound = setRelatedQuestionAnswerResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedQuestionAnswerResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedQuestionAnswerResultFound = setViewerRelatedQuestionAnswerResultFoundCallback;
        };
        this.setMultipleFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setMultipleFetchDetailResponse.push(setFetchDetailCallback);
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.search = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback, alternateSearchSuggestionsResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
            this.setAlternateSearchSuggestionsResponseFound = alternateSearchSuggestionsResponseFoundCallback;
            isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
            alternateSearchType = alternateSearchType ? alternateSearchType : AlternateSearchType.None;
            handler = handler ? handler : "";
            this.searchQuery = query;
            this.messageId = GlobalFunctions.getGuid();
            console.log('questionanswerService->search:', this.searchQuery);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('search', this.searchQuery, isAllSourceRequest, alternateSearchType, handler, this.messageId);
            });
        };
        this.fetchDetail = (partialDto, fetchDetailCallback) => {
            this.setFetchDetailResponse = fetchDetailCallback;
            console.log('questionanswerService->fetchQuestionAnswerDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchDetail', partialDto);
            });
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.question_answer_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_QUESTION_ANSWER'), this.translateService, this.dialog);
                        return reject('Failed to connect to question answer service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Question answer service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Question answer service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for question answer service');
        });
    }
    registerServerEvents() {
        this.proxy.on('searchResultFound', (result, messageId) => {
            console.log("questionanswerService->searchResultFound:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(result);
            }
        });
        this.proxy.on('updateSearchStatus', result => {
            console.log("questionanswerService->updateSearchStatus:", result);
            if (this.setUpdateSearchStatus != null)
                this.setUpdateSearchStatus(result);
        });
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('questionAnswerDetailResponse', result => {
            console.log("questionanswerService->questionAnswerDetailResponse:", result);
            if (this.setFetchDetailResponse != null) {
                this.setFetchDetailResponse(result);
                //Note : setFetchDetailResponse = null : clear the callback function registered
                this.setFetchDetailResponse = null;
            }
            if (this.setMultipleFetchDetailResponse != null && this.setMultipleFetchDetailResponse.length > 0) {
                this.setMultipleFetchDetailResponse.forEach((element, index) => { this.setMultipleFetchDetailResponse[index](result); });
            }
        });
        this.proxy.on('questionAnswerBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_QUESTION_ANSWER'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('relatedQuestionAnswerResultFound', (result, messageId) => {
            console.log("questionanswerService->relatedQuestionAnswerResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedQuestionAnswerResultFound != null)
                    this.setRelatedQuestionAnswerResultFound(result, "QuestionAnswer", this.translateService.instant("LBL_QUESTION_ANSWER"));
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedQuestionAnswerResultFound != null)
                    this.setViewerRelatedQuestionAnswerResultFound(result, "QuestionAnswer", this.translateService.instant("LBL_QUESTION_ANSWER"));
            }
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("questionanswerService->searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("questionanswerService->searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('alternateSearchResponseReceived', (message) => {
            console.log("questionanswerService->alternateSearchResponseReceived:", message);
            if (this.setAlternateSearchResponseFound != null) {
                this.setAlternateSearchResponseFound(message);
            }
        });
        this.proxy.on('alternateSearchSuggestionsResponseReceived', (message) => {
            console.log("questionanswerService -> alternateSearchSuggestionsResponseReceived:", message);
            if (this.setAlternateSearchSuggestionsResponseFound != null) {
                this.setAlternateSearchSuggestionsResponseFound(message);
            }
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_QUESTION_ANSWER'), this.translateService, this.dialog));
    }
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.QuestionAnswer, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.QuestionAnswer, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
};
QuestionAnswerService = __decorate([
    Injectable({ providedIn: 'root' })
], QuestionAnswerService);
export { QuestionAnswerService };
//# sourceMappingURL=question-answer-service.js.map