var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { AlternateSearchType, OperationType } from '../enums/common-enums';
import { StartPrefillSagaRequest } from '../models/common/start-prefill-saga-request';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let ProductService = class ProductService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, dialog, applicationSettingManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.dialog = dialog;
        this.applicationSettingManager = applicationSettingManager;
        this.setMultipleFetchDetailResponse = [];
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.productEformLink = null;
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setProductDetailResponse = null;
            this.setFetchDetailResponse = null;
            this.setRelatedProductResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setMultipleFetchDetailResponse = [];
            this.setAlternateSearchResponseFound = null;
            this.setAlternateSearchSuggestionsResponseFound = null;
            this.setViewerRelatedProductResultFound = null;
        };
        this.setRelatedResultCallback = (setRelatedProductResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedProductResultFound = setRelatedProductResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedProductResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedProductResultFound = setViewerRelatedProductResultFoundCallback;
        };
        this.setFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setFetchDetailResponse = setFetchDetailCallback;
        };
        this.setMultipleFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setMultipleFetchDetailResponse.push(setFetchDetailCallback);
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.search = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback, alternateSearchSuggestionsResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
            this.setAlternateSearchSuggestionsResponseFound = alternateSearchSuggestionsResponseFoundCallback;
            isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
            alternateSearchType = alternateSearchType ? alternateSearchType : AlternateSearchType.None;
            handler = handler ? handler : "";
            this.searchQuery = query;
            this.messageId = GlobalFunctions.createGuid();
            sourceLocation = sourceLocation != undefined ? sourceLocation : "";
            console.log('productService -> search:', this.searchQuery);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('search', this.searchQuery, isAllSourceRequest, alternateSearchType, sourceLocation, handler, this.messageId);
            });
        };
        this.fetchDetail = (partialDto, productDetailResponseCallback) => {
            this.setProductDetailResponse = productDetailResponseCallback;
            console.log('productService -> fetchProductDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchDetail', partialDto);
            });
        };
        this.setStartPrefillCallback = startPrefillCallback => {
            this.setStartPrefillCompleted = startPrefillCallback;
        };
        this.setFetchPrefillEformLinksCallback = fetchPrefillEformLinksCallback => {
            this.setFetchPrefillEformLinksCompleted = fetchPrefillEformLinksCallback;
        };
        this.setStartContentCallback = startContentCallback => {
            this.setStartContentCompleted = startContentCallback;
        };
        this.fetchPrefillEformLinks = () => {
            console.log('productService -> fetchPrefillEformLinks');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('fetchPrefillEformLinks', '');
            });
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.product_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_PRODUCT'), this.translateService, this.dialog);
                        return reject('Failed to connect to product service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Product service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Product service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for product service');
        });
    }
    registerServerEvents() {
        this.proxy.on('searchResultFound', (result, messageId) => {
            console.log("productService -> searchResultFound:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(result);
            }
        });
        this.proxy.on('updateSearchStatus', result => {
            console.log("productService -> updateSearchStatus:", result);
            if (this.setUpdateSearchStatus != null)
                this.setUpdateSearchStatus(result);
        });
        this.proxy.on('productDetailResponse', result => {
            console.log("productService -> productDetailResponse:", result);
            if (this.setProductDetailResponse != null)
                this.setProductDetailResponse(result);
            if (this.setFetchDetailResponse != null) {
                this.setFetchDetailResponse(result);
                //Note : setFetchDetailResponse = null : clear the callback function registered
                this.setFetchDetailResponse = null;
            }
            if (this.setMultipleFetchDetailResponse != null && this.setMultipleFetchDetailResponse.length > 0) {
                this.setMultipleFetchDetailResponse.forEach((element, index) => { this.setMultipleFetchDetailResponse[index](result); });
            }
        });
        this.proxy.on('productBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_PRODUCT'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('relatedProductResultFound', (result, messageId) => {
            console.log("productService -> relatedProductResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedProductResultFound != null)
                    this.setRelatedProductResultFound(result, "Product", this.translateService.instant("LBL_PRODUCT"));
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedProductResultFound != null)
                    this.setViewerRelatedProductResultFound(result, "Product", this.translateService.instant("LBL_PRODUCT"));
            }
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("productService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("productService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('alternateSearchResponseReceived', (message, messageId) => {
            console.log("productService -> alternateSearchResponseReceived:", message);
            if (this.setAlternateSearchResponseFound != null) {
                this.setAlternateSearchResponseFound(message);
            }
        });
        this.proxy.on('alternateSearchSuggestionsResponseReceived', (message) => {
            console.log("productService -> alternateSearchSuggestionsResponseReceived:", message);
            if (this.setAlternateSearchSuggestionsResponseFound != null) {
                this.setAlternateSearchSuggestionsResponseFound(message);
            }
        });
        //PREFILL
        this.proxy.on('fetchPrefillEFormLinkCompleted', response => {
            console.log('productService -> Eformresponse:' + response);
            if (this.setFetchPrefillEformLinksCompleted != null)
                this.setFetchPrefillEformLinksCompleted(response);
        });
        this.proxy.on('startContentCompleted', response => {
            console.log('productService -> startContentCompleted:' + response);
            if (this.setStartContentCompleted != null)
                this.setStartContentCompleted(response);
        });
        this.proxy.on('startPrefillCompleted', response => {
            console.log('productService -> startPrefillCompleted:' + response);
            if (this.setStartPrefillCompleted != null)
                this.setStartPrefillCompleted(response);
        });
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_PRODUCT'), this.translateService, this.dialog));
    }
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Product, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Product, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
    startPrefillRequest(startPrefillSagaRequest) {
        console.log('productService -> startPrefillRequest');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('startPrefillSagaRequest', startPrefillSagaRequest);
        });
    }
    ;
    startContentRequest(startContentRequest, errorCallback) {
        let cookie = this.isValidToken();
        let url = environment.product_config.replace("/signalr", "/post/PostStartContentRequestXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, startContentRequest).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (errorCallback)
                        errorCallback();
                });
            }
        });
    }
    showEform(eformLink) {
        if (this.applicationSettingManager.isPrefillHandlerEnabled()) {
            this.productEformLink = eformLink;
            this.setStartPrefillCallback(this.startPrefillResponse);
            const startPrefillSagaRequest = new StartPrefillSagaRequest();
            startPrefillSagaRequest.UriText = eformLink;
            this.startPrefillRequest(startPrefillSagaRequest);
        }
        else
            window.open(eformLink, "_blank");
    }
    startPrefillResponse(response) {
        if (response != null && response.BaseDtoList != null && response.BaseDtoList.length > 0)
            this.applicationSettingManager.openEForm(response, this.productEformLink);
        else
            window.open(this.productEformLink, "_blank");
    }
    ;
};
ProductService = __decorate([
    Injectable({ providedIn: 'root' })
], ProductService);
export { ProductService };
//# sourceMappingURL=product-service.js.map