var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { AppConstants } from '../../shared/constants';
import { environment } from '../../../environments/environment';
import { PhoneStatusInfo } from '../models/phone/phone-status-info';
import { PhoneTransferCallRequest } from '../models/phone/phone-transfer-call-request';
import { BaseService } from './base-service';
let PhoneService = class PhoneService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.dialog = dialog;
        this.registerPeerResponse$ = new Subject();
        this.exceptionOccurred = false;
        this.clearPhoneStatusCallbacks = () => {
            this.setFetchPhoneStatusResponse = null;
        };
        this.setCancelCallResponseCallback = (cancelCallResponseCallback) => {
            this.setCancelCallResponse = cancelCallResponseCallback;
        };
        this.setHangupCallResponseCallback = (hangupCallResponseCallback) => {
            this.setHangupCallResponse = hangupCallResponseCallback;
        };
        this.setHoldCallResponseCallback = (holdCallResponseCallback) => {
            this.setHoldCallResponse = holdCallResponseCallback;
        };
        this.setPickupCallResponseCallback = (pickupCallResponseCallback) => {
            this.setPickupCallResponse = pickupCallResponseCallback;
        };
        this.setPlaceCallResponseCallback = (placeCallResponseCallback) => {
            this.setPlaceCallResponse = placeCallResponseCallback;
        };
        this.setTransferCallResponseCallback = (transferCallResponseCallback) => {
            this.setTransferCallResponse = transferCallResponseCallback;
        };
        this.setUnholdCallResponseCallback = (unholdCallResponseCallback) => {
            this.setUnholdCallResponse = unholdCallResponseCallback;
        };
        this.setRegisterPeerResponseCallback = (registerPeerResponseCallback) => {
            this.setRegisterPeerResponse = registerPeerResponseCallback;
        };
        this.setUnregisterPeerResponseCallback = (unregisterPeerResponseCallback) => {
            this.setUnregisterPeerResponse = unregisterPeerResponseCallback;
        };
        this.setCallStatusChangedEventCallback = (callStatusChangedEventCallback) => {
            this.setCallStatusChangedEvent = callStatusChangedEventCallback;
        };
        this.setEndCallEventCallback = (endCallEventCallback) => {
            this.setEndCallEvent = endCallEventCallback;
        };
        this.setNewCallEventCallback = (newCallEventCallback) => {
            this.setNewCallEvent = newCallEventCallback;
        };
        this.setRecallEventCallback = (recallEventCallback) => {
            this.setRecallEvent = recallEventCallback;
        };
        this.setUpdatePhoneStatusCallback = (updatePhoneStatusCallback) => {
            this.setUpdatePhoneStatusResponse = updatePhoneStatusCallback;
        };
        this.setFetchPhoneStatusCallback = (fetchPhoneStatusCallback) => {
            this.setFetchPhoneStatusResponse = fetchPhoneStatusCallback;
        };
        this.setTransferSessionEventCallback = (transferSessionEventCallback) => {
            this.setTransferSessionEventResponse = transferSessionEventCallback;
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.phone_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        if (!this.isReconnecting)
                            super.serviceStopped(this.translateService.instant('LBL_PHONE'), this.translateService, this.dialog);
                        return reject('Failed to connect to phone service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        this.isReconnecting = true;
                        setTimeout(() => this.connect(), 30000);
                        console.error(`Phone service disconnected, trying to reconnect in 30 seconds: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Phone service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for phone service');
        });
    }
    registerServerEvents() {
        this.proxy.on('cancelCallResponse', message => {
            console.log("PhoneService->cancelCallResponse:", message);
            if (this.setCancelCallResponse != null)
                this.setCancelCallResponse(message);
        });
        this.proxy.on('hangupCallResponse', message => {
            console.log("PhoneService->hangupCallResponse:", message);
            if (this.setHangupCallResponse != null)
                this.setHangupCallResponse(message);
        });
        this.proxy.on('holdCallResponse', message => {
            console.log("PhoneService->holdCallResponse:", message);
            if (this.setHoldCallResponse != null)
                this.setHoldCallResponse(message);
        });
        this.proxy.on('pickupCallResponse', message => {
            console.log("PhoneService->pickupCallResponse:", message);
            if (this.setPickupCallResponse != null)
                this.setPickupCallResponse(message);
        });
        this.proxy.on('placeCallResponse', message => {
            console.log("PhoneService->placeCallResponse:", message);
            if (this.setPlaceCallResponse != null)
                this.setPlaceCallResponse(message);
        });
        this.proxy.on('registerPeerResponse', message => {
            console.log("PhoneService->registerPeerResponse:", message);
            if (this.setRegisterPeerResponse != null)
                this.setRegisterPeerResponse(message);
        });
        this.proxy.on('transferCallResponse', message => {
            console.log("PhoneService->transferCallResponse:", message);
            if (this.setTransferCallResponse != null)
                this.setTransferCallResponse(message);
        });
        this.proxy.on('unholdCallResponse', message => {
            console.log("PhoneService->unholdCallResponse:", message);
            if (this.setUnholdCallResponse != null)
                this.setUnholdCallResponse(message);
        });
        this.proxy.on('unregisterPeerCallResponse', message => {
            console.log("PhoneService->unregisterPeerCallResponse:", message);
            if (this.setUnregisterPeerResponse != null)
                this.setUnregisterPeerResponse(message);
        });
        this.proxy.on('callStatusChangedEvent', message => {
            console.log("PhoneService->callStatusChangedEvent:", message);
            if (this.setCallStatusChangedEvent != null)
                this.setCallStatusChangedEvent(message);
        });
        this.proxy.on('endCallEvent', message => {
            console.log("PhoneService->endCallEvent:", message);
            if (this.setEndCallEvent != null)
                this.setEndCallEvent(message);
        });
        this.proxy.on('newCallEvent', message => {
            console.log("PhoneService->newCallEvent:", message);
            if (this.setNewCallEvent != null)
                this.setNewCallEvent(message);
        });
        this.proxy.on('recallEvent', message => {
            console.log("PhoneService->recallEvent:", message);
            if (this.setRecallEvent != null)
                this.setRecallEvent(message);
        });
        this.proxy.on('updatePhoneStatusResponse', message => {
            console.log("PhoneService->updatePhoneStatusResponse:", message);
            if (this.setUpdatePhoneStatusResponse != null)
                this.setUpdatePhoneStatusResponse(message);
        });
        this.proxy.on('fetchPhoneStatusResponse', message => {
            console.log("PhoneService->fetchStatusResponse:", message);
            if (this.setFetchPhoneStatusResponse != null)
                this.setFetchPhoneStatusResponse(message);
        });
        this.proxy.on('transferSessionEventResponse', message => {
            console.log("PhoneService->transferSessionEventResponse:", message);
            if (this.setTransferSessionEventResponse != null)
                this.setTransferSessionEventResponse(message);
        });
        this.proxy.on('linkPhoneNumberResponse', message => {
            console.log('link phone number response --> ' + message);
            if (this.linkUnlinkEntityItemsResponse != null)
                this.linkUnlinkEntityItemsResponse(message);
        });
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_PHONE'), this.translateService, this.dialog));
    }
    refuseCallRequest(callDto) {
        console.log('PhoneService->refuseCallRequest');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('RefuseCallRequest', callDto);
        });
    }
    cancelCallRequest() {
        console.log('PhoneService->cancelCallRequest');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('CancelCallRequest');
        });
    }
    hangupCallRequest(callDto) {
        console.log('PhoneService->hangupCallRequest');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('HangupCallRequest', callDto);
        });
    }
    holdCallRequest(callDto) {
        console.log('PhoneService->holdCallRequest');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('HoldCallRequest', callDto);
        });
    }
    pickupCallRequest(callDto) {
        console.log('PhoneService->pickupCallRequest');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('PickupCallRequest', callDto);
        });
    }
    placeCallRequest(sourceExtension, target) {
        console.log('PhoneService->placeCallRequest');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('PlaceCallRequest', sourceExtension, target);
        });
    }
    registerPeerRequest(extensionDto) {
        console.log('PhoneService->registerPeerRequest');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('RegisterPeerRequest', extensionDto);
        });
    }
    unregisterPeerRequest(extensionDto) {
        console.log('PhoneService->unregisterPeerRequest ');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('UnregisterPeerRequest', extensionDto);
        });
    }
    transferCallRequest(callDto, target, attended, transferSessionManagerDto = null) {
        console.log('PhoneService->transferCallRequest');
        let transferCallRequest = new PhoneTransferCallRequest();
        transferCallRequest.CallDto = callDto;
        transferCallRequest.Target = target;
        transferCallRequest.Attended = attended;
        transferCallRequest.TransferSessionManagerDto = transferSessionManagerDto;
        let cookie = this.isValidToken();
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                let url = environment.phone_config.replace("/signalr", "/post/PostTransferCallXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode + "&connectionid=" + this.connection.id);
                this.httpClient.post(url, JSON.stringify(transferCallRequest)).subscribe(result => {
                    console.log(result);
                }, error => {
                    console.error(error);
                });
            }
        });
    }
    unholdCallRequest(callDto) {
        console.log('PhoneService->unholdCallRequest ');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('UnholdCallRequest', callDto);
        });
    }
    updateCallerIdRequest(callerInfoDto) {
        console.log('PhoneService->updateCallerIdRequest  ');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('UpdateCallerIdRequest', callerInfoDto);
        });
    }
    deleteCallerIdRequest(callerInfoDto) {
        console.log('PhoneService->deleteCallerIdRequest  ');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('DeleteCallerIdRequest', callerInfoDto);
        });
    }
    updatePhoneStatusRequest(phoneStatusEnum, phoneStatusCode = "") {
        console.log('PhoneService->updatePhoneStatusRequest  ');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('UpdatePhoneStatus', phoneStatusEnum, phoneStatusCode);
        });
    }
    fetchPhoneStatusRequest(phoneStatusList) {
        console.log('PhoneService->fetchPhoneStatusRequest  ');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('FetchPhoneStatus', phoneStatusList);
        });
    }
    linkUnlinkEntityItems(linkPhoneNumberDto, linkUnlinkResponseCallback) {
        console.log('Send link/unlink entity items request', Date.now());
        this.linkUnlinkEntityItemsResponse = linkUnlinkResponseCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('LinkPhoneNumber', linkPhoneNumberDto);
        });
    }
    ;
    getPhoneStatusBasedOnResult(result) {
        let phoneStatusInfo = new PhoneStatusInfo();
        switch (result.Status) {
            case 0:
                phoneStatusInfo.Status = "phoneStatusBusy";
                phoneStatusInfo.Tooltip = this.translateService.instant('LBL_BUSY');
                phoneStatusInfo.ExtensionFontColor = "redFontColor";
                break;
            case 1:
                phoneStatusInfo.Status = "phoneStatusAvailable";
                phoneStatusInfo.Tooltip = this.translateService.instant('LBL_AVAILABLE');
                phoneStatusInfo.ExtensionFontColor = "greenFontColor";
                break;
            case 2:
                phoneStatusInfo.Status = "phoneStatusOffline";
                phoneStatusInfo.Tooltip = this.translateService.instant('LBL_OFFLINE');
                phoneStatusInfo.ExtensionFontColor = "grayFontColor";
                break;
            default:
                phoneStatusInfo.Status = "";
                phoneStatusInfo.Tooltip = "";
                phoneStatusInfo.ExtensionFontColor = "blueFontColor";
                break;
        }
        phoneStatusInfo.IsPhoneStatusEnabled = true;
        return phoneStatusInfo;
    }
};
PhoneService = __decorate([
    Injectable({ providedIn: 'root' })
], PhoneService);
export { PhoneService };
//# sourceMappingURL=phone-service.js.map