var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { MessageboxComponent } from '../../components/common/messagebox/messagebox.component';
import { AppConstants, RoutePath } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { DialogHelper } from '../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { AlternateSearchType, OperationType } from '../enums/common-enums';
import { DeleteFileRequest } from '../models/file/delete-file-request';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let FileService = class FileService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, sessionManager, translateService, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.dialog = dialog;
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.setRelatedResultCallback = (setRelatedFileResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedFileResultFound = setRelatedFileResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedFileResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedFileResultFound = setViewerRelatedFileResultFoundCallback;
        };
    }
    ;
    setSearchNotificationCallbacks(setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) {
        this.setSearchStartedNotification = setSearchStartedNotificationCallback;
        this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
    }
    ;
    clearCallbacks() {
        this.setSearchResultFound = null;
        this.setUpdateSearchStatus = null;
        this.setSearchStartedNotification = null;
        this.setSearchCompletedNotification = null;
        this.setAlternateSearchResponseFound = null;
        this.setRelatedFileResultFound = null;
        this.setDownalodFileResultFound = null;
        this.setViewerRelatedFileResultFound = null;
    }
    ;
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.file_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_FILE'), this.translateService, this.dialog);
                        return reject('Failed to connect to file service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`File service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`File service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for file service');
        });
    }
    registerServerEvents() {
        this.proxy.on('createFileResponse', (result, response) => {
            console.log("fileService -> createFileComplete", result);
            if (this.setCreateFileComplete != null)
                this.setCreateFileComplete(response);
        });
        this.proxy.on('deleteFileResponse', (response) => {
            console.log('fileService -> deleteFileResponse');
            if (this.setFileDeleteResponse != null)
                this.setFileDeleteResponse(response);
        });
        this.proxy.on('searchResultFound', (result, messageId) => {
            console.log("fileService -> searchResultFound:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(result);
            }
        });
        this.proxy.on('updateSearchStatus', (result, messageId) => {
            console.log("fileService -> updateSearchStatus:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setUpdateSearchStatus != null)
                    this.setUpdateSearchStatus(result);
            }
        });
        this.proxy.on('tokenFailedResponse', () => {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_FILE_ENTITY'), textMsg: this.translateService.instant("LBL_SESSION_EXPIRED_MESSAGE") });
            this.router.navigate([RoutePath.LOGIN]);
        });
        this.proxy.on('fileBusinessExceptionReceived', (result) => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_FILE_ENTITY'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("fileService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("fileService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('detailResponse', (result) => {
            console.log("fileService -> detailResponse:", result);
            if (this.setFetchDetailResponse != null) {
                if (result != null && result.FileDto)
                    this.setFetchDetailResponse(result.FileDto);
                else
                    this.setFetchDetailResponse(result);
            }
        });
        this.proxy.on('relatedFileResultFound', (result, messageId) => {
            console.log("filEntityService->relatedFileResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedFileResultFound != null)
                    this.setRelatedFileResultFound(result, "FileDocument", this.translateService.instant("LBL_FILE_DOCUMENT"));
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedFileResultFound != null)
                    this.setViewerRelatedFileResultFound(result, "FileDocument", this.translateService.instant("LBL_FILE_DOCUMENT"));
            }
        });
        this.proxy.on('downloadFileResultFound', message => {
            console.log("filEntityService->downloadFileResultFound:", message);
            if (this.setDownalodFileResultFound != null)
                this.setDownalodFileResultFound(message);
        });
        this.proxy.on('fetchFilesToLink', (result, status) => {
            console.log("filEntityService->fetchFilesToLink:", result);
            if (this.setFileToLinkResultResponse != null) {
                this.setFileToLinkResultResponse(result, status);
            }
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_FILE'), this.translateService, this.dialog));
    }
    ;
    createFile(file, createFileCompleteCallback, errorCallbackFunction) {
        this.setCreateFileComplete = createFileCompleteCallback;
        let cookie = this.isValidToken();
        let url = environment.file_config.replace("/signalr", "/post/PostFileXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.httpClient.post(url, file).subscribe(result => {
            console.log(result);
        }, () => {
            if (errorCallbackFunction != null)
                errorCallbackFunction();
        });
    }
    ;
    deleteFile(fileDto, entityDeleteResponseCallback) {
        this.setFileDeleteResponse = entityDeleteResponseCallback;
        if (fileDto) {
            console.log('fileService -> deleting file:', Date.now());
            let deleteFileRequest = new DeleteFileRequest();
            deleteFileRequest.FileDto = new Object();
            deleteFileRequest.FileDto.Id = fileDto.Id;
            deleteFileRequest.FileDto.AttachmentType = fileDto.AttachmentType;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('DeleteFile', JSON.stringify(deleteFileRequest));
            });
        }
    }
    ;
    search(query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) {
        this.setSearchResultFound = searchResultFoundCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
        this.searchQuery = query;
        alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
        isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
        handler = handler != undefined ? handler : "";
        this.messageId = GlobalFunctions.getGuid();
        console.log('fileService->search:', this.searchQuery);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('search', this.searchQuery, this.messageId, isAllSourceRequest);
        });
    }
    ;
    fetchDetail(partialDto, fetchDetailCallback, partialDtoList) {
        this.setFetchDetailResponse = fetchDetailCallback;
        console.log('fileService -> fetchDetail:', partialDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('FetchDetail', partialDto, partialDtoList);
        });
    }
    ;
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.File, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.File, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
    downloadFile(fileDocumentDto, callbackFunction) {
        console.log('fileService->downloadFileDocument');
        this.setDownalodFileResultFound = callbackFunction;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('DownloadFile', fileDocumentDto);
        });
    }
    ;
    fetchFileToLinkResults(fetchFileToLinkResultCallback) {
        this.setFileToLinkResultResponse = fetchFileToLinkResultCallback;
        console.log('fileService -> fetchFileToLinkResults');
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('FetchFileFromLocation');
        });
    }
    ;
    uploadFile(file, url, onSuccessCallbackFunction, onErrorCallbackFunction) {
        this.setCreateFileComplete = onSuccessCallbackFunction;
        this.httpClient.post(url, file).subscribe(result => {
            if (this.setCreateFileComplete != null)
                this.setCreateFileComplete(result);
            console.log(result);
        }, err => {
            if (onErrorCallbackFunction != null)
                onErrorCallbackFunction(err);
        });
    }
    uploadFileAsync(file, url) {
        return this.httpClient.post(url, file).toPromise();
    }
};
FileService = __decorate([
    Injectable({ providedIn: 'root' })
], FileService);
export { FileService };
//# sourceMappingURL=file-service.js.map