var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { BaseService } from './base-service';
import { environment } from '../../../environments/environment';
let DownloadService = class DownloadService extends BaseService {
    constructor(zone, router, httpClient, eventProvider) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.DOWNLOAD_API_URL = environment.api_url + "/File?ticketId={0}";
    }
    downloadFile(ticketId) {
        const url = this.DOWNLOAD_API_URL.replace('{0}', ticketId);
        const blob = this.httpClient.get(url, { responseType: 'blob', observe: 'response', headers: this.getHeader() });
        return blob;
    }
    downloadMediaFromURL(url) {
        const blob = this.httpClient.get(url, { responseType: 'blob', observe: 'response', headers: this.getHeader() });
        return blob;
    }
};
DownloadService = __decorate([
    Injectable({ providedIn: 'root' })
], DownloadService);
export { DownloadService };
//# sourceMappingURL=download-service.js.map