var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { AlternateSearchType, OperationType } from '../enums/common-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let DocumentService = class DocumentService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.dialog = dialog;
        this.setMultipleFetchDetailResponse = [];
        this.searchRelatedMessageId = "";
        this.searchViewerRelatedMessageId = "";
        this.searchMessageId = "";
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setFetchDetailResponse = null;
            this.setMultipleFetchDetailResponse = [];
            this.setRelatedDocumentResultFound = null;
            this.setRelatedFileDocumentResultFound = null;
            this.setViewerRelatedFileDocumentResultFound = null;
            this.setDownalodFileDocumentResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setAlternateSearchResponseFound = null;
            this.setDocumentTypesResponseReceived = null;
            this.setGetMergeTemplatesResponse = null;
            this.setViewerRelatedDocumentResultFound = null;
        };
        this.setRelatedResultCallback = (setRelatedDocumentResultFoundCallback, messageId) => {
            this.searchRelatedMessageId = messageId;
            this.setRelatedDocumentResultFound = setRelatedDocumentResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedDocumentResultFound, messageId) => {
            this.searchViewerRelatedMessageId = messageId;
            this.setViewerRelatedDocumentResultFound = setViewerRelatedDocumentResultFound;
        };
        this.setFileRelatedResultCallback = (setRelatedFileDocumentResultFoundCallback, messageId) => {
            this.searchRelatedMessageId = messageId;
            this.setRelatedFileDocumentResultFound = setRelatedFileDocumentResultFoundCallback;
        };
        this.setViewerFileRelatedResultCallback = (setViewerRelatedFileDocumentResultFoundCallback, messageId) => {
            this.searchViewerRelatedMessageId = messageId;
            this.setViewerRelatedFileDocumentResultFound = setViewerRelatedFileDocumentResultFoundCallback;
        };
        this.setMultipleFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setMultipleFetchDetailResponse.push(setFetchDetailCallback);
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.setGetMergeTemplatesResponseCallback = (callback) => {
            this.setGetMergeTemplatesResponse = callback;
        };
        this.search = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
            isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
            alternateSearchType = alternateSearchType ? alternateSearchType : AlternateSearchType.None;
            handler = handler ? handler : "";
            this.searchQuery = query;
            this.searchMessageId = GlobalFunctions.getGuid();
            console.log('documentService->search:', this.searchQuery);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('search', this.searchQuery, isAllSourceRequest, alternateSearchType, handler, this.searchMessageId);
            });
        };
        this.advancedSearch = (searchDto, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
            this.advancedSearchDto = searchDto;
            alternateSearchType = alternateSearchType ? alternateSearchType : AlternateSearchType.None;
            handler = handler ? handler : "";
            this.searchMessageId = GlobalFunctions.getGuid();
            console.log('documentService->advancedSearch:', searchDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('advancedSearch', searchDto, alternateSearchType, handler, this.searchMessageId);
            });
        };
        this.fetchDetail = (partialDto, fetchDetailCallback) => {
            this.setSearchResultFound = fetchDetailCallback;
            this.searchMessageId = "";
            console.log('documentService->fetchDocumentDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchDetail', partialDto);
            });
        };
        this.downloadFileDocument = (fileDocumentDto, callbackFunction) => {
            console.log('documentService->downloadFileDocument');
            this.setDownalodFileDocumentResultFound = callbackFunction;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('downloadFileDocument', fileDocumentDto);
            });
        };
        this.createDocument = (addNewDocumentRequest, createDocumentResponseCallback, errorCallback) => {
            this.setCreateDocumentResponseReceived = createDocumentResponseCallback;
            console.log('documentService -> creating document:', Date.now());
            let cookie = this.isValidToken();
            let url = environment.document_config.replace("/signalr", "/post/PostDocumentXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, addNewDocumentRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (errorCallback)
                            errorCallback();
                    });
                }
            });
        };
        this.createDocumentAsEmail = (addDocumentAsEmailRequest, createDocumentResponseCallback, errorCallback) => {
            this.setCreateDocumentResponseReceived = createDocumentResponseCallback;
            console.log('documentService -> creating document as email:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    let cookie = this.isValidToken();
                    let url = environment.document_config.replace("/signalr", "/post/PostDocumentAsEmailXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
                    this.httpClient.post(url, addDocumentAsEmailRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (errorCallback)
                            errorCallback();
                    });
                }
            });
        };
        this.getDocumentTypes = function (caseTypeId, getDocumentTypesCallback) {
            this.setDocumentTypesResponseReceived = getDocumentTypesCallback;
            console.log('documentService -> GetDocumentTypes: for casetype id: ' + caseTypeId);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('GetDocumentTypes', caseTypeId);
            });
        };
        this.getMergeTemplates = (ticketId, collectionId, callback) => {
            this.setGetMergeTemplatesResponse = callback;
            console.log('documentService -> getMergeTemplates');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('GetMergeTemplates', ticketId, collectionId);
            });
        };
        this.searchPendingDocumentCount = (pendingCountCallback) => {
            console.log('documentService -> searchPendingDocumentCount:', Date.now());
            this.setPendingCountResponse = pendingCountCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke("searchPendingDocument", null, true);
            });
        };
        this.searchPendingDocument = (searchResultFoundCallback, searchStartedStatusCallback, searchCompletedStatusCallback) => {
            console.log('documentService -> searchPendingDocument:', Date.now());
            this.setSearchResultFound = searchResultFoundCallback;
            this.setSearchStartedNotification = searchStartedStatusCallback;
            this.setSearchCompletedNotification = searchCompletedStatusCallback;
            this.searchMessageId = "";
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke("searchPendingDocument", null, false);
            });
        };
        this.lockDocument = (documentUniqueId) => {
            console.log('documentService -> lockDocument:', documentUniqueId);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('lockDocument', documentUniqueId);
            });
        };
        this.unlockDocument = (documentUniqueId) => {
            console.log('documentService -> unlockDocument:', documentUniqueId);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('unlockDocument', documentUniqueId);
            });
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.document_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_DOCUMENT'), this.translateService, this.dialog);
                        return reject('Failed to connect to document service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Document service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Document service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for document service');
        });
    }
    registerServerEvents() {
        this.proxy.on('searchResultFound', (result, messageId) => {
            if (this.searchMessageId == "" || this.searchMessageId == messageId) {
                console.log("documentService->searchResultFound:", result);
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(result);
                if (this.setMultipleFetchDetailResponse != null && this.setMultipleFetchDetailResponse.length > 0 && result != null && result.length > 0) {
                    this.setMultipleFetchDetailResponse.forEach((element, index) => { this.setMultipleFetchDetailResponse[index](result[0]); });
                }
            }
        });
        this.proxy.on('updateSearchStatus', result => {
            console.log("documentService->updateSearchStatus:", result);
            if (this.setUpdateSearchStatus != null)
                this.setUpdateSearchStatus(result);
        });
        this.proxy.on('relatedDocumentResultFound', (result, messageId) => {
            if (this.searchRelatedMessageId == "" || this.searchRelatedMessageId == messageId) {
                console.log("documentService->relatedDocumentResultFound:", result);
                if (this.setRelatedDocumentResultFound != null)
                    this.setRelatedDocumentResultFound(result, "Document", this.translateService.instant("LBL_DOCUMENT"));
            }
            else if (this.searchViewerRelatedMessageId == "" || this.searchViewerRelatedMessageId == messageId) {
                console.log("documentService->relatedDocumentResultFound:", result);
                if (this.setViewerRelatedDocumentResultFound != null)
                    this.setViewerRelatedDocumentResultFound(result, "Document", this.translateService.instant("LBL_DOCUMENT"));
            }
        });
        this.proxy.on('relatedFileDocumentResultFound', (result, messageId) => {
            console.log("documentService->relatedFileDocumentResultFound:", result);
            if (this.searchRelatedMessageId == "" || this.searchRelatedMessageId == messageId) {
                if (this.setRelatedFileDocumentResultFound != null)
                    this.setRelatedFileDocumentResultFound(result, "FileDocument", this.translateService.instant("LBL_FILE_DOCUMENT"));
            }
            else if (this.searchViewerRelatedMessageId == "" || this.searchViewerRelatedMessageId == messageId) {
                console.log("documentService->relatedFileDocumentResultFound:", result);
                if (this.setViewerRelatedFileDocumentResultFound != null)
                    this.setViewerRelatedFileDocumentResultFound(result, "FileDocument", this.translateService.instant("LBL_FILE_DOCUMENT"));
            }
        });
        this.proxy.on('downloadFileDocumentResultFound', message => {
            console.log("documentService->downloadFileDocumentResultFound:", message);
            if (this.setDownalodFileDocumentResultFound != null)
                this.setDownalodFileDocumentResultFound(message);
        });
        this.proxy.on('tokenFailedResponse', () => {
            this.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('documentBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_DOCUMENT'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("documentService->searchStartedNotification:", message);
            if ((this.searchMessageId == "" && this.searchRelatedMessageId == "") || this.searchMessageId == message.MessageId || this.searchRelatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("documentService->searchCompletedNotification:", message);
            if ((this.searchMessageId == "" && this.searchRelatedMessageId == "") || this.searchMessageId == message.MessageId || this.searchRelatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('alternateSearchResponseReceived', (message, messageId) => {
            console.log("documentService->alternateSearchResponseReceived:", message);
            if (this.setAlternateSearchResponseFound != null) {
                this.setAlternateSearchResponseFound(message);
            }
        });
        this.proxy.on('createDocumentResponseReceived', response => {
            console.log("documentService -> createDocumentResponseReceived");
            if (this.setCreateDocumentResponseReceived != null)
                this.setCreateDocumentResponseReceived(response);
        });
        this.proxy.on('documentTypesReceived', response => {
            console.log("documentService -> documentTypesReceived");
            if (this.setDocumentTypesResponseReceived != null)
                this.setDocumentTypesResponseReceived(response);
        });
        this.proxy.on('getMergeTemplatesResponse', response => {
            console.log("documentService -> GetMergeTemplatesResponse");
            if (this.setGetMergeTemplatesResponse != null)
                this.setGetMergeTemplatesResponse(response);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_DOCUMENT'), this.translateService, this.dialog));
        this.proxy.on('pendingItemCountResponse', result => {
            console.log("documentService -> pendingItemCountResponse:", result);
            if (this.setPendingCountResponse != null)
                this.setPendingCountResponse(result);
        });
    }
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Document, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.searchViewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Document, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.searchRelatedMessageId);
            });
        }
    }
    ;
};
DocumentService = __decorate([
    Injectable({ providedIn: 'root' })
], DocumentService);
export { DocumentService };
//# sourceMappingURL=document-service.js.map