var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ChatMessageType, ChatReplyBy, ChatState, OperationType } from '../enums/common-enums';
import { ChatHistoryDto } from '../models/chat/chat-historyDto';
import { ChatDto } from '../models/chat/chatDto';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let ChatService = class ChatService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, chatManager, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.chatManager = chatManager;
        this.dialog = dialog;
        this.dateJS = Date;
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.exceptionOccurred = false;
        this.chatMessageCallbacks = (messageCallback) => {
            this.sendMessageCallback = messageCallback;
        };
        this.resetChat = () => {
            this.sendMessageCallback = null;
            this.reployIncomingChatCallback = null;
            this.chatManager.closeIncomingChat();
            this.chatManager.closeChat();
            this.chatMessage = new ChatDto();
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.replyIncomingChat = (chatDto, reployIncomingChatResponseCallback) => {
            this.reployIncomingChatCallback = reployIncomingChatResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('replyIncomingChat', chatDto);
            });
        };
        this.checkLiveState = (connectionId, checkLiveStateResponseCallback) => {
            this.checkLiveStateCallback = checkLiveStateResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('checkLiveState', connectionId);
            });
        };
    }
    setRelatedResultCallback(setRelatedChatResultFoundCallback, messageId) {
        this.relatedMessageId = messageId;
        this.setRelatedChatResultFound = setRelatedChatResultFoundCallback;
    }
    ;
    setViewerRelatedResultCallback(setViewerRelatedChatResultFoundCallback, messageId) {
        this.viewerRelatedMessageId = messageId;
        this.setViewerRelatedChatResultFound = setViewerRelatedChatResultFoundCallback;
    }
    ;
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.chat_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        if (!this.isReconnecting)
                            super.serviceStopped(this.translateService.instant('LBL_CHAT'), this.translateService, this.dialog);
                        return reject('Failed to connect to chat service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        this.isReconnecting = true;
                        setTimeout(() => this.connect(), 30000);
                        console.error(`Chat service disconnected, trying to reconnect in 30 seconds: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Chat service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for chat service');
        });
    }
    registerServerEvents() {
        this.proxy.on('sendMessageResponse', (response) => {
            console.log('chatService -> sendMessageResponse', response);
            if (this.sendMessageCallback != null)
                this.sendMessageCallback(response);
        });
        this.proxy.on('incomingChatRequest', (request) => {
            console.log('chatService -> incomingChatRequest', request);
            if (this.chatPanel == null && this.incomingChatPanel == null) {
                this.chatMessage = request.ChatDto;
                this.chatMessage.StringRepresentation = this.translateService.instant('LBL_CHAT');
                this.chatManager.showIncomingChat();
            }
        });
        this.proxy.on('replyIncomingChatResponse', (response) => {
            console.log('chatService -> replyIncomingChatResponse', response);
            if (this.reployIncomingChatCallback != null)
                this.reployIncomingChatCallback(response);
        });
        this.proxy.on('relatedChatResultFound', (message) => {
            console.log('chatService->relatedTaskResultFound:', message);
            if (this.relatedMessageId == "" || this.relatedMessageId == message.MessageId) {
                if (this.setRelatedChatResultFound != null) {
                    let contentType = GlobalFunctions.getObjectTypeName(message.ResponseEntityType);
                    this.setRelatedChatResultFound(message.DtoList, contentType, this.translateService.instant('LBL_' + contentType.toUpperCase()));
                }
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == message.MessageId) {
                if (this.setViewerRelatedChatResultFound != null) {
                    let contentType = GlobalFunctions.getObjectTypeName(message.ResponseEntityType);
                    this.setViewerRelatedChatResultFound(message.DtoList, contentType, this.translateService.instant('LBL_' + contentType.toUpperCase()));
                }
            }
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log('chatService->searchStartedNotification:', message);
            if ((this.messageId == '' && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log('chatService->searchCompletedNotification:', message);
            if ((this.messageId == '' && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('sendLiveState', () => {
            if (this.checkLiveStateCallback != null)
                this.checkLiveStateCallback();
        });
        this.proxy.on('tokenFailedResponse', () => {
            this.sessionExpired(this.translateService, this.dialog);
        });
    }
    sendMessage(chatDto) {
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('sendMessage', chatDto);
        });
    }
    ;
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Chat, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    if (relatedObject.nativeObjectList != null && relatedObject.nativeObjectList.length > 0)
                        this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
                }
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Chat, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    if (relatedObject.nativeObjectList != null && relatedObject.nativeObjectList.length > 0)
                        this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
                }
            });
        }
    }
    ;
    endChat(userName, message) {
        try {
            if (this.chatMessage != null && !GlobalFunctions.isEmpty(this.chatMessage.Id)) {
                let chatMessageToSend = new ChatHistoryDto();
                chatMessageToSend.UserName = userName;
                chatMessageToSend.Message = message;
                chatMessageToSend.ChatId = this.chatMessage.Id;
                chatMessageToSend.MessageDateTime = new this.dateJS().toString('M/d/yyyy HH:mm:ss');
                chatMessageToSend.ReplyBy = ChatReplyBy.Handler;
                chatMessageToSend.MessageType = ChatMessageType.End;
                let chatDtoToSend = { ...this.chatMessage };
                chatDtoToSend.State = ChatState.Ended;
                chatDtoToSend.ChatHistoryList = new Array();
                chatDtoToSend.ChatHistoryList.push(chatMessageToSend);
                this.sendMessage(chatDtoToSend);
                this.resetChat();
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
};
ChatService = __decorate([
    Injectable({ providedIn: 'root' })
], ChatService);
export { ChatService };
//# sourceMappingURL=chat-service.js.map