var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { AlternateSearchType, OperationType } from '../enums/common-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let CaseService = class CaseService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, dialog, translateService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.dialog = dialog;
        this.translateService = translateService;
        this.setMultipleFetchDetailResponse = [];
        this.searchRelatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.searchMessageId = "";
        this.caseTypeMessageId = "";
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setFetchDetailResponse = null;
            this.setMultipleFetchDetailResponse = [];
            this.setRelatedCaseResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setAlternateSearchResponseFound = null;
            this.setHandlerRolesResponseReceived = null;
            this.setViewerRelatedCaseResultFound = null;
        };
        this.setMultipleFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setMultipleFetchDetailResponse.push(setFetchDetailCallback);
        };
        this.setRelatedResultCallback = (setRelatedCaseResultFoundCallback, messageId) => {
            this.searchRelatedMessageId = messageId;
            this.setRelatedCaseResultFound = setRelatedCaseResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedCaseResultFound, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedCaseResultFound = setViewerRelatedCaseResultFound;
        };
        this.setLinkToCaseCallbacks = fetchLinkToCaseCallback => {
            this.linkToCaseResponseReceived = fetchLinkToCaseCallback;
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.clearCaseTypeCallbacks = () => {
            this.setSearchCaseTypeResultFound = null;
            this.setUpdateSearchCaseTypeStatus = null;
        };
        this.search = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
            isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
            alternateSearchType = alternateSearchType ? alternateSearchType : AlternateSearchType.None;
            handler = handler ? handler : "";
            this.searchQuery = query;
            this.searchMessageId = GlobalFunctions.createGuid();
            console.log('caseService -> search:', this.searchQuery);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('search', this.searchQuery, isAllSourceRequest, alternateSearchType, handler, this.searchMessageId, sourceLocation);
            });
        };
        this.advancedSearch = (searchDto, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
            this.advancedSearchDto = searchDto;
            alternateSearchType = alternateSearchType ? alternateSearchType : AlternateSearchType.None;
            handler = handler ? handler : "";
            this.searchMessageId = GlobalFunctions.createGuid();
            console.log('caseService -> advancedSearch:', searchDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('advancedSearch', searchDto, alternateSearchType, handler, this.searchMessageId, sourceLocation);
            });
        };
        this.fetchDetail = (partialDto, fetchDetailCallback) => {
            this.setSearchResultFound = fetchDetailCallback;
            this.searchMessageId = "";
            console.log('caseService -> fetchCaseDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchDetail', partialDto);
            });
        };
        this.linkToCase = (caseEntity, caseObjectDtoJson, documentType) => {
            console.log('caseService -> linkToCase:', caseEntity, caseObjectDtoJson);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('linkToCase', caseEntity, JSON.stringify(caseObjectDtoJson), documentType);
            });
        };
        this.createCaseEntity = (createCaseRequest, createCaseResponseCallback, addCaseErrorCallback) => {
            console.log('caseService -> creating case:', Date.now());
            this.setCreateCaseResponseReceived = createCaseResponseCallback;
            let cookie = this.isValidToken();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    let url = environment.case_config.replace("/signalr", "/post/PostCaseXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
                    this.httpClient.post(url, createCaseRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (addCaseErrorCallback)
                            addCaseErrorCallback();
                    });
                }
            });
        };
        this.createCaseAsEmailEntity = (addCaseAsEmailRequest, createCaseResponseCallback, addCaseErrorCallback) => {
            console.log('createCaseAsEmailEntity -> creating case against email:', Date.now());
            this.setCreateCaseResponseReceived = createCaseResponseCallback;
            let cookie = this.isValidToken();
            let url = environment.case_config.replace("/signalr", "/post/PostCaseAsEmailXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, addCaseAsEmailRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (addCaseErrorCallback)
                            addCaseErrorCallback();
                    });
                }
            });
        };
        this.getHandlerRoles = (getHandlerRolesCallback, caseTypeId) => {
            this.setHandlerRolesResponseReceived = getHandlerRolesCallback;
            console.log('caseService -> GetHandlerRoles: for casetype id: ' + caseTypeId);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('GetHandlerRoles', caseTypeId);
            });
        };
        this.searchCaseType = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback) => {
            this.setSearchCaseTypeResultFound = searchResultFoundCallback;
            this.setUpdateSearchCaseTypeStatus = updateSearchStatusCallback;
            isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
            alternateSearchType = alternateSearchType ? alternateSearchType : AlternateSearchType.None;
            handler = handler ? handler : "";
            this.searchCaseTypeQuery = query;
            this.caseTypeMessageId = GlobalFunctions.createGuid();
            console.log('caseService -> searchCaseType:', this.searchCaseTypeQuery);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchCaseType', this.searchCaseTypeQuery, isAllSourceRequest, alternateSearchType, handler, this.caseTypeMessageId);
            });
        };
        this.fetchCaseTypeDetail = partialDto => {
            console.log('caseService -> fetchCaseTypeDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchCaseTypeDetail', partialDto);
            });
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.case_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_CASE'), this.translateService, this.dialog);
                        return reject('Failed to connect to case service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Case service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Case service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for case service');
        });
    }
    registerServerEvents() {
        this.proxy.on('searchResultFound', (result, messageId) => {
            console.log("caseService -> searchResultFound:", result);
            if (this.searchMessageId == "" || this.searchMessageId == messageId) {
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(result);
            }
            if (this.setMultipleFetchDetailResponse != null && this.setMultipleFetchDetailResponse.length > 0 && result != null && result.length > 0) {
                this.setMultipleFetchDetailResponse.forEach((element, index) => { this.setMultipleFetchDetailResponse[index](result[0]); });
            }
        });
        this.proxy.on('updateSearchStatus', result => {
            console.log("caseService -> updateSearchStatus:", result);
            if (this.setUpdateSearchStatus != null)
                this.setUpdateSearchStatus(result);
        });
        this.proxy.on('relatedCaseResultFound', (result, messageId) => {
            console.log("caseService -> relatedCaseResultFound:", result);
            if (this.searchRelatedMessageId == "" || this.searchRelatedMessageId == messageId) {
                if (this.setRelatedCaseResultFound != null)
                    this.setRelatedCaseResultFound(result, "CaseEntity", this.translateService.instant("LBL_CASE"));
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedCaseResultFound != null)
                    this.setViewerRelatedCaseResultFound(result, "CaseEntity", this.translateService.instant("LBL_CASE"));
            }
        });
        this.proxy.on('tokenFailedResponse', () => {
            this.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('caseBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_CASE'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('linkToCaseResponseReceived', response => {
            console.log("caseService -> linkToCaseResponseReceived:", response);
            if (this.linkToCaseResponseReceived != null)
                this.linkToCaseResponseReceived(response);
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("caseService -> searchStartedNotification:", message);
            if ((this.searchMessageId == "" && this.searchRelatedMessageId == "") || this.searchMessageId == message.MessageId || this.searchRelatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("caseService -> searchCompletedNotification:", message);
            if ((this.searchMessageId == "" && this.searchRelatedMessageId == "") || this.searchMessageId == message.MessageId || this.searchRelatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('alternateSearchResponseReceived', (message) => {
            console.log("caseService -> alternateSearchResponseReceived:", message);
            if (this.setAlternateSearchResponseFound != null) {
                this.setAlternateSearchResponseFound(message);
            }
        });
        this.proxy.on('createCaseResponseReceived', (response) => {
            console.log("caseService -> createCaseResponseReceived", response);
            if (this.setCreateCaseResponseReceived != null)
                this.setCreateCaseResponseReceived(response);
        });
        this.proxy.on('getHandlerRolesResponseReceived', (response) => {
            console.log("caseService -> getHandlerRolesResponseReceived", response);
            if (this.setHandlerRolesResponseReceived != null)
                this.setHandlerRolesResponseReceived(response);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_CASE'), this.translateService, this.dialog));
        this.proxy.on('searchCaseTypeResultFound', (result, messageId) => {
            if (this.caseTypeMessageId == "" || this.caseTypeMessageId == messageId) {
                console.log("caseService -> searchCaseTypeResultFound:", result);
                if (this.setSearchCaseTypeResultFound != null)
                    this.setSearchCaseTypeResultFound(result);
            }
        });
        this.proxy.on('updateSearchCaseTypeStatus', result => {
            console.log("caseService -> updateSearchCaseTypeStatus:", result);
            if (this.setUpdateSearchCaseTypeStatus != null)
                this.setUpdateSearchCaseTypeStatus(result);
        });
        this.proxy.on('caseTypeBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_CASETYPE'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
    }
    ;
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Case, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Case, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.searchRelatedMessageId);
            });
        }
    }
    sendCaseTypeRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.CaseType, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            let userId = GlobalFunctions.getLoggedInUserId();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchCaseTypeRelatedRequest', userId, JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.caseTypeMessageId);
            });
        }
    }
    ;
};
CaseService = __decorate([
    Injectable({ providedIn: 'root' })
], CaseService);
export { CaseService };
//# sourceMappingURL=case-service.js.map