var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { AppConstants } from '../../shared/constants';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { environment } from '../../../environments/environment';
import { BaseService } from './base-service';
let BasketService = class BasketService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.dialog = dialog;
        this.uniqueId = "";
        this.searchScanner = (searchScannerCallback) => {
            this.setSearchScannerResponse = searchScannerCallback;
            console.log('basketService -> searchScanner');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchScanner');
            });
        };
        this.scanBasket = (setting, scanBasketCallback) => {
            this.setScanBasketResponse = scanBasketCallback;
            console.log('basketService -> searchScanner');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('scanBasket', setting);
            });
        };
    }
    registerServerEvents() {
        this.proxy.on('printBasketResponseReceived', result => {
            console.log("basketService -> printBasketResponseReceived", result);
            if (this.setprintBasketResponseReceived != null)
                this.setprintBasketResponseReceived(result);
        });
        this.proxy.on('emailBasketResponseReceived', result => {
            console.log("basketService -> emailBasketResponseReceived", result);
            if (this.setemailBasketResponseReceived != null)
                this.setemailBasketResponseReceived(result);
        });
        this.proxy.on('basketBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_EMAIL'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_BASKET'), this.translateService, this.dialog));
        this.proxy.on('scanBasketResponse', message => {
            console.log("basketService -> scanBasketResponse", message);
            if (this.setScanBasketResponse != null)
                this.setScanBasketResponse(message);
        });
        this.proxy.on('searchScannerResponse', message => {
            console.log("basketService -> searchScannerResponse", message);
            if (this.setSearchScannerResponse != null)
                this.setSearchScannerResponse(message);
        });
        this.proxy.on('tokenFailedResponse', () => {
            this.sessionExpired(this.translateService, this.dialog);
        });
    }
    ;
    emailBasket(emailBasketRequest, basketResponseCallback, errorCallback) {
        this.setemailBasketResponseReceived = basketResponseCallback;
        console.log('basketService->emailBasketRequest');
        let cookie = this.isValidToken();
        let url = environment.basket_config.replace("/signalr", "/post/PostEmailBasketXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, emailBasketRequest).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (errorCallback)
                        errorCallback();
                });
            }
        });
    }
    ;
    printBasket(printBasketRequest, basketResponseCallback, errorCallback) {
        this.setprintBasketResponseReceived = basketResponseCallback;
        console.log('basketService->printBasketRequest');
        let cookie = this.isValidToken();
        let url = environment.basket_config.replace("/signalr", "/post/PostPrintBasketXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, printBasketRequest).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (errorCallback)
                        errorCallback();
                });
            }
        });
    }
    ;
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.basket_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_BASKET'), this.translateService, this.dialog);
                        return reject('Failed to connect to basket service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Basket service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Basket service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for basket service');
        });
    }
};
BasketService = __decorate([
    Injectable({ providedIn: 'root' })
], BasketService);
export { BasketService };
//# sourceMappingURL=basket-service.js.map