var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { map } from 'rxjs/operators';
import { environment } from '../../../environments/environment';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { BaseService } from './base-service';
let AvailibilityService = class AvailibilityService extends BaseService {
    constructor(zone, router, dialog, httpClient, eventProvider, translateService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.dialog = dialog;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.getAvailabilityByMultipleKey = (employeeList, completedAvailabilityFetchByMultipleKey) => {
            return new Promise((resolve, reject) => {
                var availabilityCollection = [];
                if (employeeList.length > 0 && employeeList.length <= 20) {
                    let where = "";
                    for (let index = 0; index < employeeList.length; index++) {
                        if (!GlobalFunctions.isEmpty(employeeList[index]?.EmailAddress)) {
                            if (GlobalFunctions.isEmpty(where))
                                where = "(EMPLOYEEAVAILABILITYID%20eq%20%27" + encodeURIComponent(employeeList[index].EmailAddress.toLowerCase().replace(/'/g, "''")) + "%27)";
                            else
                                where = where + " or (EMPLOYEEAVAILABILITYID%20eq%20%27" + encodeURIComponent(employeeList[index].EmailAddress.toLowerCase().replace(/'/g, "''")) + "%27)";
                        }
                    }
                    if (!GlobalFunctions.isEmpty(where)) {
                        let url = environment.oData_config + "/AvailabilitiesCollection?$filter=" + where;
                        return this.httpClient.get(url, { headers: this.getHeader() }).subscribe(data => {
                            if (data != null && data.length > 0) {
                                for (let index = 0; index < data.length; index++) {
                                    let availablityCollection = data[index];
                                    availablityCollection.Availability = JSON.parse(data[index].AvailabilityJson);
                                    availablityCollection.AvailabilityJson = null;
                                    availabilityCollection.push(availablityCollection);
                                }
                                if (completedAvailabilityFetchByMultipleKey != null)
                                    completedAvailabilityFetchByMultipleKey(availabilityCollection);
                                return resolve(availabilityCollection);
                            }
                        }, (err) => {
                            let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_EMPLOYEE_AVAILABILITY_ERROR_MSG"), this.translateService.instant("LBL_EMPLOYEE"));
                            ExceptionHelper.showException(this.dialog, exception, true);
                        });
                    }
                }
                return resolve(availabilityCollection);
            });
        };
    }
    getAvailabilityByKey(availabilityKey, completedAvailabilityFetchByKey) {
        let url = environment.oData_config + "/AvailabilitiesCollection?$filter=EMPLOYEEAVAILABILITYID%20eq%20%27" + encodeURIComponent(availabilityKey.replace(/'/g, "''")) + "%27";
        console.log(url);
        return this.httpClient.get(url, { headers: this.getHeader() }).pipe(map(data => {
            console.log('callback of availability for a given key odata response');
            if (data != null && data.length > 0) {
                let availabilityCollection = [];
                for (let index = 0; index < data.length; index++) {
                    let availablityCollection = data[index];
                    availablityCollection.Availability = JSON.parse(data[index].AvailabilityJson);
                    availablityCollection.AvailabilityJson = null;
                    availabilityCollection.push(availablityCollection);
                }
                if (completedAvailabilityFetchByKey != null)
                    completedAvailabilityFetchByKey(availabilityCollection);
            }
        }));
    }
    getEmployeeIdByAvailabilityStatus(status, operator, completedAvailabilityFetchByStatus) {
        let empIds = [];
        let url = environment.oData_config + "/EmployeeStatus?$filter=CURRENTSTATUS%20" + operator + "%20" + status + "&$select=EMPLOYEEID";
        this.httpClient.get(url, { headers: this.getHeader() }).subscribe(data => {
            console.log('callback of availability for a given key odata response');
            if (data != null && data.length > 0) {
                empIds = data;
                if (completedAvailabilityFetchByStatus != null)
                    completedAvailabilityFetchByStatus(data);
            }
            return empIds;
        }, (err) => {
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_EMPLOYEE_AVAILABILITY_ERROR_MSG"), this.translateService.instant("LBL_EMPLOYEE"));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
    }
};
AvailibilityService = __decorate([
    Injectable({ providedIn: 'root' })
], AvailibilityService);
export { AvailibilityService };
//# sourceMappingURL=availibility-service.js.map