var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { GlobalFunctions } from '../../shared/global-functions';
import { AvailabilityRuleSubItemSetting } from '../models/availibility/availibility-rule-sub-item-setting';
import { AvailabilityStatusInfo } from '../models/availibility/availibility-status-info';
import { AvailabilityRuleItemSetting } from '../models/common/availability-rule-item-setting';
import { BaseService } from './base-service';
let X2JS = require('x2js');
let AvailibilityRuleService = class AvailibilityRuleService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, applicationSettingManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
    }
    getAvailabilityStatusInfo(availabilityCollection) {
        let availabilityStatusInfo = null;
        let currentEmployeeAvailabilityList = [];
        if (availabilityCollection != null && availabilityCollection.length > 0) {
            let availabilityRule = null;
            let currentdate = new Date();
            for (let index = 0; index < availabilityCollection.length; index++) {
                let availability = availabilityCollection[index].Availability;
                if (availability != null && availability.length > 0) {
                    for (let subIndex = 0; subIndex < availability.length; subIndex++) {
                        let startDate = new Date(availability[subIndex].StartDate);
                        let endDate = new Date(availability[subIndex].EndDate);
                        if (startDate <= currentdate && endDate >= currentdate) {
                            let employeeAvailability = new AvailabilityRuleSubItemSetting();
                            if (availability[subIndex].FreeBusyStatus != '2') {
                                employeeAvailability.Status = availability[subIndex].FreeBusyStatus;
                            }
                            employeeAvailability.StatusDescription = availabilityCollection[index].Caption;
                            employeeAvailability.Name = availabilityCollection[index].ObjectSource;
                            currentEmployeeAvailabilityList.push(employeeAvailability);
                            break;
                        }
                    }
                }
            }
        }
        //Get enabled availablity source
        let enabledHandlerList = this.getEnabledAvailabilityHandlers(currentEmployeeAvailabilityList);
        if (enabledHandlerList != null && enabledHandlerList.length > 0) {
            for (let index = 0; index < enabledHandlerList.length; index++) {
                let employeeAvailability = new AvailabilityRuleSubItemSetting();
                employeeAvailability.Status = '2';
                employeeAvailability.Name = enabledHandlerList[index];
                currentEmployeeAvailabilityList.push(employeeAvailability);
            }
        }
        //Find availability rule on basis of current availabilities
        let employeeAvailabilityRule = this.getAvailabilityRule(currentEmployeeAvailabilityList);
        availabilityStatusInfo = new AvailabilityStatusInfo();
        availabilityStatusInfo.Color = employeeAvailabilityRule.Color;
        availabilityStatusInfo.Status = employeeAvailabilityRule.Status;
        availabilityStatusInfo.StatusText = employeeAvailabilityRule.ShortText;
        availabilityStatusInfo.StatusToolTipText = employeeAvailabilityRule.LongText;
        availabilityStatusInfo.StatusDescription = employeeAvailabilityRule.StatusDescription;
        return availabilityStatusInfo;
    }
    ;
    getAvailabilityRule(currentEmployeeAvailabilityList) {
        let availabilityRuleItemSetting = null;
        if (currentEmployeeAvailabilityList != null && currentEmployeeAvailabilityList.length > 0) {
            let hitCounter = 0;
            let availabilityRuleItems = this.getAvailabilityRuleSettings();
            for (let index = 0; index < availabilityRuleItems.length; index++) {
                hitCounter = 0;
                let availabilityRuleSubItems = availabilityRuleItems[index].SubItems;
                for (let subIndex = 0; subIndex < availabilityRuleSubItems.length; subIndex++) {
                    for (let empIndex = 0; empIndex < currentEmployeeAvailabilityList.length; empIndex++) {
                        if (availabilityRuleSubItems[subIndex].Name.toUpperCase() == currentEmployeeAvailabilityList[empIndex].Name.toUpperCase() && availabilityRuleSubItems[subIndex].Status == currentEmployeeAvailabilityList[empIndex].Status) {
                            availabilityRuleItems[index].StatusDescription = currentEmployeeAvailabilityList[empIndex].StatusDescription;
                            hitCounter++;
                            break;
                        }
                    }
                }
                if (hitCounter == currentEmployeeAvailabilityList.length) {
                    availabilityRuleItemSetting = availabilityRuleItems[index];
                    break;
                }
            }
        }
        //Rule is not matched or availability list is empty then apply default availability rule
        if (availabilityRuleItemSetting == null)
            availabilityRuleItemSetting = this.getDefaultAvailabilityRule(currentEmployeeAvailabilityList);
        return availabilityRuleItemSetting;
    }
    getDefaultAvailabilityRule(currentEmployeeAvailabilityList) {
        let availabilityRuleItemSetting = new AvailabilityRuleItemSetting();
        let countAvailablity = 0, status = -1;
        if (currentEmployeeAvailabilityList.length > 0) {
            for (let index = 0; index < currentEmployeeAvailabilityList.length; index++) {
                if (currentEmployeeAvailabilityList[index].Status == '1')
                    countAvailablity++;
            }
            if (countAvailablity > 0) {
                if (countAvailablity == currentEmployeeAvailabilityList.length)
                    status = 1;
                else
                    status = 2;
            }
            else
                status = 0;
            if (currentEmployeeAvailabilityList.length == 1 && currentEmployeeAvailabilityList[0].Status != null && currentEmployeeAvailabilityList[0].Status == '2')
                status = -1;
        }
        switch (status) {
            case -1: //Presence information is not available
                {
                    availabilityRuleItemSetting.Color = '#404048'; //Dark grey
                    availabilityRuleItemSetting.ShortText = this.translateService.instant('LBL_NO_DATA_FOUND');
                    availabilityRuleItemSetting.LongText = this.translateService.instant('LBL_NO_DATA_FOUND');
                    availabilityRuleItemSetting.Status = 2;
                    break;
                }
            case 0: //Not available
                {
                    availabilityRuleItemSetting.Color = '#ED1C24'; //Red
                    availabilityRuleItemSetting.ShortText = this.translateService.instant('LBL_NOT_AVAILABLE');
                    availabilityRuleItemSetting.LongText = this.translateService.instant('LBL_NOT_AVAILABLE');
                    availabilityRuleItemSetting.Status = 2;
                    break;
                }
            case 1: //Available
                {
                    availabilityRuleItemSetting.Color = '#22B14C'; //Green
                    availabilityRuleItemSetting.ShortText = this.translateService.instant('LBL_AVAILABLE');
                    ;
                    availabilityRuleItemSetting.LongText = this.translateService.instant('LBL_AVAILABLE');
                    ;
                    availabilityRuleItemSetting.Status = 0;
                    break;
                }
            case 2: //Partially available
                {
                    availabilityRuleItemSetting.Color = '#FFF200'; //Yellow
                    availabilityRuleItemSetting.ShortText = this.translateService.instant('LBL_PARTIALLY_AVAILABLE');
                    availabilityRuleItemSetting.LongText = this.translateService.instant('LBL_PARTIALLY_AVAILABLE');
                    availabilityRuleItemSetting.Status = 1;
                    break;
                }
        }
        return availabilityRuleItemSetting;
    }
    ;
    getStatusText(status) {
        let statusText = this.translateService.instant('LBL_NO_DATA_FOUND');
        switch (status) {
            case '0':
                statusText = this.translateService.instant('LBL_NOT_AVAILABLE');
                break;
            case '1':
                statusText = this.translateService.instant('LBL_AVAILABLE');
                break;
            case '2':
                statusText = this.translateService.instant('LBL_NO_DATA_FOUND');
                break;
            case '3':
                statusText = this.translateService.instant('LBL_PARTIALLY_AVAILABLE');
                break;
            case '4':
                statusText = this.translateService.instant('LBL_DO_NOT_DISTURB');
                break;
            case '5':
                statusText = this.translateService.instant('LBL_BE_RIGHT_BACK');
                break;
            case '6':
                statusText = this.translateService.instant('LBL_AWAY');
                break;
            case '7':
                statusText = this.translateService.instant('LBL_OFFLINE');
                break;
            case '8':
                statusText = this.translateService.instant('LBL_SICK');
                break;
            case '9':
                statusText = this.translateService.instant('LBL_WORK_VISIT');
                break;
            case '10':
                statusText = this.translateService.instant('LBL_INACTIVE');
                break;
            case '11':
                statusText = this.translateService.instant('LBL_TRAINING');
                break;
            case '12':
                statusText = this.translateService.instant('LBL_OUT_OF_OFFICE');
                break;
            case '13':
                statusText = this.translateService.instant('LBL_WORKING_ELSE_WHERE');
                break;
        }
        return statusText;
    }
    ;
    getEnabledAvailabilityHandlers(currentEmployeeAvailabilityList) {
        let enabledHandlerList = [];
        let setttings = this.applicationSettingManager.getApplicationSettingValueByKey('EmployeeAvailabilitySources');
        if (!GlobalFunctions.isEmpty(setttings)) {
            let x2js = new X2JS();
            let availabilitySourcesSettings = x2js.xml2js(setttings);
            if (availabilitySourcesSettings != null && availabilitySourcesSettings.AvailabilitySources != null && availabilitySourcesSettings.AvailabilitySources.AvailabilitySource != null) {
                availabilitySourcesSettings.AvailabilitySources.AvailabilitySource = GlobalFunctions.ConvertToArrayIfOnlySingleObject(availabilitySourcesSettings.AvailabilitySources.AvailabilitySource);
                for (let index = 0; index < availabilitySourcesSettings.AvailabilitySources.AvailabilitySource.length; index++) {
                    if (availabilitySourcesSettings.AvailabilitySources.AvailabilitySource[index]._HandlerEnabled.toUpperCase() == 'TRUE')
                        enabledHandlerList.push(availabilitySourcesSettings.AvailabilitySources.AvailabilitySource[index]._Name);
                }
            }
            if (currentEmployeeAvailabilityList != null && currentEmployeeAvailabilityList.length > 0) {
                for (let index = 0; index < currentEmployeeAvailabilityList.length; index++) {
                    let sourceName = currentEmployeeAvailabilityList[index].Name;
                    if (!GlobalFunctions.isEmpty(sourceName) && enabledHandlerList.length > 0 && enabledHandlerList.indexOf(sourceName) != -1) {
                        enabledHandlerList = jQuery.grep(enabledHandlerList, function (value) {
                            return value != sourceName;
                        });
                    }
                }
            }
        }
        return enabledHandlerList;
    }
    ;
    getAvailabilityRuleSettings() {
        let availabilityRuleItems = [];
        let setttings = this.applicationSettingManager.getApplicationSettingValueByKey('EmployeeAvailabilityRuleSettings');
        if (!GlobalFunctions.isEmpty(setttings)) {
            let x2js = new X2JS();
            let availabilityRuleSettings = x2js.xml2js(setttings);
            if (!GlobalFunctions.isEmpty(availabilityRuleSettings) && !GlobalFunctions.isEmpty(availabilityRuleSettings.AvailabilityRules) && !GlobalFunctions.isEmpty(availabilityRuleSettings.AvailabilityRules.Rule)) {
                availabilityRuleSettings = GlobalFunctions.ConvertToArrayIfOnlySingleObject(availabilityRuleSettings.AvailabilityRules.Rule);
                for (let index = 0; index < availabilityRuleSettings.length; index++) {
                    let availabilityRuleItem = new AvailabilityRuleItemSetting();
                    availabilityRuleItem.ShortText = availabilityRuleSettings[index]._ShortText;
                    availabilityRuleItem.LongText = availabilityRuleSettings[index]._LongText;
                    availabilityRuleItem.Status = availabilityRuleSettings[index]._Status;
                    availabilityRuleItem.Color = availabilityRuleSettings[index]._Color;
                    if (availabilityRuleSettings[index].SourceItem != null) {
                        if (!Array.isArray(availabilityRuleSettings[index].SourceItem)) {
                            let availabilityRuleSubItemSetting = this.jsonToAvailabilityRuleSubItem(availabilityRuleSettings[index].SourceItem);
                            availabilityRuleItem.SubItems.push(availabilityRuleSubItemSetting);
                        }
                        else {
                            let sourceItems = availabilityRuleSettings[index].SourceItem;
                            for (let subIndex = 0; subIndex < sourceItems.length; subIndex++) {
                                let availabilityRuleSubItemSetting = this.jsonToAvailabilityRuleSubItem(sourceItems[subIndex]);
                                availabilityRuleItem.SubItems.push(availabilityRuleSubItemSetting);
                            }
                        }
                    }
                    availabilityRuleItems.push(availabilityRuleItem);
                }
            }
        }
        return availabilityRuleItems;
    }
    ;
    jsonToAvailabilityRuleSubItem(sourceItem) {
        let availabilityRuleSubItemSetting = new AvailabilityRuleSubItemSetting();
        availabilityRuleSubItemSetting.Name = sourceItem._Name;
        availabilityRuleSubItemSetting.DisplayName = sourceItem._DisplayName;
        availabilityRuleSubItemSetting.Status = sourceItem._Status;
        availabilityRuleSubItemSetting.StatusText = this.getStatusText(sourceItem._Status);
        return availabilityRuleSubItemSetting;
    }
};
AvailibilityRuleService = __decorate([
    Injectable({ providedIn: 'root' })
], AvailibilityRuleService);
export { AvailibilityRuleService };
//# sourceMappingURL=availibility-rule-service.js.map