import { GlobalFunctions } from 'src/app/shared/global-functions';
import { MainEntityType } from '../../enums/task-enum';
export class ThirdPartyDto {
    constructor() {
        this.Contacts = new Array();
        this.PersonToDto = (person, personAddress) => {
            this.Name = person.StringRepresentation;
            this.Address = personAddress;
            this.EntityId = person.Id;
            this.EntitySource = person.ObjectSource;
            this.EntityType = MainEntityType.Person;
            this.Email = !GlobalFunctions.isEmpty(person.EmailAddress) ? person.EmailAddress : '';
            this.PhoneNumber = !GlobalFunctions.isEmpty(person.PhoneNumber) ? person.PhoneNumber : '';
            this.MobileNumber = !GlobalFunctions.isEmpty(person.MobileNumber) ? person.MobileNumber : '';
        };
        this.OrganizationToDto = (organization, organizationAddress) => {
            this.Name = organization.Name;
            this.Address = organizationAddress;
            this.EntityId = organization.Id;
            this.EntitySource = organization.ObjectSource;
            this.EntityType = MainEntityType.Organization;
            this.Email = !GlobalFunctions.isEmpty(organization.EmailAddress) ? organization.EmailAddress : '';
            this.PhoneNumber = !GlobalFunctions.isEmpty(organization.PhoneNumber) ? organization.PhoneNumber : '';
            this.MobileNumber = !GlobalFunctions.isEmpty(organization.MobileNumber) ? organization.MobileNumber : '';
        };
    }
}
//# sourceMappingURL=third-partDto.js.map