export const ContentType = {
    Case: 'Decos.Kcs.Cases.Entities.CaseEntity',
    CaseType: 'Decos.Kcs.CaseTypes.Entities.CaseType',
    Document: 'Decos.Kcs.Documents.Entities.Document',
    Email: 'Decos.Kcs.Email.Entities.Email',
    Employee: 'Decos.Kcs.Employees.Entities.Employee',
    Note: 'Decos.Kcs.Notes.Entities.NoteEntity',
    Organization: 'Decos.Kcs.Organizations.Entities.Organization',
    Person: 'Decos.Kcs.Persons.Entities.Person',
    Product: 'Decos.Kcs.Products.Entities.Product',
    Task: 'Decos.Kcs.Tasks.Entities.Task',
    CallbackNote: 'Decos.Kcs.Tasks.Entities.CallbackNote',
    Appointment: 'Decos.Kcs.Tasks.Entities.Appointment',
    Assignment: 'Decos.Kcs.Tasks.Entities.Assignment',
    ReportImprovement: 'Decos.Kcs.Tasks.Entities.ReportImprovement',
    InformationRequest: 'Decos.Kcs.Tasks.Entities.InformationRequest',
    InformationResponse: 'Decos.Kcs.Notes.Entities.InformationResponse',
    Department: 'Decos.Kcs.Employees.Entities.Department',
    ContactMoment: 'Decos.Kcs.ContactHistory.Entities.ContactMoment',
    News: 'Decos.Kcs.News.Entities.Item',
    QuestionAnswer: 'Decos.Kcs.Faqs.Entities.QuestionAnswer',
    Session: 'Decos.Kcs.Sessions.Entities.Session',
    Location: 'Decos.Kcs.Locations.Entities.AddressableObjectMark',
    GlobalSearch: 'Decos.Kcs.Entities.GlobalSearch',
    File: 'Decos.Kcs.Files.Entities.FileEntity',
    Theme: 'Decos.Kcs.Themes.Entities.Theme',
    Link: 'Decos.Kcs.Links.Entities.Link',
    SessionNote: 'Decos.Kcs.SessionNotes.Entities.SessionNote',
    SocialMedia: 'Decos.Kcs.SocialMedia.Entities.SocialMedia',
    Facebook: 'Decos.Kcs.SocialMedia.Entities.Facebook',
    Twitter: 'Decos.Kcs.SocialMedia.Entities.Twitter',
    WhatsApp: 'Decos.Kcs.SocialMedia.Entities.WhatsApp',
    Ticket: 'Decos.Kcs.Tickets.Entities.Ticket',
    Chat: 'Decos.Kcs.Chat.Entities.Chat',
    Issue: 'Decos.Kcs.Issues.Entities.Issue',
    AllSources: 'Decos.Kcs.Core.Entities.UniversalEntity',
    ContactHistory: 'Decos.Kcs.ContactHistory.Entities.ContactHistory',
    Domain: 'Decos.Kcs.Domains.Entities.Domain',
};
export const JsonDtoType = {
    Case: "{\"$type\":\"Decos.Kcs.Cases.Dtos.CaseEntityDto, Decos.Kcs.Cases.Dtos\",",
    CaseType: "{\"$type\":\"Decos.Kcs.CaseTypes.Dtos.CaseTypeDto, Decos.Kcs.CaseTypes.Dtos\",",
    Document: "{\"$type\":\"Decos.Kcs.Documents.Dtos.DocumentDto, Decos.Kcs.Documents.Dtos\",",
    FileDocument: "{\"$type\":\"Decos.Kcs.Core.Dtos.FileDocumentDto, Decos.Kcs.Core.Dtos\",",
    Email: "{\"$type\":\"Decos.Kcs.Email.Dtos.EmailDto, Decos.Kcs.Email.Dtos\",",
    EmailAttachment: "{\"$type\":\"Decos.Kcs.Email.Dtos.EmailAttachmentDto, Decos.Kcs.Email.Dtos\",",
    Employee: "{\"$type\":\"Decos.Kcs.Employees.Dtos.EmployeeDto, Decos.Kcs.Employees.Dtos\",",
    Department: "{\"$type\":\"Decos.Kcs.Employees.Dtos.DepartmentDto, Decos.Kcs.Employees.Dtos\",",
    TaskMailbox: "{\"$type\":\"Decos.Kcs.Employees.Dtos.TaskMailboxDto, Decos.Kcs.Employees.Dtos\",",
    Note: "{\"$type\":\"Decos.Kcs.Notes.Dtos.NoteEntityDto, Decos.Kcs.Notes.Dtos\",",
    Organization: "{\"$type\":\"Decos.Kcs.Organizations.Dtos.OrganizationDto, Decos.Kcs.Organizations.Dtos\",",
    Person: "{\"$type\":\"Decos.Kcs.Persons.Dtos.PersonDto, Decos.Kcs.Persons.Dtos\",",
    Product: "{\"$type\":\"Decos.Kcs.Products.Dtos.ProductDto, Decos.Kcs.Products.Dtos\",",
    QuestionAnswer: "{\"$type\":\"Decos.Kcs.Faqs.Dtos.QuestionAnswerDto, Decos.Kcs.Faqs.Dtos\",",
    Task: "{\"$type\":\"Decos.Kcs.Tasks.Dtos.TaskDto, Decos.Kcs.Tasks.Dtos\",",
    CallbackNote: "{\"$type\":\"Decos.Kcs.Tasks.Dtos.CallbackNoteDto, Decos.Kcs.Tasks.Dtos\",",
    Appointment: "{\"$type\":\"Decos.Kcs.Tasks.Dtos.AppointmentDto, Decos.Kcs.Tasks.Dtos\",",
    Assignment: "{\"$type\":\"Decos.Kcs.Tasks.Dtos.AssignmentDto, Decos.Kcs.Tasks.Dtos\",",
    ReportImprovement: "{\"$type\":\"Decos.Kcs.Tasks.Dtos.ReportImprovementDto, Decos.Kcs.Tasks.Dtos\",",
    InformationRequest: "{\"$type\":\"Decos.Kcs.Tasks.Dtos.InformationRequestDto, Decos.Kcs.Tasks.Dtos\",",
    InformationResponse: "{\"$type\":\"Decos.Kcs.Notes.Dtos.InformationResponseDto, Decos.Kcs.Notes.Dtos\",",
    ContactMoment: "{\"$type\":\"Decos.Kcs.ContactHistory.Dtos.ContactMomentDto, Decos.Kcs.ContactHistory.Dtos\",",
    Theme: "{\"$type\":\"Decos.Kcs.Themes.Dtos.ThemeDto, Decos.Kcs.Themes.Dtos\",",
    SocialMedia: "{\"$type\":\"Decos.Kcs.SocialMedia.Dtos.SocialMediaDto, Decos.Kcs.SocialMedia.Dtos\",",
    WhatsApp: "{\"$type\":\"Decos.Kcs.SocialMedia.Dtos.WhatsAppDto, Decos.Kcs.SocialMedia.Dtos\",",
    Twitter: "{\"$type\":\"Decos.Kcs.SocialMedia.Dtos.TwitterDto, Decos.Kcs.SocialMedia.Dtos\",",
    Facebook: "{\"$type\":\"Decos.Kcs.SocialMedia.Dtos.FacebookDto, Decos.Kcs.SocialMedia.Dtos\",",
    Domain: "{\"$type\":\"Decos.Kcs.Domains.Dtos.DomainDto, Decos.Kcs.Domains.Dtos\","
};
export const SourceType = {
    Phone_Cisco: 'Decos.Kcs.Phone.Cisco',
    Phone_Mitel: 'Decos.Kcs.Phone.Mitel',
    Phone_Avaya: 'Decos.Kcs.Phone.AvayaAES',
    Phone_Anywhere365: 'Decos.Kcs.Phone.Anywhere365',
    Phone_Basic: 'Decos.Kcs.Phone.Basic',
    Phone_Unexus: 'Decos.Kcs.Phone.Unexus',
    Case_DecosConnect: 'Decos.Kcs.Cases.DecosConnect',
    Document_DecosConnect: 'Decos.Kcs.Documents.DecosConnect',
    Email_EWS: 'Decos.Kcs.Email.EWS',
    Basket_Email: 'Decos.Kcs.Baskets.Email',
    Task_Jcc: 'Decos.Kcs.Tasks.Jcc',
    Task_Qmatic: 'Decos.Kcs.Tasks.Qmatic',
    Task_SmartCJM: 'Decos.Kcs.Tasks.SmartCJM',
    Task_Cdr: 'Decos.Kcs.Tasks.Cdr',
    Employee_Native: 'Decos.Kcs.Employees.Native',
    ContactHistory_Cdr: 'Decos.Kcs.ContactHistory.Cdr',
    Person_StUF0204: 'Decos.Kcs.Persons.StUF0204',
    Person_DecosConnect: 'Decos.Kcs.Persons.DecosConnect',
    Person_Cdr: 'Decos.Kcs.Persons.Cdr',
    Note_Cdr: 'Decos.Kcs.Notes.Cdr',
    Theme_Cdr: 'Decos.Kcs.Themes.Cdr',
    File_Cdr: 'Decos.Kcs.Files.Cdr',
    SocialMedia_Facebook: 'Decos.Kcs.SocialMedia.Facebook',
    Ticket_Cdr: 'Decos.Kcs.Tickets.Cdr',
    Availability_Cdr: 'Decos.Kcs.Availability.Cdr',
    Chat_Cdr: 'Decos.Kcs.Chat.Cdr',
    SocialMedia_WhatsApp: 'Decos.Kcs.SocialMedia.WhatsApp',
    SocialMedia_Twitter: 'Decos.Kcs.SocialMedia.Twitter',
    Domain: 'Decos.Kcs.Domains.Domain',
    Organization_Cdr: 'Decos.Kcs.Organizations.Cdr'
};
export const PersonSearchField = {
    Id: 'DECOS.KCS.PERSONS.DTOS.PERSONDTO.ID',
    Surname: 'DECOS.KCS.PERSONS.DTOS.PERSONDTO.DETAILS.FORMALNAME.SURNAME',
    Birthdate: 'DECOS.KCS.PERSONS.DTOS.PERSONDTO.DETAILS.DATEOFBIRTH',
    ServiceNumber: 'DECOS.KCS.PERSONS.DTOS.PERSONDTO.ADMINISTEREDPERSONDTO.SERVICENUMBER',
    ZipCode: 'DECOS.KCS.PERSONS.DTOS.PERSONDTO.RESIDENTIALADDRESS.ADDRESS.ZIPCODE',
    StreetName: 'DECOS.KCS.PERSONS.DTOS.PERSONDTO.RESIDENTIALADDRESS.ADDRESS.STREETNAME',
    City: 'DECOS.KCS.PERSONS.DTOS.PERSONDTO.RESIDENTIALADDRESS.ADDRESS.CITY',
    Email: 'DECOS.KCS.PERSONS.DTOS.PERSONDTO.EMAILADDRESS',
    MobileNumber: 'DECOS.KCS.PERSONS.DTOS.PERSONDTO.MOBILENUMBER',
    PhoneNumber: 'DECOS.KCS.PERSONS.DTOS.PERSONDTO.PHONENUMBER'
};
export const ContactHistorySearchField = {
    Description: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.DESCRIPTION',
    Question: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.SUBJECT',
    Answer: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.MEMO',
    StartDate: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.STARTDATE',
    EndDate: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.ENDDATE',
    Handler: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.HANDLER',
    HandlerId: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.HANDLERID',
    CaseNumber: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.CASENUMBER',
    CustomerRole: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.CUSTOMERROLE',
    ContactPerson: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.CONTACTPERSON',
    ContactType: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.CONTACTTYPEOPTION',
    ContactTypes: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.CONTACTTYPEOPTIONS',
    ContactSource: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.CONTACTSOURCEOPTION',
    NeverDelete: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.NEVERDELETE',
    Tags: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.TAGS',
    AssignedMailbox: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.ASSIGNEDMAILBOX',
    RoleId: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.ROLEID',
    ObjectId: 'DECOS.KCS.CONTACTHISTORY.DTOS.CONTACTMOMENTDTO.OBJECTID'
};
export const OrganizationSearchField = {
    Id: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.ID',
    Name: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.NAME',
    StatutoryName: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.STATUTORYNAME',
    Identification: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.ADMINISTEREDORGANIZATIONDTO.IDENTIFICATION',
    BranchNumber: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.BRANCHNUMBER',
    RSINumber: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.RSINUMBER',
    ZipCode: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.REGISTRATIONADDRESS.ADDRESS.ZIPCODE',
    StreetName: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.REGISTRATIONADDRESS.ADDRESS.STREETNAME',
    Email: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.EMAILADDRESS',
    MobileNumber: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.PHONENUMBER',
    PhoneNumber: 'DECOS.KCS.ORGANIZATIONS.DTOS.ORGANIZATIONDTO.MOBILENUMBER'
};
export const DocumentSearchField = {
    Identification: 'DECOS.KCS.DOCUMENTS.DTOS.DOCUMENTDTO.IDENTIFICATION',
    ReceivedDate: 'DECOS.KCS.DOCUMENTS.DTOS.DOCUMENTDTO.RECEIVEDDATE',
    Description: 'DECOS.KCS.DOCUMENTS.DTOS.DOCUMENTDTO.DESCRIPTION'
};
export const CaseSearchField = {
    Id: 'DECOS.KCS.CASES.DTOS.CASEENTITYDTO.ID',
    StartDate: 'DECOS.KCS.CASES.DTOS.CASEENTITYDTO.STARTDATE',
    Description: 'DECOS.KCS.CASES.DTOS.CASEENTITYDTO.DESCRIPTION',
    Petitioner: 'DECOS.KCS.CASES.DTOS.CASEENTITYDTO.PRIMARYSUBJECTNAME'
};
export const TaskSearchField = {
    Handler: 'DECOS.KCS.TASKS.DTOS.TASKDTO.HANDLER',
    CreatedDate: 'DECOS.KCS.TASKS.DTOS.TASKDTO.CREATEDDATE',
    CallbackDate: 'DECOS.KCS.TASKS.DTOS.TASKDTO.REQUIREDCALLBACKDATE',
    TaskType: 'DECOS.KCS.TASKS.DTOS.TASKDTO.TASKTYPE',
    HandledDate: 'DECOS.KCS.TASKS.DTOS.TASKDTO.HANDLEDDATE',
    ContactPerson: 'DECOS.KCS.TASKS.DTOS.TASKDTO.CONTACTPERSON',
    Question: 'DECOS.KCS.TASKS.DTOS.TASKDTO.CUSTOMERQUESTION',
    Tags: 'DECOS.KCS.TASKS.DTOS.TASKDTO.TAGS',
    PhoneNumber: 'DECOS.KCS.TASKS.DTOS.TASKDTO.PHONENUMBER',
    MobileNumber: 'DECOS.KCS.TASKS.DTOS.TASKDTO.MOBILENUMBER',
    Email: 'DECOS.KCS.TASKS.DTOS.TASKDTO.EMAIL',
    CreatedById: 'DECOS.KCS.TASKS.DTOS.TASKDTO.CREATEDBYID',
    Role: 'DECOS.KCS.TASKS.DTOS.TASKDTO.ROLE',
    CreatedByRole: 'DECOS.KCS.TASKS.DTOS.TASKDTO.CREATEDBYROLE',
};
export const ThemeSearchField = {
    Id: 'DECOS.KCS.THEMES.DTOS.THEMEDTO.ID',
};
export const TicketSearchField = {
    Description: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.DESCRIPTION',
    Result: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.RESULT',
    Type: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.TICKETTYPE',
    Customer: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.CUSTOMERNAME',
    ThirdParty: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.THIRDPARTYNAME',
    CreatedDate: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.CREATEDDATE',
    ClosedDate: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.CLOSEDDATE',
    Number: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.NUMBER',
    Handler: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.HANDLER',
    Filter: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.FILTER',
    Status: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.STATUS',
    Priority: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.PRIORITY',
    ContactEmail: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.CONTACTEMAIL',
    ContactPhoneNumber: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.CONTACTPHONENUMBER',
    ContactMobileNumber: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.CONTACTMOBILENUMBER',
    CreatedById: 'DECOS.KCS.TICKETS.DTOS.TICKETDTO.CREATEDBYID',
};
export const TaskDtoSource = {
    CallbackNotes: 'Decos.Kcs.CallbackNotes.Cdr',
    Appointments: 'Decos.Kcs.Appointments.Cdr',
    Assignments: 'Decos.Kcs.Assignments.Cdr',
    ReportImprovements: 'Decos.Kcs.ReportImprovements.Cdr',
    InformationRequest: 'Decos.Kcs.InformationRequest.Cdr'
};
//# sourceMappingURL=jkc-object.js.map