import { GlobalFunctions } from "src/app/shared/global-functions";
export class DashboardWebpartLink {
    constructor() {
        this.Date = null;
        this.FromFavourite = (entity) => {
            const entityType = GlobalFunctions.getObjectTypeName(entity.EntityType);
            const dashboardWebpartLink = new DashboardWebpartLink();
            dashboardWebpartLink.Id = entity.EntityId;
            dashboardWebpartLink.StringRepresentation = entity.EntityTitle;
            dashboardWebpartLink.Entity = entityType;
            dashboardWebpartLink.RelatedEntityFqdn = GlobalFunctions.toContentType(entityType);
            dashboardWebpartLink.Icon = GlobalFunctions.getIconClass(dashboardWebpartLink.RelatedEntityFqdn);
            dashboardWebpartLink.RelatedEntityFqdn = dashboardWebpartLink.RelatedEntityFqdn.replace(/\./g, '_');
            dashboardWebpartLink.ObjectSource = entity.EntitySource;
            dashboardWebpartLink.Date = new Date(entity.CreatedOn);
            return dashboardWebpartLink;
        };
    }
}
//# sourceMappingURL=dashboard-webpart-link.js.map