import { GlobalFunctions } from "src/app/shared/global-functions";
import { BroadCastEventKeys } from "../../../shared/constants";
import { TagActionType, ScreenMode } from "../../enums/common-enums";
import { Tag } from "../tag/tag";
import { TagAction } from "../tag/tag-action";
import { TagCriteria } from "../tag/tag-criteria";
export class TagSetting {
    constructor() {
        this.tagList = [];
    }
    setSettings(value) {
        try {
            if (!GlobalFunctions.isEmpty(value)) {
                this.tagList = [];
                const xmlDoc = $.parseXML(value);
                const tags = $(xmlDoc).find('TAGSETTING');
                if (!GlobalFunctions.isEmpty(tags)) {
                    tags.each((i, tag) => {
                        const newTag = new Tag();
                        newTag.Id = tag.getAttribute('ID');
                        newTag.Name = tag.getAttribute('NAME');
                        newTag.text = '#' + tag.getAttribute('NAME');
                        newTag.KeyWords = tag.getAttribute('KEYWORDS');
                        if (!GlobalFunctions.isEmpty(tag.getAttribute('ISACTIVE')))
                            newTag.IsActive = tag.getAttribute('ISACTIVE').toLowerCase() == "true";
                        newTag.CriteriaList = [];
                        const criterias = $(tag).find('CRITERIA');
                        criterias.each((i, criteria) => {
                            const newCriteria = new TagCriteria();
                            newCriteria.Entity = criteria.getAttribute('ENTITY');
                            newCriteria.Fields = criteria.getAttribute('FIELDS')?.split('|');
                            newTag.CriteriaList.push(newCriteria);
                        });
                        const actions = $(tag).find('ACTION');
                        if (actions?.length > 0 && !GlobalFunctions.isEmpty($(actions[0]).attr('TYPE'))) {
                            newTag.Action = new TagAction();
                            if ($(actions[0]).attr('TYPE').toUpperCase() == "SEARCH")
                                newTag.Action.Type = TagActionType.Search;
                            else if ($(actions[0]).attr('TYPE').toUpperCase() == "ADD")
                                newTag.Action.Type = TagActionType.Add;
                            else
                                newTag.Action.Type = TagActionType.Url;
                            newTag.Action.Entity = $(actions[0]).attr('ENTITY');
                            newTag.Action.Value = $(actions[0]).attr('VALUE');
                        }
                        this.tagList.push(newTag);
                    });
                    this.tagList.sort((a, b) => (a.Name.toLowerCase() > b.Name.toLowerCase()) ? 1 : ((b.Name.toLowerCase() > a.Name.toLowerCase()) ? -1 : 0));
                }
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    searchTagById(tagIds) {
        let tagsList = [];
        if (!GlobalFunctions.isEmpty(tagIds) && this.tagList != null && this.tagList.length > 0) {
            if (this.tagList && this.tagList.length > 0) {
                for (let i = 0; i < this.tagList.length; i++) {
                    if (tagIds.indexOf(this.tagList[i].Id) != -1)
                        tagsList.push(this.tagList[i]);
                }
            }
        }
        return tagsList;
    }
    ;
    searchTagByQuery(query, onlyActive = true) {
        let filterTagsList = [];
        if (this.tagList.length > 0) {
            const tagsList = onlyActive ? jlinq.from(this.tagList).equals("IsActive", true).select() : this.tagList;
            if (GlobalFunctions.isEmpty(query))
                filterTagsList = [...tagsList];
            else {
                for (let i = 0; i < tagsList.length; i++) {
                    if (tagsList[i].Name.toLowerCase().indexOf(query.toLowerCase()) != -1)
                        filterTagsList.push(tagsList[i]);
                }
            }
        }
        return filterTagsList;
    }
    ;
    getPossibleTags(selectedTags, sessionObject, newTags) {
        let tagsList = selectedTags != null && selectedTags.length > 0 ? selectedTags : [];
        if (sessionObject != null && this.tagList && this.tagList.length > 0) {
            for (let i = 0; i < this.tagList.length; i++) {
                if (this.tagList[i].IsActive && this.isMatchedTag(this.tagList[i], sessionObject)) {
                    newTags.push(this.tagList[i]);
                    let tag = jlinq.from(selectedTags).equals("Id", this.tagList[i].Id).first();
                    if (!tag)
                        tagsList.push(this.tagList[i]);
                }
            }
        }
        return tagsList;
    }
    ;
    isMatchedTag(tag, sessionObject) {
        let isMatched = false;
        let contentType = GlobalFunctions.getObjectTypeName(sessionObject?.RelatedEntityFqdn).toUpperCase();
        if (contentType.toUpperCase().indexOf("FACEBOOK") != -1 || contentType.toUpperCase().indexOf("TWITTER") != -1 || contentType.toUpperCase().indexOf("WHATSAPP") != -1)
            contentType = "SOCIALMEDIA";
        for (let c = 0; c < tag.CriteriaList.length; c++) {
            let criteria = tag.CriteriaList[c];
            if (criteria.Entity?.toUpperCase()?.includes(contentType)) {
                let matchText = "";
                switch (contentType) {
                    case "PRODUCT":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "TITLE":
                                        matchText += sessionObject?.Name;
                                        break;
                                    case "DESCRIPTION":
                                        {
                                            if (sessionObject.Descriptions != null && sessionObject?.Descriptions?.length > 0) {
                                                for (let index = 0; index < sessionObject.Descriptions.length; index++) {
                                                    matchText += sessionObject.Descriptions[index].Description || "";
                                                }
                                            }
                                            break;
                                        }
                                    case "SYNONYMS":
                                        {
                                            if (sessionObject.Synonym != null && sessionObject?.Synonym?.length > 0) {
                                                for (let index = 0; index < sessionObject.Synonym.length; index++) {
                                                    matchText += sessionObject.Synonym[index].SynonymsValue || "";
                                                }
                                            }
                                            break;
                                        }
                                }
                            }
                        }
                        break;
                    case "QUESTIONANSWER":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "QUESTION":
                                        {
                                            if (sessionObject.ChannelQuestionAnswers)
                                                matchText += sessionObject?.ChannelQuestionAnswers[0]?.Question;
                                            break;
                                        }
                                    case "ANSWER":
                                        {
                                            if (sessionObject.ChannelQuestionAnswers && sessionObject?.ChannelQuestionAnswers[0]?.Descriptions != null && sessionObject.ChannelQuestionAnswers[0].Descriptions.length > 0) {
                                                for (let index = 0; index < sessionObject.ChannelQuestionAnswers[0].Descriptions.length; index++)
                                                    matchText += sessionObject.ChannelQuestionAnswers[0].Descriptions[index].Description;
                                            }
                                            break;
                                        }
                                }
                            }
                            break;
                        }
                    case "SOCIALMEDIA":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "TITLE":
                                        sessionObject?.Message != undefined ? matchText += sessionObject.Message.Message : matchText;
                                        break;
                                    case "MESSAGE":
                                        {
                                            if (sessionObject?.MessageHistoryList != null && sessionObject.MessageHistoryList.length > 0) {
                                                for (let index = 0; index < sessionObject.MessageHistoryList.length; index++)
                                                    matchText += sessionObject.MessageHistoryList[index].Message;
                                            }
                                            break;
                                        }
                                }
                            }
                            break;
                        }
                    case "EMAIL":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "SUBJECT":
                                        if (sessionObject && sessionObject.Header)
                                            matchText += sessionObject?.Header?.Subject;
                                        break;
                                    case "BODY":
                                        if (sessionObject && !GlobalFunctions.isEmpty(sessionObject.Body))
                                            matchText += sessionObject?.Body?.Body;
                                        break;
                                }
                            }
                            break;
                        }
                    case "PERSON":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "FIRSTNAME":
                                        matchText += sessionObject?.Details?.FormalName?.FirstNames[0];
                                        break;
                                    case "SURNAME":
                                        matchText += sessionObject?.Details?.FormalName?.Surname;
                                        break;
                                    case "CITY":
                                        matchText += sessionObject?.ResidentialAddress?.Address?.City;
                                        break;
                                }
                            }
                            break;
                        }
                    case "ORGANIZATION":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "NAME":
                                        matchText += sessionObject?.Name;
                                        break;
                                }
                            }
                            break;
                        }
                    case "EMPLOYEE":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "FIRSTNAME":
                                        matchText += sessionObject?.FirstName || "";
                                        break;
                                    case "SURNAME":
                                        matchText += sessionObject?.Surname || "";
                                        break;
                                    case "DEPARTMENTNAME":
                                        matchText += sessionObject?.Department?.Name || "";
                                        break;
                                }
                            }
                            break;
                        }
                    case "CASEENTITY":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "DESCRIPTION":
                                        matchText += sessionObject?.Description;
                                        break;
                                    case "RESULT":
                                        matchText += sessionObject?.ResultDescription;
                                        break;
                                }
                            }
                            break;
                        }
                    case "DOCUMENT":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "SUBJECT":
                                        matchText += sessionObject?.Subject;
                                        break;
                                    case "DESCRIPTION":
                                        matchText += sessionObject?.Description;
                                        break;
                                }
                            }
                            break;
                        }
                    case "TASK":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "CUSTOMERQUESTION":
                                        matchText += sessionObject?.CustomerQuestion;
                                        break;
                                    case "RESULT":
                                        matchText += sessionObject?.Result;
                                        break;
                                }
                            }
                            break;
                        }
                    case "FILEENTITY":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "TITLE":
                                        matchText += sessionObject?.Title;
                                        break;
                                    case "DESCRIPTION":
                                        matchText += sessionObject?.Description;
                                        break;
                                }
                            }
                            break;
                        }
                    case "NOTEENTITY":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "TITLE":
                                        matchText += sessionObject?.Title;
                                        break;
                                    case "DESCRIPTION":
                                        matchText += sessionObject?.Description;
                                        break;
                                }
                            }
                            break;
                        }
                    case "SESSION":
                    case "SESSIONNOTE":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "NOTES":
                                        matchText += sessionObject?.Notes + " ";
                                        break;
                                    case "SUBJECTFREETEXT":
                                        matchText += sessionObject?.SubjectFreeText + " ";
                                        break;
                                    case "MEMOFREETEXT":
                                        matchText += sessionObject?.MemoFreeText + " ";
                                        break;
                                }
                            }
                            break;
                        }
                    case "THEME":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "TITLE":
                                        matchText += sessionObject?.Title;
                                        break;
                                    case "DESCRIPTION":
                                        matchText += sessionObject?.FormattedDescription;
                                        break;
                                }
                            }
                            break;
                        }
                    case "TICKET":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "TITLE":
                                        matchText += sessionObject?.Description;
                                        break;
                                    case "DESCRIPTION":
                                        matchText += sessionObject?.Result;
                                        break;
                                    case "TYPE":
                                        matchText += sessionObject?.TicketTypeText;
                                        break;
                                }
                            }
                            break;
                        }
                    case "ISSUE":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "DESCRIPTION":
                                        matchText += sessionObject?.Description;
                                        break;
                                }
                            }
                            break;
                        }
                    case "CHAT":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "MESSAGE":
                                        if (!GlobalFunctions.isEmpty(sessionObject?.ChatHistoryList))
                                            matchText += sessionObject?.ChatHistoryList[0].Message;
                                        break;
                                }
                            }
                            break;
                        }
                    case "NEWS":
                        {
                            for (let f = 0; f < criteria.Fields.length; f++) {
                                switch (criteria.Fields[f].toUpperCase()) {
                                    case "TITLE":
                                        matchText += sessionObject?.Title;
                                        break;
                                    case "DESCRIPTION":
                                        matchText += sessionObject?.Description;
                                        break;
                                }
                            }
                            break;
                        }
                }
                if (!GlobalFunctions.isEmpty(matchText)) {
                    matchText = matchText.toUpperCase();
                    let keywordList = tag.KeyWords.toUpperCase().split('|');
                    for (let k = 0; k < keywordList.length; k++) {
                        let regex = new RegExp("(\\b)" + keywordList[k] + "(\\b)", "gi");
                        if (matchText.match(regex)) {
                            isMatched = true;
                            break;
                        }
                    }
                }
                if (isMatched)
                    break;
            }
        }
        return isMatched;
    }
    ;
    handleAction(tag, sessionManager, searchService, dialogManager, eventProvider, $event = null, viewContainerRef = null) {
        if (tag != null && tag.Action != null) {
            switch (tag.Action.Type) {
                case TagActionType.Search:
                    {
                        sessionManager.startSessionIfPossible(tag.Action.Entity.toLowerCase(), ScreenMode.List);
                        let selectedSearchOption = {
                            style: "",
                            selectable: false,
                            searchType: tag.Action.Entity.toLowerCase(),
                            searchQuery: tag.Name,
                            formattedText: "",
                            item: null,
                            currentDateTime: new Date(),
                            url: "",
                            sourceLocation: null
                        };
                        searchService.searchOptionChanged(selectedSearchOption);
                        break;
                    }
                case TagActionType.Url:
                    {
                        if (!GlobalFunctions.isEmpty(tag.Action.Value))
                            window.open(tag.Action.Value, "_blank", "toolbar=0,location=0,menubar=0,status=1,scrollbars=1,resizable=1,width=500,height=500");
                        break;
                    }
                case TagActionType.Add:
                    {
                        let dialogName = "ADD_";
                        if (GlobalFunctions.isEmpty(tag.Action.Value))
                            dialogName = dialogName + tag.Action.Entity.toUpperCase();
                        else
                            dialogName = dialogName + tag.Action.Value.toUpperCase();
                        dialogManager.openJsPanelOrDialog(dialogName, null, null, null, viewContainerRef);
                        break;
                    }
            }
        }
        if (tag != null) {
            eventProvider.BroadcastEvent(BroadCastEventKeys.TAG_SELECTED, tag);
            if (sessionManager.contactSessionNotesState.Tags != null && sessionManager.contactSessionNotesState.Tags.length > 0) {
                let tagExists = jlinq.from(sessionManager.contactSessionNotesState.Tags).equals("Id", tag.Id).first();
                if (tagExists == null || tagExists == undefined)
                    sessionManager.contactSessionNotesState.Tags.push(tag);
            }
            else
                sessionManager.contactSessionNotesState.Tags.push(tag);
            if ($event != null) {
                if ($event.stopPropagation)
                    $event.stopPropagation();
                if ($event.preventDefault)
                    $event.preventDefault();
            }
        }
    }
    ;
}
//# sourceMappingURL=tag-setting.js.map