import { GlobalFunctions } from "src/app/shared/global-functions";
import { Role } from "../role/role";
import { RoleCriteria } from "../role/role-criteria";
import { RoleCriteriaSetting } from "../role/role-criteria-setting";
import { cloneDeep } from "lodash";
export class RoleSetting {
    constructor() {
        this.roleList = [];
        this.setSettings = (value) => {
            try {
                if (!GlobalFunctions.isEmpty(value)) {
                    this.roleList = [];
                    const xmlDoc = $.parseXML(value);
                    const roles = $(xmlDoc).find('RoleSetting');
                    if (!GlobalFunctions.isEmpty(roles)) {
                        roles.each((i, role) => {
                            const newRole = new Role();
                            newRole.Id = role.getAttribute('Id');
                            newRole.Name = role.getAttribute('Name');
                            newRole.CriteriaSetting = new RoleCriteriaSetting();
                            newRole.CriteriaSetting.CriteriaList = [];
                            const criteriaSetting = $(role).find('CriteriaSetting')[0];
                            if (criteriaSetting) {
                                newRole.CriteriaSetting.KeyWords = criteriaSetting.getAttribute('Keywords');
                                newRole.CriteriaSetting.Enabled = criteriaSetting.getAttribute('EnabledCriteria').toUpperCase() == 'TRUE';
                                const criterias = $(criteriaSetting).find('Criteria');
                                criterias.each((i, criteria) => {
                                    const newCriteria = new RoleCriteria();
                                    newCriteria.Entity = criteria.getAttribute('Entity');
                                    newCriteria.Fields = criteria.getAttribute('Fields')?.split('|');
                                    newRole.CriteriaSetting.CriteriaList.push(newCriteria);
                                });
                            }
                            this.roleList.push(newRole);
                        });
                    }
                }
            }
            catch (e) {
                console.error(e);
            }
        };
        this.searchRoleById = (roleIds) => {
            const rolesList = [];
            if (!GlobalFunctions.isEmpty(roleIds) && this.roleList?.length > 0) {
                for (let i = 0; i < this.roleList.length; i++) {
                    if (roleIds.indexOf(this.roleList[i].Id) != -1)
                        rolesList.push(this.roleList[i]);
                }
            }
            return rolesList;
        };
        this.searchRoleByQuery = (query) => {
            const rolesList = [];
            if (GlobalFunctions.isEmpty(query))
                return cloneDeep(this.roleList);
            if (this.roleList?.length > 0) {
                for (let i = 0; i < this.roleList.length; i++) {
                    if (this.roleList[i].Name.toLowerCase().indexOf(query.toLowerCase()) != -1)
                        rolesList.push(this.roleList[i]);
                }
            }
            return rolesList;
        };
        this.getPossibleRole = (sessionObject) => {
            let role = null;
            if (sessionObject && this.roleList?.length > 0) {
                for (let index = 0; index < this.roleList.length; index++) {
                    if (this.roleList[index].CriteriaSetting.Enabled && this.isMatchedRole(this.roleList[index], sessionObject)) {
                        role = this.roleList[index];
                        break;
                    }
                }
            }
            return role;
        };
        this.isMatchedRole = (role, sessionObject) => {
            let isMatched = false;
            let contentType = GlobalFunctions.getObjectTypeName(sessionObject.RelatedEntityFqdn).toUpperCase();
            if (contentType.toUpperCase().indexOf("FACEBOOK") != -1 || contentType.toUpperCase().indexOf("TWITTER") != -1 || contentType.toUpperCase().indexOf("WHATSAPP") != -1)
                contentType = "SOCIALMEDIA";
            for (let c = 0; c < role.CriteriaSetting.CriteriaList.length; c++) {
                const criteria = role.CriteriaSetting.CriteriaList[c];
                if (criteria.Entity?.toUpperCase()?.includes(contentType)) {
                    let matchText = "";
                    switch (contentType) {
                        case "PRODUCT":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "TITLE":
                                            matchText += sessionObject.Name;
                                            break;
                                        case "DESCRIPTION":
                                            {
                                                if (sessionObject.Descriptions?.length > 0) {
                                                    for (let index = 0; index < sessionObject.Descriptions.length; index++)
                                                        matchText += sessionObject.Descriptions[index].Description;
                                                }
                                                break;
                                            }
                                        case "SYNONYMS":
                                            {
                                                if (sessionObject.Synonym?.length > 0) {
                                                    for (let index = 0; index < sessionObject.Synonym.length; index++)
                                                        matchText += sessionObject.Synonym[index].SynonymsValue;
                                                }
                                                break;
                                            }
                                    }
                                }
                                break;
                            }
                        case "QUESTIONANSWER":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "QUESTION":
                                            {
                                                if (sessionObject.ChannelQuestionAnswers?.length > 0 && sessionObject.ChannelQuestionAnswers[0].Question)
                                                    matchText += sessionObject.ChannelQuestionAnswers[0].Question;
                                                break;
                                            }
                                        case "ANSWER":
                                            {
                                                if (sessionObject.ChannelQuestionAnswers[0].Descriptions?.length > 0) {
                                                    for (let index = 0; index < sessionObject.ChannelQuestionAnswers[0].Descriptions.length; index++)
                                                        matchText += sessionObject.ChannelQuestionAnswers[0].Descriptions[index].Description;
                                                }
                                                break;
                                            }
                                    }
                                }
                                break;
                            }
                        case "SOCIALMEDIA":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "TITLE":
                                            matchText += sessionObject.Message.Message;
                                            break;
                                        case "MESSAGE":
                                            {
                                                if (sessionObject.MessageHistoryList != null && sessionObject.MessageHistoryList.length > 0) {
                                                    for (let index = 0; index < sessionObject.MessageHistoryList.length; index++)
                                                        matchText += sessionObject.MessageHistoryList[index].Message;
                                                }
                                                break;
                                            }
                                    }
                                }
                                break;
                            }
                        case "EMAIL":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "SUBJECT":
                                            matchText += sessionObject.Header.Subject;
                                            break;
                                        case "BODY":
                                            matchText += sessionObject.Body.Body;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "PERSON":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "FIRSTNAME":
                                            matchText += sessionObject?.Details?.FormalName?.FirstNames[0];
                                            break;
                                        case "SURNAME":
                                            matchText += sessionObject?.Details?.FormalName?.Surname;
                                            break;
                                        case "CITY":
                                            matchText += sessionObject?.ResidentialAddress?.Address?.City;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "ORGANIZATION":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "NAME":
                                            matchText += sessionObject.Name;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "EMPLOYEE":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "FIRSTNAME":
                                            matchText += sessionObject.FirstName;
                                            break;
                                        case "SURNAME":
                                            matchText += sessionObject.Surname;
                                            break;
                                        case "DEPARTMENTNAME":
                                            matchText += sessionObject.Department.Name;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "CASEENTITY":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "DESCRIPTION":
                                            matchText += sessionObject.Description;
                                            break;
                                        case "RESULT":
                                            matchText += sessionObject.ResultDescription;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "DOCUMENT":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "SUBJECT":
                                            matchText += sessionObject.Subject;
                                            break;
                                        case "DESCRIPTION":
                                            matchText += sessionObject.Description;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "TASK":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "CUSTOMERQUESTION":
                                            matchText += sessionObject.CustomerQuestion;
                                            break;
                                        case "RESULT":
                                            matchText += sessionObject.Result;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "FILEENTITY":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "TITLE":
                                            matchText += sessionObject.Title;
                                            break;
                                        case "DESCRIPTION":
                                            matchText += sessionObject.Description;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "NOTEENTITY":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "TITLE":
                                            matchText += sessionObject.Title;
                                            break;
                                        case "DESCRIPTION":
                                            matchText += sessionObject.Description;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "SESSION":
                        case "SESSIONNOTE":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "NOTES":
                                            matchText += sessionObject.Notes;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "THEME":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "TITLE":
                                            matchText += sessionObject.Title;
                                            break;
                                        case "DESCRIPTION":
                                            matchText += sessionObject.FormattedDescription;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "TICKET":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "TITLE":
                                            matchText += sessionObject.Description;
                                            break;
                                        case "DESCRIPTION":
                                            matchText += sessionObject.Result;
                                            break;
                                        case "TYPE":
                                            matchText += sessionObject.TicketType?.Description;
                                            break;
                                    }
                                }
                                break;
                            }
                        case "ISSUE":
                            {
                                for (let f = 0; f < criteria.Fields.length; f++) {
                                    switch (criteria.Fields[f].toUpperCase()) {
                                        case "DESCRIPTION":
                                            matchText += sessionObject.Description;
                                            break;
                                    }
                                }
                                break;
                            }
                    }
                    if (!GlobalFunctions.isEmpty(matchText)) {
                        matchText = matchText.toUpperCase();
                        let keywordList = role.CriteriaSetting.KeyWords.toUpperCase().split('|');
                        for (let k = 0; k < keywordList.length; k++) {
                            if (matchText.indexOf(keywordList[k] + " ") != -1 || matchText.indexOf(keywordList[k] + ",") != -1 || matchText.indexOf(keywordList[k] + ".") != -1 || matchText.indexOf(" " + keywordList[k]) != -1 || matchText == keywordList[k]) {
                                isMatched = true;
                                break;
                            }
                        }
                    }
                    if (isMatched)
                        break;
                }
            }
            return isMatched;
        };
    }
}
//# sourceMappingURL=role-setting.js.map