import { GlobalFunctions } from 'src/app/shared/global-functions';
export class Menu {
    constructor() {
        this.menuItemList = [];
    }
    addOrUpdateMenuItem(count, contentType, title, showCount = true, active = false, showSpinner = false, enabled = true, newUpdate = false, subMenuItem = null) {
        let isItemExist = false;
        for (let i = 0; i < this.menuItemList.length; i++) {
            if (this.menuItemList[i].contentType.toUpperCase() == contentType.toUpperCase()) {
                this.menuItemList[i].count = count;
                this.menuItemList[i].enabled = enabled;
                this.menuItemList[i].newUpdate = newUpdate;
                isItemExist = true;
                break;
            }
        }
        if (isItemExist == false) {
            let menuItem = new MenuItem();
            menuItem.title = title;
            menuItem.contentType = contentType.toUpperCase();
            menuItem.iconName = menuItem.contentType.indexOf('DOMAIN') == -1 ? GlobalFunctions.capitalize(contentType.replace(/Detail/g, '').replace(/Viewer/g, '').toLowerCase()) : 'Domain';
            menuItem.count = count;
            menuItem.isSubMenuType = subMenuItem != null;
            menuItem.showCount = showCount;
            menuItem.active = active;
            menuItem.enabled = enabled;
            menuItem.showSpinner = showSpinner;
            menuItem.newUpdate = newUpdate;
            menuItem.isAutoStopped = false;
            menuItem.subMenItem = subMenuItem;
            menuItem.index = GlobalFunctions.getRelatedViewsIndex(contentType);
            this.menuItemList.push(menuItem);
        }
        GlobalFunctions.sortMenuItems(this.menuItemList);
    }
    updateSpinnerStatus(contentType, showSpinner, autoStop = false) {
        for (let i = 0; i < this.menuItemList.length; i++) {
            if (this.menuItemList[i].contentType.toUpperCase() == contentType.toUpperCase()) {
                this.menuItemList[i].showSpinner = showSpinner;
                this.menuItemList[i].isAutoStopped = autoStop;
                break;
            }
        }
    }
    addOrUpdateSubMenuItems(title, contentType, currentContentType) {
        let menuItem = jlinq.from(this.menuItemList).starts('contentType', contentType).first();
        if (menuItem != null) {
            let menuItemIndex = this.menuItemList.indexOf(menuItem);
            this.menuItemList[menuItemIndex].isSubMenuType = true;
            if (menuItem.subMenItem == null)
                menuItem.subMenItem = new SubMenuItem();
            let menuItemOfSubMenuItem = jlinq.from(menuItem.subMenItem.menuItemList).starts('contentType', currentContentType.toUpperCase()).first();
            if (menuItemOfSubMenuItem == null) {
                let menuItemOfSubMenuItem = new Object();
                menuItemOfSubMenuItem.title = title;
                menuItemOfSubMenuItem.contentType = currentContentType.toUpperCase();
                menuItem.subMenItem.menuItemList.push(menuItemOfSubMenuItem);
            }
            else {
                let menuItemOfSubMenuItemIndex = menuItem.subMenItem.menuItemList.indexOf(menuItemOfSubMenuItem);
                menuItem.subMenItem.menuItemList[menuItemOfSubMenuItemIndex].title = title;
            }
            this.menuItemList[menuItemIndex].subMenItem = menuItem.subMenItem;
        }
    }
    addSubMenuItem(title, contentType, subMenuItem) {
        let menuItem = new MenuItem();
        menuItem.title = title;
        menuItem.contentType = contentType.toUpperCase();
        menuItem.count = 0;
        menuItem.isSubMenuType = true;
        menuItem.subMenItem = subMenuItem;
        menuItem.showCount = false;
        menuItem.active = false;
        menuItem.newUpdate = false;
        menuItem.isAutoStopped = false;
        this.menuItemList.push(menuItem);
    }
}
export class MenuItem {
}
export class SubMenuItem {
    constructor() {
        this.menuItemList = [];
    }
    addMenuItem(title, contentType) {
        let menuItem = new Object();
        menuItem.title = title;
        menuItem.contentType = contentType.toUpperCase();
        this.menuItemList.push(menuItem);
    }
}
;
//# sourceMappingURL=menu.js.map