import { GlobalFunctions } from "../../../shared/global-functions";
import { ContactTypeOption, OperationType, LicenseSpecificFeature } from "../../enums/common-enums";
import { EmployeeStatusDto } from "../employee/employee-statusDto";
import { ContentType } from "../jkc-object/jkc-object";
export class EmployeeStatus {
    constructor() {
        this.statusList = new Array();
        this.channelList = new Array();
        this.statusIndex = "1";
        this.statusColor = "";
        this.statusDescription = "";
        this.showStatusText = false;
        this.isEnabled = false;
        this.isInitialized = false;
        this.selectedAvailabilityChannelIndex = "0";
        this.selectedChannelTitle = "";
        this.selectedChannelClass = "jkcNoChannelWhite jkcSizeSmall";
        this.loggedInUserTime = GlobalFunctions.getCurrentDateAndTime();
        this.selectedAllChannel = false;
        this.rememberChannelPreference = false;
        this.selectedStatus = null;
        this.isEmailFeatureEnabledFromChannel = false;
        this.isPhoneFeatureEnabledFromChannel = false;
        this.isSocialMediaFeatureEnabledFromChannel = false;
        this.isLetterFeatureEnabledFromChannel = false;
        this.isPhoneChannelActive = false;
        this.isEmailChannelActive = false;
        this.isSocialMediaChannelActive = false;
        this.isChatChannelActive = false;
        this.isCounterChannelActive = false;
        this.isLetterChannelActive = false;
        this.isVoicemailChannelActive = false;
        this.isVisitChannelActive = false;
    }
    changeStatusIndex(index) {
        this.statusIndex = index;
        if (this.statusList.length > 0) {
            for (let i = 0; i < this.statusList.length; i++) {
                if (this.statusList[i].key == index) {
                    this.statusColor = this.statusList[i].color;
                    this.selectedStatus = this.statusList[i];
                    break;
                }
            }
        }
    }
    changeChannelIndex(channel, translateService) {
        if (!GlobalFunctions.isEmpty(channel) && this.channelList.length > 0) {
            let availabilityChannelIndex = "";
            for (let index = 0; index < this.channelList.length; index++) {
                if (this.channelList[index].IsChecked) {
                    if (GlobalFunctions.isEmpty(availabilityChannelIndex))
                        availabilityChannelIndex = this.channelList[index].Key;
                    else
                        availabilityChannelIndex = availabilityChannelIndex + "|" + this.channelList[index].Key;
                }
            }
            this.selectedAvailabilityChannelIndex = availabilityChannelIndex;
            if (GlobalFunctions.isEmpty(this.selectedAvailabilityChannelIndex)) {
                this.setDefaultChannelSelection(translateService);
            }
            else if (!GlobalFunctions.isEmpty(this.selectedAvailabilityChannelIndex) && this.selectedAvailabilityChannelIndex.split('|').length == 1) {
                this.selectedChannelTitle = translateService.instant("LBL_" + ContactTypeOption[this.selectedAvailabilityChannelIndex].toString().toUpperCase());
                this.selectedChannelTitle = translateService.instant("LBL_" + ContactTypeOption[this.selectedAvailabilityChannelIndex].toString().toUpperCase());
                this.selectedChannelClass = "jkc" + ContactTypeOption[this.selectedAvailabilityChannelIndex].toString() + "White jkcSizeSmall";
            }
            else if (!GlobalFunctions.isEmpty(this.selectedAvailabilityChannelIndex) && this.selectedAvailabilityChannelIndex.split('|').length > 1) {
                let channelIndexs = this.selectedAvailabilityChannelIndex.split('|');
                let multiChannelName = "";
                for (let indexCounter = 0; indexCounter < channelIndexs.length; indexCounter++) {
                    multiChannelName += translateService.instant("LBL_" + ContactTypeOption[channelIndexs[indexCounter]].toString().toUpperCase()) + ", ";
                }
                multiChannelName = multiChannelName.substring(0, multiChannelName.length - 2);
                this.selectedChannelTitle = translateService.instant("LBL_MULTI_CHANNEL_SELECTION_MSG") + multiChannelName + " " + translateService.instant("LBL_CHANNEL");
                this.selectedChannelClass = "jkcMultiChannelWhite jkcSizeSmall";
            }
        }
        else {
            this.setDefaultChannelSelection(translateService);
        }
    }
    setDefaultChannelSelection(translateService) {
        this.selectedAvailabilityChannelIndex = "0";
        this.selectedChannelTitle = translateService.instant("LBL_DEFAULT_CHANNEL_SELECTED");
        this.selectedChannelClass = "jkcNoChannelWhite jkcSizeSmall";
        for (let i = 0; i < this.channelList.length; i++) {
            this.channelList[i].IsChecked = false;
        }
    }
    restorePreviousChannelSelection(indexes, translateService) {
        if (!GlobalFunctions.isEmpty(indexes) && this.channelList.length > 0) {
            for (let j = 0; j < indexes.length; j++) {
                for (let i = 0; i < this.channelList.length; i++) {
                    if (this.channelList[i].Key == indexes[j]) {
                        this.channelList[i].IsChecked = true;
                        this.changeChannelIndex(this.channelList[i], translateService);
                        break;
                    }
                }
            }
        }
    }
    hasChannelEnabled(contactTypeOption) {
        let retValue = false;
        let contactTypeOptionStr = contactTypeOption.toString();
        if (GlobalFunctions.isEmpty(this.selectedAvailabilityChannelIndex))
            return retValue;
        let channels = this.selectedAvailabilityChannelIndex.split('|');
        for (let i = 0; i < channels.length; i++) {
            if (channels[i] == contactTypeOptionStr) {
                retValue = true;
                break;
            }
        }
        return retValue;
    }
    initializeChannelList(availabilityChannelStr, translateService) {
        if (!GlobalFunctions.isEmpty(availabilityChannelStr)) {
            this.channelList = [];
            let availabilityChannels = availabilityChannelStr.split('|');
            for (let i = 0; i < availabilityChannels.length; i++) {
                this.setActiveChannel(availabilityChannels[i]);
                if (availabilityChannels[i] == '2' && !GlobalFunctions.hasRight(ContentType.Email, OperationType.View))
                    continue;
                else if (availabilityChannels[i] == '1' && !GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Phone))
                    continue;
                else if ((availabilityChannels[i] == '5' || availabilityChannels[i] == '13' || availabilityChannels[i] == '14' || availabilityChannels[i] == '15') && (!GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.SocialMedia) || !GlobalFunctions.hasRight(ContentType.SocialMedia, OperationType.View)))
                    continue;
                else if (availabilityChannels[i] == ContactTypeOption.Chat && !GlobalFunctions.hasRight(ContentType.Chat, OperationType.View))
                    continue;
                this.channelList.push({
                    Key: availabilityChannels[i],
                    Value: ContactTypeOption[availabilityChannels[i]].toString(),
                    StringRepresentation: translateService.instant("LBL_" + ContactTypeOption[availabilityChannels[i]].toString().toUpperCase()),
                    IsChecked: false
                });
            }
            this.selectedChannelTitle = translateService.instant("LBL_DEFAULT_CHANNEL_SELECTED");
        }
        else {
            this.isEmailFeatureEnabledFromChannel = true;
            this.isPhoneFeatureEnabledFromChannel = true;
            this.isSocialMediaFeatureEnabledFromChannel = true;
            this.isLetterFeatureEnabledFromChannel = true;
        }
        this.isInitialized = true;
    }
    setActiveChannel(channel) {
        switch (channel) {
            case "1":
                this.isPhoneChannelActive = true;
                break;
                ;
            case "2":
                this.isEmailChannelActive = true;
                break;
            case "3":
                this.isLetterChannelActive = true;
                break;
            case "4":
                this.isCounterChannelActive = true;
                break;
            case "5":
                this.isSocialMediaChannelActive = true;
                break;
            case "11":
                this.isVoicemailChannelActive = true;
                break;
            case "12":
                this.isChatChannelActive = true;
                break;
            case "18":
                this.isVisitChannelActive = true;
                break;
        }
    }
    getLoggedOutStatus() {
        let employeeStatus = new EmployeeStatusDto();
        employeeStatus.EmployeeId = GlobalFunctions.getLoggedInUserId();
        employeeStatus.CurrentStatus = "1";
        employeeStatus.CurrentStatusText = null;
        employeeStatus.Channels = [ContactTypeOption.None.toString()];
        employeeStatus.CurrentChannel = ContactTypeOption.None.toString();
        employeeStatus.LoggedInTime = GlobalFunctions.isEmpty(this.loggedInUserTime) ? GlobalFunctions.getCurrentDateAndTime() : this.loggedInUserTime;
        employeeStatus.LoggedOutTime = GlobalFunctions.getCurrentDateAndTime();
        employeeStatus.SessionId = GlobalFunctions.getSessionTokenAsString();
        return employeeStatus;
    }
    getEmployeeStatus() {
        let employeeStatus = new EmployeeStatusDto();
        employeeStatus.EmployeeId = GlobalFunctions.getLoggedInUserId();
        employeeStatus.CurrentStatus = this.statusIndex;
        employeeStatus.CurrentStatusText = this.statusDescription;
        employeeStatus.Channels = this.selectedAvailabilityChannelIndex.split('|');
        employeeStatus.CurrentChannel = this.selectedAvailabilityChannelIndex.split('|')[0];
        employeeStatus.LoggedInTime = GlobalFunctions.isEmpty(this.loggedInUserTime) ? GlobalFunctions.getCurrentDateAndTime() : this.loggedInUserTime;
        employeeStatus.SessionId = GlobalFunctions.getSessionTokenAsString();
        return employeeStatus;
    }
}
//# sourceMappingURL=employee-status.js.map