import { GlobalFunctions } from "src/app/shared/global-functions";
import { BasketItemDto } from "../basket/basket-itemDto";
export class BasketItems {
    constructor() {
        this.basketItems = new Array();
    }
    addBasketItem(value) {
        if (value != null) {
            let isAdded = false;
            let basketItemDto = new BasketItemDto();
            basketItemDto.Type = value.RelatedEntityFqdn;
            basketItemDto.TypeText = value.RelatedEntityFqdn.split('_')[value.RelatedEntityFqdn.split('_').length - 1].toLowerCase();
            let entityName = GlobalFunctions.getObjectTypeName(value.RelatedEntityFqdn);
            basketItemDto.Item = value;
            basketItemDto.ItemList = null;
            for (let index = 0; index < this.basketItems.length; index++) {
                isAdded = false;
                if (!GlobalFunctions.isEmpty(entityName) && basketItemDto != null && basketItemDto.Item != null && this.basketItems[index].Item != null && this.basketItems[index].Item.Id == basketItemDto.Item.Id) {
                    isAdded = true;
                    break;
                }
            }
            if (!isAdded) {
                basketItemDto.Item.IsMarked = true;
                this.basketItems.push(basketItemDto);
            }
        }
    }
    addBasketItemFromSession(value) {
        if (value != null) {
            this.basketItems.push(value);
        }
    }
    setBasketItems(basketItems) {
        this.basketItems = basketItems;
    }
    getBasketItems() {
        return this.basketItems;
    }
    count() {
        return this.basketItems.length;
    }
}
//# sourceMappingURL=basket-item.js.map