var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import { map } from 'rxjs/operators';
import { environment } from 'src/environments/environment';
import { BaseService } from '../services/base-service';
let UserSettingManager = class UserSettingManager extends BaseService {
    constructor(zone, router, httpClient, eventProvider) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.userSettingsDictionary = {};
        this.userSettingList = [];
        this.isUserSettingsCached = false;
    }
    /**
     * cache  user setting
     * @param loggedInUserId  logged in user id
     * @param sessionId session id
     * @returns user setting list
     */
    cacheUserSetting(loggedInUserId) {
        if (!this.isUserSettingsCached) {
            return this.getUserSetting(loggedInUserId).pipe(map(data => {
                if (data != null && data.length > 0) {
                    this.userSettingsDictionary = {};
                    this.userSettingList = data;
                    if (this.userSettingList.length > 0) {
                        for (let index = 0; index < this.userSettingList.length; index++) {
                            this.userSettingsDictionary[this.userSettingList[index].Key.toUpperCase()] = this.userSettingList[index].Value;
                        }
                    }
                    this.isUserSettingsCached = true;
                }
                return this.userSettingList;
            }));
        }
        else {
            return new BehaviorSubject(this.userSettingList);
        }
    }
    /**
     * get user setting
     * @param loggedInUserId logged in user id
     * @returns  user sessting
     */
    getUserSetting(loggedInUserId) {
        const url = environment.oData_config + '/UsersSettings?$filter=USERID%20eq%20%27' + loggedInUserId + '%27';
        return this.httpClient.get(url, { headers: this.getHeader() });
    }
    getUserSettingValueByKey(settingKey) {
        settingKey = settingKey.toUpperCase();
        let settingValue = "";
        if (this.userSettingsDictionary)
            settingValue = this.userSettingsDictionary[settingKey];
        return settingValue;
    }
    setUserSettingValueByKey(settingKey, settingValue) {
        settingKey = settingKey.toUpperCase();
        if (this.userSettingsDictionary)
            this.userSettingsDictionary[settingKey] = settingValue;
    }
    ;
    clear() {
        this.isUserSettingsCached = false;
        this.userSettingsDictionary = {};
    }
};
UserSettingManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], UserSettingManager);
export { UserSettingManager };
//# sourceMappingURL=user-setting-manager.js.map