var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { SubSink } from 'subsink';
import { SuggestionPanelComponent } from '../../components/common/suggestion-panel/suggestion-panel.component';
import { BroadCastEventKeys } from '../../shared/constants';
import { JkcPanel } from "../../shared/helper/jkc-panel-helper";
import { BaseService } from "../services/base-service";
const JsPanel = require('../../../../node_modules/jspanel4/dist/jspanel.min.js');
let SuggestionPanelManager = class SuggestionPanelManager extends BaseService {
    constructor(zone, router, httpClient, sessionManager, eventProvider, contactHistoryService, applicationSettingManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.contactHistoryService = contactHistoryService;
        this.applicationSettingManager = applicationSettingManager;
        this.suggestionPanel = null;
        this.subs = new SubSink();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    show(tag, viewContainerRef) {
        try {
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.TOGGLE_SUGGESTION_PANEL);
            this.suggestionPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, tag, false, null, null, null, 'suggestionPanelHeader', null, '-42px', '1.2%', '65%', '17%', null, '17%');
            $("#jkcSuggestionPanelContainer").empty();
            const componentRef = viewContainerRef.createComponent(SuggestionPanelComponent);
            const element = componentRef.location.nativeElement;
            JsPanel.create({
                borderRadius: '5px 5px 0px 0px',
                id: "jkcSuggestionPanel",
                size: { width: 'auto', height: 'auto' },
                header: false,
                contentOverflow: 'hidden',
                resizeit: {
                    minWidth: 500,
                    minHeight: 500,
                    containment: '#applicationBody',
                    stack: '.jsPanel',
                    opacity: 0.6,
                    disable: true,
                    resize: (event, ui) => {
                    },
                    start: function (event, ui) {
                        $("#jkcSuggestionPanel").css({ 'transition': 'unset' });
                    },
                },
                dragit: { disable: true },
                container: '#jkcSuggestionPanelContainer',
                controls: { buttons: 'closeonly' },
                title: '',
                content: element
            });
            if ($("#jkcSuggestionPanel") != null) {
                this.suggestionPanel.setInitialJsPanelStyle('#jkcSuggestionPanel');
                this.sessionManager.contactSessionNotesState.isSuggestionPanelOpen = true;
                this.contactHistoryService.setDefaultPositionAndHeightToPanel();
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    close() {
        $("#jkcSuggestionPanelContainer").empty();
        this.suggestionPanel = null;
        this.sessionManager.contactSessionNotesState.isSuggestionPanelOpen = false;
        this.sessionManager.contactSessionNotesState.TagIdForSuggestionPanel = null;
        this.contactHistoryService.setDefaultPositionAndHeightToPanel();
    }
    ;
    autoShow(tags, viewContainerRef) {
        if (this.applicationSettingManager.suggestionSetting.autoShow && this.sessionManager.contactSessionNotesState.isSuggestionPanelOpen == false && tags != null && tags.length > 0) {
            for (let index = 0; index < tags.length; index++) {
                let suggestion = this.applicationSettingManager.suggestionSetting.searchByRelationId(tags[index].Id, 'Tag');
                if (suggestion != null) {
                    this.initialize(tags[index], viewContainerRef);
                    break;
                }
            }
        }
    }
    initialize(tag, viewContainerRef) {
        if (this.sessionManager.isSuggestionFeatureEnabled) {
            let suggestion = this.applicationSettingManager.suggestionSetting.searchByRelationId(tag.Id, 'Tag');
            if (suggestion != null)
                this.show(tag, viewContainerRef);
        }
    }
};
SuggestionPanelManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], SuggestionPanelManager);
export { SuggestionPanelManager };
//# sourceMappingURL=suggestion-panel-manager.js.map