var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import jQuery from "jquery";
import { Injectable } from "@angular/core";
import { BroadCastEventKeys, RoutePath } from "../../shared/constants";
import { GlobalFunctions } from "../../shared/global-functions";
import { AuthenticationType, AvailablityStatusCode, ContactSessionNotesUIState, OperationType, ScreenMode } from "../enums/common-enums";
import { EntityFqdn, TaskSource } from "../enums/core-enums";
import { EmailType } from "../enums/global-enum";
import { PhoneStatus } from "../enums/phone-enum";
import { SessionStatus, UIState } from "../enums/session-enum";
import { CreateTaskAction, TaskStatus } from "../enums/task-enum";
import { BasketItemDto } from "../models/basket/basket-itemDto";
import { BreadcrumbItem } from "../models/bread-crumb/bread-crumb-item";
import { AdvancedSearchItem } from "../models/common/advance-serach-item";
import { ApplicationInfo } from "../models/common/application-Info";
import { BaseDto } from "../models/common/baseDto";
import { BasketItems } from "../models/common/basket-item";
import { DateCriteriaDto } from "../models/common/date-criteria";
import { EmployeeStatus } from "../models/common/employee-status";
import { EnumCriteriaDto } from "../models/common/enum-criteria";
import { LocationDto } from "../models/common/locationDto";
import { PendingCount } from "../models/common/pending-count";
import { StringCriteriaDto } from "../models/common/string-criteria";
import { ContactHistoryMomentDto } from "../models/contact-history/contact-history-momentDto";
import { FavouriteDto } from "../models/dashboard/favouriteDto";
import { DescriptionDocumentDto } from "../models/document/description-document-dto";
import { CaseSearchField, ContactHistorySearchField, ContentType, DocumentSearchField, OrganizationSearchField, PersonSearchField, SourceType, TicketSearchField } from "../models/jkc-object/jkc-object";
import { SessionContainerDto } from "../models/session/session-containerDto";
import { SessionEntityDto } from "../models/session/session-entityDto";
import { SessionHistoryDto } from "../models/session/session-historyDto";
import { SessionItemDto } from "../models/session/session-itemDto";
import { SessionObjectDto } from "../models/session/session-objectDto";
import { SessionUIDto } from "../models/session/session-uiDto";
import { TaskHandlerDto } from "../models/task/task-handlerDto";
import { BaseService } from "../services/base-service";
import { SubSink } from "subsink";
import { ExceptionHelper } from "../../shared/helper/exception-helper";
let SessionManager = class SessionManager extends BaseService {
    constructor(zone, router, dialog, httpClient, eventProvider, cacheManager, applicationSettingManager, integrationSettingManager, searchService, translateService, htmlToPlainTextPipe, datePipe) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.dialog = dialog;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.cacheManager = cacheManager;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.searchService = searchService;
        this.translateService = translateService;
        this.htmlToPlainTextPipe = htmlToPlainTextPipe;
        this.datePipe = datePipe;
        this.dateJS = Date;
        this.basketItems = new BasketItems();
        this.isValiduser = false;
        this.isLoggedOut = false;
        this.isThemeFeatureEnabled = false;
        this.isSocialMediaFeatureEnabled = false;
        this.isIssueFeatureEnabled = false;
        this.isViewerFeatureEnabled = false;
        this.isSuggestionFeatureEnabled = false;
        this.isSecureEmailFeatureEnabled = false;
        this.showDetailViewActionOption = false;
        this.showTopHeader = false;
        this.hasViewerAccess = false;
        this.isSessionStart = false;
        this.isEWSEnabled = false;
        this.ticketFilters = null;
        this.isTicketFeatureEnabled = false;
        this.isTicketFilterFeatureEnabled = false;
        this.isChatFeatureEnabled = false;
        this.isRoleFeatureEnabled = false;
        this.isCallerRecentActivityFeatureEnabled = false;
        this.isPersonDeeplinkEnabled = false;
        this.isWindowActive = true;
        this.hasPendingSession = false;
        this.showLocalSearch = false;
        this.showDetailSearch = false;
        this.showMenuOptions = false;
        this.userMailboxes = [];
        this.sentEmailDetail = null;
        this.sentEmailType = EmailType.None;
        this.currentCallerId = null;
        this.currentCallId = null;
        this.detailViewCachedEntityList = [];
        this.BreadcrumbItems = [];
        this.ActivityItemsRelatedBreadCrumbs = [];
        this.outboxItemCount = 0;
        this.loadedFromNextEmailButton = false;
        this.isActivityFound = false;
        this.loadedFromRelatedView = false;
        this.isAppLoaded = false;
        this.pendingCount = new PendingCount();
        this.selectedIndex = 0;
        this.selectedMailbox = '';
        this.selectedRole = '';
        this.isRoleChanged = false;
        this.isRoleSelectionDialogOpen = false;
        this.customContextMenuItems = [];
        this.isSystemAIFeatureEnabled = false;
        this.isCustomSelectionEnabled = false;
        this.showUIOnTop = false;
        this.timer = null;
        this.keepPhoneBusy = false;
        this.emailPattern = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/i;
        this.decosEmailPattern = /^[_a-z0-9]+(\.[_a-z0-9]+)*@(decos.com|doclogic.nl)$/i;
        this.phoneNumberPattern = /^[\+]?[ \d-]{1,20}$/;
        this.jkcParentPanel = null;
        this.jkcChildPanel = null;
        this.jkcViewerPanel = null;
        this.jkcViewerBreadCrumbList = [];
        this.localSearchQuery = '';
        this.detailSearchQuery = '';
        this.localSearchField = null;
        this.localSearchFieldList = [];
        this.showTaskReminder = false;
        this.sessionStartDateTime = new Date();
        this.seconds = "00";
        this.minutes = "00";
        this.sessionExceeded = false;
        this.sessionDuration = 1;
        this.phoneTransferStatus = 0;
        this.isFavouriteEnabled = false;
        this.isFavouriteApplicable = false;
        this.isAutoLogin = false;
        this.deeplinkPhoneNumber = "";
        this.isSSOLogout = false;
        this.applicationInfo = new ApplicationInfo();
        this.employeeStatus = new EmployeeStatus();
        this.authenticationType = AuthenticationType.None;
        this.contactSessionNotesState = {
            ContactHistoryDto: new ContactHistoryMomentDto(), RelatedEntityList: [], isContactSessionNotesOpen: false, isContactSessionNotesHighlighted: false, UIState: ContactSessionNotesUIState.None, DefaultPosition: { Left: "75%", LeftMargin: "-28px", Top: "-42px", Height: $(window).height() - 58 - 5 + "px", Width: "25%" }, LastPosition: { Left: null, Top: null, Height: null, Width: null }, Tags: [], isSuggestionPanelOpen: false, TagIdForSuggestionPanel: null
        };
        this.currentSession = null;
        this.defaultOptions = {
            dateFormat: '', dateMonthYear: 'dd-MM-yyyy', datetime12HoursFormat: 'dd MMM yyyy hh:mm', datetime24HoursFormat: 'dd MMM yyyy HH:mm', timeFormat: 'HH:mm', year: 'yyyy', month: 'MMM', date: 'dd', hhmmss: 'HH:mm:ss', hhmm: 'HH:mm', mdyyyyhhmmss: "M/d/yyyy HH:mm:ss", mdyyyy: 'M/d/yyyy', birthDateFormat: 'dd MMMM',
            defaultDateFormat: 'dd MMM yyyy', defaultFullTimeFormat: 'HH:mm:ss', defaultShortTimeFormat: '', defaultFullDateTimeFormat: '', defaultShortDateTimeFormat: '', ddMMyyyy: 'ddMMyyyy', ddMMyy: 'ddMMyy'
        };
        this.overviewSubSink = new SubSink();
        this.overviewSubSinkInitialized = false;
        this.appointmentLocationList = [];
        this.appointmentProductList = [];
        this._selectedEntity = null;
        this.setWindowFocusEvents = () => {
            window.onfocus = () => this.isWindowActive = true;
            window.onblur = () => this.isWindowActive = false;
        };
        this.getSessionTicketUiObject = (modalObject) => {
            let sessionTicketUiObject = new Object();
            sessionTicketUiObject.title = modalObject.title;
            sessionTicketUiObject.CreatedDate = !GlobalFunctions.isEmpty(modalObject.ticketDto.CreatedDate) ? modalObject.ticketDto.CreatedDate : new this.dateJS().toString(this.defaultOptions.mdyyyyhhmmss);
            sessionTicketUiObject.CreatedBy = !GlobalFunctions.isEmpty(modalObject.ticketDto.CreatedBy) ? modalObject.ticketDto.CreatedBy : GlobalFunctions.getLoggedInUserId();
            sessionTicketUiObject.ContactAddress = modalObject.ticketDto.ContactAddress;
            sessionTicketUiObject.ContactEmail = modalObject.ticketDto.ContactEmail;
            sessionTicketUiObject.ContactPhoneNumber = modalObject.ticketDto.ContactPhoneNumber;
            sessionTicketUiObject.ContactMobileNumber = modalObject.ticketDto.ContactMobileNumber;
            sessionTicketUiObject.CustomerName = modalObject.ticketDto.CustomerName;
            sessionTicketUiObject.Description = modalObject.ticketDto.Description;
            sessionTicketUiObject.MainEntityId = modalObject.ticketDto.MainEntityId;
            sessionTicketUiObject.MainEntitySource = modalObject.ticketDto.MainEntitySource;
            sessionTicketUiObject.MainEntityType = modalObject.ticketDto.MainEntityType;
            sessionTicketUiObject.Result = modalObject.ticketDto.Result;
            sessionTicketUiObject.ThirdParties = modalObject.ticketDto.ThirdParties;
            sessionTicketUiObject.Priority = modalObject.ticketDto.Priority;
            sessionTicketUiObject.ReceivedDate = modalObject.ticketDto.ReceivedDate;
            sessionTicketUiObject.State = modalObject.ticketDto.State;
            sessionTicketUiObject.currentThirdPartyType = modalObject.currentThirdPartyType;
            sessionTicketUiObject.TicketType = modalObject.ticketDto.TicketType;
            sessionTicketUiObject.TicketTypeId = modalObject.ticketDto.TicketTypeId;
            sessionTicketUiObject.RepresentativeContactMobileNumber = modalObject.ticketDto.RepresentativeContactMobileNumber;
            sessionTicketUiObject.RepresentativeContactPhoneNumber = modalObject.ticketDto.RepresentativeContactPhoneNumber;
            sessionTicketUiObject.RepresentativeName = modalObject.ticketDto.RepresentativeName;
            sessionTicketUiObject.RepresentativeContactEmail = modalObject.ticketDto.RepresentativeContactEmail;
            sessionTicketUiObject.ContactPerson = modalObject.ticketDto.ContactPerson;
            sessionTicketUiObject.SelectedRepresentativeObject = modalObject.selectedRepresentativeObject;
            sessionTicketUiObject.RepresentativeList = modalObject.representativeList;
            sessionTicketUiObject.Id = modalObject.ticketDto.Id;
            sessionTicketUiObject.RelatedEntityList = modalObject.ticketDto.RelatedEntityList;
            sessionTicketUiObject.Number = modalObject.ticketDto.Number;
            let currentHandlerList = [];
            if (modalObject.handlerTags != undefined && modalObject.handlerTags != null && modalObject.handlerTags.length > 0) {
                for (let i = 0; i < modalObject.handlerTags.length; i++) {
                    if (!GlobalFunctions.isEmpty(modalObject.handlerTags[i])) {
                        let currentHandler = new TaskHandlerDto();
                        currentHandler.HandlerId = modalObject.handlerTags[i].Id;
                        let baseDtoObject = new BaseDto();
                        baseDtoObject.Id = modalObject.handlerTags[i].HandlerId;
                        currentHandler.HandlerObject = baseDtoObject;
                        currentHandler.HandlerType = modalObject.currentHandlerType;
                        currentHandlerList.push(currentHandler);
                    }
                }
            }
            sessionTicketUiObject.CurrentHandlerList = currentHandlerList;
            sessionTicketUiObject.CurrentHandlerType = modalObject.currentHandlerType;
            let searchEntitySelected = [];
            if (modalObject.searchEntityObject != undefined && modalObject.searchEntityObject.searchEntityTags != undefined && modalObject.searchEntityObject.searchEntityTags != null && modalObject.searchEntityObject.searchEntityTags.length > 0) {
                for (let i = 0; i < modalObject.searchEntityObject.searchEntityTags.length; i++) {
                    if (!GlobalFunctions.isEmpty(modalObject.searchEntityObject.searchEntityTags[i])) {
                        searchEntitySelected.push(modalObject.searchEntityObject.searchEntityTags[i]);
                    }
                }
            }
            sessionTicketUiObject.SearchEntityTags = searchEntitySelected;
            return sessionTicketUiObject;
        };
        this.addPersonAdvancedSearchItems = () => {
            let personAdvancedSearchItem = null;
            this.advancedSearchMatrix["Person"] = [];
            let privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
            //Surname
            personAdvancedSearchItem = new AdvancedSearchItem();
            personAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            personAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_LAST_NAME";
            personAdvancedSearchItem.SearchCriteria.IsInUse = true;
            personAdvancedSearchItem.SearchCriteria.CompareType = 0;
            personAdvancedSearchItem.SearchCriteria.Name = PersonSearchField.Surname;
            personAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            personAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Person"].push(personAdvancedSearchItem);
            //DOB
            if (GlobalFunctions.isEmpty(privateFields) || privateFields.toUpperCase().indexOf("|DATEOFBIRTH|") === -1) {
                personAdvancedSearchItem = new AdvancedSearchItem();
                personAdvancedSearchItem.SearchCriteria = new DateCriteriaDto();
                personAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_DATE_OF_BIRTH";
                personAdvancedSearchItem.SearchCriteria.IsInUse = true;
                personAdvancedSearchItem.SearchCriteria.CompareType = 0;
                personAdvancedSearchItem.SearchCriteria.Name = PersonSearchField.Birthdate;
                personAdvancedSearchItem.TypeOfSearchCriteria = "DateCriteria";
                personAdvancedSearchItem.IsCalenderEnabled = true;
                personAdvancedSearchItem.IsComparisonOperatorEnabled = true;
                personAdvancedSearchItem.PlaceholderText = "[dd-mm-yyyy, dd/mm/yyyy, ddMMyyyy, ddMMyy]";
                this.advancedSearchMatrix["Person"].push(personAdvancedSearchItem);
            }
            //BSN
            if (GlobalFunctions.isEmpty(privateFields) || privateFields.toUpperCase().indexOf("|SERVICENUMBER|") === -1) {
                personAdvancedSearchItem = new AdvancedSearchItem();
                personAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
                personAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_BSN";
                personAdvancedSearchItem.SearchCriteria.IsInUse = true;
                personAdvancedSearchItem.SearchCriteria.CompareType = 0;
                personAdvancedSearchItem.SearchCriteria.Name = PersonSearchField.ServiceNumber;
                personAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
                personAdvancedSearchItem.RegularExpressionValidator = /^(\d{8}|\d{9})$/;
                personAdvancedSearchItem.ValidationMessage = this.translateService.instant("LBL_WRONG_BSN_FORMAT_ERROR");
                personAdvancedSearchItem.IsComparisonOperatorEnabled = true;
                personAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
                this.advancedSearchMatrix["Person"].push(personAdvancedSearchItem);
            }
            //Zip
            if (GlobalFunctions.isEmpty(privateFields) || (privateFields.toUpperCase().indexOf("|ZIPCODE|") === -1 && privateFields.toUpperCase().indexOf("|ADDRESS|") === -1)) {
                personAdvancedSearchItem = new AdvancedSearchItem();
                personAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
                personAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_ZIP_CODE";
                personAdvancedSearchItem.SearchCriteria.IsInUse = true;
                personAdvancedSearchItem.SearchCriteria.CompareType = 0;
                personAdvancedSearchItem.SearchCriteria.Name = PersonSearchField.ZipCode;
                personAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
                personAdvancedSearchItem.RegularExpressionValidator = /^[1-9][0-9]{3} ?(?!sa|sd|ss)[a-z]{2}$/i;
                personAdvancedSearchItem.ValidationMessage = this.translateService.instant("LBL_WRONG_ZIP_CODE_FORMAT_ERROR");
                personAdvancedSearchItem.IsComparisonOperatorEnabled = true;
                personAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
                this.advancedSearchMatrix["Person"].push(personAdvancedSearchItem);
            }
            //StreetName
            if (GlobalFunctions.isEmpty(privateFields) || (privateFields.toUpperCase().indexOf("|STREETNAME|") === -1 && privateFields.toUpperCase().indexOf("|ADDRESS|") === -1)) {
                personAdvancedSearchItem = new AdvancedSearchItem();
                personAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
                personAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_STREET_NAME";
                personAdvancedSearchItem.SearchCriteria.IsInUse = true;
                personAdvancedSearchItem.SearchCriteria.CompareType = 0;
                personAdvancedSearchItem.SearchCriteria.Name = PersonSearchField.StreetName;
                personAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
                personAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
                this.advancedSearchMatrix["Person"].push(personAdvancedSearchItem);
            }
            //City
            if (GlobalFunctions.isEmpty(privateFields) || (privateFields.toUpperCase().indexOf("|CITY|") === -1 && privateFields.toUpperCase().indexOf("|ADDRESS|") === -1)) {
                personAdvancedSearchItem = new AdvancedSearchItem();
                personAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
                personAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_CITY";
                personAdvancedSearchItem.SearchCriteria.IsInUse = true;
                personAdvancedSearchItem.SearchCriteria.CompareType = 0;
                personAdvancedSearchItem.SearchCriteria.Name = PersonSearchField.City;
                personAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
                personAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
                this.advancedSearchMatrix["Person"].push(personAdvancedSearchItem);
            }
        };
        this.addContactHistoryAdvancedSearchItems = () => {
            let contactHistoryAdvancedSearchItem = null;
            this.advancedSearchMatrix["ContactHistory"] = [];
            //Description
            contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
            contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_DESCRIPTION";
            contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
            contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.Description;
            contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 0;
            contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
            contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["ContactHistory"].push(contactHistoryAdvancedSearchItem);
            //Registration Date
            contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
            contactHistoryAdvancedSearchItem.SearchCriteria = new DateCriteriaDto();
            contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_REGISTRATION_DATE";
            contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
            contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 0;
            contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.StartDate;
            contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "DateCriteria";
            contactHistoryAdvancedSearchItem.IsCalenderEnabled = true;
            contactHistoryAdvancedSearchItem.PlaceholderText = "[dd-mm-yyyy, dd/mm/yyyy, ddMMyyyy, ddMMyy]";
            this.advancedSearchMatrix["ContactHistory"].push(contactHistoryAdvancedSearchItem);
            //Handled Date
            contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
            contactHistoryAdvancedSearchItem.SearchCriteria = new DateCriteriaDto();
            contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_HANDLED_DATE";
            contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
            contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 0;
            contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.EndDate;
            contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "DateCriteria";
            contactHistoryAdvancedSearchItem.IsCalenderEnabled = true;
            contactHistoryAdvancedSearchItem.PlaceholderText = "[dd-mm-yyyy, dd/mm/yyyy, ddMMyyyy, ddMMyy]";
            this.advancedSearchMatrix["ContactHistory"].push(contactHistoryAdvancedSearchItem);
            //Handler
            contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
            contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_HANDLERTEXT";
            contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
            contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 0;
            contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.Handler;
            contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["ContactHistory"].push(contactHistoryAdvancedSearchItem);
            //Contact Person
            contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
            contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_REPRESENTATIVE";
            contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
            contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 0;
            contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.ContactPerson;
            contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["ContactHistory"].push(contactHistoryAdvancedSearchItem);
            //Channel
            contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
            contactHistoryAdvancedSearchItem.SearchCriteria = new EnumCriteriaDto();
            contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_CHANNEL";
            contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
            contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 0;
            contactHistoryAdvancedSearchItem.SearchCriteria.Name = ContactHistorySearchField.ContactType;
            contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "NumericCriteria";
            contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
            contactHistoryAdvancedSearchItem.IsComboBoxEnabled = true;
            contactHistoryAdvancedSearchItem.ComboBoxValues = [
                { "Value": 0, "Text": "NONE" },
                { "Value": 1, "Text": "PHONE" },
                { "Value": 2, "Text": "EMAIL" },
                { "Value": 3, "Text": "LETTER" },
                { "Value": 4, "Text": "COUNTER" },
                { "Value": 5, "Text": "OTHER" },
                { "Value": 6, "Text": "CALLBACK_ATTEMPT" },
                { "Value": 7, "Text": "PURCHASED_PRODUCT" },
                { "Value": 8, "Text": "CALLBACK_NOTE" }
            ];
            contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["ContactHistory"].push(contactHistoryAdvancedSearchItem);
        };
        this.addOrganizationAdvancedSearchItems = () => {
            let organizationAdvancedSearchItem = null;
            this.advancedSearchMatrix["Organization"] = [];
            let privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Organization, OperationType.PrivateField);
            //Organization Name
            organizationAdvancedSearchItem = new AdvancedSearchItem();
            organizationAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            organizationAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_NAME";
            organizationAdvancedSearchItem.SearchCriteria.IsInUse = true;
            organizationAdvancedSearchItem.SearchCriteria.CompareType = 0;
            organizationAdvancedSearchItem.SearchCriteria.Name = OrganizationSearchField.Name;
            organizationAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            organizationAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Organization"].push(organizationAdvancedSearchItem);
            //Organization Statutory Name
            organizationAdvancedSearchItem = new AdvancedSearchItem();
            organizationAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            organizationAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_STATUTORY_NAME";
            organizationAdvancedSearchItem.SearchCriteria.IsInUse = true;
            organizationAdvancedSearchItem.SearchCriteria.CompareType = 1;
            organizationAdvancedSearchItem.SearchCriteria.Name = OrganizationSearchField.StatutoryName;
            organizationAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            organizationAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Organization"].push(organizationAdvancedSearchItem);
            //KVK
            if (GlobalFunctions.isEmpty(privateFields) || privateFields.toUpperCase().indexOf("|IDENTIFICATION|") === -1) {
                organizationAdvancedSearchItem = new AdvancedSearchItem();
                organizationAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
                organizationAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_KVK";
                organizationAdvancedSearchItem.SearchCriteria.IsInUse = true;
                organizationAdvancedSearchItem.SearchCriteria.CompareType = 0;
                organizationAdvancedSearchItem.SearchCriteria.Name = OrganizationSearchField.Identification;
                organizationAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
                organizationAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
                this.advancedSearchMatrix["Organization"].push(organizationAdvancedSearchItem);
            }
            if (GlobalFunctions.isEmpty(privateFields) || privateFields.toUpperCase().indexOf("|BRANCHNUMBER|") === -1) {
                organizationAdvancedSearchItem = new AdvancedSearchItem();
                organizationAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
                organizationAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_BRANCH_NUMBER";
                organizationAdvancedSearchItem.SearchCriteria.IsInUse = true;
                organizationAdvancedSearchItem.SearchCriteria.CompareType = 0;
                organizationAdvancedSearchItem.SearchCriteria.Name = OrganizationSearchField.BranchNumber;
                organizationAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
                organizationAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
                this.advancedSearchMatrix["Organization"].push(organizationAdvancedSearchItem);
            }
            if (GlobalFunctions.isEmpty(privateFields) || privateFields.toUpperCase().indexOf("|RSINUMBER|") === -1) {
                organizationAdvancedSearchItem = new AdvancedSearchItem();
                organizationAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
                organizationAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_RSI_NUMBER";
                organizationAdvancedSearchItem.SearchCriteria.IsInUse = true;
                organizationAdvancedSearchItem.SearchCriteria.CompareType = 0;
                organizationAdvancedSearchItem.SearchCriteria.Name = OrganizationSearchField.RSINumber;
                organizationAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
                organizationAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
                this.advancedSearchMatrix["Organization"].push(organizationAdvancedSearchItem);
            }
            organizationAdvancedSearchItem = new AdvancedSearchItem();
            organizationAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            organizationAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_ZIP_CODE";
            organizationAdvancedSearchItem.SearchCriteria.IsInUse = true;
            organizationAdvancedSearchItem.SearchCriteria.CompareType = 0;
            organizationAdvancedSearchItem.SearchCriteria.Name = OrganizationSearchField.ZipCode;
            organizationAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            organizationAdvancedSearchItem.RegularExpressionValidator = /^[1-9][0-9]{3} ?(?!sa|sd|ss)[a-z]{2}$/i;
            organizationAdvancedSearchItem.ValidationMessage = this.translateService.instant("LBL_WRONG_ZIP_CODE_FORMAT_ERROR");
            organizationAdvancedSearchItem.IsComparisonOperatorEnabled = false;
            organizationAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Organization"].push(organizationAdvancedSearchItem);
            organizationAdvancedSearchItem = new AdvancedSearchItem();
            organizationAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            organizationAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_STREET_NAME";
            organizationAdvancedSearchItem.SearchCriteria.IsInUse = true;
            organizationAdvancedSearchItem.SearchCriteria.CompareType = 0;
            organizationAdvancedSearchItem.SearchCriteria.Name = OrganizationSearchField.StreetName;
            organizationAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            organizationAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Organization"].push(organizationAdvancedSearchItem);
        };
        this.addDucumentAdvancedSearchItems = () => {
            let documentAdvancedSearchItem = null;
            this.advancedSearchMatrix["Document"] = [];
            //Number
            documentAdvancedSearchItem = new AdvancedSearchItem();
            documentAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            documentAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_NUMBER";
            documentAdvancedSearchItem.SearchCriteria.IsInUse = true;
            documentAdvancedSearchItem.SearchCriteria.CompareType = 0;
            documentAdvancedSearchItem.SearchCriteria.Name = DocumentSearchField.Identification;
            documentAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            documentAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Document"].push(documentAdvancedSearchItem);
            //Received Date
            documentAdvancedSearchItem = new AdvancedSearchItem();
            documentAdvancedSearchItem.SearchCriteria = new DateCriteriaDto();
            documentAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_RECEIVED_DATE";
            documentAdvancedSearchItem.SearchCriteria.IsInUse = true;
            documentAdvancedSearchItem.SearchCriteria.CompareType = 0;
            documentAdvancedSearchItem.SearchCriteria.Name = DocumentSearchField.ReceivedDate;
            documentAdvancedSearchItem.TypeOfSearchCriteria = "DateCriteria";
            documentAdvancedSearchItem.IsCalenderEnabled = true;
            documentAdvancedSearchItem.PlaceholderText = "[dd-mm-yyyy, dd/mm/yyyy, ddMMyyyy, ddMMyy]";
            this.advancedSearchMatrix["Document"].push(documentAdvancedSearchItem);
            //Description
            documentAdvancedSearchItem = new AdvancedSearchItem();
            documentAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            documentAdvancedSearchItem.SearchCriteria.TypeOfCompareType[1].selected = true;
            documentAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_DESCRIPTION";
            documentAdvancedSearchItem.SearchCriteria.CompareType = 0;
            documentAdvancedSearchItem.SearchCriteria.IsInUse = true;
            documentAdvancedSearchItem.SearchCriteria.Name = DocumentSearchField.Description;
            documentAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            documentAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Document"].push(documentAdvancedSearchItem);
        };
        this.addCaseAdvancedSearchItems = () => {
            let caseAdvancedSearchItem = null;
            this.advancedSearchMatrix["Case"] = [];
            //Number
            caseAdvancedSearchItem = new AdvancedSearchItem();
            caseAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            caseAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_NUMBER";
            caseAdvancedSearchItem.SearchCriteria.IsInUse = true;
            caseAdvancedSearchItem.SearchCriteria.CompareType = 0;
            caseAdvancedSearchItem.SearchCriteria.Name = CaseSearchField.Id;
            caseAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            caseAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Case"].push(caseAdvancedSearchItem);
            //Started Date
            caseAdvancedSearchItem = new AdvancedSearchItem();
            caseAdvancedSearchItem.SearchCriteria = new DateCriteriaDto();
            caseAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_STARTED";
            caseAdvancedSearchItem.TypeOfSearchCriteria = "DateCriteria";
            caseAdvancedSearchItem.SearchCriteria.IsInUse = true;
            caseAdvancedSearchItem.SearchCriteria.CompareType = 0;
            caseAdvancedSearchItem.SearchCriteria.Name = CaseSearchField.StartDate;
            caseAdvancedSearchItem.IsCalenderEnabled = true;
            caseAdvancedSearchItem.PlaceholderText = "[dd-mm-yyyy, dd/mm/yyyy, ddMMyyyy, ddMMyy]";
            this.advancedSearchMatrix["Case"].push(caseAdvancedSearchItem);
            //Description
            caseAdvancedSearchItem = new AdvancedSearchItem();
            caseAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            caseAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_DESCRIPTION";
            caseAdvancedSearchItem.SearchCriteria.TypeOfCompareType[1].selected = true;
            caseAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            caseAdvancedSearchItem.SearchCriteria.IsInUse = true;
            caseAdvancedSearchItem.SearchCriteria.CompareType = 0;
            caseAdvancedSearchItem.SearchCriteria.Name = CaseSearchField.Description;
            caseAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Case"].push(caseAdvancedSearchItem);
            //Petitioner
            caseAdvancedSearchItem = new AdvancedSearchItem();
            caseAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            caseAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_PETITIONER";
            caseAdvancedSearchItem.SearchCriteria.TypeOfCompareType[1].selected = true;
            caseAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            caseAdvancedSearchItem.SearchCriteria.IsInUse = true;
            caseAdvancedSearchItem.SearchCriteria.CompareType = 0;
            caseAdvancedSearchItem.SearchCriteria.Name = CaseSearchField.Petitioner;
            caseAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Case"].push(caseAdvancedSearchItem);
        };
        this.addTicketAdvancedSearchItems = () => {
            let ticketAdvancedSearchItem = null;
            this.advancedSearchMatrix["Ticket"] = [];
            //Description
            ticketAdvancedSearchItem = new AdvancedSearchItem();
            ticketAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            ticketAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_DESCRIPTION";
            ticketAdvancedSearchItem.SearchCriteria.TypeOfCompareType[1].selected = true;
            ticketAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            ticketAdvancedSearchItem.SearchCriteria.IsInUse = true;
            ticketAdvancedSearchItem.SearchCriteria.CompareType = 0;
            ticketAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.Description;
            ticketAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Ticket"].push(ticketAdvancedSearchItem);
            //Result
            ticketAdvancedSearchItem = new AdvancedSearchItem();
            ticketAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            ticketAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_RESULT";
            ticketAdvancedSearchItem.SearchCriteria.TypeOfCompareType[1].selected = true;
            ticketAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            ticketAdvancedSearchItem.SearchCriteria.IsInUse = true;
            ticketAdvancedSearchItem.SearchCriteria.CompareType = 0;
            ticketAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.Result;
            ticketAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Ticket"].push(ticketAdvancedSearchItem);
            //Customer
            ticketAdvancedSearchItem = new AdvancedSearchItem();
            ticketAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            ticketAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_CUSTOMER";
            ticketAdvancedSearchItem.SearchCriteria.TypeOfCompareType[1].selected = true;
            ticketAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            ticketAdvancedSearchItem.SearchCriteria.IsInUse = true;
            ticketAdvancedSearchItem.SearchCriteria.CompareType = 0;
            ticketAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.Customer;
            ticketAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["Ticket"].push(ticketAdvancedSearchItem);
            //Started Date
            ticketAdvancedSearchItem = new AdvancedSearchItem();
            ticketAdvancedSearchItem.SearchCriteria = new DateCriteriaDto();
            ticketAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_CREATED";
            ticketAdvancedSearchItem.TypeOfSearchCriteria = "DateCriteria";
            ticketAdvancedSearchItem.SearchCriteria.IsInUse = true;
            ticketAdvancedSearchItem.SearchCriteria.CompareType = 0;
            ticketAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.CreatedDate;
            ticketAdvancedSearchItem.IsCalenderEnabled = true;
            ticketAdvancedSearchItem.PlaceholderText = "[dd-mm-yyyy, dd/mm/yyyy, ddMMyyyy, ddMMyy]";
            this.advancedSearchMatrix["Ticket"].push(ticketAdvancedSearchItem);
        };
        this.addAllSourcesAdvancedSearchItems = () => {
            let allSourcesAdvancedSearchItem = null;
            this.advancedSearchMatrix["AllSources"] = [];
            //Number
            allSourcesAdvancedSearchItem = new AdvancedSearchItem();
            allSourcesAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
            allSourcesAdvancedSearchItem.SearchCriteria.DisplayName = "LBL_SEARCH";
            allSourcesAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
            allSourcesAdvancedSearchItem.SearchCriteria.CompareType = 0;
            allSourcesAdvancedSearchItem.IsComparisonOperatorEnabled = true;
            allSourcesAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
            this.advancedSearchMatrix["AllSources"].push(allSourcesAdvancedSearchItem);
        };
        this.setSessionStateChangeCallback = this.setSessionStateChangeCallback.bind(this);
    }
    get selectedEntity() {
        return this._selectedEntity;
    }
    set selectedEntity(selectedEntity) {
        this._selectedEntity = selectedEntity;
        if (selectedEntity != null) {
            this.addItemToSession(selectedEntity);
            this.setFavorite(selectedEntity);
        }
    }
    setSessionStateChangeCallback(callback) {
        this.sessionStateChangedCallback = callback;
    }
    startSessionIfPossible(type, mode) {
        if (this.employeeStatus.statusIndex != AvailablityStatusCode.DoNotStartSession) {
            if (type == 'Facebook' && this.selectedEntity.IsPublishedMessage)
                return;
            if (type == 'notype' || this.applicationSettingManager.isContentTypeEligibleForStartingSession(GlobalFunctions.toContentType(type), mode)) {
                if (!this.timer) {
                    this.timer = setTimeout(() => this.onTimeout(), 1000);
                    this.isSessionStart = true;
                    this.sessionStartDateTime = new Date();
                    if (this.sessionStateChangedCallback != null)
                        this.sessionStateChangedCallback("StartSession");
                }
            }
            ;
        }
    }
    ;
    setRoleInBaseService(roleId) {
        this.roleId = roleId;
    }
    onTimeout() {
        this.seconds++;
        if (this.seconds == 60) {
            this.minutes++;
            this.seconds = 0;
        }
        if (this.minutes >= this.sessionDuration)
            this.sessionExceeded = true;
        if (this.seconds < 10 && this.seconds.toString().length == 1)
            this.seconds = "0" + this.seconds;
        if (this.minutes < 10 && this.minutes.toString().length == 1)
            this.minutes = "0" + this.minutes;
        this.timer = setTimeout(() => this.onTimeout(), 1000);
    }
    ;
    setBgColorBasedOnObjectSource(result) {
        if (result != null && result.length > 0) {
            result.forEach(record => {
                if (record != null) {
                    try {
                        if (record.ObjectSource == SourceType.Theme_Cdr) {
                            let themeSources = [];
                            let selectedValue = null;
                            let sourceResult = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Themes_Entities_Theme, "SOURCECONFIGURATION");
                            themeSources = GlobalFunctions.getThemeSourceSetting(sourceResult);
                            if (record.SourceConfigurationId != null) {
                                for (let i = 0; i < themeSources.length; i++) {
                                    if (themeSources[i]._Id == record.SourceConfigurationId) {
                                        selectedValue = themeSources[i];
                                        break;
                                    }
                                }
                                if (selectedValue != null) {
                                    record.BackgroundColor = selectedValue._BackgroundColor;
                                    record.Legendcharacter = selectedValue._SourceId;
                                    record.Tooltiptext = selectedValue._SourceName;
                                }
                            }
                            else {
                                record.BackgroundColor = this.applicationSettingManager.getApplicationSettingsColorCodeDictionary(record.ObjectSource);
                                record.Legendcharacter = this.applicationSettingManager.getLegendCharacter(record);
                                record.Tooltiptext = this.applicationSettingManager.getTooltiptext(record);
                            }
                        }
                        else if (record.ObjectSource?.indexOf(SourceType.Domain) != -1)
                            this.integrationSettingManager.setDomainObjectInfo(record);
                        else if ((record.ObjectSource == SourceType.SocialMedia_WhatsApp || record.ObjectSource == SourceType.SocialMedia_Facebook || record.ObjectSource == SourceType.SocialMedia_Twitter) && !GlobalFunctions.isEmpty(record.SourceId) && !GlobalFunctions.isEmpty(record.SourceName)) {
                            record.Legendcharacter = record.SourceId;
                            record.Tooltiptext = record.SourceName;
                        }
                        else if (!GlobalFunctions.isEmpty(record.ObjectSource) && record.ObjectSource?.indexOf(SourceType.Case_DecosConnect) != -1 && !GlobalFunctions.isEmpty(record.ObjectSourceId) && !GlobalFunctions.isEmpty(record.ObjectSourceCaption)) {
                            record.Legendcharacter = record.ObjectSourceId;
                            record.Tooltiptext = record.ObjectSourceCaption;
                        }
                        else if (!GlobalFunctions.isEmpty(record.ObjectSource) && EntityFqdn[record.RelatedEntityFqdn] === EntityFqdn.Decos_Kcs_News_Entities_Item)
                            record.Legendcharacter = this.fetchSourceCaption(record.ObjectSource, record.Legendcharacter);
                        else {
                            if (record.additionalObjectSource != null)
                                record.BackgroundColor = '#808080';
                            else
                                record.BackgroundColor = this.applicationSettingManager.getApplicationSettingsColorCodeDictionary(record.ObjectSource);
                            record.Legendcharacter = this.applicationSettingManager.getLegendCharacter(record);
                            record.Tooltiptext = this.applicationSettingManager.getTooltiptext(record);
                        }
                        record.Legendcharacter = this.fetchSourceCaption(record.ObjectSource, record.Legendcharacter);
                    }
                    catch (e) {
                        console.error(e);
                    }
                }
            });
        }
    }
    fetchSourceCaption(name, legendInitail) {
        if (legendInitail != undefined && !GlobalFunctions.isEmpty(legendInitail))
            return legendInitail;
        let objectSourceCharacter = "";
        if (!GlobalFunctions.isEmpty(name)) {
            let nameArray = name.split('.');
            if (nameArray != null && nameArray.length > 0) {
                let objectSourceName = nameArray[nameArray.length - 1];
                if (!GlobalFunctions.isEmpty(objectSourceName)) {
                    if (objectSourceName.indexOf("Cdr") == 0)
                        objectSourceName = "Kcs";
                    objectSourceCharacter = objectSourceName.trim().charAt(0).toUpperCase();
                    if (objectSourceName.split('\n').length > 1)
                        objectSourceCharacter = objectSourceName.split('\n').length;
                }
            }
        }
        return objectSourceCharacter;
    }
    getSessionUIDetails(modalScope, sessionUIDetail) {
        if (!GlobalFunctions.isEmpty(modalScope.taskDto) && !GlobalFunctions.isEmpty(modalScope.taskType) && modalScope.taskType.toLowerCase() == 'callbacknote') {
            sessionUIDetail.uiState = UIState.CallbackNote;
            sessionUIDetail.uiObject = this.getSessionCallbackNoteUiObject(modalScope);
        }
        else if (!GlobalFunctions.isEmpty(modalScope.taskDto) && !GlobalFunctions.isEmpty(modalScope.taskType) && modalScope.taskType.toLowerCase() == 'appointment') {
            sessionUIDetail.uiState = UIState.Appointment;
            sessionUIDetail.uiObject = this.getSessionCallbackNoteUiObject(modalScope, sessionUIDetail.uiState);
        }
        else if (!GlobalFunctions.isEmpty(modalScope.taskDto) && !GlobalFunctions.isEmpty(modalScope.taskType) && modalScope.taskType.toLowerCase() == 'informationrequest') {
            sessionUIDetail.uiState = UIState.InformationRequestion;
            sessionUIDetail.uiObject = this.getSessionCallbackNoteUiObject(modalScope, sessionUIDetail.uiState);
        }
        else if (!GlobalFunctions.isEmpty(modalScope.taskDto) && !GlobalFunctions.isEmpty(modalScope.taskType) && modalScope.taskType.toLowerCase() == 'reportimprovement') {
            sessionUIDetail.uiState = UIState.ReportImprovement;
            sessionUIDetail.uiObject = this.getSessionReportImprovementUiObject(modalScope);
        }
        else if (!GlobalFunctions.isEmpty(modalScope.emailDto)) {
            sessionUIDetail.uiState = modalScope.emailType == EmailType.Send ? UIState.SendEmail : UIState.ReplyEmail;
            sessionUIDetail.uiObject = this.getSessionEmailUiObject(modalScope);
        }
        else if (!GlobalFunctions.isEmpty(modalScope.ticketDto)) {
            sessionUIDetail.uiState = UIState.Ticket;
            sessionUIDetail.uiObject = this.getSessionTicketUiObject(modalScope);
        }
        else if (!GlobalFunctions.isEmpty(modalScope.noteEntityDto)) {
            sessionUIDetail.uiState = UIState.Note;
            sessionUIDetail.uiObject = this.getSessionNoteUiObject(modalScope);
        }
        else if (!GlobalFunctions.isEmpty(modalScope.themeDto)) {
            sessionUIDetail.uiState = UIState.Theme;
            sessionUIDetail.uiObject = this.getSessionThemeUiObject(modalScope);
        }
        else if (!GlobalFunctions.isEmpty(modalScope.fileDto)) {
            sessionUIDetail.uiState = UIState.File;
            sessionUIDetail.uiObject = this.getSessionFileUiObject(modalScope);
        }
        else if (!GlobalFunctions.isEmpty(modalScope.organizationDto)) {
            sessionUIDetail.uiState = UIState.Organization;
            sessionUIDetail.uiObject = this.getSessionOrganizationUiObject(modalScope);
        }
        else if (!GlobalFunctions.isEmpty(modalScope.personDto)) {
            sessionUIDetail.uiState = UIState.Person;
            sessionUIDetail.uiObject = this.getSessionPersonUiObject(modalScope);
        }
    }
    getSessionCallbackNoteUiObject(modalObject, uiState = null) {
        let sessionCallbackNoteUiObject = new Object();
        sessionCallbackNoteUiObject.CreatedDate = new this.dateJS().toString(this.defaultOptions.mdyyyyhhmmss);
        sessionCallbackNoteUiObject.CreatedById = GlobalFunctions.getLoggedInUserId();
        sessionCallbackNoteUiObject.MainEntityId = modalObject.taskDto.MainEntityId;
        sessionCallbackNoteUiObject.MainEntitySource = modalObject.taskDto.MainEntitySource;
        sessionCallbackNoteUiObject.MainEntityType = modalObject.currentRelationType;
        sessionCallbackNoteUiObject.CustomerBSN = modalObject.taskDto.CustomerBSN;
        sessionCallbackNoteUiObject.CustomerKVKNumber = modalObject.taskDto.CustomerKVKNumber;
        sessionCallbackNoteUiObject.CustomerDateOfBirth = modalObject.taskDto.CustomerDateOfBirth;
        sessionCallbackNoteUiObject.ContactPerson = modalObject.taskDto.ContactPerson;
        sessionCallbackNoteUiObject.ContactAddress = modalObject.taskDto.ContactAddress;
        sessionCallbackNoteUiObject.ContactEmail = modalObject.taskDto.ContactEmail;
        sessionCallbackNoteUiObject.selectedDateFromPicker = modalObject.selectedDateFromPicker;
        sessionCallbackNoteUiObject.enableDurationBox = modalObject.enableDurationBox;
        sessionCallbackNoteUiObject.slotLength = modalObject.slotLength;
        sessionCallbackNoteUiObject.enableWorkweek = modalObject.enableWorkweek;
        sessionCallbackNoteUiObject.selectedStartDateTime = modalObject.selectedStartDateTime;
        sessionCallbackNoteUiObject.selectedEndDateTime = modalObject.selectedEndDateTime;
        if (!GlobalFunctions.isEmpty(modalObject.phoneNumber) && !GlobalFunctions.isEmpty(modalObject.mobileNumber))
            modalObject.taskDto.ContactPhoneNumber = modalObject.phoneNumber + "/" + modalObject.mobileNumber;
        else if (!GlobalFunctions.isEmpty(modalObject.phoneNumber))
            modalObject.taskDto.ContactPhoneNumber = modalObject.phoneNumber;
        else
            modalObject.taskDto.ContactPhoneNumber = modalObject.mobileNumber;
        sessionCallbackNoteUiObject.ContactPhoneNumber = modalObject.taskDto.ContactPhoneNumber;
        sessionCallbackNoteUiObject.CustomerQuestion = modalObject.taskDto.CustomerQuestion;
        if (!GlobalFunctions.isEmpty(modalObject.taskDto.CustomerOrOrganizationName))
            sessionCallbackNoteUiObject.CustomerOrOrganizationName = modalObject.taskDto.CustomerOrOrganizationName;
        if (uiState == UIState.Appointment) {
            let selectedRoom;
            if (modalObject.allAvailableMeetingRooms != null) {
                modalObject.allAvailableMeetingRooms.forEach((meetingRoom, i) => {
                    if (modalObject.selectedMeetingRoom == meetingRoom.EmailAddress)
                        selectedRoom = modalObject.allAvailableMeetingRooms[i];
                });
                let selectedRoomList = [];
                selectedRoomList.push(selectedRoom);
                if (!GlobalFunctions.isEmpty(selectedRoom))
                    sessionCallbackNoteUiObject.MeetingRoomList = selectedRoomList;
            }
        }
        if (uiState == UIState.InformationRequestion) {
            sessionCallbackNoteUiObject.PublishTo = modalObject.taskDto.PublishTo;
            sessionCallbackNoteUiObject.currentTemplate = modalObject.currentTemplate;
            sessionCallbackNoteUiObject.AttachmentList = modalObject.fileAttachments;
            sessionCallbackNoteUiObject.RequiredCallbackDate = modalObject.requiredCallbackDate;
        }
        else {
            sessionCallbackNoteUiObject.CallBetweenStartDate = new this.dateJS(modalObject.selectedStartDateTime).toString('M/d/yyyy HH:mm:ss');
            sessionCallbackNoteUiObject.CallBetweenEndDate = new this.dateJS(modalObject.selectedEndDateTime).toString('M/d/yyyy HH:mm:ss');
            sessionCallbackNoteUiObject.RequiredCallbackDate = new this.dateJS(modalObject.selectedStartDateTime).toString('M/d/yyyy HH:mm:ss');
        }
        sessionCallbackNoteUiObject.CreateTaskAction = CreateTaskAction[CreateTaskAction.Direct];
        sessionCallbackNoteUiObject.CurrentStatus = TaskStatus[TaskStatus.Unhandled];
        sessionCallbackNoteUiObject.Priority = modalObject.priorityValue;
        sessionCallbackNoteUiObject.ReferenceNumber = GlobalFunctions.isEmpty(modalObject.taskDto.ReferenceNumber) ? 0 : modalObject.taskDto.ReferenceNumber;
        let currentHandlerList = [];
        if (modalObject.handlerTags != undefined && modalObject.handlerTags != null && modalObject.handlerTags.length > 0) {
            for (let i = 0; i < modalObject.handlerTags.length; i++) {
                if (!GlobalFunctions.isEmpty(modalObject.handlerTags[i])) {
                    let currentHandler = new TaskHandlerDto();
                    currentHandler.HandlerId = modalObject.handlerTags[i].Id;
                    let baseDtoObject = new BaseDto();
                    baseDtoObject.Id = modalObject.handlerTags[i].HandlerId;
                    currentHandler.HandlerObject = baseDtoObject;
                    currentHandler.HandlerType = modalObject.currentHandlerType;
                    currentHandlerList.push(currentHandler);
                }
            }
        }
        sessionCallbackNoteUiObject.CurrentHandlerList = currentHandlerList;
        sessionCallbackNoteUiObject.CurrentHandlerType = modalObject.currentHandlerType;
        let searchEntitySelected = [];
        if (modalObject.searchEntityTags != null && modalObject.searchEntityTags.length > 0) {
            for (let i = 0; i < modalObject.searchEntityTags.length; i++) {
                if (!GlobalFunctions.isEmpty(modalObject.searchEntityTags[i])) {
                    searchEntitySelected.push(modalObject.searchEntityTags[i]);
                }
            }
        }
        sessionCallbackNoteUiObject.SearchEntityTags = searchEntitySelected;
        return sessionCallbackNoteUiObject;
    }
    getSessionNoteUiObject(modalObject) {
        let SessionNoteUiObject = new Object();
        SessionNoteUiObject.NoteEntityDto = modalObject.noteEntityDto;
        SessionNoteUiObject.EnableAssignee = modalObject.enableAssignee;
        SessionNoteUiObject.EnableDuedate = modalObject.enableDuedate;
        SessionNoteUiObject.DueDate = modalObject.dueDate;
        SessionNoteUiObject.EnableAnnouncement = modalObject.enableAnnouncement;
        SessionNoteUiObject.PublishTo = modalObject.publishTo;
        SessionNoteUiObject.PublishToHandlerTags = modalObject.publishToHandlerTags;
        SessionNoteUiObject.HandlerTags = modalObject.handlerTags;
        return SessionNoteUiObject;
    }
    getSessionReportImprovementUiObject(modalObject) {
        let SessionReportUiObject = new Object();
        SessionReportUiObject.CustomerQuestion = modalObject.taskDto.CustomerQuestion;
        SessionReportUiObject.SelectedEmployees = modalObject.selectedEmployees;
        SessionReportUiObject.EmployeeNames = modalObject.employeeNames;
        return SessionReportUiObject;
    }
    getSessionThemeUiObject(modalObject) {
        let SessionThemeUiObject = new Object();
        SessionThemeUiObject.Description = modalObject.themeDto.Description;
        SessionThemeUiObject.Title = modalObject.themeDto.Title;
        SessionThemeUiObject.IsPublished = modalObject.themeDto.IsPublished;
        SessionThemeUiObject.Keywords = modalObject.themeDto.Keywords;
        SessionThemeUiObject.SectionObjectList = modalObject.sectionsObjectList;
        SessionThemeUiObject.ThemeSources = modalObject.themeSources;
        return SessionThemeUiObject;
    }
    getSessionFileUiObject(modalObject) {
        let SessionFileUiObject = new Object();
        SessionFileUiObject.Title = modalObject.fileDto.Title;
        SessionFileUiObject.IsAttachmentExist = modalObject.fileDto.IsAttachmentExist;
        SessionFileUiObject.Path = modalObject.fileDto.Path;
        SessionFileUiObject.Description = modalObject.fileDto.Description;
        SessionFileUiObject.Files = [];
        if (!GlobalFunctions.isEmpty(modalObject.fileLinksTags) && modalObject.fileLinksTags.length > 0) {
            SessionFileUiObject.Name = modalObject.fileLinksTags[0].text;
            let file = new Object();
            file.text = SessionFileUiObject.Name;
            file.NameOnServer = "";
            SessionFileUiObject.Files.push(file);
        }
        else {
            SessionFileUiObject.Files = modalObject.files;
            SessionFileUiObject.Name = modalObject.fileDto.Name;
        }
        return SessionFileUiObject;
    }
    getSessionOrganizationUiObject(modalObject) {
        let SessionOrganizationUiObject = new Object();
        SessionOrganizationUiObject.Name = modalObject.organizationDto.Name;
        SessionOrganizationUiObject.EmailAddress = modalObject.organizationDto.EmailAddress;
        SessionOrganizationUiObject.PhoneNumber = modalObject.organizationDto.PhoneNumber;
        SessionOrganizationUiObject.KVKNumber = modalObject.organizationDto.AdministeredOrganizationDto.Identification;
        SessionOrganizationUiObject.FaxNumber = modalObject.organizationDto.FaxNumber;
        SessionOrganizationUiObject.Website = modalObject.organizationDto.Website;
        SessionOrganizationUiObject.ZipCode = modalObject.organizationDto?.RegistrationAddress?.Address?.ZipCode;
        SessionOrganizationUiObject.City = modalObject.organizationDto?.RegistrationAddress?.Address?.City;
        SessionOrganizationUiObject.Country = modalObject.organizationDto?.RegistrationAddress?.Address?.Country;
        SessionOrganizationUiObject.StreetName = modalObject.organizationDto?.RegistrationAddress.Address?.StreetName;
        SessionOrganizationUiObject.State = modalObject.organizationDto?.RegistrationAddress?.Address?.State;
        SessionOrganizationUiObject.POBoxNumber = modalObject.organizationDto?.RegistrationAddress?.Address?.POBoxNumber;
        SessionOrganizationUiObject.FacebookId = modalObject.organizationDto.FacebookId;
        SessionOrganizationUiObject.TwitterId = modalObject.organizationDto.TwitterId;
        SessionOrganizationUiObject.WhatsAppNumber = modalObject.organizationDto.WhatsAppNumber;
        SessionOrganizationUiObject.ContactPersonSurname = modalObject.personDto?.Details?.FormalName?.Surname;
        SessionOrganizationUiObject.ContactPersonFirstName = modalObject.personDto?.Details?.FormalName?.FirstNames[0];
        SessionOrganizationUiObject.ContactPersonPrefix = modalObject.personDto?.Details?.FormalName?.Prefix;
        SessionOrganizationUiObject.ContactPersonGender = modalObject.personDto?.Details?.FormalName?.Gender;
        SessionOrganizationUiObject.ContactPersonPhoneNumber = modalObject.personDto.PhoneNumber;
        SessionOrganizationUiObject.ContactPersonMobileNumber = modalObject.personDto.MobileNumber;
        SessionOrganizationUiObject.ContactPersonEmailAddress = modalObject.personDto.EmailAddress;
        SessionOrganizationUiObject.ContactPersonWhatsAppNumber = modalObject.personDto.WhatsAppNumber;
        SessionOrganizationUiObject.ContactPersonTwitterId = modalObject.personDto.TwitterId;
        SessionOrganizationUiObject.ContactPersonFacebookId = modalObject.personDto.FacebookId;
        SessionOrganizationUiObject.ContactPersonInitials = modalObject.personDto.Details.AddressName.Initials;
        SessionOrganizationUiObject.ContactPersonFunction = modalObject.personDto.Function;
        return SessionOrganizationUiObject;
    }
    getSessionPersonUiObject(modalObject) {
        let SessionPersonUiObject = new Object();
        SessionPersonUiObject.ServiceNumber = modalObject.personDto.AdministeredPersonDto.ServiceNumber;
        SessionPersonUiObject.Initials = modalObject.personDto.Details.AddressName.Initials;
        SessionPersonUiObject.Surname = modalObject.personDto?.Details?.FormalName?.Surname;
        SessionPersonUiObject.FirstName = modalObject.personDto?.Details?.FormalName?.FirstNames[0];
        SessionPersonUiObject.Prefix = modalObject.personDto?.Details?.FormalName?.Prefix;
        SessionPersonUiObject.Gender = modalObject.personDto?.Details?.FormalName?.Gender;
        SessionPersonUiObject.Nationality = modalObject.personDto.Nationality.CountryId;
        SessionPersonUiObject.StreetName = modalObject.personDto?.ResidentialAddress?.Address?.StreetName;
        SessionPersonUiObject.ZipCode = modalObject.personDto?.ResidentialAddress?.Address?.ZipCode;
        SessionPersonUiObject.City = modalObject.personDto?.ResidentialAddress?.Address?.City;
        SessionPersonUiObject.HouseNumber = modalObject.personDto?.ResidentialAddress?.Address?.HouseNumber;
        SessionPersonUiObject.Country = modalObject.personDto?.ResidentialAddress?.Address?.Country.Name;
        SessionPersonUiObject.PhoneNumber = modalObject.personDto.PhoneNumber;
        SessionPersonUiObject.MobileNumber = modalObject.personDto.MobileNumber;
        SessionPersonUiObject.EmailAddress = modalObject.personDto.EmailAddress;
        SessionPersonUiObject.DateOfBirth = modalObject.personDto.Details.DateOfBirth;
        SessionPersonUiObject.State = modalObject.personDto?.ResidentialAddress?.Address?.State;
        SessionPersonUiObject.WhatsAppNumber = modalObject.personDto.WhatsAppNumber;
        SessionPersonUiObject.TwitterId = modalObject.personDto.TwitterId;
        SessionPersonUiObject.FacebookId = modalObject.personDto.FacebookId;
        SessionPersonUiObject.HouseNumberAddition = modalObject.personDto?.ResidentialAddress?.Address?.HouseNumberAddition;
        return SessionPersonUiObject;
    }
    getSessionEmailUiObject(modalObject) {
        let SessionEmailUiObject = new Object();
        SessionEmailUiObject.To = "";
        SessionEmailUiObject.Cc = "";
        if (modalObject.toEmailList != null && modalObject.toEmailList != undefined && modalObject.toEmailList.length > 0) {
            let emailToText = "";
            for (let index = 0; index < modalObject.toEmailList.length; index++) {
                if (!GlobalFunctions.isEmpty(emailToText))
                    emailToText += ";" + modalObject.toEmailList[index].text;
                else
                    emailToText = modalObject.toEmailList[index].text;
            }
            SessionEmailUiObject.To = emailToText;
        }
        if (modalObject.ccEmailList != null && modalObject.ccEmailList != undefined && modalObject.ccEmailList.length > 0) {
            let emailCcText = "";
            for (let index = 0; index < modalObject.ccEmailList.length; index++) {
                if (!GlobalFunctions.isEmpty(emailCcText))
                    emailCcText += ";" + modalObject.ccEmailList[index].text;
                else
                    emailCcText = modalObject.ccEmailList[index].text;
            }
            SessionEmailUiObject.Cc = emailCcText;
        }
        if (modalObject.bccEmailList != null && modalObject.bccEmailList != undefined && modalObject.bccEmailList.length > 0) {
            let emailBccText = "";
            for (let index = 0; index < modalObject.bccEmailList.length; index++) {
                if (!GlobalFunctions.isEmpty(emailBccText))
                    emailBccText += ";" + modalObject.bccEmailList[index].text;
                else
                    emailBccText = modalObject.bccEmailList[index].text;
            }
            SessionEmailUiObject.Bcc = emailBccText;
        }
        if (!GlobalFunctions.isEmpty(modalObject.emailDto)) {
            SessionEmailUiObject.Body = GlobalFunctions.isEmpty(modalObject.emailDto.Body) ? "" : modalObject.emailDto.Body.Body;
            SessionEmailUiObject.IsBodyHtml = true;
            SessionEmailUiObject.Subject = modalObject.emailDto.Header.Subject;
            SessionEmailUiObject.EmailType = modalObject.emailDto.EmailType;
        }
        SessionEmailUiObject.DefaultMailbox = modalObject.defaultUserMailbox.MailboxId;
        SessionEmailUiObject.Attachments = modalObject.fileAttachments;
        SessionEmailUiObject.SelectedEmailTemplates = modalObject.selectedEmailTemplates;
        SessionEmailUiObject.SelectedEmailTemplateType = modalObject.selectedEmailTemplateType;
        return SessionEmailUiObject;
    }
    setBreadcrumbGrammer(obj) {
        try {
            if (GlobalFunctions.isEmpty(obj.StringRepresentation)) {
                let getTypeValue = GlobalFunctions.getObjectTypeName(obj.RelatedEntityFqdn);
                if (!GlobalFunctions.isEmpty(getTypeValue)) {
                    let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting(getTypeValue + "Dto_Breadcrumb");
                    GlobalFunctions.setStringPresentation(obj, getGrammerValue, this.datePipe, this.defaultOptions.defaultDateFormat);
                    if (getTypeValue === "ContactMoment") {
                        const splitDate = obj.StringRepresentation.split(',');
                        if (splitDate.length > 1 && splitDate[1]) {
                            const formattedDate = GlobalFunctions.convertStringDate(splitDate[1], `${this.defaultOptions.date} ${this.defaultOptions.month} ${this.defaultOptions.year} ${this.defaultOptions.timeFormat}`, this.datePipe);
                            if (formattedDate) {
                                obj.contactDate = formattedDate;
                                splitDate[1] = ' ' + obj.contactDate;
                                obj.StringRepresentation = splitDate.join(',');
                            }
                        }
                    }
                }
            }
        }
        catch (error) {
            console.error("Error in setBreadcrumbGrammer:", error);
        }
    }
    createCurrentSession(sessionStatus, description, forwardedToUserId, uiObject, uiState, sessionStartDateTime) {
        let session = null;
        let sessionData = new SessionContainerDto();
        if (this.selectedEntity != null) {
            sessionData.DetailObject = new SessionItemDto();
            sessionData.DetailObject.Id = this.selectedEntity.Id;
            sessionData.DetailObject.Type = GlobalFunctions.getObjectTypeName(this.selectedEntity.RelatedEntityFqdn);
            sessionData.DetailObject.Source = this.selectedEntity.ObjectSource;
            sessionData.DetailObject.StringRepresentation = this.selectedEntity.StringRepresentation;
            if (sessionData.DetailObject.Type) {
                switch (sessionData.DetailObject.Type.toLowerCase()) {
                    case "location":
                        {
                            sessionData.DetailObject.GeoSeachCriteria = this.selectedEntity.GeoSeachCriteria;
                            sessionData.DetailObject.GeoCoordinatesCriteria = this.selectedEntity.GeoCoordinatesCriteria;
                            break;
                        }
                    case "facebook":
                    case "twitter":
                    case "whatsapp":
                        {
                            sessionData.DetailObject.User = this.selectedEntity.User;
                            sessionData.DetailObject.Message = this.selectedEntity.Message;
                            break;
                        }
                    case "email":
                        {
                            sessionData.DetailObject.Mailbox = this.selectedEntity.Mailbox;
                            sessionData.DetailObject.Header = this.selectedEntity.Header;
                            sessionData.DetailObject.Body = this.selectedEntity.Body;
                            break;
                        }
                }
            }
        }
        ;
        if (this.detailViewCachedEntityList != null && this.detailViewCachedEntityList.length > 0) {
            sessionData.SessionObjects = new Array();
            for (let i = 0; i < this.detailViewCachedEntityList.length; i++) {
                if (this.detailViewCachedEntityList[i] != null && this.detailViewCachedEntityList[i]?.value != null) {
                    let sessionItem = this.detailViewCachedEntityList[i].key;
                    let sessionObject = new SessionItemDto();
                    sessionObject.Id = sessionItem.Id;
                    sessionObject.Type = (!GlobalFunctions.isEmpty(this.detailViewCachedEntityList[i].value) && this.detailViewCachedEntityList[i].value === "Decos.Kcs.SocialMedia.Entities.SocialMedia")
                        ? GlobalFunctions.getObjectTypeName("Decos_Kcs_SocialMedia_Entities_SocialMedia")
                        : GlobalFunctions.getObjectTypeName(sessionItem.RelatedEntityFqdn);
                    sessionObject.Source = sessionItem.ObjectSource;
                    sessionObject.StringRepresentation = sessionItem.StringRepresentation;
                    sessionObject.Sequence = i + 1;
                    if (sessionObject.Type && sessionObject.Type.toLowerCase() == "location") {
                        sessionObject.GeoSeachCriteria = sessionItem.GeoSeachCriteria;
                        sessionObject.GeoCoordinatesCriteria = sessionItem.GeoCoordinatesCriteria;
                    }
                    else if (sessionObject.Type && sessionObject.Type.toLowerCase() == "email") {
                        sessionObject.Mailbox = sessionItem.Mailbox;
                        sessionObject.Header = sessionItem.Header;
                        sessionObject.Body = sessionItem.Body;
                    }
                    sessionData.SessionObjects.push(sessionObject);
                }
            }
        }
        ;
        if (this.basketItems != null && this.basketItems.basketItems != null && this.basketItems.basketItems.length > 0) {
            sessionData.OutboxObjects = new Array();
            for (let i = 0; i < this.basketItems.basketItems.length; i++) {
                if (this.basketItems.basketItems[i] != null) {
                    let basketItem = this.basketItems.basketItems[i];
                    let outboxObject = new SessionItemDto();
                    outboxObject.Id = basketItem.Item.Id;
                    outboxObject.Type = GlobalFunctions.getObjectTypeName(basketItem.Type);
                    outboxObject.Source = basketItem.Item.ObjectSource;
                    outboxObject.StringRepresentation = basketItem.Item.StringRepresentation;
                    outboxObject.Sequence = i + 1;
                    sessionData.OutboxObjects.push(outboxObject);
                }
            }
        }
        ;
        sessionData.UIObject = new SessionUIDto();
        sessionData.UIObject.UIObject = uiObject;
        sessionData.UIObject.UIState = uiState;
        sessionData.UIObject.TagIdForSuggestionPanel = this.contactSessionNotesState.TagIdForSuggestionPanel;
        sessionData.ContactSessionNotesObject = new Object();
        sessionData.ContactSessionNotesObject.CallId = this.contactSessionNotesState.ContactHistoryDto.CallId;
        sessionData.ContactSessionNotesObject.CaseNumber = this.contactSessionNotesState.ContactHistoryDto.CaseNumber;
        sessionData.ContactSessionNotesObject.ContactEmail = this.contactSessionNotesState.ContactHistoryDto.ContactEmail;
        sessionData.ContactSessionNotesObject.ContactPerson = this.contactSessionNotesState.ContactHistoryDto.ContactPerson;
        sessionData.ContactSessionNotesObject.ContactPhoneNumber = this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber;
        sessionData.ContactSessionNotesObject.ContactType = this.contactSessionNotesState.ContactHistoryDto.ContactType;
        sessionData.ContactSessionNotesObject.CustomerRole = this.contactSessionNotesState.ContactHistoryDto.CustomerRole;
        sessionData.ContactSessionNotesObject.CustomerRoleFreeText = this.contactSessionNotesState.ContactHistoryDto.CustomerRoleFreeText;
        sessionData.ContactSessionNotesObject.Memo = this.contactSessionNotesState.ContactHistoryDto.Memo;
        sessionData.ContactSessionNotesObject.MemoFreeText = this.contactSessionNotesState.ContactHistoryDto.MemoFreeText;
        sessionData.ContactSessionNotesObject.Notes = this.contactSessionNotesState.ContactHistoryDto.Notes;
        sessionData.ContactSessionNotesObject.StartDate = !GlobalFunctions.isEmpty(this.contactSessionNotesState.ContactHistoryDto.StartDate) ? this.contactSessionNotesState.ContactHistoryDto.StartDate : new this.dateJS(sessionStartDateTime).toString('M/d/yyyy HH:mm:ss');
        sessionData.ContactSessionNotesObject.Subject = this.contactSessionNotesState.ContactHistoryDto.Subject;
        sessionData.ContactSessionNotesObject.SubjectFreeText = this.contactSessionNotesState.ContactHistoryDto.SubjectFreeText;
        sessionData.ContactSessionNotesObject.ForwardedToHandlers = this.contactSessionNotesState.ContactHistoryDto.ForwardedTo;
        sessionData.ContactSessionNotesObject.HandledOnBehalfHandlers = this.contactSessionNotesState.ContactHistoryDto.HandledOnBehalf;
        sessionData.ContactSessionNotesObject.ForwardedToType = this.contactSessionNotesState.ContactHistoryDto.ForwardedToType;
        sessionData.ContactSessionNotesObject.HandledOnBehalfType = this.contactSessionNotesState.ContactHistoryDto.HandledOnBehalfType;
        sessionData.ContactSessionNotesObject.Tags = this.getTags();
        if (this.currentSession == null)
            session = new SessionEntityDto();
        else
            session = this.currentSession;
        session.SessionStartDateTime = new this.dateJS(sessionStartDateTime).toString('M/d/yyyy HH:mm:ss');
        session.SessionEndDateTime = new this.dateJS(new Date()).toString('M/d/yyyy HH:mm:ss');
        if (sessionStatus == SessionStatus.Forwarded)
            session.CurrentUserId = forwardedToUserId;
        else
            session.CurrentUserId = GlobalFunctions.getLoggedInUserId();
        session.CurrentStatus = sessionStatus;
        session.Description = description;
        session.LockedByUser = false;
        session.ContactType = this.contactSessionNotesState.ContactHistoryDto.ContactType;
        session.ContactTypeSource = this.contactSessionNotesState.ContactHistoryDto.ContactTypeSource;
        let personObject = GlobalFunctions.getLastPersonFromSession(this.detailViewCachedEntityList);
        if (personObject != null)
            session.CustomerName = personObject.StringRepresentation;
        else
            session.CustomerName = this.contactSessionNotesState.ContactHistoryDto.ContactPerson;
        let sessionHistoryDto = new SessionHistoryDto();
        sessionHistoryDto.CreatedBy = GlobalFunctions.getLoggedInUserId();
        sessionHistoryDto.ForwardedTo = forwardedToUserId;
        sessionHistoryDto.CreatedDate = new Date();
        sessionHistoryDto.CurrentStatus = sessionStatus;
        session.SessionHistoryList = new Array();
        session.SessionHistoryList.push(sessionHistoryDto);
        if (session.SessionObject == null)
            session.SessionObject = new SessionObjectDto();
        session.SessionObject.SessionId = session.Id;
        session.SessionObject.SessionData = JSON.stringify(sessionData);
        return session;
    }
    ;
    getTags() {
        let tags = "";
        if (this.contactSessionNotesState.Tags != null && this.contactSessionNotesState.Tags.length > 0) {
            this.contactSessionNotesState.Tags.forEach((tag) => {
                if (!GlobalFunctions.isEmpty(tag.Id)) {
                    if (tags.length == 0)
                        tags = tag.Id;
                    else
                        tags = tags + ";" + tag.Id;
                }
            });
        }
        return tags;
    }
    removeFromDetailViewCachedEntityList(objectId) {
        if (!GlobalFunctions.isEmpty(objectId) && this.detailViewCachedEntityList && this.detailViewCachedEntityList.length > 0) {
            let index = -1;
            let list = this.detailViewCachedEntityList;
            for (let i = 0; i < list.length; i++) {
                if (list[i] != null && list[i].key != null && !GlobalFunctions.isEmpty(list[i].key.Id) && list[i].key.Id == objectId) {
                    index = i;
                    break;
                }
            }
            if (index > -1) {
                this.detailViewCachedEntityList.splice(index, 1);
                this.updateContactSessionNotes();
            }
        }
    }
    updateContactSessionNotes(isEmailReplied = false) {
        if (!isEmailReplied) {
            if (!GlobalFunctions.isEmpty(this.currentCallerId) && this.currentCallerId.length >= 10) {
                this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = this.currentCallerId;
                this.contactSessionNotesState.ContactHistoryDto.CallId = this.currentCallId;
            }
            this.contactSessionNotesState.RelatedEntityList = [];
            for (let i = 0; i < this.detailViewCachedEntityList.length; i++) {
                if (this.detailViewCachedEntityList[i] != null) {
                    let entityFullName;
                    if (!GlobalFunctions.isEmpty(this.detailViewCachedEntityList[i].value))
                        entityFullName = (this.detailViewCachedEntityList[i].value === "Facebook" || this.detailViewCachedEntityList[i].value === "SocialMedia" || this.detailViewCachedEntityList[i].value === "WhatsApp" || this.detailViewCachedEntityList[i].value === "Twitter")
                            ? GlobalFunctions.toContentType(this.detailViewCachedEntityList[i].value)
                            : this.detailViewCachedEntityList[i].value;
                    let entityLastName = entityFullName?.split('.');
                    if (entityLastName != null && entityLastName.length > 0) {
                        let entityType = entityLastName[entityLastName.length - 1];
                        if (entityType.toLowerCase() != "location" && entityType.toLowerCase() != "addressableobjectmark") {
                            let entityContent = new Object();
                            entityContent.entityFullName = entityFullName;
                            entityContent.entityName = entityLastName[entityLastName.length - 1];
                            entityContent.content = this.detailViewCachedEntityList[i].key;
                            if (!GlobalFunctions.isEmpty(entityContent.content))
                                entityContent.content.IsMarked = true;
                            this.contactSessionNotesState.RelatedEntityList.push(entityContent);
                        }
                    }
                    if (this.detailViewCachedEntityList[i] != null && this.detailViewCachedEntityList[i].key != null && this.detailViewCachedEntityList[i].key != undefined) {
                        if (GlobalFunctions.isEmpty(this.contactSessionNotesState.ContactHistoryDto.ContactEmail) && this.detailViewCachedEntityList[i]?.value?.toUpperCase() === GlobalFunctions.toContentType("EMAIL").toUpperCase() && this.detailViewCachedEntityList[i].key.Header != null)
                            this.contactSessionNotesState.ContactHistoryDto.ContactEmail = this.detailViewCachedEntityList[i].key.Header.From;
                        if (this.detailViewCachedEntityList[i].key.IsMarked) {
                            if (this.detailViewCachedEntityList[i]?.value?.toUpperCase() === GlobalFunctions.toContentType("PERSON").toUpperCase()) {
                                let personDto = this.detailViewCachedEntityList[i].key;
                                if (GlobalFunctions.isEmpty(this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber)) {
                                    if (!GlobalFunctions.isEmpty(personDto.PhoneNumber) && !GlobalFunctions.isEmpty(personDto.MobileNumber) && !GlobalFunctions.isPrivateField('PHONENUMBER', ContentType.Person) && !GlobalFunctions.isPrivateField('MOBILENUMBER', ContentType.Person))
                                        this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = personDto.PhoneNumber + "/" + personDto.MobileNumber;
                                    else if (!GlobalFunctions.isEmpty(personDto.PhoneNumber) && !GlobalFunctions.isPrivateField('PHONENUMBER', ContentType.Person))
                                        this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = personDto.PhoneNumber;
                                    else if (!GlobalFunctions.isPrivateField('MOBILENUMBER', ContentType.Person))
                                        this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = personDto.MobileNumber;
                                }
                                if (GlobalFunctions.isEmpty(this.contactSessionNotesState.ContactHistoryDto.ContactPerson))
                                    this.contactSessionNotesState.ContactHistoryDto.ContactPerson = personDto.StringRepresentation;
                                if (GlobalFunctions.isEmpty(this.contactSessionNotesState.ContactHistoryDto.ContactEmail) && !GlobalFunctions.isEmpty(personDto.EmailAddress))
                                    this.contactSessionNotesState.ContactHistoryDto.ContactEmail = personDto.EmailAddress;
                            }
                            else if (this.detailViewCachedEntityList[i]?.value?.toUpperCase() === GlobalFunctions.toContentType("TICKET").toUpperCase()) {
                                let ticketDto = this.detailViewCachedEntityList[i].key;
                                this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = ticketDto.ContactPhoneNumber;
                                this.contactSessionNotesState.ContactHistoryDto.ContactPerson = ticketDto.CustomerName;
                            }
                            else if (this.detailViewCachedEntityList[i]?.value?.toUpperCase() === GlobalFunctions.toContentType("CALLBACKNOTE").toUpperCase() || this.detailViewCachedEntityList[i]?.value?.toUpperCase() === GlobalFunctions.toContentType("APPOINTMENT").toUpperCase() || this.detailViewCachedEntityList[i]?.value?.toUpperCase() === GlobalFunctions.toContentType("INFORMATIONREQUEST").toUpperCase()) {
                                let callbackNoteDto = this.detailViewCachedEntityList[i].key;
                                if (GlobalFunctions.isEmpty(this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber))
                                    this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = callbackNoteDto.ContactPhoneNumber;
                                if (GlobalFunctions.isEmpty(this.contactSessionNotesState.ContactHistoryDto.ContactPerson))
                                    this.contactSessionNotesState.ContactHistoryDto.ContactPerson = callbackNoteDto.CustomerOrOrganizationName;
                                if (this.applicationSettingManager.isCustomerOM()) {
                                    this.contactSessionNotesState.ContactHistoryDto.ContactPerson = callbackNoteDto.CustomerOrOrganizationName;
                                    this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = callbackNoteDto.ContactPhoneNumber;
                                    this.contactSessionNotesState.ContactHistoryDto.CaseNumber = callbackNoteDto.CaseNumber;
                                }
                            }
                            else if (this.detailViewCachedEntityList[i]?.value?.toUpperCase() === GlobalFunctions.toContentType("ORGANIZATION").toUpperCase()) {
                                {
                                    let organizationDto = this.detailViewCachedEntityList[i].key;
                                    if (GlobalFunctions.isEmpty(this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber) && !GlobalFunctions.isPrivateField("PHONENUMBER", ContentType.Organization))
                                        this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = organizationDto.PhoneNumber;
                                    if (GlobalFunctions.isEmpty(this.contactSessionNotesState.ContactHistoryDto.ContactPerson))
                                        this.contactSessionNotesState.ContactHistoryDto.ContactPerson = organizationDto.StringRepresentation;
                                    if (GlobalFunctions.isEmpty(this.contactSessionNotesState.ContactHistoryDto.ContactEmail) && !GlobalFunctions.isEmpty(organizationDto.EmailAddress))
                                        this.contactSessionNotesState.ContactHistoryDto.ContactEmail = organizationDto.EmailAddress;
                                }
                            }
                            else if (this.detailViewCachedEntityList[i]?.value?.toUpperCase().indexOf("EMAIL") != -1) {
                                if (this.minutes == 0 && this.seconds < 2)
                                    this.contactSessionNotesState.ContactHistoryDto.ContactType = "Email";
                            }
                            else if (this.detailViewCachedEntityList[i]?.value?.toUpperCase().indexOf("DOCUMENT") != -1 && this.detailViewCachedEntityList[i].key.IsLetter) {
                                if (this.minutes == 0 && this.seconds < 2)
                                    this.contactSessionNotesState.ContactHistoryDto.ContactType = "Letter";
                            }
                        }
                    }
                }
            }
        }
        else if (this.sentEmailType == EmailType.Reply && !GlobalFunctions.isEmpty(this.sentEmailDetail))
            this.contactSessionNotesState.ContactHistoryDto.MemoFreeText = this.htmlToPlainTextPipe.transform(this.sentEmailDetail).replace("p{margin:0;padding:0}", "");
    }
    clearHeaderTextValue() {
        GlobalFunctions.clearValue();
        this.searchService.searchQuery = "";
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.CLEAR_POPULAR_LIST);
    }
    ;
    loadSession(item, dialogManager, viewContainerRef, setTimer = true) {
        let sessionData = null;
        const session = item.ObjectSourceDto;
        if (!GlobalFunctions.isEmpty(session.SessionObject) && !GlobalFunctions.isEmpty(session.SessionObject.SessionData))
            sessionData = JSON.parse(session.SessionObject.SessionData);
        if (setTimer)
            this.setSessionTimer(session, sessionData);
        this.currentSession = item.ObjectSourceDto;
        if (sessionData) {
            if (sessionData.DetailObject) {
                const detailObject = sessionData.DetailObject;
                this.selectedEntity = detailObject;
                this.selectedEntity.Partial = true;
                this.selectedEntity.ObjectSource = detailObject.Source;
                this.selectedEntity.RelatedEntityFqdn = GlobalFunctions.toEntityFqdnString(detailObject.Type);
                this.currentSession.LoadingDetail = true;
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
                setTimeout(() => this.router.navigate([RoutePath.DETAIL_PATH, detailObject.Type.toLowerCase(), detailObject.Id]));
            }
            if (sessionData.SessionObjects?.length > 0) {
                for (let i = 0; i < sessionData.SessionObjects.length; i++) {
                    this.addItemsToDetailViewCacheList(sessionData.SessionObjects[i], sessionData.SessionObjects[i].Type);
                    const breadCrumbItem = sessionData.SessionObjects[i];
                    breadCrumbItem.Partial = true;
                    breadCrumbItem.RelatedEntityFqdn = breadCrumbItem.Type;
                    breadCrumbItem.ObjectSource = breadCrumbItem.Source;
                    breadCrumbItem.locationUrl = `${RoutePath.DETAIL_PATH}/${breadCrumbItem.Type.toLowerCase()}`;
                    this.addBreadcrumbItems([breadCrumbItem], null, RoutePath.DETAIL_PATH);
                }
            }
            if (sessionData.OutboxObjects?.length > 0) {
                for (let index = 0; index < sessionData.OutboxObjects.length; index++)
                    this.addBasketItemFromSession(sessionData.OutboxObjects[index]);
            }
            if (!GlobalFunctions.isEmpty(sessionData.ContactSessionNotesObject)) {
                this.contactSessionNotesState.ContactHistoryDto.CaseNumber = sessionData.ContactSessionNotesObject.CaseNumber;
                this.contactSessionNotesState.ContactHistoryDto.ContactEmail = sessionData.ContactSessionNotesObject.ContactEmail;
                this.contactSessionNotesState.ContactHistoryDto.ContactPerson = sessionData.ContactSessionNotesObject.ContactPerson;
                this.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = sessionData.ContactSessionNotesObject.ContactPhoneNumber;
                // Timeout needed to prevent weird issue of value not updating
                setTimeout(() => this.contactSessionNotesState.ContactHistoryDto.ContactType = sessionData.ContactSessionNotesObject.ContactType);
                this.contactSessionNotesState.ContactHistoryDto.CustomerRole = sessionData.ContactSessionNotesObject.CustomerRole;
                this.contactSessionNotesState.ContactHistoryDto.CustomerRoleFreeText = sessionData.ContactSessionNotesObject.CustomerRoleFreeText;
                this.contactSessionNotesState.ContactHistoryDto.Memo = sessionData.ContactSessionNotesObject.Memo;
                this.contactSessionNotesState.ContactHistoryDto.MemoFreeText = sessionData.ContactSessionNotesObject.MemoFreeText;
                this.contactSessionNotesState.ContactHistoryDto.Notes = sessionData.ContactSessionNotesObject.Notes;
                this.contactSessionNotesState.ContactHistoryDto.StartDate = sessionData.ContactSessionNotesObject.StartDate;
                this.contactSessionNotesState.ContactHistoryDto.Subject = sessionData.ContactSessionNotesObject.Subject;
                this.contactSessionNotesState.ContactHistoryDto.SubjectFreeText = sessionData.ContactSessionNotesObject.SubjectFreeText;
                this.contactSessionNotesState.ContactHistoryDto.ForwardedTo = sessionData.ContactSessionNotesObject.ForwardedToHandlers;
                this.contactSessionNotesState.ContactHistoryDto.HandledOnBehalf = sessionData.ContactSessionNotesObject.HandledOnBehalfHandlers;
                this.contactSessionNotesState.ContactHistoryDto.ForwardedToType = sessionData.ContactSessionNotesObject.ForwardedToType;
                this.contactSessionNotesState.ContactHistoryDto.HandledOnBehalfType = sessionData.ContactSessionNotesObject.HandledOnBehalfType;
                if (!GlobalFunctions.isEmpty(sessionData.ContactSessionNotesObject.Tags))
                    this.contactSessionNotesState.Tags = this.applicationSettingManager.tagSetting.searchTagById(sessionData.ContactSessionNotesObject.Tags.split(';'));
                if (!GlobalFunctions.isEmpty(sessionData.UIObject.TagIdForSuggestionPanel))
                    this.eventProvider.BroadcastEvent(BroadCastEventKeys.TAG_SELECTED, { Id: sessionData.UIObject.TagIdForSuggestionPanel });
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.SET_CONTACT_SESSION_QUESTION_ANSWERS, true);
            }
            if (sessionData.DetailObject == null && sessionData.SessionObjects.length === 0 && sessionData.OutboxObjects.length === 0)
                this.router.navigate([RoutePath.DASHBOARD], { replaceUrl: true });
        }
        dialogManager.openUISession(this.currentSession, viewContainerRef);
    }
    ;
    getItemsFromDetailViewCacheList(sourceId) {
        let foundObject = null;
        let list = this.detailViewCachedEntityList;
        for (let i = 0; i < list.length; i++) {
            if (list[i] != null && list[i].key != null && sourceId != null && sourceId != '') {
                let targetId = GlobalFunctions.getValueByPropertyName("Id", list[i].key);
                if (sourceId == targetId) {
                    foundObject = list[i].key;
                    break;
                }
            }
        }
        return foundObject;
    }
    ;
    addItemsToDetailViewCacheList(itemToCache, contentType, addWithoutCheckingStartSession = false) {
        if (this.employeeStatus.statusIndex != AvailablityStatusCode.DoNotStartSession) {
            if (this.detailViewCachedEntityList == null)
                this.detailViewCachedEntityList = [];
            if (!addWithoutCheckingStartSession)
                addWithoutCheckingStartSession = this.applicationSettingManager.isAllowedToAddWithoutSessionStart();
            let isValidToAdd = addWithoutCheckingStartSession || (this.isSessionStart || this.applicationSettingManager.isContentTypeEligibleForStartingSession(GlobalFunctions.toContentType(contentType), ScreenMode.Detail));
            if (GlobalFunctions.toContentType(contentType) == ContentType.Facebook)
                isValidToAdd = isValidToAdd && !itemToCache.IsPublishedMessage;
            if (isValidToAdd) {
                if (!GlobalFunctions.containsObject(itemToCache, this.detailViewCachedEntityList))
                    this.detailViewCachedEntityList.push({ key: itemToCache, value: contentType });
                else {
                    let index = -1;
                    this.detailViewCachedEntityList.forEach((el, i) => {
                        if (el != null && el.key != null && itemToCache != null) {
                            let sourceId = GlobalFunctions.getValueByPropertyName("Id", itemToCache);
                            let targetId = GlobalFunctions.getValueByPropertyName("Id", el.key);
                            if (sourceId == targetId)
                                index = i;
                        }
                    });
                    if (index != -1)
                        this.detailViewCachedEntityList.splice(index, 1);
                    this.detailViewCachedEntityList.push({ key: itemToCache, value: contentType });
                }
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.ADDED_ENTITY_TO_CURRENT_SESSION);
            }
            this.updateContactSessionNotes();
        }
        if (itemToCache != null) {
            let newTags = [];
            this.contactSessionNotesState.Tags = this.applicationSettingManager.tagSetting.getPossibleTags(this.contactSessionNotesState.Tags, itemToCache, newTags);
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.TAGS_SELECTED, newTags);
        }
    }
    ;
    addBreadcrumbItems(resultList, selectedObject, sourceUrl, searchResultText = null) {
        const resultBreadCrumb = [];
        const isSearchResult = sourceUrl && sourceUrl.toLowerCase().indexOf("list") > -1;
        resultList.forEach((el, i) => {
            const clonedObjectItem = jQuery.extend(true, {}, el);
            if (clonedObjectItem) {
                if (isSearchResult && selectedObject && clonedObjectItem.Id == selectedObject.Id)
                    selectedObject.locationUrl = clonedObjectItem.locationUrl;
                this.setBreadcrumbGrammer(clonedObjectItem);
                const innerBreadcrumbItem = new BreadcrumbItem();
                innerBreadcrumbItem.isSelected = selectedObject == null;
                innerBreadcrumbItem.index = i;
                innerBreadcrumbItem.itemData = clonedObjectItem;
                innerBreadcrumbItem.locationUrl = clonedObjectItem.locationUrl;
                innerBreadcrumbItem.sourceUrl = sourceUrl;
                innerBreadcrumbItem.title = clonedObjectItem.StringRepresentation;
                if (innerBreadcrumbItem.isSelected) {
                    this.SelectedBreadcrumbItem = jQuery.extend(true, {}, innerBreadcrumbItem);
                    this.SelectedBreadcrumbItem.title = this.SelectedBreadcrumbItem.sourceUrl.toLowerCase().indexOf(`/${RoutePath.LIST_PATH}/`) != -1 ? searchResultText ? searchResultText : this.translateService.instant("LBL_SEARCH_RESULT") : this.SelectedBreadcrumbItem.title;
                    if (i == 0) {
                        innerBreadcrumbItem.subTitle = this.SelectedBreadcrumbItem.title;
                        innerBreadcrumbItem.loadFirstElement = true;
                    }
                }
                else {
                    if (i == 0)
                        innerBreadcrumbItem.subTitle = innerBreadcrumbItem.sourceUrl.toLowerCase().indexOf(`/${RoutePath.LIST_PATH}/`) != -1 ? searchResultText ? searchResultText : this.translateService.instant("LBL_SEARCH_RESULT") : innerBreadcrumbItem.title;
                }
                resultBreadCrumb.push(innerBreadcrumbItem);
            }
        });
        if (resultBreadCrumb.length > 0) {
            if (!GlobalFunctions.isEmpty(this.BreadcrumbItems) && !GlobalFunctions.isEmpty(this.BreadcrumbItems[0]) && !GlobalFunctions.isEmpty(this.BreadcrumbItems[0][0].sourceUrl) && this.BreadcrumbItems[0][0].sourceUrl.indexOf("detail") !== -1 && !GlobalFunctions.isEmpty(resultBreadCrumb[0].itemData) && resultBreadCrumb[0].itemData.Id == this.BreadcrumbItems[0][0].itemData.Id)
                this.BreadcrumbItems[0][0] = resultBreadCrumb[0];
            else
                this.BreadcrumbItems.unshift(resultBreadCrumb);
        }
        const selectedData = [];
        if (isSearchResult && selectedObject) {
            const clonedObject = jQuery.extend(true, {}, selectedObject);
            this.setBreadcrumbGrammer(clonedObject);
            const selectedBreadcrumbItem = new BreadcrumbItem();
            selectedBreadcrumbItem.isSelected = true;
            selectedBreadcrumbItem.index = 0;
            selectedBreadcrumbItem.itemData = clonedObject;
            selectedBreadcrumbItem.locationUrl = clonedObject.locationUrl;
            selectedBreadcrumbItem.sourceUrl = RoutePath.DETAIL_PATH;
            selectedBreadcrumbItem.title = clonedObject.StringRepresentation;
            selectedData.push(selectedBreadcrumbItem);
            this.BreadcrumbItems.unshift(selectedData);
            this.SelectedBreadcrumbItem = jQuery.extend(true, {}, selectedBreadcrumbItem);
            this.SelectedBreadcrumbItem.title = this.SelectedBreadcrumbItem.sourceUrl.toLowerCase().indexOf('/list/') != -1 ? this.translateService.instant("LBL_SEARCH_RESULT") : this.SelectedBreadcrumbItem.title;
        }
        this.selectedBreadcrumbIndex = 0;
    }
    ;
    addBasketItemFromSession(basketItem) {
        let sessionBasketItem = new BasketItemDto();
        sessionBasketItem.Type = basketItem.Type;
        sessionBasketItem.Item = new BaseDto();
        sessionBasketItem.Item.Id = basketItem.Id;
        sessionBasketItem.Item.ObjectSource = basketItem.Source;
        sessionBasketItem.Item.StringRepresentation = basketItem.StringRepresentation;
        sessionBasketItem.Item.Partial = true;
        this.basketItems.addBasketItemFromSession(sessionBasketItem);
        this.outboxItemCount = this.basketItems.getBasketItems().length;
    }
    ;
    setSessionTimer(session, sessionData) {
        try {
            this.contactSessionNotesState.ContactHistoryDto.StartDate = !GlobalFunctions.isEmpty(sessionData.ContactSessionNotesObject.StartDate) ? sessionData.ContactSessionNotesObject.StartDate : new Date(session.SessionStartDateTime);
            let startTime = new Date(session.SessionStartDateTime).getTime();
            let endTime = new Date(session.SessionEndDateTime).getTime();
            let delta = Math.abs(endTime - startTime) / 1000;
            let minutes = Math.floor(delta / 60);
            let seconds = delta % 60;
            this.endSession();
            this.seconds = seconds.toString();
            this.minutes = minutes.toString();
            this.startSessionIfPossible("notype", ScreenMode.None);
            this.sessionStartDateTime.setMinutes(this.sessionStartDateTime.getMinutes() - minutes, this.sessionStartDateTime.getSeconds() - seconds);
        }
        catch (e) { }
    }
    ;
    endSession() {
        GlobalFunctions.clearTemporaryNote();
        let headerSearchBox = $('#headerSearchBox');
        if (headerSearchBox)
            headerSearchBox.val('').empty();
        this.localSearchQuery = "";
        this.localSearchField = null;
        this.localSearchFieldList = [];
        this.searchService.searchOptions = null;
        this.searchService.searchQuery = "";
        this.phoneTransferStatus = 0;
        this.isSessionStart = false;
        this.deeplinkPhoneNumber = "";
        if (this.timer) {
            this.seconds = "00";
            this.minutes = "00";
            clearTimeout(this.timer);
            this.timer = null;
            this.sessionExceeded = false;
        }
        this.clearSession();
        if (this.sessionStateChangedCallback != null)
            this.sessionStateChangedCallback("EndSession");
    }
    ;
    clearSession() {
        this.selectedEntity = null;
        this.phoneTransferStatus = 0;
        this.searchService.selectedSearchOption = null;
        this.searchService.searchOptions = null;
        this.searchService.searchQuery = "";
        this.detailViewCachedEntityList = [];
        this.BreadcrumbItems = [];
        this.basketItems.basketItems = [];
        this.outboxItemCount = this.basketItems.getBasketItems().length;
        this.currentSession = null;
        this.addAdvancedSearchItems();
        this.localSearchQuery = "";
        this.localSearchField = null;
        this.localSearchFieldList = [];
        this.loadedFromNextEmailButton = false;
        this.currentCallerId = null;
        this.currentCallId = null;
        this.contactPersonFromRecentActivity = "";
        this.sentEmailDetail = null;
        this.sentEmailType = EmailType.None;
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.CLEAR_SESSION);
        this.contactSessionNotesState.isContactSessionNotesHighlighted = false;
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.REMOVE_COMPONENT);
        this.closeJkcParentPanel();
        this.closeJkcViewerPanel();
        this.jkcViewerBreadCrumbList = [];
    }
    ;
    closeJkcParentPanel() {
        if (!GlobalFunctions.isEmpty(this.jkcChildPanel))
            this.closeJkcChildPanel();
        $("#jkcParentPanelContainer").empty();
        this.jkcParentPanel = null;
    }
    closeJkcChildPanel() {
        $("#jkcChildPanelContainer").empty();
        this.jkcChildPanel = null;
    }
    closeJkcViewerPanel() {
        $("#jkcViewerPanelContainer").empty();
        if (this.jkcViewerPanel != null) {
            this.jkcViewerPanel.parameters.IsPanelPinned = false;
            this.resetJkcPanel();
        }
        this.jkcViewerPanel = null;
    }
    addAdvancedSearchItems() {
        this.advancedSearchMatrix = [];
        this.addPersonAdvancedSearchItems();
        this.addContactHistoryAdvancedSearchItems();
        this.addOrganizationAdvancedSearchItems();
        this.addDucumentAdvancedSearchItems();
        this.addCaseAdvancedSearchItems();
        this.addTicketAdvancedSearchItems();
        this.addAllSourcesAdvancedSearchItems();
    }
    getBasketItems() {
        return this.basketItems.getBasketItems();
    }
    ;
    clearBasketItems() {
        let basketItems = this.getBasketItems();
        if (basketItems != null && basketItems.length > 0) {
            let updatedBasketItems = [];
            let index = 0;
            for (let i = 0; i < basketItems.length; i++) {
                let basketItem = basketItems[i];
                if (basketItem.Item != null && basketItem.Item != undefined && !basketItem.Item.IsMarked) {
                    updatedBasketItems[index++] = basketItem;
                }
            }
            this.basketItems.setBasketItems(updatedBasketItems);
            this.outboxItemCount = this.basketItems.count();
        }
    }
    ;
    removeBasketItem(basketItemToRemove) {
        if (basketItemToRemove == null)
            return;
        let basketItems = this.getBasketItems();
        if (basketItems != null && basketItems.length > 0) {
            basketItems.forEach(basketItem => {
                if (basketItem.Item != null && basketItem.Item != undefined && basketItemToRemove.Item != null && basketItem.Item.Id == basketItemToRemove.Item.Id) {
                    let index = basketItems.indexOf(basketItem);
                    basketItems.splice(index, 1);
                }
                this.outboxItemCount = this.basketItems.getBasketItems().length;
            });
        }
    }
    ;
    getMarkedItems(basketItemsList) {
        let basketItems = basketItemsList;
        let outBasketItemDtoList = [];
        if (basketItems != null && basketItems.length > 0) {
            basketItems.forEach(basketItem => {
                let entityFqdn = basketItem.Item.RelatedEntityFqdn;
                basketItem.Type = EntityFqdn[entityFqdn];
                switch (basketItem.Type) {
                    case EntityFqdn.Decos_Kcs_Documents_Entities_FileDocument:
                        {
                            basketItem.Item = GlobalFunctions.setEntityType(basketItem.Item, GlobalFunctions.toJsonFqdnType("FILEDOCUMENT"));
                            break;
                        }
                    case EntityFqdn.Decos_Kcs_Products_Entities_Product:
                        {
                            if (basketItem.Item && basketItem.Item.Descriptions.length > 0)
                                basketItem.JsonItemList = JSON.stringify(basketItem.Item.Descriptions);
                            break;
                        }
                    case EntityFqdn.Decos_Kcs_Faqs_Entities_QuestionAnswer:
                        {
                            if (basketItem.Item.ChannelQuestionAnswers && basketItem.Item.ChannelQuestionAnswers.length > 0) {
                                let faqDescriptionData = new DescriptionDocumentDto();
                                faqDescriptionData.DownloadTicketId = basketItem.Item.ChannelQuestionAnswers[0].ClarificationDownloadTicketId;
                                basketItem.Item.ChannelQuestionAnswers[0].Answers.push(faqDescriptionData);
                                basketItem.JsonItemList = JSON.stringify(basketItem.Item.ChannelQuestionAnswers[0].Answers);
                            }
                            break;
                        }
                    case EntityFqdn.Decos_Kcs_Notes_Entities_NoteEntity:
                        {
                            let descriptionList = [];
                            let noteDescriptionData = new DescriptionDocumentDto();
                            noteDescriptionData.DownloadTicketId = basketItem.Item.DescriptionDownloadTicketId;
                            descriptionList.push(noteDescriptionData);
                            basketItem.JsonItemList = JSON.stringify(descriptionList);
                            break;
                        }
                    case EntityFqdn.Decos_Kcs_Persons_Entities_Person:
                        {
                            if (!GlobalFunctions.isEmpty(basketItem.Item)) {
                                if (!GlobalFunctions.isEmpty(basketItem.Item.ResidentialAddress)) {
                                    basketItem.Item.ResidentialAddress.Address.StreetName = GlobalFunctions.isEmpty(basketItem.Item.ResidentialAddress?.Address?.StreetName) ? "" : basketItem.Item.ResidentialAddress?.Address?.StreetName;
                                    basketItem.Item.ResidentialAddress.Address.HouseNumber = GlobalFunctions.isEmpty(basketItem.Item.ResidentialAddress?.Address?.HouseNumber) ? "" : basketItem.Item.ResidentialAddress?.Address?.HouseNumber;
                                    basketItem.Item.ResidentialAddress.Address.ZipCode = GlobalFunctions.isEmpty(basketItem.Item.ResidentialAddress?.Address?.ZipCode) ? "" : basketItem.Item.ResidentialAddress?.Address?.ZipCode;
                                    basketItem.Item.ResidentialAddress.Address.City = GlobalFunctions.isEmpty(basketItem.Item.ResidentialAddress?.Address?.City) ? "" : basketItem.Item.ResidentialAddress?.Address?.City;
                                    if (GlobalFunctions.isEmpty(basketItem.Item.ResidentialAddress.StartDate))
                                        basketItem.Item.ResidentialAddress.StartDate = "";
                                }
                                else
                                    basketItem.Item.ResidentialAddress = "";
                                if (!GlobalFunctions.isEmpty(basketItem.Item.Details) && !GlobalFunctions.isEmpty(basketItem.Item?.Details?.FormalName) && GlobalFunctions.isEmpty(basketItem.Item.Details?.FormalName?.GenderText))
                                    basketItem.Item.Details.FormalName.GenderText = basketItem.Item?.Details?.FormalName?.Gender == 1 ? this.translateService.instant("LBL_FEMALE") : (basketItem.Item.Details?.FormalName?.Gender == 0 ? this.translateService.instant("LBL_MALE") : "");
                                if (GlobalFunctions.isEmpty(basketItem.Item.PhoneNumber))
                                    basketItem.Item.PhoneNumber = "";
                                if (GlobalFunctions.isEmpty(basketItem.Item.MobileNumber))
                                    basketItem.Item.MobileNumber = "";
                            }
                            break;
                        }
                    case EntityFqdn.Decos_Kcs_Organizations_Entities_Organization:
                        {
                            if (!GlobalFunctions.isEmpty(basketItem.Item)) {
                                if (GlobalFunctions.isEmpty(basketItem.Item.ResidentialAddress))
                                    basketItem.Item.ResidentialAddress = "";
                                if (GlobalFunctions.isEmpty(basketItem.Item.PhoneNumber))
                                    basketItem.Item.PhoneNumber = "";
                                if (GlobalFunctions.isEmpty(basketItem.Item.FaxNumber))
                                    basketItem.Item.FaxNumber = "";
                                if (GlobalFunctions.isEmpty(basketItem.Item.EmailAddress))
                                    basketItem.Item.EmailAddress = "";
                            }
                            break;
                        }
                    case EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity:
                        {
                            if (!GlobalFunctions.isEmpty(basketItem.Item)) {
                                if (GlobalFunctions.isEmpty(basketItem.Item.HandlerName))
                                    basketItem.Item.HandlerName = "";
                                if (GlobalFunctions.isEmpty(basketItem.Item.HandlingDepartmentName))
                                    basketItem.Item.HandlingDepartmentName = "";
                                if (GlobalFunctions.isEmpty(basketItem.Item.PrimarySubjectName))
                                    basketItem.Item.PrimarySubjectName = "";
                                if (GlobalFunctions.isEmpty(basketItem.Item.ResultDescription))
                                    basketItem.Item.ResultDescription = "";
                                if (GlobalFunctions.isEmpty(basketItem.Item.Statuses) || basketItem.Item.Statuses.length == 0) {
                                    basketItem.Item.Statuses = [];
                                    let status = new Object();
                                    status.Explanation = "";
                                    basketItem.Item.Statuses.push(status);
                                }
                                if (GlobalFunctions.isEmpty(basketItem.Item.Statuses[0].Explanation))
                                    basketItem.Item.Statuses[0].Explanation = "";
                            }
                            break;
                        }
                    case EntityFqdn.Decos_Kcs_ContactHistory_Entities_ContactMoment:
                        {
                            if (basketItem.ItemList != null && basketItem.ItemList.length > 0)
                                basketItem.JsonItemList = JSON.stringify(basketItem.ItemList);
                            break;
                        }
                    case EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket:
                        {
                            if (GlobalFunctions.isEmpty(basketItem.Item.ContactPhoneNumber))
                                basketItem.Item.ContactPhoneNumber = "";
                        }
                }
                if (basketItem.Item != null && basketItem.Item != undefined && basketItem.Item.IsMarked) {
                    basketItem.JsonItem = JSON.stringify(basketItem.Item);
                    if (basketItem.Type == EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket) {
                        let baseDtoTicket = GlobalFunctions.convertTicketToBase(basketItem.Item);
                        basketItem.Item = baseDtoTicket;
                    }
                    // if (basketItem.Type == EntityFqdn.Decos_Kcs_Persons_Entities_Person || basketItem.Type == EntityFqdn.Decos_Kcs_Organizations_Entities_Organization || basketItem.Type == EntityFqdn.Decos_Kcs_Employees_Entities_Employee) {
                    //  let privacyBaketItem = this.formatManager.removePrivacyDataFromObject(JSON.parse(basketItem.JsonItem), basketItem.Type);
                    //  basketItem.JsonItem = JSON.stringify(privacyBaketItem);
                    // }
                    outBasketItemDtoList.push(basketItem);
                }
            });
        }
        return outBasketItemDtoList;
    }
    ;
    resetJkcPanel() {
        if (!GlobalFunctions.isEmpty(this.jkcParentPanel) && this.jkcParentPanel.parameters.IsUsed) {
            this.jkcParentPanel.sessionNotesUIState = this.contactSessionNotesState;
            if (this.jkcParentPanel.parameters.IsPanelExpanded)
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.JSPANEL_RESIZE);
            else
                this.jkcParentPanel.setCollapsedJsPanelStyle('#jkcParentPanel');
        }
        if (!GlobalFunctions.isEmpty(this.jkcChildPanel) && this.jkcChildPanel.parameters.IsUsed) {
            this.jkcChildPanel.sessionNotesUIState = this.contactSessionNotesState.UIState;
            if (this.jkcChildPanel.parameters.IsPanelExpanded)
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.JSPANEL_RESIZE);
            else
                this.jkcChildPanel.setCollapsedJsPanelStyle('#jkcChildPanel');
        }
        let width = 0;
        if (this.contactSessionNotesState.UIState == ContactSessionNotesUIState.Pinned)
            width = this.contactSessionNotesState.isSuggestionPanelOpen ? 65 : 75;
        let jkcSuggestionPanelElement = $("#jkcSuggestionPanel");
        if (jkcSuggestionPanelElement && this.contactSessionNotesState.isSuggestionPanelOpen) {
            let suggestionLeft = width = width == 0 ? 83 : 65;
            jkcSuggestionPanelElement.css({ top: '-42px', left: suggestionLeft + "%" });
        }
        let jkcViewerPanelElement = $("#jkcViewerPanel");
        if (jkcViewerPanelElement && this.jkcViewerPanel != null) {
            let viewerLeft = 0;
            if (this.jkcViewerPanel.parameters.IsPanelPinned) {
                width = width == 0 ? 70 : width - 30;
                viewerLeft = width;
            }
            else
                viewerLeft = width == 0 ? 70 : width - 30;
            jkcViewerPanelElement.css({ top: '-42px', left: viewerLeft + "%" });
        }
        if (width === 0)
            width = GlobalFunctions.checkRights("ContactHistory", OperationType.Add) ? 98 : 99;
        GlobalFunctions.resizejkcBootstrapTable();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.JKC_PANEL_RESET);
    }
    addBreadcrumbTypeItems(resultList, fromSubMenu, resetTitle = false) {
        let clonedList = [];
        resultList.forEach((item) => {
            let clonedItem = jQuery.extend(true, {}, item);
            if (clonedItem.sourceUrl.toLowerCase().indexOf(RoutePath.LIST_PATH) == -1 || fromSubMenu)
                clonedItem.sourceUrl = RoutePath.DETAIL_PATH;
            clonedList.push(clonedItem);
        });
        clonedList.forEach((item) => {
            if (item.isSelected) {
                this.SelectedBreadcrumbItem = jQuery.extend(true, {}, item);
                if (resetTitle)
                    item.subTitle = "";
                this.SelectedBreadcrumbItem.title = item.sourceUrl.toLowerCase().indexOf(`/${RoutePath.LIST_PATH}/`) != -1 && !fromSubMenu ? item.subTitle ? item.subTitle : this.translateService.instant("LBL_SEARCH_RESULT") : item.title;
            }
        });
        this.BreadcrumbItems.unshift(clonedList);
        this.selectedBreadcrumbIndex = 0;
    }
    ;
    isActive(route) {
        return route === this.router.url;
    }
    ;
    getSelectedItem(basketItem) {
        let result = [];
        if (basketItem != null) {
            let list = this.getBasketItems();
            if (list != null && list.length > 0) {
                for (let index = 0; index < list.length; index++) {
                    if (list[index] != null && list[index].Item != null && list[index].Item != undefined && list[index].Item.Id == basketItem.Id) {
                        let entityFqdn = list[index].Item.RelatedEntityFqdn;
                        list[index].Type = EntityFqdn[entityFqdn];
                        result.push(list[index]);
                        break;
                    }
                }
            }
        }
        return result;
    }
    ;
    getAdvancedSearchMatrixFor(contentType) {
        let advanceSearchMatrix = null;
        if (contentType)
            advanceSearchMatrix = this.advancedSearchMatrix[contentType];
        return advanceSearchMatrix;
    }
    ;
    addRelatedPersonOrOrganizationIntoSession(cacheManager) {
        if (cacheManager.relatedResultList != null)
            if (!GlobalFunctions.isEmpty(cacheManager.relatedResultList["PERSON"]) && !GlobalFunctions.isEmpty(cacheManager.relatedResultList["PERSON"][0])) {
                this.addItemsToDetailViewCacheList(cacheManager.relatedResultList["PERSON"][0], GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person]), true);
                if (!GlobalFunctions.isEmpty(cacheManager.relatedResultList["ORGANIZATION"]) && !GlobalFunctions.isEmpty(cacheManager.relatedResultList["ORGANIZATION"][0]))
                    this.addItemsToDetailViewCacheList(cacheManager.relatedResultList["ORGANIZATION"][0], GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Organizations_Entities_Organization]), true);
            }
    }
    ;
    geoCurrentLocation() {
        let currentLocation = this.applicationSettingManager.getApplicationSettingValueByKey("CurrentLocation");
        let locationDto = new LocationDto();
        locationDto.Id = GlobalFunctions.createGuid();
        locationDto.Partial = false;
        locationDto.GeoSeachCriteria = currentLocation;
        locationDto.StringRepresentation = currentLocation;
        locationDto.locationUrl = `${RoutePath.DETAIL_PATH}/location`;
        this.selectedEntity = locationDto;
        this.loadedFromRelatedView = false;
        this.addBreadcrumbItems([locationDto], null, RoutePath.DETAIL_PATH);
        this.router.navigate([locationDto.locationUrl]);
    }
    ;
    addEntityToSession(selectedEntity, type) {
        if (type == "Organization") {
            let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("OrganizationDto_Breadcrumb");
            if (!GlobalFunctions.isEmpty(getGrammerValue))
                GlobalFunctions.setStringPresentation(selectedEntity, getGrammerValue);
            this.addItemsToDetailViewCacheList(selectedEntity, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Organizations_Entities_Organization]), true);
        }
        else if (type == "Person") {
            let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
            if (!GlobalFunctions.isEmpty(getGrammerValue))
                GlobalFunctions.setStringPresentation(selectedEntity, getGrammerValue);
            this.addItemsToDetailViewCacheList(selectedEntity, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person]), true);
        }
        else if (type == "Issue") {
            let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("IssueDto_Breadcrumb");
            if (!GlobalFunctions.isEmpty(getGrammerValue))
                GlobalFunctions.setStringPresentation(selectedEntity, getGrammerValue);
            this.addItemsToDetailViewCacheList(selectedEntity, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Issues_Entities_Issue]), true);
        }
        else if (type == "Ticket") {
            let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("TicketDto_Breadcrumb");
            if (!GlobalFunctions.isEmpty(getGrammerValue))
                GlobalFunctions.setStringPresentation(selectedEntity, getGrammerValue);
            this.addItemsToDetailViewCacheList(selectedEntity, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket]), true);
        }
    }
    ;
    addItemToSession(item) {
        let contentType;
        this.setBreadcrumbGrammer(item);
        const excludingEntityEnums = this.applicationSettingManager.getExcludeEntityInSessionSettings();
        if (!((item.RelatedEntityFqdn == EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Appointment] && item.TaskSource === TaskSource.Jcc) || item.IsClosed || excludingEntityEnums.indexOf(item.RelatedEntityFqdn) > -1)) {
            contentType = !item.RelatedEntityFqdn ? GlobalFunctions.toContentType(item.Type) : GlobalFunctions.toString(item.RelatedEntityFqdn);
            this.addItemsToDetailViewCacheList(item, contentType);
        }
    }
    setFavorite(entity) {
        const favouriteDto = new FavouriteDto(entity);
        const dashboardItem = this.cacheManager.getItemFromDashboardCache("MyFavourite", favouriteDto);
        entity.IsFavourite = dashboardItem != null && dashboardItem != undefined;
    }
    getMarkedBasketItems() {
        let basketItems = this.getBasketItems();
        let outBasketItemDtoList = [];
        if (basketItems != null && basketItems.length > 0) {
            basketItems.forEach(basketItem => {
                let entityFqdn = basketItem.Item.RelatedEntityFqdn;
                basketItem.Type = EntityFqdn[entityFqdn];
                if (basketItem.Item != null && basketItem.Item != undefined && basketItem.Item.IsMarked)
                    outBasketItemDtoList.push(basketItem);
            });
        }
        return outBasketItemDtoList;
    }
    isAllowedToFetchCount(channel) {
        if (this.employeeStatus) {
            if (this.employeeStatus.isInitialized === false)
                return true;
            let isAllowed = false;
            switch (channel) {
                case 'Email':
                    {
                        isAllowed = this.employeeStatus.isEmailFeatureEnabledFromChannel && GlobalFunctions.checkDashboardRights('Email');
                        break;
                    }
                case 'SocialMedia':
                    {
                        isAllowed = this.employeeStatus.isSocialMediaFeatureEnabledFromChannel && this.isSocialMediaFeatureEnabled && GlobalFunctions.checkRights('SocialMedia');
                        break;
                    }
            }
            return isAllowed;
        }
    }
    ;
    autoIgnoreSession(dialog, dialogManager, cacheManager, phoneManager, closeAllDialogs = true) {
        if (closeAllDialogs)
            dialog.closeAll();
        this.endSession();
        document.getElementById('contentFieldQuestion')?.classList?.remove('error');
        document.getElementById('contentFieldAnswer')?.classList?.remove('error');
        document.getElementById('customerRolesCombo')?.classList?.remove('error');
        dialogManager.openContactHistorySource = "";
        cacheManager.removeDashboardCache();
        phoneManager.updatePhoneAvailabilityStatus(PhoneStatus.Available);
        this.router.navigate([RoutePath.DASHBOARD]);
    }
    loadSelectedEntityInDetail(selectedEntity) {
        this.selectedEntity = selectedEntity;
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL, this.selectedEntity);
    }
    isAssignmentTaskAutoIgnoreSessionValid(cacheManager, subTaskType) {
        let isValid = false;
        if (cacheManager.relatedResultList != null && !GlobalFunctions.isEmpty(cacheManager.relatedResultList["TASK"]) && !GlobalFunctions.isEmpty(cacheManager.relatedResultList["TASK"][0]) && cacheManager.relatedResultList["TASK"][0].TaskType.toLowerCase() === "assignment" && cacheManager.relatedResultList["TASK"][0].SubTaskType.toLowerCase() === subTaskType.toLowerCase())
            isValid = true;
        return isValid;
    }
    ;
    saveSentEmailDetail(sentEmailDto, sentEmailtype) {
        let answerRemarks = "";
        if (sentEmailDto.Header != null && !GlobalFunctions.isEmpty(sentEmailDto.Header.To) && sentEmailDto.Header.To.length > 0) {
            answerRemarks = answerRemarks + "" + this.translateService.instant("LBL_TO") + ": ";
            for (let i = 0; i < sentEmailDto.Header.To.length; i++)
                answerRemarks = answerRemarks + sentEmailDto.Header.To[i] + ";";
        }
        if (sentEmailDto.Header != null && !GlobalFunctions.isEmpty(sentEmailDto.Header.Cc) && sentEmailDto.Header.Cc.length > 0) {
            answerRemarks = answerRemarks + " \n" + this.translateService.instant("LBL_CC") + ": ";
            for (let i = 0; i < sentEmailDto.Header.Cc.length; i++)
                answerRemarks = answerRemarks + sentEmailDto.Header.Cc[i] + ";";
        }
        if (!GlobalFunctions.isEmpty(sentEmailDto.Header.Subject))
            answerRemarks = answerRemarks + " \n" + this.translateService.instant("LBL_SUBJECT") + ": " + sentEmailDto.Header.Subject;
        if (sentEmailDto.Body != null && !GlobalFunctions.isEmpty(sentEmailDto.Body.Body))
            answerRemarks = answerRemarks + " \n" + this.translateService.instant("LBL_EMAIL_BODY") + ": " + sentEmailDto.Body.Body;
        if (sentEmailDto.AttachmentList != null && sentEmailDto.AttachmentList.length > 0) {
            answerRemarks = answerRemarks + " \n" + this.translateService.instant("LBL_ATTACHMENT") + ": ";
            for (let i = 0; i < sentEmailDto.AttachmentList.length; i++)
                answerRemarks = answerRemarks + GlobalFunctions.getBasketName(sentEmailDto.AttachmentList[i]) + ";";
        }
        this.sentEmailDetail = answerRemarks;
        this.sentEmailType = sentEmailtype;
        this.updateContactSessionNotes(true);
    }
    addBasketItem() {
        this.basketItems.addBasketItem({ ...this.selectedEntity });
        this.outboxItemCount = this.basketItems.getBasketItems().length;
    }
    ;
    clear() {
        this.isValiduser = false;
        this.isLoggedOut = true;
        this.BreadcrumbItems = [];
        this.pendingCount = new PendingCount();
        this.clearHeaderTextValue();
        this.endSession();
        this.employeeStatus = null;
        this.contactSessionNotesState.ContactHistoryDto = new ContactHistoryMomentDto();
        this.contactSessionNotesState.RelatedEntityList = [];
        this.contactSessionNotesState.isContactSessionNotesHighlighted = false;
        this.contactSessionNotesState.Tags = [];
        this.contactSessionNotesState.isSuggestionPanelOpen = false;
        this.contactSessionNotesState.TagIdForSuggestionPanel = null;
        this.selectedRole = null;
        this.roleId = null;
        this.applicationInfo = null;
        this.isAutoLogin = false;
    }
    isRefreshAllowed(entity) {
        let isAllowed = false;
        switch (entity) {
            case 'Ticket':
                {
                    isAllowed = this.pendingCount.IsTicketCountUpdated == false || this.applicationSettingManager.refreshCountSetting.Ticket.OnDashboard;
                    break;
                }
            case 'Task':
                {
                    isAllowed = this.pendingCount.IsTaskCountUpdated == false || this.applicationSettingManager.refreshCountSetting.Task.OnDashboard;
                    break;
                }
            case 'Document':
                {
                    isAllowed = this.pendingCount.IsDocumentCountUpdated == false || this.applicationSettingManager.refreshCountSetting.Document.OnDashboard;
                    break;
                }
            case 'Email':
                {
                    isAllowed = this.pendingCount.IsEmailCountUpdated == false || this.applicationSettingManager.refreshCountSetting.Email.OnDashboard;
                    break;
                }
            case 'SocialMedia':
                {
                    isAllowed = this.pendingCount.IsSocialMediaCountUpdated == false || this.applicationSettingManager.refreshCountSetting.SocialMedia.OnDashboard;
                    break;
                }
        }
        return isAllowed;
    }
    ;
    getApplicationPadding() {
        let value = this.contactSessionNotesState.UIState === 1 ? (this.contactSessionNotesState.isSuggestionPanelOpen ? 35 : 25) : (this.contactSessionNotesState.isSuggestionPanelOpen ? 17 : 0);
        if (this.jkcViewerPanel?.parameters?.IsPanelPinned)
            value += 30;
        return value != 0 ? value + '%' : '28px';
    }
    getAppointmentLocation(id) {
        return this.appointmentLocationList.find(location => location.Uid === id);
    }
    getAppointmentProduct(id) {
        return this.appointmentProductList.find(product => product.Uid === id);
    }
    isValidSession() {
        if (this.isValidToken())
            return true;
        else {
            if (!this.eventProvider.isSessionExpired) {
                this.dialog.closeAll();
                this.eventProvider.isSessionExpired = true;
                ExceptionHelper.showException(this.dialog, ExceptionHelper.create(this.translateService.instant('LBL_SESSION_EXPIRED'), this.translateService.instant('LBL_SESSION_EXPIRED_MSG'), this.translateService.instant('LBL_SESSION')), true, null, null, this.zone).afterClosed().subscribe(() => this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOGOUT));
            }
            return false;
        }
    }
};
SessionManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], SessionManager);
export { SessionManager };
//# sourceMappingURL=session-manager.js.map