var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { map } from 'rxjs/operators';
import { environment } from '../../../environments/environment';
import { EformComponent } from '../../components/common/eform/eform.component';
import { GlobalFunctions } from '../../shared/global-functions';
import { DialogHelper } from '../../shared/helper/dialog-helper';
import { ScreenMode } from '../enums/common-enums';
import { EntityFqdn } from '../enums/core-enums';
import { ColorCodeInformation } from '../models/common/color-code-information';
import { DashboardSetting } from '../models/common/dashboard-setting';
import { LetterTemplateSetting } from '../models/common/letter-template-setting';
import { RefreshCountSetting } from '../models/common/refresh-count-setting';
import { SuggestionSetting } from '../models/common/suggestion-setting';
import { TagSetting } from '../models/common/tag-setting';
import { ViewerSetting } from '../models/common/viewer-setting';
import { EntityRequiredPropertyConfiguration } from '../models/configuration/enitity-required-propert-configuration';
import { EntityPropertyConfiguration } from '../models/configuration/entity-property-configuration';
import { PropertyConfiguration } from '../models/configuration/property-configuration';
import { RequiredPropertyConfiguration } from '../models/configuration/required-property-configuration';
import { ContentType, SourceType } from '../models/jkc-object/jkc-object';
import { BaseService } from '../services/base-service';
let X2JS = require('x2js');
let ApplicationSettingManager = class ApplicationSettingManager extends BaseService {
    constructor(zone, router, dialog, httpClient, eventProvider, translateService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.dialog = dialog;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.applicationSettingsDictionary = {};
        this.applicationSettingsColorCodeDictionary = {};
        this.applicationSettingCached = false;
        this.autoIgnoreSession = false;
        this.autoEndSession = false;
        this.showWarningOnIgnoreSession = false;
        this.isLinkCSNToCaseSystemEnabled = false;
        this.sourceLocations = [];
        this.privacyPropertyList = new EntityPropertyConfiguration();
        this.entityRequiredPropertyList = new EntityRequiredPropertyConfiguration();
        this.UIConfigurator = new EntityPropertyConfiguration();
        this.letterTemplateList = new LetterTemplateSetting();
        this.tagSetting = new TagSetting();
        this.suggestionSetting = new SuggestionSetting();
        this.viewerSetting = new ViewerSetting();
        this.dashboardSetting = new DashboardSetting();
        this.refreshCountSetting = new RefreshCountSetting();
        this.setUIConfigurator = () => {
            let uiConfigurations = this.getApplicationSettingValueByKey("UIConfigurator");
            if (!GlobalFunctions.isEmpty(uiConfigurations)) {
                let x2js = new X2JS();
                let jsonObj = x2js.xml2js(uiConfigurations);
                jsonObj.UIEntityFieldSelection.Entity = GlobalFunctions.ConvertToArrayIfOnlySingleObject(jsonObj.UIEntityFieldSelection.Entity);
                //Contact session
                this.UIConfigurator.ContactSessionProperties = {};
                let contactSessionSetting = GlobalFunctions.ConvertToArrayIfOnlySingleObject(jlinq.from(jsonObj.UIEntityFieldSelection.Entity).starts("_ContentType", ContentType.ContactMoment).select());
                if (!GlobalFunctions.isEmpty(contactSessionSetting)) {
                    for (let i = 0; i < contactSessionSetting[0].Property.length; i++) {
                        let propertyFqdn = contactSessionSetting[0].Property[i]._Fqdn;
                        let propertyName = GlobalFunctions.getObjectTypeName(propertyFqdn).replace('[0]', '');
                        this.UIConfigurator.ContactSessionProperties[propertyName] = new PropertyConfiguration();
                        this.UIConfigurator.ContactSessionProperties[propertyName].IsVisible = contactSessionSetting[0].Property[i]._IsVisible == true || contactSessionSetting[0].Property[i]._IsVisible == 'true';
                        if (!GlobalFunctions.isEmpty(contactSessionSetting[0].Property[i]._IsRequired))
                            this.UIConfigurator.ContactSessionProperties[propertyName].IsRequired = contactSessionSetting[0].Property[i]._IsRequired == true || contactSessionSetting[0].Property[i]._IsRequired == 'true';
                        else
                            this.UIConfigurator.ContactSessionProperties[propertyName].IsRequired = false;
                    }
                }
                this.UIConfigurator.CallbackNoteProperties = {};
                const callbacknoteSetting = GlobalFunctions.ConvertToArrayIfOnlySingleObject(jlinq.from(jsonObj.UIEntityFieldSelection.Entity).starts("_ContentType", ContentType.CallbackNote).select());
                if (!GlobalFunctions.isEmpty(callbacknoteSetting)) {
                    if (callbacknoteSetting[0] && callbacknoteSetting[0].Property)
                        callbacknoteSetting[0].Property = GlobalFunctions.ConvertToArrayIfOnlySingleObject(callbacknoteSetting[0].Property);
                    for (let i = 0; i < callbacknoteSetting[0].Property.length; i++) {
                        const propertyFqdn = callbacknoteSetting[0].Property[i]._Fqdn;
                        const propertyName = GlobalFunctions.getObjectTypeName(propertyFqdn).replace('[0]', '');
                        this.UIConfigurator.CallbackNoteProperties[propertyName] = new PropertyConfiguration();
                        this.UIConfigurator.CallbackNoteProperties[propertyName].IsVisible = callbacknoteSetting[0].Property[i]._IsVisible == true || callbacknoteSetting[0].Property[i]._IsVisible == 'true';
                        if (!GlobalFunctions.isEmpty(callbacknoteSetting[0].Property[i]._IsRequired))
                            this.UIConfigurator.CallbackNoteProperties[propertyName].IsRequired = callbacknoteSetting[0].Property[i]._IsRequired == true || callbacknoteSetting[0].Property[i]._IsRequired == 'true';
                        else
                            this.UIConfigurator.CallbackNoteProperties[propertyName].IsRequired = false;
                    }
                }
            }
        };
    }
    getApplicationSettingsColorCodeDictionary(objectSourceValue) {
        let result = "";
        let testResult = "#37BBDD";
        if (!GlobalFunctions.isEmpty(objectSourceValue) && this.applicationSettingsColorCodeDictionary != null) {
            let colorCodeValue = new ColorCodeInformation();
            colorCodeValue = this.applicationSettingsColorCodeDictionary[objectSourceValue.toLowerCase()];
            if (colorCodeValue != null && colorCodeValue != undefined)
                result = colorCodeValue.SelectedBackgroundColor;
        }
        if (GlobalFunctions.isEmpty(result))
            result = testResult;
        return result;
    }
    isContentTypeEligibleForStartingSession(contentType, mode) {
        let startSession = mode != ScreenMode.List;
        if (contentType.includes("SocialMedia.Entities"))
            contentType = ContentType.SocialMedia;
        else if (contentType.includes("Tasks.Entities"))
            contentType = ContentType.Task;
        let settingValue = this.getApplicationSettingValueByKey("CONTENTTYPESDONOTSTARTSESSIONLIST");
        if (typeof settingValue === 'string') {
            if (!settingValue.toUpperCase().includes(contentType.toUpperCase()))
                startSession = true;
            else {
                let settingValueParts = settingValue.toUpperCase().split(";");
                settingValueParts.forEach(entityValue => {
                    let entityValueParts = entityValue.split("|");
                    if (entityValueParts[0] == contentType.toUpperCase()) {
                        if (entityValueParts.length == 1)
                            startSession = false;
                        else {
                            switch (mode) {
                                case ScreenMode.List:
                                    startSession = entityValueParts[1] == "FALSE";
                                    break;
                                case ScreenMode.Detail:
                                    startSession = entityValueParts[2] == "FALSE";
                                    break;
                                case ScreenMode.Add:
                                    startSession = entityValueParts[3] == "FALSE";
                                    break;
                                case ScreenMode.Edit:
                                    startSession = entityValueParts[4] == "FALSE";
                                    break;
                            }
                        }
                    }
                });
            }
        }
        return startSession;
    }
    getObjectGrammerSetting(settingKey) {
        let settingValue = '';
        const objectdtogrammarlistValue = this.getApplicationSettingValueByKey("objectdtogrammarlist");
        if (!GlobalFunctions.isEmpty(objectdtogrammarlistValue))
            settingValue = GlobalFunctions.parseXmlValue(objectdtogrammarlistValue, settingKey);
        return settingValue;
    }
    getApplicationSettingValueByKey(settingKey) {
        settingKey = settingKey.toUpperCase();
        let settingValue = "";
        if (this.applicationSettingsDictionary)
            settingValue = this.applicationSettingsDictionary[settingKey];
        return settingValue;
    }
    getSearchFieldListByEntity(entityType) {
        let settingValue = this.getApplicationSettingValueByKey("SearchFieldList");
        let fields = [];
        let x2js = new X2JS();
        let jsonObj = x2js.xml2js(settingValue);
        if (jsonObj != null && jsonObj.SearchFieldList != null && jsonObj.SearchFieldList.SearchItem != null) {
            let entitySearchFieldList = jlinq.from(jsonObj.SearchFieldList.SearchItem).equals("_ContentType", entityType).first();
            if (entitySearchFieldList && !GlobalFunctions.isEmpty(entitySearchFieldList._FieldList)) {
                let entityFields = entitySearchFieldList._FieldList.split(';');
                entityFields.forEach(field => fields.push({ key: field, value: this.translateService.instant("LBL_" + field) }));
            }
        }
        return fields;
    }
    getSourceLocationsByEntity(entityName) {
        let sourceLocationList = [];
        switch (entityName.toUpperCase()) {
            case "PERSON":
                if (this.sourceLocations["PERSONS"] != null) {
                    sourceLocationList = [...this.sourceLocations["PERSONS"]];
                    if (sourceLocationList.length > 0) {
                        sourceLocationList.push({
                            'EntityName': 'persons',
                            'SourceLocationName': this.translateService.instant("LBL_ALL_SOURCES")
                        });
                    }
                }
                break;
            case "ORGANIZATION":
                if (this.sourceLocations["ORGANIZATIONS"] != null) {
                    sourceLocationList = [...this.sourceLocations["ORGANIZATIONS"]];
                    if (sourceLocationList.length > 0) {
                        sourceLocationList.push({
                            'EntityName': 'organizations',
                            'SourceLocationName': this.translateService.instant("LBL_ALL_SOURCES")
                        });
                    }
                }
                break;
            case "PRODUCT":
                if (this.sourceLocations["PRODUCTS"] != null) {
                    sourceLocationList = [...this.sourceLocations["PRODUCTS"]];
                    if (sourceLocationList.length > 0) {
                        sourceLocationList.push({
                            'EntityName': 'products',
                            'SourceLocationName': this.translateService.instant("LBL_ALL_SOURCES")
                        });
                    }
                }
                break;
            case "TICKET":
                if (this.sourceLocations["TICKETS"] != null) {
                    let ticketSources = this.sourceLocations["TICKETS"];
                    if (GlobalFunctions.isEmpty(ticketSources))
                        break;
                    sourceLocationList = [...this.sourceLocations["TICKETS"]];
                    sourceLocationList.unshift({
                        'EntityName': 'tickets',
                        'SourceLocationName': this.translateService.instant("LBL_ALL_SOURCES")
                    });
                }
                break;
            case "CASEENTITY":
                if (this.sourceLocations["CASEENTITY"] != null) {
                    let caseSources = this.sourceLocations["CASEENTITY"];
                    if (GlobalFunctions.isEmpty(caseSources))
                        break;
                    sourceLocationList = [...this.sourceLocations["CASEENTITY"]];
                    sourceLocationList.unshift({
                        'EntityName': 'caseentity',
                        'SourceLocationName': this.translateService.instant("LBL_ALL_SOURCES")
                    });
                }
                break;
        }
        return sourceLocationList;
    }
    getLegendCharacter(object) {
        let result = "";
        if (!GlobalFunctions.isEmpty(object) && !GlobalFunctions.isEmpty(object.ObjectSource) && this.applicationSettingsColorCodeDictionary != null) {
            let colorCodeValue = new ColorCodeInformation();
            colorCodeValue = this.applicationSettingsColorCodeDictionary[object.ObjectSource.toLowerCase()];
            if (colorCodeValue != null && colorCodeValue != undefined && !GlobalFunctions.isEmpty(colorCodeValue.Legendcharacter))
                result = colorCodeValue.Legendcharacter.toUpperCase();
        }
        return result;
    }
    ;
    getTooltiptext(object) {
        let result = "";
        if (!GlobalFunctions.isEmpty(object) && !GlobalFunctions.isEmpty(object.ObjectSource) && this.applicationSettingsColorCodeDictionary != null) {
            result = object.ObjectSource.split('.')[object.ObjectSource.split('.').length - 1];
            let colorCodeValue = new ColorCodeInformation();
            colorCodeValue = this.applicationSettingsColorCodeDictionary[object.ObjectSource.toLowerCase()];
            if (colorCodeValue != null && colorCodeValue != undefined && !GlobalFunctions.isEmpty(colorCodeValue.Tooltiptext))
                result = colorCodeValue.Tooltiptext.charAt(0).toUpperCase() + colorCodeValue.Tooltiptext.slice(1);
        }
        return result;
    }
    ;
    getSearchDescriptionText(contentType) {
        let result = '';
        try {
            const searchDescriptionListXml = this.getApplicationSettingValueByKey("SearchDescriptionList");
            if (!GlobalFunctions.isEmpty(searchDescriptionListXml)) {
                const xmlDoc = $.parseXML(searchDescriptionListXml), $xml = $(xmlDoc), childHandlers = $xml.find('SearchDescription');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('ContentType').toLowerCase() == contentType.toLowerCase())
                            result = childHandler.getAttribute('SearchText');
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isQmaticEnabled() {
        let result = false;
        try {
            const taskIntegrationXml = this.getApplicationSettingValueByKey("TaskIntegrationSettings");
            if (!GlobalFunctions.isEmpty(taskIntegrationXml)) {
                const xmlDoc = $.parseXML(taskIntegrationXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('Name') === SourceType.Task_Qmatic && childHandler.getAttribute('HandlerEnabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isSmartCJMEnabled() {
        let result = false;
        try {
            const taskIntegrationXml = this.getApplicationSettingValueByKey("TaskIntegrationSettings");
            if (!GlobalFunctions.isEmpty(taskIntegrationXml)) {
                const xmlDoc = $.parseXML(taskIntegrationXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('Name') == SourceType.Task_SmartCJM && childHandler.getAttribute('HandlerEnabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isJCCEnabled() {
        let result = false;
        try {
            const taskIntegrationXml = this.getApplicationSettingValueByKey("TaskIntegrationSettings");
            if (!GlobalFunctions.isEmpty(taskIntegrationXml)) {
                const xmlDoc = $.parseXML(taskIntegrationXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('Name') === SourceType.Task_Jcc && childHandler.getAttribute('HandlerEnabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isCustomerOM() {
        let result = false;
        let customerName = this.getApplicationSettingValueByKey("CustomerName");
        if (!GlobalFunctions.isEmpty(customerName) && customerName.toUpperCase() == "OM")
            result = true;
        return result;
    }
    ;
    isAvailabilityCdrEnabled() {
        let result = false;
        try {
            const availabilityIntegrationXml = this.getApplicationSettingValueByKey("AvailabilityIntegrationSettings");
            if (!GlobalFunctions.isEmpty(availabilityIntegrationXml)) {
                const xmlDoc = $.parseXML(availabilityIntegrationXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('Name') == SourceType.Availability_Cdr && childHandler.getAttribute('HandlerEnabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isEmailEWSEnabled() {
        let result = false;
        try {
            const ewsIntegrationXml = this.getApplicationSettingValueByKey("EmailIntegrationSettings");
            if (!GlobalFunctions.isEmpty(ewsIntegrationXml)) {
                const xmlDoc = $.parseXML(ewsIntegrationXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('Name') == SourceType.Email_EWS && childHandler.getAttribute('HandlerEnabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isCaseConnectEnabled() {
        let result = false;
        try {
            const caseIntegrationXml = this.getApplicationSettingValueByKey("CaseIntegrationSettings");
            if (!GlobalFunctions.isEmpty(caseIntegrationXml)) {
                const xmlDoc = $.parseXML(caseIntegrationXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('Name') == SourceType.Case_DecosConnect && childHandler.getAttribute('HandlerEnabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    getAllowMultipleSourceSearch(newEntity) {
        let result = false;
        try {
            const valueData = this.getApplicationSettingValueByKey("AllowMultipleSourceSearch");
            if (!GlobalFunctions.isEmpty(valueData)) {
                const xmlDoc = $.parseXML(valueData), $xml = $(xmlDoc), entites = $xml.find('Entity');
                if (entites?.length > 0) {
                    entites.each((i, entity) => {
                        if (entity.getAttribute('Name') == newEntity && entity.getAttribute('Enabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isArchiveMailOptionRequired() {
        let result = false;
        const valueData = this.getApplicationSettingValueByKey("IsArchiveMailOptionRequired");
        if (!GlobalFunctions.isEmpty(valueData))
            result = valueData.toLowerCase() == "true" ? true : false;
        return result;
    }
    ;
    isPhoneHandlerEnabled(handlerFqdn) {
        let result = false;
        try {
            const phoneIntegrationXml = this.getApplicationSettingValueByKey("PhoneIntegrationSettings");
            if (!GlobalFunctions.isEmpty(phoneIntegrationXml)) {
                const xmlDoc = $.parseXML(phoneIntegrationXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('Name') == handlerFqdn && childHandler.getAttribute('HandlerEnabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isPhoneBasicEnabled() {
        let result = false;
        result = this.isPhoneHandlerEnabled(SourceType.Phone_Anywhere365) || this.isPhoneHandlerEnabled(SourceType.Phone_Basic);
        return result;
    }
    ;
    isEnableAllSources(handlerFqdn) {
        let result = false;
        try {
            const enableAllSourcesXml = this.getApplicationSettingValueByKey("EnableAllSources");
            if (!GlobalFunctions.isEmpty(enableAllSourcesXml)) {
                const xmlDoc = $.parseXML(enableAllSourcesXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('Name').toLowerCase() == handlerFqdn.toLowerCase() && childHandler.getAttribute('EnableSearch').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    getOwnerEmailAddress(objectSource) {
        let result = '';
        try {
            const integrationOwnerSettingsXml = this.getApplicationSettingValueByKey("IntegrationOwnerSettings");
            if (!GlobalFunctions.isEmpty(integrationOwnerSettingsXml)) {
                const xmlDoc = $.parseXML(integrationOwnerSettingsXml), $xml = $(xmlDoc), handlers = $xml.find('ChildHandler');
                if (handlers?.length > 0 && !GlobalFunctions.isEmpty(objectSource)) {
                    handlers.each((i, handler) => {
                        if (handler.getAttribute('Name').toLowerCase() == objectSource.toLowerCase())
                            result = handler.getAttribute('OwnerEmailAddress');
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isPrefillHandlerEnabled() {
        let result = false;
        try {
            const prefillIntegrationXml = this.getApplicationSettingValueByKey("PrefillIntegrationSettings");
            if (!GlobalFunctions.isEmpty(prefillIntegrationXml)) {
                const xmlDoc = $.parseXML(prefillIntegrationXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('HandlerEnabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isPersonStufEnabled() {
        let result = false;
        try {
            const personIntegrationXml = this.getApplicationSettingValueByKey("PersonIntegrationSettings");
            if (!GlobalFunctions.isEmpty(personIntegrationXml)) {
                const xmlDoc = $.parseXML(personIntegrationXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('Name') == SourceType.Person_StUF0204 && childHandler.getAttribute('HandlerEnabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    setIntegrationSetting(keyValue) {
        try {
            const xmlValue = this.getApplicationSettingValueByKey(keyValue);
            if (!GlobalFunctions.isEmpty(xmlValue)) {
                const xmlDoc = $.parseXML(xmlValue), $xml = $(xmlDoc), useColorCode = $xml.find('ParentHandler').attr('UseColorCoding');
                if (useColorCode)
                    this.setApplicationColorCodeDictionary(xmlValue);
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    setApplicationColorCodeDictionary(xml) {
        try {
            if (!GlobalFunctions.isEmpty(xml)) {
                const xmlDoc = $.parseXML(xml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        const sourceName = childHandler.getAttribute('Name').toLocaleLowerCase();
                        const selectedBackgroundColor = childHandler.getAttribute('SelectedBackgroundColor');
                        const regularBackgroundColor = childHandler.getAttribute('RegularBackgroundColor');
                        const colorCodeInformation = new ColorCodeInformation();
                        colorCodeInformation.Caption = sourceName;
                        colorCodeInformation.RegularBackgroundColor = regularBackgroundColor;
                        colorCodeInformation.SelectedBackgroundColor = selectedBackgroundColor;
                        colorCodeInformation.Legendcharacter = childHandler.getAttribute('LegendCharacter');
                        colorCodeInformation.Tooltiptext = childHandler.getAttribute('ToolTipText');
                        if (!this.applicationSettingsColorCodeDictionary[sourceName])
                            this.applicationSettingsColorCodeDictionary[sourceName] = colorCodeInformation;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    getUIHandlerTypeOption(handlerType) {
        let result = new Object();
        result.EmployeeHandler = true;
        result.DepartmentHandler = true;
        result.MailboxHandler = true;
        result.ShowHandlerOption = true;
        let valueData = handlerType == undefined ? this.getApplicationSettingValueByKey("DefaultUIHandlerTypeOption") : handlerType;
        if (!GlobalFunctions.isEmpty(valueData)) {
            switch (valueData.toString()) {
                case "1":
                    {
                        result.EmployeeHandler = true;
                        result.DepartmentHandler = false;
                        result.MailboxHandler = false;
                        result.ShowHandlerOption = false;
                        break;
                    }
                case "2":
                    {
                        result.EmployeeHandler = false;
                        result.DepartmentHandler = true;
                        result.MailboxHandler = false;
                        result.ShowHandlerOption = false;
                        break;
                    }
                case "3":
                    {
                        result.EmployeeHandler = false;
                        result.DepartmentHandler = false;
                        result.MailboxHandler = true;
                        result.ShowHandlerOption = false;
                        break;
                    }
                case "4":
                    {
                        result.EmployeeHandler = true;
                        result.DepartmentHandler = true;
                        result.MailboxHandler = false;
                        break;
                    }
                case "5":
                    {
                        result.EmployeeHandler = true;
                        result.DepartmentHandler = false;
                        result.MailboxHandler = true;
                        break;
                    }
                case "6":
                    {
                        result.EmployeeHandler = false;
                        result.DepartmentHandler = true;
                        result.MailboxHandler = true;
                        break;
                    }
            }
        }
        return result;
    }
    ;
    getEmailStandardStyle() {
        let standardStyle = { IsEnabled: false, IsAutoStyleEnabled: false, FontName: 'arial, helvetica, sans-serif', FontSize: '9.5pt', FontColor: 'red' };
        let xmlStyleText = this.getApplicationSettingValueByKey("EMAILSTYLECONFIGURATION");
        if (!GlobalFunctions.isEmpty(xmlStyleText)) {
            let x2js = new X2JS();
            let jsonObj = x2js.xml2js(xmlStyleText);
            if (jsonObj.StandardStyle != null) {
                if (!GlobalFunctions.isEmpty(jsonObj.StandardStyle._IsEnabled))
                    standardStyle.IsEnabled = jsonObj.StandardStyle._IsEnabled.toUpperCase() == "TRUE";
                if (!GlobalFunctions.isEmpty(jsonObj.StandardStyle._IsAutoStyleEnabled))
                    standardStyle.IsAutoStyleEnabled = jsonObj.StandardStyle._IsAutoStyleEnabled.toUpperCase() == "TRUE";
                if (!GlobalFunctions.isEmpty(jsonObj.StandardStyle._FontFamily))
                    jsonObj.StandardStyle._FontName = jsonObj.StandardStyle._FontFamily;
                standardStyle.FontName = jsonObj.StandardStyle._FontName;
                standardStyle.FontSize = jsonObj.StandardStyle._FontSize;
                standardStyle.FontColor = jsonObj.StandardStyle._ForeColor;
            }
        }
        return standardStyle;
    }
    ;
    setEntityRequiredPropertySettings() {
        let entityRequiredPropertyList = this.getApplicationSettingValueByKey("EntityRequiredProperty");
        if (!GlobalFunctions.isEmpty(entityRequiredPropertyList)) {
            let x2js = new X2JS();
            let jsonObj = x2js.xml2js(entityRequiredPropertyList);
            //Person
            let jlinqPerson = jlinq.from(GlobalFunctions.ConvertToArrayIfOnlySingleObject(jsonObj.RequiredPropertyList.Entity)).starts("_ContentType", ContentType.Person).select();
            let personRequiredPropertySetting = GlobalFunctions.ConvertToArrayIfOnlySingleObject(jlinqPerson);
            if (!GlobalFunctions.isEmpty(personRequiredPropertySetting)) {
                for (let i = 0; i < personRequiredPropertySetting[0].Property.length; i++) {
                    let propertyFqdn = personRequiredPropertySetting[0].Property[i]._Fqdn;
                    let propertyName = GlobalFunctions.getObjectTypeName(propertyFqdn).replace('[0]', '');
                    this.entityRequiredPropertyList.PersonRequiredProperties[propertyName] = new RequiredPropertyConfiguration();
                    this.entityRequiredPropertyList.PersonRequiredProperties[propertyName].IsRequired = personRequiredPropertySetting[0].Property[i]._IsRequired == true || personRequiredPropertySetting[0].Property[i]._IsRequired == 'true';
                }
            }
        }
    }
    setPrivacySettings() {
        let privacyPropertyList = this.getApplicationSettingValueByKey("PrivacySetting");
        if (!GlobalFunctions.isEmpty(privacyPropertyList)) {
            let x2js = new X2JS();
            let jsonObj = x2js.xml2js(privacyPropertyList);
            if (!GlobalFunctions.isEmpty(jsonObj) && !GlobalFunctions.isEmpty(jsonObj.PrivacyPropertyList) && !GlobalFunctions.isEmpty(jsonObj.PrivacyPropertyList.ContactHistoryAutoDeletion))
                this.privacyPropertyList.NumberOfDaysToDeleteContactHistory = parseInt(jsonObj.PrivacyPropertyList.ContactHistoryAutoDeletion.DeleteAfterNumberOfDays);
        }
    }
    ;
    isTicketEnabled() {
        let result = false;
        try {
            const ticketIntegrationXml = this.getApplicationSettingValueByKey("TicketIntegrationSettings");
            if (!GlobalFunctions.isEmpty(ticketIntegrationXml)) {
                const xmlDoc = $.parseXML(ticketIntegrationXml), $xml = $(xmlDoc), childHandlers = $xml.find('ChildHandler');
                if (childHandlers?.length > 0) {
                    childHandlers.each((i, childHandler) => {
                        if (childHandler.getAttribute('Name') == SourceType.Ticket_Cdr && childHandler.getAttribute('HandlerEnabled').toLowerCase() === "true")
                            result = true;
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return result;
    }
    ;
    isAllowedToAddWithoutSessionStart() {
        let result = false;
        let settingValue = this.getApplicationSettingValueByKey("AlwaysAddLoadedEntityToSession");
        if (settingValue != null && settingValue.toLowerCase() === "true")
            result = true;
        return result;
    }
    ;
    getTaskTemplates(taskType) {
        let templateList = [];
        try {
            const templateAppSetting = this.getApplicationSettingValueByKey("TaskTemplates");
            if (!GlobalFunctions.isEmpty(templateAppSetting)) {
                const xmlDoc = $.parseXML(templateAppSetting);
                const templates = $(xmlDoc).find('TASKTEMPLATE');
                if (!GlobalFunctions.isEmpty(templates)) {
                    templates.each((i, template) => {
                        const templateTaskType = template.getAttribute('TASKTYPE');
                        if (!GlobalFunctions.isEmpty(template.getAttribute('ID')) && (GlobalFunctions.isEmpty(templateTaskType) || templateTaskType == taskType)) {
                            const attachments = $(template).find('ATTACHMENT');
                            const attachmentArray = [];
                            if (!GlobalFunctions.isEmpty(attachments)) {
                                attachments.each((i, attachment) => {
                                    if (!GlobalFunctions.isEmpty(attachment.getAttribute('ID')))
                                        attachmentArray.push({ Id: attachment.getAttribute('ID'), Name: attachment.getAttribute('NAME'), Title: attachment.getAttribute('TITLE'), Path: attachment.getAttribute('CONTENT') });
                                });
                            }
                            const handlerIds = $(template).find('HandlerList');
                            const ids = [];
                            if (!GlobalFunctions.isEmpty(handlerIds)) {
                                handlerIds.each((i, handler) => {
                                    if (!GlobalFunctions.isEmpty($(handler).find('value')?.text()))
                                        ids.push($(handler).find('value').text());
                                });
                            }
                            ;
                            const requiredFields = $(template).find('RequiredFields');
                            const fields = [];
                            if (!GlobalFunctions.isEmpty(requiredFields)) {
                                requiredFields.each((i, field) => {
                                    if (!GlobalFunctions.isEmpty($(requiredFields).find('value')?.text()))
                                        fields.push($(field).find('value').text());
                                });
                            }
                            ;
                            templateList.push({ Id: template.getAttribute('ID'), Name: template.getAttribute('NAME'), Description: template.getAttribute('DESCRIPTION'), TaskType: templateTaskType, Content: template.getAttribute('TEXT'), HandlerType: template.getAttribute('HANDLERTYPE'), HandlerIds: ids, RequiredFields: fields, Attachments: attachmentArray, DueDays: !template.getAttribute('DUEDAYS') ? 0 : parseInt(template.getAttribute('DUEDAYS')) });
                        }
                    });
                    if (!GlobalFunctions.isEmpty(templateList))
                        templateList = jlinq.from(templateList).sort("Name").select();
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return templateList;
    }
    ;
    isEmployeeAutoLinkEnabled() {
        let result = false;
        let isEnabled = this.getApplicationSettingValueByKey("LinkEmployeeOnConsultationCall");
        if (!GlobalFunctions.isEmpty(isEnabled) && isEnabled.toUpperCase() === "TRUE")
            result = true;
        return result;
    }
    ;
    isCallerRecentActivityEnabled() {
        let result = false;
        let value = this.getApplicationSettingValueByKey("ShowCallerRecentActivity");
        if (!GlobalFunctions.isEmpty(value) && value.toUpperCase() == "TRUE")
            result = true;
        return result;
    }
    ;
    isDepartmentNameInHandlerEnabled() {
        let result = false;
        let value = this.getApplicationSettingValueByKey("ENABLEDEPARTMENTNAMEINHANDLER");
        if (!GlobalFunctions.isEmpty(value) && value.toUpperCase() == "TRUE")
            result = true;
        return result;
    }
    ;
    isIncomingCallNotificationEnabled() {
        let result = false;
        let isEnabled = this.getApplicationSettingValueByKey("EnableIncomingCallNotification");
        if (!GlobalFunctions.isEmpty(isEnabled) && isEnabled.toUpperCase() === "TRUE")
            result = true;
        return result;
    }
    ;
    initalize(sessionManager) {
        try {
            this.setIntegrationSetting("PersonIntegrationSettings");
            this.setIntegrationSetting("OrganizationIntegrationSettings");
            this.setIntegrationSetting("ProductIntegrationSettings");
            this.setIntegrationSetting("CaseIntegrationSettings");
            this.setIntegrationSetting("DocumentIntegrationSettings");
            this.setIntegrationSetting("NoteIntegrationSettings");
            this.setIntegrationSetting("EmployeeIntegrationSettings");
            this.setIntegrationSetting("EmailIntegrationSettings");
            this.setIntegrationSetting("TaskIntegrationSettings");
            this.setIntegrationSetting("FaqIntegrationSettings");
            this.setIntegrationSetting("NewsIntegrationSettings");
            this.setIntegrationSetting("ContactHistoryIntegrationSettings");
            this.setIntegrationSetting("FileIntegrationSettings");
            this.setIntegrationSetting("ThemeIntegrationSettings");
            this.setIntegrationSetting("SocialMediaIntegrationSettings");
            let xmlValue = this.getApplicationSettingValueByKey("LetterTemplates");
            if (!GlobalFunctions.isEmpty(xmlValue))
                this.letterTemplateList.setSettings(xmlValue);
            this.applicationSettingsDictionary["LetterTemplates"] = "";
            xmlValue = this.getApplicationSettingValueByKey("ConfigureTags");
            if (!GlobalFunctions.isEmpty(xmlValue))
                this.tagSetting.setSettings(xmlValue);
            this.applicationSettingsDictionary["ConfigureTags"] = "";
            xmlValue = this.getApplicationSettingValueByKey("ConfigureSuggestionPanel");
            if (!GlobalFunctions.isEmpty(xmlValue))
                this.suggestionSetting.initialize(xmlValue);
            this.applicationSettingsDictionary["ConfigureSuggestionPanel"] = "";
            this.autoIgnoreSession = (!GlobalFunctions.isEmpty(this.getApplicationSettingValueByKey("AutoIgnoreSessionAfterProcessingTask")) && this.getApplicationSettingValueByKey("AutoIgnoreSessionAfterProcessingTask").toLowerCase() === 'true') ? true : false;
            this.autoEndSession = (!GlobalFunctions.isEmpty(this.getApplicationSettingValueByKey("AutoEndSessionAfterProcessingEmail")) && this.getApplicationSettingValueByKey("AutoEndSessionAfterProcessingEmail").toLowerCase() === 'true') ? true : false;
            this.showWarningOnIgnoreSession = (!GlobalFunctions.isEmpty(this.getApplicationSettingValueByKey("ShowWarningOnIgnoreSession")) && this.getApplicationSettingValueByKey("ShowWarningOnIgnoreSession").toLowerCase() === 'true') ? true : false;
            this.isLinkCSNToCaseSystemEnabled = (!GlobalFunctions.isEmpty(this.getApplicationSettingValueByKey("LinkContactHistoryToCaseSystem")) && this.getApplicationSettingValueByKey("LinkContactHistoryToCaseSystem").toLowerCase() === 'true') ? true : false;
            xmlValue = this.getApplicationSettingValueByKey("ConfigureViewer");
            if (!GlobalFunctions.isEmpty(xmlValue))
                this.viewerSetting.initialize(xmlValue);
            this.applicationSettingsDictionary["ConfigureViewer"] = "";
            xmlValue = this.getApplicationSettingValueByKey("ConfigureDashboard");
            if (!GlobalFunctions.isEmpty(xmlValue))
                this.dashboardSetting.initialize(xmlValue, sessionManager);
            this.applicationSettingsDictionary["ConfigureDashboard"] = "";
            xmlValue = this.getApplicationSettingValueByKey("RefreshEntityCountSettings");
            if (!GlobalFunctions.isEmpty(xmlValue))
                this.refreshCountSetting.initialize(xmlValue);
            this.applicationSettingsDictionary["RefreshEntityCountSettings"] = "";
            xmlValue = this.getApplicationSettingValueByKey("DEFAULTTIMEFORMAT");
            if (!GlobalFunctions.isEmpty(xmlValue)) {
                xmlValue = this.toTimeFormatText(xmlValue);
                sessionManager.defaultOptions.defaultFullTimeFormat = xmlValue;
                if (xmlValue.includes('ss'))
                    sessionManager.defaultOptions.defaultShortTimeFormat = xmlValue.slice(0, 5);
            }
            this.applicationSettingsDictionary["DEFAULTTIMEFORMAT"] = "";
            xmlValue = this.getApplicationSettingValueByKey("DEFAULTDATEFORMAT");
            if (!GlobalFunctions.isEmpty(xmlValue)) {
                xmlValue = this.toDateFormatText(xmlValue);
                sessionManager.defaultOptions.defaultDateFormat = xmlValue;
            }
            sessionManager.defaultOptions.defaultFullDateTimeFormat = sessionManager.defaultOptions.defaultDateFormat + ' ' + sessionManager.defaultOptions.defaultFullTimeFormat; // Date + FullTime(HH:mm:ss)
            sessionManager.defaultOptions.defaultShortDateTimeFormat = sessionManager.defaultOptions.defaultDateFormat + ' ' + sessionManager.defaultOptions.defaultShortTimeFormat; // Date + ShortTime(HH:mm)
            this.applicationSettingsDictionary["DEFAULTDATEFORMAT"] = "";
        }
        catch (message) {
            console.error(message);
        }
    }
    ;
    cacheApplicationSettings(sessionManager) {
        this.applicationSettingsDictionary = {};
        let url = environment.oData_config + "/ApplicationSettings";
        return this.getAppicationSetting(url).pipe(map(data => {
            if (data != null && data.length > 0) {
                for (let index = 0; index < data.length; index++) {
                    let settingKey = data[index].SettingKey.toUpperCase();
                    if (data[index] != undefined && this.applicationSettingsDictionary[settingKey] == null)
                        this.applicationSettingsDictionary[settingKey] = data[index].SettingValue;
                }
                this.initalize(sessionManager);
                this.applicationSettingCached = true;
            }
        }));
    }
    getAppicationSetting(url) {
        return this.httpClient.get(url, { headers: this.getHeader() });
    }
    clear() {
        this.applicationSettingCached = false;
        this.autoIgnoreSession = false;
        this.autoEndSession = false;
        this.sourceLocations = [];
        this.privacyPropertyList = new EntityPropertyConfiguration();
        this.entityRequiredPropertyList = new EntityRequiredPropertyConfiguration();
        this.UIConfigurator = new EntityPropertyConfiguration();
        this.letterTemplateList = new LetterTemplateSetting();
        this.tagSetting = new TagSetting();
        this.suggestionSetting = new SuggestionSetting();
        this.viewerSetting = new ViewerSetting();
        this.dashboardSetting = new DashboardSetting();
    }
    getGeoData(url) {
        return this.httpClient.get(url, { headers: this.getHeader() });
    }
    getVersion(url) {
        return this.httpClient.get(url, { headers: this.getHeader() });
    }
    getAppData(url) {
        return this.httpClient.get(url, { headers: this.getHeader() });
    }
    getAdminUrl(url) {
        return this.httpClient.get(url, { headers: this.getHeader() });
    }
    openEForm(response, eformLink) {
        DialogHelper.openDialog(this.dialog, EformComponent, '100%', 'auto', '50vh', '45vw', { startPrefillResponse: response, eformLinkValue: eformLink });
    }
    getExcludeEntityInSessionSettings() {
        let excludedEntityFqdn = [];
        try {
            let excludeEntityInSessionSettings = this.getApplicationSettingValueByKey("ExcludeEntityInSessionSettings");
            if (!GlobalFunctions.isEmpty(excludeEntityInSessionSettings)) {
                let x2js = new X2JS();
                let jsonObj = x2js.xml2js(excludeEntityInSessionSettings);
                if (jsonObj != null && !GlobalFunctions.isEmpty(jsonObj.EXCLUDEENTITYINSESSIONSETTINGS) && !GlobalFunctions.isEmpty(jsonObj.EXCLUDEENTITYINSESSIONSETTINGS.EXCLUDEENTITYINSESSIONSETTING)) {
                    let excludedEntities = jlinq.from(jsonObj.EXCLUDEENTITYINSESSIONSETTINGS.EXCLUDEENTITYINSESSIONSETTING).equals("_Excluded", "true").select();
                    if (!GlobalFunctions.isEmpty(excludedEntities)) {
                        for (let i = 0; i < excludedEntities.length; i++)
                            excludedEntityFqdn.push(EntityFqdn[excludedEntities[i]._EnumValue]);
                    }
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return excludedEntityFqdn;
    }
    ;
    toDateFormatText(xmlDateValue) {
        if (!GlobalFunctions.isEmpty(xmlDateValue)) {
            switch (xmlDateValue) {
                case "0":
                    {
                        xmlDateValue = "dd MMM yyyy";
                        break;
                    }
                case "1":
                    {
                        xmlDateValue = "dd-MM-yyyy";
                        break;
                    }
            }
            return xmlDateValue;
        }
    }
    toTimeFormatText(xmlTimeValue) {
        if (!GlobalFunctions.isEmpty(xmlTimeValue)) {
            switch (xmlTimeValue) {
                case "0":
                    {
                        xmlTimeValue = "HH:mm:ss";
                        break;
                    }
                case "1":
                    {
                        xmlTimeValue = "hh:mm:ss";
                        break;
                    }
            }
            return xmlTimeValue;
        }
    }
    isWarningForCsnDuringPhoneCallEnabled() {
        let result = true;
        let value = this.getApplicationSettingValueByKey("WARNINGFORCSNDURINGPHONECALL");
        if (!GlobalFunctions.isEmpty(value) && value.toUpperCase() == "FALSE")
            result = false;
        return result;
    }
    ;
};
ApplicationSettingManager = __decorate([
    Injectable({ providedIn: 'root' })
], ApplicationSettingManager);
export { ApplicationSettingManager };
//# sourceMappingURL=application-setting-manager.js.map