var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { LicenseSpecificFeature } from '../enums/common-enums';
import { ApplicationInfo } from '../models/common/application-Info';
import { BaseService } from '../services/base-service';
let ApplicationFeatureManager = class ApplicationFeatureManager extends BaseService {
    constructor(zone, router, httpClient, chatService, issueService, phoneManager, phoneService, themeService, ticketService, eventProvider, sessionManager, serviceManager, socialMediaService, systemComponentService, applicationSettingManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.chatService = chatService;
        this.issueService = issueService;
        this.phoneManager = phoneManager;
        this.phoneService = phoneService;
        this.themeService = themeService;
        this.ticketService = ticketService;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.serviceManager = serviceManager;
        this.socialMediaService = socialMediaService;
        this.systemComponentService = systemComponentService;
        this.applicationSettingManager = applicationSettingManager;
        this.isShowNextEmailFeatureEnabled = false;
        this.isPhoneStatusEnabled = false;
        this.getSourceLocationsResponse = this.getSourceLocationsResponse.bind(this);
        this.getLicenseSpecificFeatureResponse = this.getLicenseSpecificFeatureResponse.bind(this);
    }
    clear() {
        GlobalFunctions.licenseSpecificFeatureList = null;
    }
    getLicenseSpecificFeatureResponse(result) {
        GlobalFunctions.licenseSpecificFeatureList = result.LicenseSpecificFeatureDtoList;
        if (GlobalFunctions.licenseSpecificFeatureList?.length > 0) {
            this.sessionManager.isChatFeatureEnabled = this.chatService.isLicensed = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Chat);
            this.sessionManager.isIssueFeatureEnabled = this.issueService.isLicensed = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Issue);
            this.sessionManager.isThemeFeatureEnabled = this.themeService.isLicensed = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Theme);
            this.sessionManager.isTicketFeatureEnabled = this.ticketService.isLicensed = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Ticket);
            this.phoneManager.phoneState.IsPhoneFeatureEnabled = this.phoneService.isLicensed = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Phone);
            this.sessionManager.isSocialMediaFeatureEnabled = this.socialMediaService.isLicensed = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.SocialMedia);
            this.sessionManager.isRoleFeatureEnabled = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Role);
            this.sessionManager.isViewerFeatureEnabled = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Viewer);
            this.sessionManager.isSuggestionFeatureEnabled = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Suggestion);
            this.sessionManager.isSecureEmailFeatureEnabled = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.SecureEmail);
            this.sessionManager.isCallerRecentActivityFeatureEnabled = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.CallerRecentActivity);
            this.sessionManager.isPersonDeeplinkEnabled = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.PersonDeeplink);
            this.sessionManager.isSystemAIFeatureEnabled = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.AI);
            if (result.LicenseDetailDto != null) {
                if (this.sessionManager.applicationInfo == null)
                    this.sessionManager.applicationInfo = new ApplicationInfo();
                this.sessionManager.applicationInfo.LicenseDetail = result.LicenseDetailDto;
            }
            this.sessionManager.actionMenu.addLicencedMenuItem(this.sessionManager);
            if (this.sessionManager.isChatFeatureEnabled || this.phoneManager.phoneState.IsPhoneFeatureEnabled)
                this.sessionManager.setWindowFocusEvents();
            this.serviceManager.connectLicenseBasedServices();
        }
    }
    setFeatureControlsVisibility() {
        let showNextEmailFeature = this.applicationSettingManager.getApplicationSettingValueByKey("ENABLENEXTEMAILFEATURE");
        this.isShowNextEmailFeatureEnabled = !GlobalFunctions.isEmpty(showNextEmailFeature) && showNextEmailFeature.toLowerCase() === "true";
        this.phoneManager.setFeatureControlsVisibility();
    }
    fetchData() {
        try {
            this.systemComponentService.customContextMenuItems(this.systemComponentService.handleCustomContextMenuItemsCallback);
            this.systemComponentService.getSourceLocations(this.getSourceLocationsResponse);
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    getSourceLocationsResponse(response) {
        this.applicationSettingManager.sourceLocations = jlinq.from(response.SourceLocations).group("EntityName");
        if (!GlobalFunctions.isEmpty(this.applicationSettingManager.sourceLocations["PERSONS"]))
            this.applicationSettingManager.sourceLocations["PERSONS"].sort(this.comparor);
        if (!GlobalFunctions.isEmpty(this.applicationSettingManager.sourceLocations["ORGANIZATIONS"]))
            this.applicationSettingManager.sourceLocations["ORGANIZATIONS"].sort(this.comparor);
        if (!GlobalFunctions.isEmpty(this.applicationSettingManager.sourceLocations["PRODUCTS"]))
            this.applicationSettingManager.sourceLocations["PRODUCTS"].sort(this.comparor);
        if (!GlobalFunctions.isEmpty(this.applicationSettingManager.sourceLocations["TICKETS"]))
            this.applicationSettingManager.sourceLocations["TICKETS"].sort(this.comparor);
        if (!GlobalFunctions.isEmpty(this.applicationSettingManager.sourceLocations["CASEENTITY"]))
            this.applicationSettingManager.sourceLocations["CASEENTITY"].sort(this.comparor);
    }
    ;
    comparor(x, y) {
        if (x.SourceLocationName < y.SourceLocationName)
            return -1;
        if (x.SourceLocationName > y.SourceLocationName)
            return 1;
        return 0;
    }
};
ApplicationFeatureManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], ApplicationFeatureManager);
export { ApplicationFeatureManager };
//# sourceMappingURL=application-feature-manager.js.map