var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { LocalStorageKey, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { environment } from '../../../environments/environment';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { AuthenticationType, ContactSessionNotesUIState } from '../enums/common-enums';
import { PhoneState } from '../models/common/phone-state';
import { UpdateEmployeeStatusRequest } from '../models/employee/update-employee-status-request';
let AppManager = class AppManager {
    constructor(router, phoneManager, systemComponentService, applicationFeatureManager, sessionManager, employeeService, searchService, userSettingManager, dialog, sortManager, applicationSettingManager, integrationSettingManager, cacheManager, serviceManager) {
        this.router = router;
        this.phoneManager = phoneManager;
        this.systemComponentService = systemComponentService;
        this.applicationFeatureManager = applicationFeatureManager;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.searchService = searchService;
        this.userSettingManager = userSettingManager;
        this.dialog = dialog;
        this.sortManager = sortManager;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.cacheManager = cacheManager;
        this.serviceManager = serviceManager;
    }
    async logout() {
        try {
            if (this.sessionManager.employeeStatus?.isEnabled && !GlobalFunctions.isEmpty(this.sessionManager.employeeStatus?.channelList)) {
                let updateEmployeeStatusRequest = new UpdateEmployeeStatusRequest();
                updateEmployeeStatusRequest.EmployeeStatus = this.sessionManager.employeeStatus.getLoggedOutStatus();
                this.employeeService.updateEmployeeAvailabilityStatus(updateEmployeeStatusRequest);
            }
            this.sessionManager.isSSOLogout = this.sessionManager.authenticationType === AuthenticationType.ADFS || this.sessionManager.authenticationType === AuthenticationType.SSO;
            GlobalFunctions.setCookie(LocalStorageKey.SSO_LOGOUT, this.sessionManager.isSSOLogout);
            console.log("isSSOLogout " + this.sessionManager.isSSOLogout);
            this.systemComponentService.clearAllEntityLock();
            await this.flushSessionData();
            this.sessionManager.overviewSubSink.unsubscribe();
            this.sessionManager.overviewSubSinkInitialized = false;
            this.sessionManager.contactSessionNotesState.UIState = ContactSessionNotesUIState.None;
            this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen = false;
            if (this.sessionManager.authenticationType === AuthenticationType.OIDC || this.sessionManager.authenticationType === AuthenticationType.SAML2 || this.sessionManager.authenticationType === AuthenticationType.ADFS)
                window.location.href = environment.general_config + "LoggedOut.aspx?userState=logout";
            else
                this.router.navigate([RoutePath.LOGIN]);
        }
        catch (e) {
            ExceptionHelper.showException(this.dialog, e, true);
        }
    }
    async flushSessionData() {
        this.phoneManager.unregisterExtension();
        this.phoneManager.phoneState = new PhoneState();
        await this.systemComponentService.clearSessionToken();
        this.serviceManager.disconnect();
        this.applicationFeatureManager.clear();
        this.removeCookies();
        this.employeeService.loggedInEmployee = null;
        this.sessionManager.clear();
        this.searchService.searchQuery = '';
        this.userSettingManager.clear();
        GlobalFunctions.clearAppCacheData();
        this.cacheManager.clear();
        if (this.dialog)
            this.dialog.closeAll();
        this.sortManager.clear();
        this.applicationSettingManager.clear();
        this.integrationSettingManager.clear();
    }
    removeCookies() {
        if (!JSON.parse(GlobalFunctions.getCookie(LocalStorageKey.KCS_REMEMBER_ME)))
            GlobalFunctions.removeCookie(LocalStorageKey.KCS_USERNAME);
        GlobalFunctions.removeCookie(LocalStorageKey.USER_AUTHENTICATED);
        GlobalFunctions.removeCookie(LocalStorageKey.KCS_PASSWORD);
        GlobalFunctions.removeCookie(LocalStorageKey.SESSION_TOKEN);
        GlobalFunctions.removeCookie(LocalStorageKey.KCS_USERLOGON_TYPE);
        GlobalFunctions.removeCookie(LocalStorageKey.REDIRECT_URL);
        GlobalFunctions.removeCookie(LocalStorageKey.REGISTERED_EXTENSION);
        GlobalFunctions.removeCookie(LocalStorageKey.PRIVILEGE_DATA);
        GlobalFunctions.removeCookie(LocalStorageKey.KCS_USER2FA);
    }
};
AppManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], AppManager);
export { AppManager };
//# sourceMappingURL=app-manager.js.map