var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { SubSink } from 'subsink';
import { FieldDataType } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { TicketStatus } from '../../../../core/enums/ticket-enum';
import { TicketHandlerDto } from '../../../../core/models/ticket/ticket-handlerDto';
import { TicketHistoryDto } from '../../../../core/models/ticket/ticket-historyDto';
import { BroadCastEventKeys, EntityName, RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let TicketForwardComponent = class TicketForwardComponent extends BaseDialogComponent {
    constructor(router, dialog, cacheManager, eventProvider, ticketService, dialogManager, sessionManager, shortcutManager, translateService, dialogRef, applicationSettingManager, integrationSettingManager) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.cacheManager = cacheManager;
        this.eventProvider = eventProvider;
        this.ticketService = ticketService;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.dateJS = Date;
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.handlerTypeList = [];
        this.reasonList = [];
        this.reasonIndex = 0;
        this.enableReasonValidation = false;
        this.reassignReasonFreeText = "";
        this.ticketDto = this.sessionManager.selectedEntity;
        this.forwardTicketTitle = this.ticketDto.TicketType.Title + " (" + this.translateService.instant("LBL_REASSIGN") + ")";
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.subs = new SubSink();
        this.assignTicketResponse = this.assignTicketResponse.bind(this);
    }
    ngOnInit() {
        this.setHandlerTypes();
        this.setDefaultNotForMeReasons();
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.forwardTicket());
        this.setHandlerTags();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    setHandlerTags() {
        switch (this.currentHandlerType) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList();
        }
    }
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById("handlerForwardTicketTagControl")?.focus();
    }
    ;
    setDefaultNotForMeReasons() {
        let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "DEFAULTNOTFORMEREASONS");
        if (GlobalFunctions.isEmpty(result)) {
            result = result.replace(/\n/g, "\r");
            let splitResult = result.split("\r");
            if (splitResult != null && splitResult.length > 0) {
                for (let index = 0; index < splitResult.length; index++) {
                    if (splitResult[index] != '')
                        this.reasonList.push(splitResult[index]);
                }
            }
        }
        this.reasonList.push(this.translateService.instant("LBL_OTHER"));
        // this.ticketHistoryDto.Reason = this.reasonList[this.questionIndex];
        this.changeReasonOption();
    }
    ;
    changeReasonOption() {
        this.enableReasonValidation = (this.reasonList.length == (this.reasonIndex + 1));
    }
    ;
    forwardTicketErrorCallback() {
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_TICKET_ERROR_MSG"), this.translateService.instant("LBL_TICKET"));
        ExceptionHelper.showException(this.dialog, exception, true);
        this.stopSpinner();
    }
    ;
    forwardTicket() {
        if (this.handlerTags.length === 0 || this.form.invalid)
            return;
        if (this.handlerTags.length > 0) {
            let ticketHandlerList = [];
            let ticketHandlerDto = new TicketHandlerDto();
            ticketHandlerDto.HandlerId = this.handlerTags[0].Id;
            ticketHandlerDto.HandlerType = this.currentHandlerType;
            ticketHandlerList.push(ticketHandlerDto);
            let ticketHistoryDto = new TicketHistoryDto();
            ticketHistoryDto.TicketId = this.ticketDto.Id;
            ticketHistoryDto.Reason = this.reasonList[this.reasonIndex];
            ticketHistoryDto.ReasonFreeText = this.reassignReasonFreeText;
            ticketHistoryDto.DateRecorded = new this.dateJS().toString('M/d/yyyy HH:mm:ss');
            ticketHistoryDto.Status = TicketStatus.Reassigned;
            ticketHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
            this.startSpinner();
            this.ticketService.assignTicket(ticketHistoryDto, ticketHandlerList, this.assignTicketResponse);
        }
        else
            this.linkTypeError = "LBL_MSG_EMPTY_HANDLER";
    }
    ;
    assignTicketResponse(result) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TICKET_STATISTIC);
        if (result.Result == 0) {
            this.close();
            this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.TICKET], { queryParams: { filter: 'my' } });
        }
        else {
            const header = this.translateService.instant("LBL_TICKET");
            const message = this.translateService.instant("LBL_MSG_FAILED_ASSIGN_TICKET").replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET"));
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message });
        }
    }
    setHandlerTypes() {
        if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups)) {
            this.ticketDto.TicketType.FieldGroups = jlinq.from(this.ticketDto.TicketType.FieldGroups).sort("Order").select();
            for (let i = 0; i < this.ticketDto.TicketType.FieldGroups.length; i++) {
                if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields)) {
                    this.ticketDto.TicketType.FieldGroups[i].Fields = jlinq.from(this.ticketDto.TicketType.FieldGroups[i].Fields).sort("Order").select();
                    for (let j = 0; j < this.ticketDto.TicketType.FieldGroups[i].Fields.length; j++) {
                        if (!GlobalFunctions.isEmpty(this.ticketDto.TicketType.FieldGroups[i].Fields[j].Title)) {
                            if (this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataType === FieldDataType.Handler) {
                                this.currentHandlerType = "Employee";
                                this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption(this.ticketDto.TicketType.FieldGroups[i].Fields[j].DataTypeRule);
                                if (this.handlerTypeOption.EmployeeHandler)
                                    this.handlerTypeList.push({ handlerTypeValue: "Employee", handlerTypeText: this.translateService.instant("LBL_EMPLOYEE") });
                                if (this.handlerTypeOption.DepartmentHandler)
                                    this.handlerTypeList.push({ handlerTypeValue: "Department", handlerTypeText: this.translateService.instant("LBL_DEPARTMENT") });
                                if (this.handlerTypeOption.MailboxHandler)
                                    this.handlerTypeList.push({ handlerTypeValue: "Mailbox", handlerTypeText: this.translateService.instant("LBL_MAILBOX") });
                                if (!this.handlerTypeOption.EmployeeHandler)
                                    this.currentHandlerType = "Department";
                            }
                        }
                    }
                }
            }
        }
    }
    ;
    searchEmployee() {
        this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL').afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
            }
        });
    }
    ;
    close(result) {
        this.dialogRef.close(result);
    }
    ;
};
__decorate([
    ViewChild('form')
], TicketForwardComponent.prototype, "form", void 0);
TicketForwardComponent = __decorate([
    Component({
        selector: 'ticket-forward',
        templateUrl: './ticket-forward.component.html',
        styleUrls: ['./ticket-forward.component.scss']
    })
], TicketForwardComponent);
export { TicketForwardComponent };
//# sourceMappingURL=ticket-forward.component.js.map