var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { SubSink } from 'subsink';
import { ContextMenuView, FieldDataType, FieldGroupLayout } from '../../../../core/enums/common-enums';
import { ContextMenu } from '../../../../core/models/common/context-menu';
import { Menu } from '../../../../core/models/common/menu';
import { BroadCastEventKeys, RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDetailComponent } from '../../../common/base-detail.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let TicketDetailComponent = class TicketDetailComponent extends BaseDetailComponent {
    constructor(router, dialog, formatManager, personService, ticketService, sessionManager, activatedRoute, contextMenuService, organizationService, eventProvider, applicationSettingManager, integrationSettingManager, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.router = router;
        this.dialog = dialog;
        this.formatManager = formatManager;
        this.personService = personService;
        this.ticketService = ticketService;
        this.sessionManager = sessionManager;
        this.activatedRoute = activatedRoute;
        this.contextMenuService = contextMenuService;
        this.organizationService = organizationService;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.loadedFromDeeplink = false;
        this.customerSectionTitle = 'klant';
        this.fieldDataTypeEnum = FieldDataType;
        this.fieldGroupLayoutEnum = FieldGroupLayout;
        this.ticket = this.sessionManager.selectedEntity;
        this.ticketNumberTitle = this.translateService.instant("LBL_TICKET_NUMBER").replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET"));
        this.selectedThirdParty = null;
        this.subs = new SubSink();
        this.timeoutIds = [];
        this.detailResponse = this.detailResponse.bind(this);
        this.fetchEntityDetailResponse = this.fetchEntityDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.sessionManager.selectedEntity.Partial = true;
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        GlobalFunctions.removeDeeplinkLocalStorage();
        if (!this.sessionManager.selectedEntity) {
            this.loadedFromDeeplink = true;
            this.fetchTicket(this.activatedRoute.snapshot.paramMap.get('id'));
        }
        else if (this.sessionManager.selectedEntity.Partial)
            this.fetchTicket(this.sessionManager.selectedEntity.Id);
        else {
            this.initTicketMenu();
            this.sendRelatedRequest.emit();
            this.alignFieldGroups();
        }
    }
    fetchTicket(entityId) {
        this.startSpinner();
        this.ticketService.connect().then(() => this.ticketService.fetchDetail(entityId, this.detailResponse));
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    initTicketMenu() {
        this.menu.addOrUpdateMenuItem(0, "TicketDetail", this.translateService.instant("LBL_TICKET"), false, true, true);
        this.addMenuItem.emit(this.menu);
        let contentType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn);
        let oldContentType = GlobalFunctions.toContentType(contentType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, contentType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(contentType);
    }
    assignFieldListDataValue(ticketDto) {
        if (!GlobalFunctions.isEmpty(ticketDto.TicketType) && !GlobalFunctions.isEmpty(ticketDto.TicketType.FieldGroups) && ticketDto.TicketType?.FieldGroups?.length > 0) {
            for (let fg = 0; fg < ticketDto.TicketType?.FieldGroups?.length; fg++) {
                let fieldGroup = ticketDto.TicketType.FieldGroups[fg];
                if (!GlobalFunctions.isEmpty(fieldGroup.Fields) && fieldGroup?.Fields?.length > 0) {
                    for (let f = 0; f < fieldGroup?.Fields?.length; f++) {
                        let fieldData = fieldGroup.Fields[f];
                        if (!GlobalFunctions.isEmpty(fieldData.Data) && !GlobalFunctions.isEmpty(fieldData.FieldList) && !GlobalFunctions.isEmpty(fieldData.FieldList.Entries)) {
                            let entry = jlinq.from(fieldData.FieldList.Entries).equals("Key", fieldData.Data).first();
                            if (!GlobalFunctions.isEmpty(entry) && !GlobalFunctions.isEmpty(entry.Title))
                                fieldData.DataValue = entry.Title;
                        }
                    }
                }
            }
        }
    }
    ;
    detailResponse(ticketDto) {
        if (ticketDto) {
            this.assignFieldListDataValue(ticketDto);
            this.sessionManager.selectedEntity = ticketDto;
            this.ticket = ticketDto;
            this.formatManager.setCreatedBy(this.sessionManager.selectedEntity.HistoryList);
            this.sendRelatedRequest.emit();
            this.initTicketMenu();
            //Create ContextMenu if not created since the ticket is loaded from deeplinking url   
            if (this.sessionManager.contextMenu == null) {
                this.sessionManager.loadedFromRelatedView = false;
                this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/ticket/${this.sessionManager.selectedEntity.Id}`;
                this.sessionManager.addBreadcrumbItems([this.sessionManager.selectedEntity], null, this.router.url);
            }
            if (!GlobalFunctions.isEmpty(ticketDto.ThirdParties) && !GlobalFunctions.isEmpty(ticketDto.ThirdParties[0].EntityType))
                this.ticket.ThirdPartyType = ticketDto.ThirdParties[0].EntityType;
            this.alignFieldGroups();
            if (this.loadedFromDeeplink) {
                this.loadedFromDeeplink = false;
                if (ticketDto.IsMyTicket) {
                    if (ticketDto.State == "afgesloten")
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_HANDLED'), textMsg: this.translateService.instant('LBL_HANDLED_TICKET_MESSAGE').replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET")) });
                    else
                        this.dialogManager.handleTicket(this.sessionManager.headerViewContainerRef);
                }
                else
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_UNAUTHORIZED'), textMsg: this.translateService.instant('LBL_UNAUTHORIZED_TICKET_MESSAGE').replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET")) });
            }
        }
        this.stopSpinner();
    }
    ;
    showHistory() {
        this.dialogManager.openJsPanelOrDialog('entity_history');
    }
    ;
    alignFieldGroups() {
        this.timeoutIds.push(setTimeout(() => {
            $('div[id^="fieldGroupDetail_"]').each((key, element) => {
                if (!GlobalFunctions.isEmpty(this.ticket.TicketType?.FieldGroups[key]?.Layout) && this.ticket.TicketType?.FieldGroups[key].Layout == FieldGroupLayout.Right && key > 0) {
                    let previousElement = $("#fieldGroupDetail_" + (key - 1));
                    let previousElementContainer = previousElement.find(".container");
                    let previousElementTable = !GlobalFunctions.isEmpty(previousElementContainer) ? previousElementContainer : previousElement.find(".table");
                    element = $(element);
                    let elementContainer = element.find(".container");
                    let elementTable = !GlobalFunctions.isEmpty(elementContainer) ? elementContainer : element.find(".table");
                    let maxHeight = elementTable.innerHeight() > previousElementTable.innerHeight() ? elementTable.innerHeight() : previousElementTable.innerHeight();
                    if (maxHeight != null) {
                        element.height(maxHeight + 21);
                        previousElement.height(maxHeight + 21);
                    }
                    previousElement[0].style.clear = 'both';
                }
            });
        }, 300));
    }
    ;
    selectThirdPartyContact(selectedThirdParty) {
        this.selectedThirdParty = selectedThirdParty;
        this.alignFieldGroups();
    }
    viewThirdParty(entity, event) {
        if (entity != null) {
            this.startSpinner();
            let partialDto = new Object();
            partialDto.Id = entity.EntityId;
            partialDto.ObjectSource = entity.EntitySource;
            if (partialDto.ObjectSource.indexOf('Persons') > -1)
                this.personService.fetchDetail(partialDto, this.fetchEntityDetailResponse);
            else
                this.organizationService.fetchDetail(partialDto, this.fetchEntityDetailResponse);
        }
        event.preventDefault();
        event.stopPropagation();
        event.cancelBubble = false;
    }
    ;
    fetchEntityDetailResponse(response) {
        this.stopSpinner();
        const type = response.ObjectSource.indexOf('Persons') > -1 ? "PERSON" : "ORGANIZATION";
        this.select(type, response);
    }
    select(type, selectedEntity) {
        if (selectedEntity) {
            if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem(type))
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.OPEN_VIEWER_PANEL, selectedEntity);
            else
                this.openItemInDetailView(type, selectedEntity);
        }
    }
    ;
    openItemInDetailView(type, item) {
        if (type.toUpperCase() == 'PERSON' && GlobalFunctions.isEmpty(item.Id) && !GlobalFunctions.isEmpty(item.AdministeredPersonDto) && !GlobalFunctions.isEmpty(item.AdministeredPersonDto.ServiceNumber))
            item.Id = item.AdministeredPersonDto.ServiceNumber;
        if (type.toUpperCase() == 'EMPLOYEE' && !GlobalFunctions.isEmpty(item.IsDeleted) && item.IsDeleted)
            return;
        this.sessionManager.loadedFromRelatedView = true;
        this.sessionManager.selectedEntity = item;
        if (type.toLowerCase() == 'contacthistory' && !GlobalFunctions.isEmpty(item.ContactType) && item.ContactType == "CallbackAttempt")
            type = "CallbackAttempt";
        type = type.toLowerCase();
        item.locationUrl = `${RoutePath.DETAIL_PATH}/${type}`;
        this.sessionManager.setBreadcrumbGrammer(item);
        this.sessionManager.addBreadcrumbItems([item], null, RoutePath.DETAIL_PATH);
        this.router.navigate([item.locationUrl]);
    }
    ;
};
TicketDetailComponent = __decorate([
    Component({
        selector: 'ticket-detail',
        templateUrl: './ticket-detail.component.html',
        styleUrls: ['./ticket-detail.component.scss']
    })
], TicketDetailComponent);
export { TicketDetailComponent };
//# sourceMappingURL=ticket-detail.component.js.map